/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils.strategies;

import com.mathworks.peermodel.synchronizer.utils.ImageDifferenceStrategy;
import com.mathworks.peermodel.synchronizer.utils.strategies.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ImageDifferenceStrategy1cInt
implements ImageDifferenceStrategy {
    private int[] oldBytes;
    private int[] newBytes;
    private int imageWidth;
    private int imageHeight;
    private int singleRowSize;
    private static final int defaultTileSize = 256;
    private int tileSize = 256;

    public ImageDifferenceStrategy1cInt() {
        this(256);
    }

    public ImageDifferenceStrategy1cInt(int tileSize) {
        this.tileSize = tileSize;
    }

    public synchronized void init(BufferedImage oldImage, BufferedImage newImage) {
        this.init(oldImage, newImage, 256);
    }

    public synchronized void init(BufferedImage oldImage, BufferedImage newImage, int tileSize) {
        if (oldImage.getWidth() != newImage.getWidth()) {
            throw new IllegalArgumentException("old image width " + oldImage.getWidth() + " does not match new " + newImage.getWidth());
        }
        if (oldImage.getHeight() != newImage.getHeight()) {
            throw new IllegalArgumentException("old image height " + oldImage.getHeight() + " does not match new " + newImage.getHeight());
        }
        this.imageWidth = oldImage.getWidth();
        this.imageHeight = oldImage.getHeight();
        if (this.imageWidth <= 0) {
            throw new IllegalArgumentException("Invalid image width " + oldImage.getWidth());
        }
        if (this.imageHeight <= 0) {
            throw new IllegalArgumentException("Invalid image height " + oldImage.getHeight());
        }
        if (tileSize < 1) {
            throw new IllegalArgumentException("Invalid tile size " + tileSize);
        }
        this.tileSize = tileSize;
        ColorModel imageModel = newImage.getColorModel();
        if (imageModel.getNumComponents() < 1) {
            throw new IllegalArgumentException("Cannot difference images with " + imageModel.getNumComponents() + " components, only positive");
        }
        this.singleRowSize = this.imageWidth;
        int imageType = newImage.getType();
        switch (imageType) {
            case 1: 
            case 2: {
                this.oldBytes = ((DataBufferInt)oldImage.getRaster().getDataBuffer()).getData();
                this.newBytes = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image format type " + imageType);
            }
        }
        if (this.oldBytes == null || this.newBytes == null || this.oldBytes.length != this.newBytes.length) {
            throw new IllegalArgumentException("Could not get image bytes for comparison");
        }
    }

    @Override
    public synchronized void setParameters(Map<String, Object> parameters) {
        if (parameters.containsKey("tileSize")) {
            this.tileSize = (Integer)parameters.get("tileSize");
        }
    }

    @Override
    public synchronized void diffImages(BufferedImage oldImage, BufferedImage newImage, Collection<Map<String, Object>> diffs) {
        this.init(oldImage, newImage);
        ArrayList<Rectangle> regions = this.getDifferences();
        for (int k = 0; k < regions.size(); ++k) {
            Rectangle rect = regions.get(k);
            HashMap<String, Object> diff = new HashMap<String, Object>();
            diff.put("x", rect.left);
            diff.put("y", rect.top);
            diff.put("image", newImage.getSubimage(rect.left, rect.top, rect.width, rect.height));
            diffs.add(diff);
        }
    }

    public synchronized ArrayList<Rectangle> getDifferences() {
        ArrayList<Rectangle> regions = new ArrayList<Rectangle>();
        for (int r = 0; r < this.imageHeight; r += this.tileSize) {
            int rEnd = Math.min(r + this.tileSize, this.imageHeight);
            int height = rEnd - r;
            for (int c = 0; c < this.imageWidth; c += this.tileSize) {
                int cEnd = Math.min(c + this.tileSize, this.imageWidth);
                int width = cEnd - c;
                Rectangle rect = this.diffImages(c, r, width, height);
                if (rect == null) continue;
                regions.add(rect);
            }
        }
        return regions;
    }

    private Rectangle diffImages(int x, int y, int w, int h) {
        assert (x < this.imageWidth);
        assert (y < this.imageHeight);
        int endY = y + h;
        int endX = x + w;
        assert (endX <= this.imageWidth);
        assert (endY <= this.imageHeight);
        int rowEnd = w;
        int r = y;
        int rowStart = y * this.singleRowSize + x;
        while (r < endY) {
            int c;
            int endC = c + rowEnd;
            for (c = rowStart; c < endC; ++c) {
                if (this.oldBytes[c] == this.newBytes[c]) continue;
                return new Rectangle(x, r, w, endY - r);
            }
            ++r;
            rowStart += this.singleRowSize;
        }
        return null;
    }
}

