/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class NamedThreadFactory
implements ThreadFactory {
    private static final boolean DAEMON = true;
    private static final boolean NOT_DAEMON = false;
    private final AtomicInteger fCounter = new AtomicInteger(0);
    private final String fPrefix;
    private final Thread.UncaughtExceptionHandler fExceptionHandler;
    private final Logger fLogger;
    private final boolean fDaemon;

    public static NamedThreadFactory createThreadFactory(String string, Logger logger) {
        return new NamedThreadFactory(string, logger, false, new LoggingUncaughtExceptionHandler(logger));
    }

    public static NamedThreadFactory createDaemonThreadFactory(String string, Logger logger) {
        return new NamedThreadFactory(string, logger, true, new LoggingUncaughtExceptionHandler(logger));
    }

    public static NamedThreadFactory createDaemonThreadFactory(String string, Logger logger, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        return new NamedThreadFactory(string, logger, true, uncaughtExceptionHandler);
    }

    private NamedThreadFactory(String string, Logger logger, boolean bl, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.fPrefix = string;
        this.fLogger = logger;
        this.fDaemon = bl;
        this.fExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable runnable) {
        String string = this.fPrefix + this.fCounter.getAndIncrement();
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(this.fDaemon);
        thread.setUncaughtExceptionHandler(this.fExceptionHandler);
        this.fLogger.finest("Created new Thread " + string);
        return thread;
    }

    private static class LoggingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger fLogger;

        LoggingUncaughtExceptionHandler(Logger logger) {
            this.fLogger = logger;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.fLogger.log(Level.SEVERE, "Thread: " + thread.getName() + ", terminated with " + throwable.toString() + ":", throwable);
        }
    }
}

