/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.logging;

import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompSimpleFormatter;
import com.mathworks.toolbox.parallel.pctutil.logging.RotatingFileHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.SafeStreamHandler;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class DistcompFileHandler
extends SafeStreamHandler {
    private static final int TOTAL_FILE_SIZE_LIMIT = 1000000000;
    private static final int NUMBER_OF_FILES = 10;
    private final RotatingFileHandler fFileHandler;
    private final String fFileNamePattern;

    public DistcompFileHandler(String string, boolean bl, Level level, int n, int n2, Formatter formatter) throws IOException {
        this.setLevel(level);
        int n3 = n2 / n;
        this.fFileNamePattern = string;
        this.fFileHandler = new RotatingFileHandler(this.fFileNamePattern, n3, n, bl);
        this.fFileHandler.setLevel(Level.ALL);
        this.fFileHandler.setFormatter(formatter);
    }

    private DistcompFileHandler(String string, boolean bl, Level level) throws IOException {
        this(string, bl, level, 10, 1000000000, new DistcompSimpleFormatter());
    }

    public DistcompFileHandler(String string, boolean bl, int n) throws IOException {
        this(string, bl, DistcompLevel.getLevelFromValue(n));
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        if (this.getLevel() == Level.OFF) {
            return false;
        }
        if (logRecord.getLevel().intValue() < this.getLevel().intValue()) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(logRecord);
    }

    @Override
    public synchronized void reallyPublish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            this.fFileHandler.publish(logRecord);
        }
    }

    public String toString() {
        return this.fFileNamePattern;
    }
}

