/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider;

import com.mathworks.storage.provider.ChannelClosedHandler;
import com.mathworks.storage.provider.ProviderChannel;
import com.mathworks.storage.provider.ProviderException;
import com.mathworks.storage.provider.ProviderIOException;
import com.mathworks.storage.provider.StorageURI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ProviderChannelAdapter
implements ProviderChannel {
    private final SeekableByteChannel fChannel;
    private final StorageURI fStorageURI;
    private final boolean fAppendMode;
    private final ChannelClosedHandler fChannelClosedHandler;

    public ProviderChannelAdapter(SeekableByteChannel seekableByteChannel, StorageURI storageURI, boolean bl, ChannelClosedHandler channelClosedHandler) {
        this.fChannel = seekableByteChannel;
        this.fStorageURI = storageURI;
        this.fAppendMode = bl;
        this.fChannelClosedHandler = channelClosedHandler;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws ProviderException {
        try {
            return this.fChannel.read(byteBuffer);
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws ProviderException {
        try {
            if (this.fAppendMode) {
                this.fChannel.position(this.fChannel.size());
            }
            return this.fChannel.write(byteBuffer);
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
    }

    @Override
    public long position() throws ProviderException {
        try {
            return this.fChannel.position();
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
    }

    @Override
    public void position(long l) throws ProviderException {
        try {
            this.fChannel.position(l);
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
    }

    @Override
    public long size() throws ProviderException {
        try {
            return this.fChannel.size();
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
    }

    @Override
    public void close() throws ProviderException {
        try {
            this.fChannel.close();
        }
        catch (IOException iOException) {
            throw this.newProviderIOException(iOException);
        }
        finally {
            this.fChannelClosedHandler.channelClosed();
        }
    }

    private ProviderException newProviderIOException(IOException iOException) throws ProviderIOException {
        throw new ProviderIOException(this.fStorageURI, (Throwable)iOException);
    }
}

