/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public enum Artifact {
    MEX_FILE,
    STATIC_LIBRARY,
    SHARED_LIBRARY,
    EXECUTABLE,
    GENERIC_ASIC_FPGA,
    FPGA_TURNKEY,
    IP_CORE_LIBRARY;

    private Icon fIcon;
    private Icon fSmallIcon;

    public String getLabel() {
        return CoderResources.getString("app.artifact." + StringUtils.upperCaseToCamelCase((String)this.toString(), (boolean)false));
    }

    public String getDescription() {
        return CoderResources.getString("app.artifact." + StringUtils.upperCaseToCamelCase((String)this.toString(), (boolean)false) + ".desc");
    }

    public Icon getIcon() {
        if (this.fIcon == null) {
            Artifact.initializeIcons();
        }
        return this.fIcon;
    }

    public Icon getSmallIcon() {
        if (this.fSmallIcon == null) {
            Artifact.initializeIcons();
        }
        return this.fSmallIcon;
    }

    private Icon getRawIcon() {
        if (this == GENERIC_ASIC_FPGA || this == FPGA_TURNKEY || this == IP_CORE_LIBRARY) {
            return CoderResources.getIcon("artifact.hdl.png");
        }
        return CoderResources.getIcon("artifact." + StringUtils.upperCaseToCamelCase((String)this.toString(), (boolean)false) + ".png");
    }

    private Icon getRawSmallIcon() {
        if (this == GENERIC_ASIC_FPGA || this == FPGA_TURNKEY || this == IP_CORE_LIBRARY) {
            return CoderResources.getIcon("artifact.hdl.small.png");
        }
        return CoderResources.getIcon("artifact." + StringUtils.upperCaseToCamelCase((String)this.toString(), (boolean)false) + ".small.png");
    }

    private static void initializeIcons() {
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        for (Artifact artifact : Artifact.values()) {
            artifact.fIcon = artifact.getRawIcon();
            artifact.fSmallIcon = artifact.getRawSmallIcon();
            dimension.width = Math.max(dimension.width, artifact.fSmallIcon.getIconWidth());
            dimension.height = Math.max(dimension.height, artifact.fSmallIcon.getIconHeight());
            dimension2.width = Math.max(dimension2.width, artifact.fIcon.getIconWidth());
            dimension2.height = Math.max(dimension2.height, artifact.fIcon.getIconHeight());
        }
        for (Artifact artifact : Artifact.values()) {
            artifact.fIcon = Artifact.normalizeIconSize(artifact.fIcon, dimension2.width, dimension2.height);
            artifact.fSmallIcon = Artifact.normalizeIconSize(artifact.fSmallIcon, dimension.width, dimension.height);
        }
    }

    private static Icon normalizeIconSize(Icon icon, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, n / 2 - icon.getIconWidth() / 2, n2 / 2 - icon.getIconHeight() / 2);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public String getLabelWithExtension() {
        if (this == STATIC_LIBRARY && PlatformInfo.isWindows()) {
            return this.getLabel() + " (.lib)";
        }
        if (this == STATIC_LIBRARY && PlatformInfo.isUnix()) {
            return this.getLabel() + " (.a)";
        }
        if (this == SHARED_LIBRARY && PlatformInfo.isWindows()) {
            return this.getLabel() + " (.dll)";
        }
        if (this == SHARED_LIBRARY && PlatformInfo.isUnix()) {
            return this.getLabel() + " (.so)";
        }
        if (this == EXECUTABLE && PlatformInfo.isWindows()) {
            return this.getLabel() + " (.exe)";
        }
        return this.getLabel();
    }

    public boolean isHdl() {
        return this == GENERIC_ASIC_FPGA || this == IP_CORE_LIBRARY || this == FPGA_TURNKEY;
    }
}

