/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.ide.AbstractIDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.wfa.files.FileSetPanel;
import com.mathworks.toolbox.coder.wfa.files.FileSetSidebarWidget;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.files.FunctionTreeView;
import com.mathworks.toolbox.coder.wfa.files.MultiFileSetView;
import com.mathworks.toolbox.coder.wfa.files.MultiViewUtils;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

final class DefaultIDEFileSidebar
extends AbstractIDEFileSidebar {
    private final Collection<SelectionListener> fSelectionListeners;
    private final Selector fSidebarSelector;
    private final IDEView fIDEView;
    private MultiFileSetView fInputFlatView;
    private FunctionTreeView fInputFunctionView;
    private CallTreeFileSetView fCallTreeView;
    private FileSetView fInputListView;
    private FileSetView fOutputListView;
    private SelectionListener fInputSelectionListener;
    private SelectionListener fOutputSelectionListener;
    private boolean fIgnoreEvents;

    DefaultIDEFileSidebar(CoderApp coderApp, EditorView editorView, FileSetSidebarWidget fileSetSidebarWidget, IDEView iDEView) {
        super(coderApp, editorView, fileSetSidebarWidget);
        this.fIDEView = iDEView;
        this.fSelectionListeners = new LinkedList<SelectionListener>();
        this.fSidebarSelector = new SidebarSelector();
    }

    Selector getSidebarSelector() {
        return this.fSidebarSelector;
    }

    @Override
    public CallTreeFileSetView getCallTreeView() {
        return this.fCallTreeView;
    }

    @Override
    public FunctionTreeView getFunctionTreeView() {
        return this.fInputFunctionView;
    }

    void reevaluateInputViewDecorations() {
        MultiFileSetView multiFileSetView = this.getRootFileSetView("input-files");
        if (multiFileSetView != null) {
            multiFileSetView.setDecorateSidebar(multiFileSetView.getEnabledViewCount() > 1);
        }
    }

    void runOnCallTreeView(ParameterRunnable<CallTreeFileSetView> parameterRunnable) {
        this.runOnViewOfType(CallTreeFileSetView.class, parameterRunnable);
    }

    @Override
    public void toggleInputFlatViewState(boolean bl) {
        if (bl) {
            this.fInputFunctionView.update();
            this.fInputFlatView.setActiveView(this.fInputFunctionView);
        } else {
            this.fInputListView.update();
            this.fInputFlatView.setActiveView(this.fInputListView);
        }
    }

    @Override
    public void toggleCallTreeViewEnabled(final boolean bl) {
        this.runOnCallTreeView(new ParameterRunnable<CallTreeFileSetView>(){

            public void run(CallTreeFileSetView callTreeFileSetView) {
                DefaultIDEFileSidebar.this.getRootFileSetView("input-files").setSubViewEnabled(callTreeFileSetView, bl);
            }
        });
        this.reevaluateInputViewDecorations();
    }

    @Override
    void buildDefaultSidebar() {
        this.addFileSet("input-files", CoderResources.getString("wfa.generateCode.sourceCode"), true);
        this.addFileSet("output-files", CoderResources.getString("wfa.generateCode.outputFiles"), !this.getApp().getModel().getOutputFiles().isEmpty());
        this.installFileSetPanels();
        this.installCallTreeView();
        this.installInputSelectionListener();
        this.installOutputSelectionListener();
        MultiViewUtils.configureInputMultiView(this.getRootFileSetView("input-files"), this.fInputFlatView, this.fCallTreeView);
        this.getRootFileSetView("input-files").setActiveView(null);
        this.getRootFileSetView("output-files").setActiveView(null);
        this.getRootFileSetView("output-files").setDecorateSidebar(false);
        this.setFiles("input-files", this.getApp().getModel().getInputFiles());
        this.setFiles("output-files", this.getApp().getModel().getOutputFiles());
        this.reevaluateInputViewDecorations();
    }

    @Override
    public void reset() {
        if (this.fCallTreeView != null) {
            this.fCallTreeView.setCallTree(null);
        }
        if (this.fInputFunctionView != null) {
            this.fInputFunctionView.setFunctions(new HashMap<File, List<Function>>());
        }
    }

    private <T> void runOnViewOfType(Class<T> clazz, ParameterRunnable<T> parameterRunnable) {
        T t = this.getFileSetViewByType(clazz);
        if (t != null) {
            parameterRunnable.run(t);
        }
    }

    private void installFileSetPanels() {
        FileSetIntegrationContext fileSetIntegrationContext = this.getFileSetIntegrationContext("input-files");
        if (this.fInputFlatView == null) {
            this.fInputListView = new FileSetPanel(fileSetIntegrationContext, "wfa.sourceCode.list");
            this.fInputFunctionView = new FunctionTreeView(fileSetIntegrationContext);
            this.fInputFlatView = new MultiFileSetView(fileSetIntegrationContext, "wfa.sidebar.functionMultiView", this.fInputListView, this.fInputFunctionView);
            this.fInputFunctionView.setErrors(this.getApp().getModel().getErrors());
            this.fInputFunctionView.setFunctions(fileSetIntegrationContext.getSourceModel().getFunctionsByFile());
        }
        this.installFileSetView(this.fInputFlatView, "input-files");
        if (this.fOutputListView == null) {
            this.fOutputListView = new FileSetPanel(this.getFileSetIntegrationContext("output-files"), "wfa.outputFiles.list");
        }
        this.installFileSetView(this.fOutputListView, "output-files");
    }

    private void installCallTreeView() {
        if (this.fCallTreeView == null) {
            this.fCallTreeView = new CallTreeFileSetView(this.getApp().getGlassPaneManager(), this.getFileSetIntegrationContext("input-files"));
        }
        this.installFileSetView(this.fCallTreeView, "input-files");
        this.getRootFileSetView("input-files").setSubViewEnabled(this.fCallTreeView, this.getApp().getModel().getCallTree() != null);
        this.fCallTreeView.setErrors(this.getApp().getModel().getErrors());
        this.fCallTreeView.setCallTree(this.getApp().getModel().getCallTree());
    }

    private void installInputSelectionListener() {
        this.getRootFileSetView("input-files").addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                DefaultIDEFileSidebar.this.refireSelectionEvent(selectionEvent);
            }
        });
    }

    private void installOutputSelectionListener() {
        this.getRootFileSetView("output-files").addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                DefaultIDEFileSidebar.this.refireSelectionEvent(selectionEvent);
            }
        });
    }

    private void refireSelectionEvent(SelectionEvent selectionEvent) {
        this.fIDEView.fireSelect(selectionEvent.derive(this.fSidebarSelector));
    }

    private class SidebarSelector
    implements Selector {
        private SidebarSelector() {
        }

        @Override
        public void select(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() != null && selectionEvent.getSource().equals(this)) {
                return;
            }
            if (DefaultIDEFileSidebar.this.fInputFlatView != null) {
                DefaultIDEFileSidebar.this.fInputFlatView.select(selectionEvent);
            }
            if (DefaultIDEFileSidebar.this.fInputFunctionView != null) {
                DefaultIDEFileSidebar.this.fInputFunctionView.select(selectionEvent);
            }
            if (DefaultIDEFileSidebar.this.fInputListView != null) {
                DefaultIDEFileSidebar.this.fInputListView.select(selectionEvent);
            }
            if (DefaultIDEFileSidebar.this.fCallTreeView != null) {
                DefaultIDEFileSidebar.this.fCallTreeView.select(selectionEvent);
            }
            if (DefaultIDEFileSidebar.this.fOutputListView != null) {
                DefaultIDEFileSidebar.this.fOutputListView.select(selectionEvent);
            }
        }

        @Override
        public void addSelectionListener(SelectionListener selectionListener) {
            DefaultIDEFileSidebar.this.fSelectionListeners.add(selectionListener);
        }

        @Override
        public void removeSelectionListener(SelectionListener selectionListener) {
            DefaultIDEFileSidebar.this.fSelectionListeners.remove(selectionListener);
        }
    }
}

