/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.StaleTextMapper;
import com.mathworks.toolbox.coder.app.ide.AdHocEditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.CodeCoverageBar;
import com.mathworks.toolbox.coder.app.ide.CoderMKit;
import com.mathworks.toolbox.coder.app.ide.DefaultEditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditManager;
import com.mathworks.toolbox.coder.app.ide.EditorContextActionProvider;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorSnapshot;
import com.mathworks.toolbox.coder.app.ide.EditorSupport;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentEvent;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentListener;
import com.mathworks.toolbox.coder.app.ide.EditorViewRegistry;
import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.LineNumberPane;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.app.ide.VariableSelectionEvent;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.Interval;
import com.mathworks.toolbox.coder.model.ScreenerError;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.widgets.GlassPaneCloseButton;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.action.AbstractSaveAction;
import com.mathworks.widgets.text.ColoringDrawLayer;
import com.mathworks.widgets.text.ColoringFactory;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MarkPair;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.cplusplus.CKit;
import com.mathworks.widgets.text.cplusplus.CLanguage;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.plain.PlainKit;
import com.mathworks.widgets.text.plain.PlainLanguage;
import com.mathworks.widgets.text.verilog.VerilogKit;
import com.mathworks.widgets.text.verilog.VerilogLanguage;
import com.mathworks.widgets.text.vhdl.VHDLKit;
import com.mathworks.widgets.text.vhdl.VHDLLanguage;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SettingsUtil;

public class EditorView
implements Selector {
    private final MJPanel fComponent;
    private final GlassPaneManager fGlassPane;
    private final PopupBarManager fPopupBarManager;
    private final PropertyChangeListener fFocusListener;
    private final FileViewProvider fFileViewProvider;
    private final StaleTextMapper fTextMapper;
    private final Queue<Runnable> fWhenLoadedQueue;
    private final Collection<ParameterRunnable<EditorView>> fLoadedObservers;
    private final Collection<EditorViewContentListener> fContentListeners;
    private final Collection<SelectionListener> fSelectionListeners;
    private final DocumentListener fDocumentListener;
    private final Object fLoadLock;
    private final List<EditorContextActionProvider> fContextActionProviders;
    private final EditorSupport fEditorSupport;
    private final boolean fAutoRequestFocus;
    private final boolean fBaseEditable;
    private EditManager fEditManager;
    private CodeCoverageModel fCoverageModel;
    private SyntaxTextPane fTextPane = null;
    private ColoringDrawLayer fErrorLayer;
    private ColoringDrawLayer fWarningLayer;
    private ColoringDrawLayer fErrorHighlightLayer;
    private ColoringDrawLayer fWarningHighlightLayer;
    private ColoringDrawLayer fPopupHighlightLayer;
    private ColoringDrawLayer fGeneralHighlightLayer;
    private EditorSupport.SafeMarkList fProblemMarkList;
    private EditorSupport.SafeMarkList fSearchMarkList;
    private EditorSupport.SafeMarkList fSelectedSearchResultMarkList;
    private EditorSupport.SafeMarkList fErrorHighlightList;
    private EditorSupport.SafeMarkList fWarningHighlightList;
    private EditorSupport.SafeMarkList fPopupHighlightList;
    private EditorSupport.SafeMarkList fGeneralHighlightList;
    private List<EditorSupport.SafeMarkList> fAllMarkLists;
    private CodePopupController fPopup = null;
    private EditorLoadContext fLoadContext;
    private EditorLoadContext fContextToOpenOnClose;
    private List<BuildError> fBuildErrors;
    private Converter<EditorLoadContext, Function> fDefaultFunctionSource;
    private Predicate<File> fEditabilityPredicate;
    private volatile boolean fLoaded;
    private boolean fErrorsInSourceCode;
    private boolean fSuppressCaretChanged;
    private boolean fInternalChange;
    private boolean fEditable;
    private boolean fBorder;
    private boolean fErrorsCloseable;
    private GlassPaneCloseButton fCloseButton;
    private int fCurrentMatchIndex;
    private FunctionScopedEntityLocator fEntityLocator;
    private ParameterRunnable<Component> fActiveRequest;
    private Point fMousePoint;
    public static final String CODE_PANE_PROPERTY = "CodePane";
    private static final String ERROR_LAYER_NAME = "errors";
    private static final String ERROR_HIGHLIGHT_LAYER_NAME = "error-higlight";
    private static final String WARNING_LAYER_NAME = "warnings";
    private static final String WARNING_HIGHLIGHT_LAYER_NAME = "warning-highlight";
    private static final String SEARCH_LAYER_NAME = "search";
    private static final String SELECTED_SEARCH_RESULT_LAYER_NAME = "selected-search-result";
    private static final String POPUP_LAYER_NAME = "popup-mark-layer";
    private static final String GENERAL_LAYER_NAME = "general-highlight-layer";

    public EditorView(GlassPaneManager glassPaneManager, File file, PopupBarManager popupBarManager, FileViewProvider fileViewProvider, @Nullable FunctionScopedEntityLocator functionScopedEntityLocator, boolean bl, boolean bl2) {
        this.fGlassPane = glassPaneManager;
        this.fPopupBarManager = popupBarManager;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fBaseEditable = bl;
        this.fEditable = bl;
        this.fAutoRequestFocus = bl2;
        this.fFileViewProvider = fileViewProvider;
        this.fBuildErrors = new LinkedList<BuildError>();
        this.fTextMapper = new StaleTextMapper(this);
        this.fWhenLoadedQueue = new LinkedList<Runnable>();
        this.fLoadedObservers = new LinkedList<ParameterRunnable<EditorView>>();
        this.fContentListeners = new LinkedList<EditorViewContentListener>();
        this.fContextActionProviders = new LinkedList<EditorContextActionProvider>();
        this.fSelectionListeners = new LinkedList<SelectionListener>();
        this.fDocumentListener = this.createDocumentListener();
        this.fLoadLock = new Object();
        this.fBorder = true;
        this.fPopupBarManager.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!EditorView.this.fPopupBarManager.isPopupBarOpen()) {
                    EditorView.this.reload();
                }
            }
        });
        this.fEditorSupport = new EditorSupport(this);
        if (functionScopedEntityLocator != null) {
            this.setEntityLocator(functionScopedEntityLocator);
        }
        if (file != null) {
            DefaultEditorLoadContext defaultEditorLoadContext = CoderFileSupport.isMatlabSourceFile(file) ? new DefaultEditorLoadContext(new Function(file, FunctionUtils.getFunctionName(file))) : new DefaultEditorLoadContext(file);
            this.load(defaultEditorLoadContext);
        }
        this.fFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Window window;
                Window window2;
                if (!propertyChangeEvent.getPropertyName().equals("focusedWindow") || (window2 = SwingUtilities.windowForComponent((Component)EditorView.this.fComponent)) == null || (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null || window.equals(window2)) {
                    // empty if block
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.fFocusListener);
    }

    public EditorView(GlassPaneManager glassPaneManager, File file, PopupBarManager popupBarManager, FileViewProvider fileViewProvider, boolean bl, boolean bl2) {
        this(glassPaneManager, file, popupBarManager, fileViewProvider, null, bl, bl2);
    }

    public EditorSnapshot takeEditorSnapshot() {
        return this.takeEditorSnapshot(new EditorSnapshot());
    }

    public EditorSnapshot takeEditorSnapshot(EditorSnapshot editorSnapshot) {
        editorSnapshot.setErrors((List<BuildError>)(this.fBuildErrors != null ? new LinkedList<BuildError>(this.fBuildErrors) : null));
        editorSnapshot.setCloseFunctionConverter(this.fDefaultFunctionSource);
        editorSnapshot.setCoverageModel(this.fCoverageModel);
        editorSnapshot.setLocator(this.fEntityLocator);
        editorSnapshot.setErrorsCloseable(this.fErrorsCloseable);
        editorSnapshot.setDrawBorder(this.fBorder);
        editorSnapshot.setEditable(this.fEditable);
        editorSnapshot.setErrorsInSourceCode(this.fErrorsInSourceCode);
        editorSnapshot.setVisibleRect(this.fTextPane != null ? this.fTextPane.getVisibleRect() : null);
        editorSnapshot.setEditorContext(this.fLoadContext);
        editorSnapshot.store(this);
        return editorSnapshot;
    }

    public void restoreEditorSnapshot(final EditorSnapshot editorSnapshot) {
        this.resetViewModifications();
        this.fBorder = editorSnapshot.isDrawBorder();
        this.setBuildErrors(editorSnapshot.getErrors(), editorSnapshot.isErrorsInSourceCode());
        this.setEditable(editorSnapshot.isEditable());
        this.setCloseFunctionConverter(editorSnapshot.getCloseFunctionConverter());
        this.setEntityLocator(editorSnapshot.getLocator());
        this.setCoverageModel(editorSnapshot.getCoverageModel());
        this.setErrorsCloseable(editorSnapshot.isErrorsCloseable());
        this.load(editorSnapshot.getEditorContext() != null ? editorSnapshot.getEditorContext() : new AdHocEditorLoadContext("", null), new Runnable(){

            @Override
            public void run() {
                if (editorSnapshot.getVisibleRect() != null && EditorView.this.fTextPane != null) {
                    EditorView.this.fTextPane.scrollRectToVisible(editorSnapshot.getVisibleRect());
                }
                editorSnapshot.restore(EditorView.this);
            }
        });
    }

    public void resetViewModifications() {
        if (this.fAllMarkLists != null) {
            for (EditorSupport.SafeMarkList safeMarkList : this.fAllMarkLists) {
                safeMarkList.clear();
            }
        }
        this.hideCloseButton(false);
    }

    public void reset() {
        this.restoreEditorSnapshot(new EditorSnapshot());
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public SyntaxTextPane getTextPane() {
        return this.fTextPane;
    }

    public void setCloseFunctionConverter(Converter<EditorLoadContext, Function> converter) {
        this.fDefaultFunctionSource = converter;
    }

    public void setCaretPosition(final int n, final boolean bl) {
        this.whenLoaded(new Runnable(){

            @Override
            public void run() {
                if (EditorView.this.fTextPane != null) {
                    EditorView.this.fSuppressCaretChanged = true;
                    EditorView.this.clearGeneralHighlights();
                    EditorView.this.fTextPane.requestFocusInWindow();
                    EditorView.this.fTextPane.setCaretPosition(bl ? EditorView.this.fTextMapper.mapToCurrent(n) : n);
                    EditorView.this.fSuppressCaretChanged = false;
                }
            }
        });
    }

    public StaleTextMapper getTextMapper() {
        return this.fTextMapper;
    }

    public FunctionScopedEntityLocator getEntityLocator() {
        return this.fEntityLocator;
    }

    public void addFileLoadedCallback(ParameterRunnable<EditorView> parameterRunnable, boolean bl) {
        MJUtilities.assertEventDispatchThread();
        this.fLoadedObservers.add(parameterRunnable);
        if (this.isLoaded() && bl) {
            parameterRunnable.run((Object)this);
        }
    }

    @Override
    public void select(SelectionEvent selectionEvent) {
        if (!Utilities.areValuesDifferent(selectionEvent.getSource(), this)) {
            return;
        }
        switch (selectionEvent.getEventType()) {
            case FUNCTION: {
                this.displayFunction(selectionEvent.getFunction());
                break;
            }
            case CALLSITE: {
                this.displayCallSite(selectionEvent.getCallSite());
                break;
            }
            case VARIABLE: {
                this.displayVariable(selectionEvent.getVariable());
                break;
            }
            case ERROR: {
                this.displayError((BuildError)selectionEvent.getSelectedValue(), this.isErrorsCloseable(), null);
                break;
            }
            default: {
                this.displayFile(selectionEvent.getFile());
            }
        }
    }

    @Override
    public void addSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.add(selectionListener);
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.remove(selectionListener);
    }

    private void fireSelection(SelectionEvent selectionEvent) {
        for (SelectionListener selectionListener : new LinkedList<SelectionListener>(this.fSelectionListeners)) {
            selectionListener.selectionChanged(selectionEvent);
        }
    }

    public void addEditorViewContentListener(EditorViewContentListener editorViewContentListener) {
        this.fContentListeners.add(editorViewContentListener);
    }

    public void removeEditorViewContentListener(EditorViewContentListener editorViewContentListener) {
        this.fContentListeners.remove(editorViewContentListener);
    }

    public void removeFileLoadedCallback(ParameterRunnable<EditorView> parameterRunnable) {
        this.fLoadedObservers.remove(parameterRunnable);
    }

    public void installContextActionProvider(EditorContextActionProvider editorContextActionProvider) {
        if (this.fContextActionProviders.contains(editorContextActionProvider)) {
            throw new IllegalArgumentException("Action provider already installed: " + editorContextActionProvider);
        }
        this.fContextActionProviders.add(editorContextActionProvider);
    }

    public void uninstallContextActionProvider(EditorContextActionProvider editorContextActionProvider) {
        this.fContextActionProviders.remove(editorContextActionProvider);
    }

    List<EditorContextActionProvider> getContextActionProviders() {
        return Collections.unmodifiableList(this.fContextActionProviders);
    }

    public Point getMousePoint() {
        return this.fMousePoint;
    }

    public void dispose() {
        if (this.fPopup != null) {
            this.fPopup.dispose();
        }
        if (this.fCloseButton != null) {
            this.fCloseButton.dispose();
            this.fCloseButton = null;
        }
        if (this.fTextPane != null) {
            this.fTextPane.cleanup();
        }
        this.fFileViewProvider.dipose();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.fFocusListener);
        EditorViewRegistry.unregisterEditorView(this);
    }

    public void removeBorder() {
        this.fBorder = false;
    }

    public void setPopupController(CodePopupController codePopupController) {
        if (this.fPopup != null) {
            this.fPopup.dispose();
        }
        this.fPopup = codePopupController;
        if (this.fPopup != null) {
            this.fPopup.setSyntaxTextPane(this.fTextPane);
            this.fPopup.addPopupControllerObserver(this.createPopupControllerObserver());
            this.fPopup.setEditorLoadContext(this.fLoadContext != null && this.fLoadContext.hasFunction() ? this.fLoadContext : null);
            if (this.fLoadContext != null && this.fLoadContext.hasFunction()) {
                this.fPopup.takeCodeStateSnapshot();
            }
        }
    }

    public void setEntityLocator(FunctionScopedEntityLocator functionScopedEntityLocator) {
        if (this.fEntityLocator != null) {
            this.fEntityLocator.setErrorSource(null);
        }
        this.fEntityLocator = functionScopedEntityLocator;
        if (this.fEntityLocator != null) {
            functionScopedEntityLocator.setEditorView(this);
            this.fEntityLocator.setErrorSource(new ReturnRunnable<Collection<BuildError>>(){

                public Collection<BuildError> run() {
                    return new LinkedList<BuildError>(EditorView.this.fBuildErrors);
                }
            });
        }
    }

    public void setEditManager(EditManager editManager) {
        this.fEditManager = editManager;
    }

    public void setEditable(boolean bl) {
        MJUtilities.assertEventDispatchThread();
        this.fEditable = bl;
        this.whenLoaded(new Runnable(){

            @Override
            public void run() {
                if (EditorView.this.fTextPane != null) {
                    EditorView.this.fTextPane.setEditable(EditorView.this.isEditable());
                    EditorView.this.fTextPane.revalidate();
                    EditorView.this.fTextPane.repaint();
                }
            }
        });
    }

    public void setEditabilityPredicate(Predicate<File> predicate) {
        this.fEditabilityPredicate = predicate;
    }

    boolean isAutoRequestFocus() {
        return this.fAutoRequestFocus;
    }

    public boolean isEditable() {
        return this.fBaseEditable && this.fEditable;
    }

    public void setCoverageModel(CodeCoverageModel codeCoverageModel) {
        CodeCoverageBar codeCoverageBar;
        this.fCoverageModel = codeCoverageModel;
        if (this.fTextPane != null && this.fTextPane.getEditorUI() instanceof CoderMKit.CoderMEditorUI && (codeCoverageBar = ((CoderMKit.CoderMEditorUI)this.fTextPane.getEditorUI()).getCoverageBar()) != null) {
            codeCoverageBar.setModel(codeCoverageModel);
        }
    }

    public void setBuildErrors(@Nullable List<BuildError> list, boolean bl) {
        List<BuildError> list2 = this.fBuildErrors = list != null ? new ArrayList<BuildError>(list) : new LinkedList();
        if (this.fEntityLocator != null) {
            this.fEntityLocator.setErrorSource(new ReturnRunnable<Collection<BuildError>>(){

                public Collection<BuildError> run() {
                    return new LinkedList<BuildError>(EditorView.this.fBuildErrors);
                }
            });
        }
        this.fErrorsInSourceCode = !this.fBuildErrors.isEmpty() && bl;
        this.updateMarkList();
        if (this.fBuildErrors.isEmpty()) {
            this.hideFrozenCodeMessage();
        }
        if (this.fBuildErrors.isEmpty()) {
            this.hideCloseButton(true);
        }
    }

    public BuildError getBuildError(int n) {
        if (this.fLoadContext != null && this.fLoadContext.hasFunction()) {
            for (BuildError buildError : this.fBuildErrors) {
                EditorLoadContext editorLoadContext = null;
                if (buildError.getFunction() != null) {
                    editorLoadContext = new DefaultEditorLoadContext(buildError.getFunction());
                } else if (buildError.getErrorSourceCode() != null) {
                    editorLoadContext = new AdHocEditorLoadContext(buildError.getErrorSourceCode(), MLanguage.INSTANCE.getMimeType());
                }
                if (editorLoadContext == null || !((Object)editorLoadContext).equals(this.fLoadContext) || buildError.getPosition() > n || n >= buildError.getPosition() + buildError.getLength()) continue;
                return buildError;
            }
        }
        return null;
    }

    public int find(String string) {
        int n;
        this.fSearchMarkList.clear();
        this.fSelectedSearchResultMarkList.clear();
        string = string.toUpperCase(Locale.ENGLISH);
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        boolean bl = true;
        Rectangle rectangle = this.fTextPane.getVisibleRect();
        String string2 = this.fTextPane.getText().replaceAll("\r", "").toUpperCase(Locale.ENGLISH);
        for (int i = 0; i < string2.length() && (n = string2.indexOf(string, i)) >= 0; ++i) {
            ++n2;
            this.fSearchMarkList.addMark(SEARCH_LAYER_NAME, n, string.length());
            if (n3 == -1) {
                n3 = n;
                n5 = this.fSearchMarkList.size() - 1;
            }
            try {
                Point point = this.fTextPane.getPointFromPos(n);
                if (bl && this.fTextPane.getVisibleRect().contains(point)) {
                    bl = false;
                    this.fSelectedSearchResultMarkList.addMark(SELECTED_SEARCH_RESULT_LAYER_NAME, n, string.length());
                    this.fCurrentMatchIndex = this.fSearchMarkList.size() - 1;
                } else if (n4 == -1 && point.getY() > rectangle.getY() + rectangle.getHeight()) {
                    n4 = n;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            i = n + string.length() - 1;
        }
        if (bl && n4 > -1) {
            this.fTextPane.setCaretPosition(n4);
            this.fCurrentMatchIndex = 0;
            this.fSelectedSearchResultMarkList.addMark(SELECTED_SEARCH_RESULT_LAYER_NAME, n4, string.length());
        } else if (bl && n3 > -1) {
            this.fTextPane.setCaretPosition(n3);
            this.fCurrentMatchIndex = n5;
            this.fSelectedSearchResultMarkList.addMark(SELECTED_SEARCH_RESULT_LAYER_NAME, n3, string.length());
        }
        return n2;
    }

    public void findNext() {
        this.fSelectedSearchResultMarkList.clear();
        if (!this.fSearchMarkList.isEmpty()) {
            ++this.fCurrentMatchIndex;
            if (this.fCurrentMatchIndex >= this.fSearchMarkList.size()) {
                this.fCurrentMatchIndex = 0;
            }
            try {
                MarkPair markPair = this.fSearchMarkList.get(this.fCurrentMatchIndex);
                this.fSelectedSearchResultMarkList.addMark(SELECTED_SEARCH_RESULT_LAYER_NAME, markPair.getStartOffset(), markPair.getEndOffset() - markPair.getStartOffset());
                this.fTextPane.setCaretPosition(markPair.getStartOffset());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clearSearch() {
        this.fSearchMarkList.clear();
        this.fSelectedSearchResultMarkList.clear();
    }

    public void reload() {
        this.reload(false);
    }

    private int getTopVisibleLine() {
        int n = 1;
        if (this.fTextPane != null) {
            Rectangle rectangle = this.fTextPane.getVisibleRect();
            try {
                if (rectangle.getWidth() * rectangle.getHeight() > 0.0) {
                    n = this.fTextPane.getLineFromPos(this.fTextPane.getPosFromPoint(rectangle.getLocation()));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n;
    }

    public void displayFunction(Function function) {
        this.displayFunction(function, 1, false, false);
    }

    public void displayFunction(Function function, boolean bl) {
        this.displayFunction(function, 1, bl, false);
    }

    public void displayFunction(final Function function, int n, final boolean bl, boolean bl2) {
        this.load(new DefaultEditorLoadContext(function), n, false, bl2, null, new Runnable(){

            @Override
            public void run() {
                MJUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EditorView.this.scrollToFunction(function, bl);
                    }
                });
            }
        });
    }

    private void scrollToFunction(Function function, boolean bl) {
        if (this.fEntityLocator != null) {
            this.fEditorSupport.scrollToFunction(function, false, bl);
        } else if (this.fTextPane != null) {
            int n = MDocumentUtils.getFunctionLineNumber((BaseDocument)((BaseDocument)this.fTextPane.getDocument()), (String)function.getName());
            try {
                int n2 = this.fTextPane.getLineStart(n);
                Point point = this.fTextPane.getPointFromPos(n2);
                Rectangle rectangle = this.fTextPane.getVisibleRect();
                this.fTextPane.scrollRectToVisible(new Rectangle(0, point.y, rectangle.width, rectangle.height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void displayText(String string, @Nullable String string2) {
        this.load(new AdHocEditorLoadContext(string, string2));
    }

    public void displayFile(File file) {
        this.displayFile(file, false);
    }

    private void displayFile(final File file, boolean bl) {
        assert (MJUtilities.isEventDispatchThread());
        if (this.fFileViewProvider == null && file != null) {
            this.load(new DefaultEditorLoadContext(file));
            return;
        }
        assert (this.fFileViewProvider != null);
        this.fFileViewProvider.setCurrentFile(file);
        if (file != null && this.fFileViewProvider.isShowTextView()) {
            this.load(new DefaultEditorLoadContext(file), 1, false, bl, null, this.fFileViewProvider.getTextViewContinuation());
        } else if (file != null) {
            this.fActiveRequest = new ParameterRunnable<Component>(){

                public void run(Component component) {
                    assert (MJUtilities.isEventDispatchThread());
                    if (!Utilities.areValuesDifferent(EditorView.this.fActiveRequest, this)) {
                        EditorView.this.fComponent.removeAll();
                        if (component == null) {
                            MJLabel mJLabel = new MJLabel(CoderResources.getString("wfa.editor.fileNotSupported"));
                            mJLabel.setName("wfa.editor.fileNotSupported.label");
                            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
                            mJPanel.add((Component)mJLabel);
                            EditorView.this.fComponent.add((Component)mJPanel);
                        } else {
                            EditorView.this.fComponent.add(component);
                        }
                        EditorView.this.fComponent.revalidate();
                        EditorView.this.fComponent.repaint();
                        EditorView.this.assignLoadContext(new DefaultEditorLoadContext(file));
                        EditorView.this.fLoaded = true;
                        EditorView.this.fActiveRequest = null;
                        EditorView.this.onLoaded();
                    }
                }
            };
            this.fLoaded = false;
            this.fFileViewProvider.provideComponentWhenReady(this.fActiveRequest);
        } else {
            this.fActiveRequest = null;
            this.assignLoadContext(null);
            if (this.fPopup != null) {
                this.fPopup.setEditorLoadContext(null);
            }
            if (this.fTextPane != null) {
                this.silentlySetText("", null);
                this.fTextPane.setEditable(false);
            }
        }
    }

    public void displayError(final BuildError buildError, boolean bl, Runnable runnable) {
        EditorLoadContext editorLoadContext;
        if (!this.fTextMapper.isValid()) {
            return;
        }
        if (buildError.getFunction() != null) {
            editorLoadContext = new DefaultEditorLoadContext(buildError.getFunction());
        } else if (buildError.getErrorSourceCode() != null) {
            editorLoadContext = new AdHocEditorLoadContext(buildError.getErrorSourceCode(), MLanguage.INSTANCE.getMimeType());
        } else {
            return;
        }
        this.load(editorLoadContext, buildError.getLine(), false, bl, runnable, new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                if (buildError instanceof ScreenerError) {
                    n2 = buildError.getPosition();
                    n = buildError.getLength();
                    int n3 = buildError.getPosition() + n;
                } else {
                    n2 = EditorView.this.fTextMapper.mapToCurrent(buildError.getPosition());
                    int n4 = EditorView.this.fTextMapper.mapToCurrent(buildError.getPosition() + buildError.getLength());
                    n = n4 - n2;
                }
                EditorView.this.setVariableHighlightingEnabled(false);
                EditorView.this.fErrorHighlightList.clear();
                EditorView.this.fWarningHighlightList.clear();
                if (buildError.getSeverity() == BuildErrorSeverity.WARNING) {
                    EditorView.this.fWarningHighlightList.addMark(EditorView.WARNING_HIGHLIGHT_LAYER_NAME, n2, n);
                } else {
                    EditorView.this.fErrorHighlightList.addMark(EditorView.ERROR_HIGHLIGHT_LAYER_NAME, n2, n);
                }
                EditorView.this.fEditorSupport.scrollToPosition(n2, true);
            }
        });
    }

    public void displayCallSite(final CallTree.CallSite callSite) {
        this.load(new DefaultEditorLoadContext(callSite.getEnclosingFunction()), new Runnable(){

            @Override
            public void run() {
                EditorView.this.fEditorSupport.scrollToCallSite(callSite, true);
            }
        });
    }

    public void displayVariable(Variable variable) {
        this.displayVariable(variable, true);
    }

    public void displayVariable(final Variable variable, final boolean bl) {
        this.load(new DefaultEditorLoadContext(variable.getFunction()), new Runnable(){

            @Override
            public void run() {
                EditorView.this.fEditorSupport.scrollToVariable(variable, bl);
            }
        });
    }

    public CodePopupController getPopupController() {
        return this.fPopup;
    }

    public Function getCurrentFunction() {
        return this.fLoadContext != null ? this.fLoadContext.getFunction() : null;
    }

    public File getCurrentFile() {
        return this.isExplicitFile() ? this.fLoadContext.getFile() : null;
    }

    public EditorLoadContext getLoadContext() {
        return this.fLoadContext;
    }

    private Interval validateInterval(Interval interval) {
        Interval interval2 = interval;
        if (this.fTextPane != null) {
            int n = Math.max(0, Math.min(interval2.getStart(), this.fTextPane.getLength()));
            int n2 = Math.max(0, Math.min(n + interval2.getLength(), this.fTextPane.getLength()));
            interval2 = new Interval(n, n2);
        }
        return interval2;
    }

    private void updateMarkList() {
        if (this.fTextMapper.isValid() && this.fProblemMarkList != null) {
            this.fProblemMarkList.clear();
            this.fErrorHighlightList.clear();
            this.fWarningHighlightList.clear();
            for (BuildError buildError : this.fBuildErrors) {
                Interval interval;
                if (buildError.getFunction() == null || this.fLoadContext == null || !this.fLoadContext.isSameFile(buildError.getFunction().getFile()) || this.getEntityLocator() == null) continue;
                Interval interval2 = interval = !(buildError instanceof ScreenerError) ? this.validateInterval(this.getEntityLocator().getBuildErrorInterval(buildError)) : new Interval(buildError.getPosition(), buildError.getPosition() + buildError.getLength());
                if (buildError.getSeverity() == BuildErrorSeverity.ERROR || buildError.getSeverity() == BuildErrorSeverity.FATAL) {
                    this.fProblemMarkList.addMark(ERROR_LAYER_NAME, interval.getStart(), interval.getLength());
                    continue;
                }
                if (buildError.getSeverity() != BuildErrorSeverity.WARNING) continue;
                this.fProblemMarkList.addMark(WARNING_LAYER_NAME, interval.getStart(), interval.getLength());
            }
        }
    }

    private void showFrozenCodeMessage() {
        this.fPopupBarManager.showSpecialHint(CoderResources.getString("f2f.code.frozen"));
    }

    private void hideFrozenCodeMessage() {
        this.fPopupBarManager.hideSpecialHint();
    }

    public void reload(boolean bl) {
        if (this.fLoadContext != null && (bl || this.fLoadContext.hasChanged())) {
            if (this.fLoadContext.hasFunction()) {
                if (this.fCoverageModel != null && this.fLoadContext.hasFile()) {
                    this.fCoverageModel.invalidate(this.fLoadContext.getFile());
                }
                this.load(this.fLoadContext, 1, true, this.fCloseButton != null, null, null);
            } else if (this.isExplicitFile()) {
                this.displayFile(this.fLoadContext.getFile(), this.fCloseButton != null);
            }
        }
    }

    public void highlight(final @Nullable Color color, final Interval ... intervalArray) {
        this.whenLoaded(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (EditorView.this.fGeneralHighlightLayer == null && EditorView.this.fGeneralHighlightList == null) {
                    return;
                }
                Color color2 = color != null ? color : new Color(183, 220, 234);
                EditorView.this.fGeneralHighlightList.clear();
                EditorView.this.fGeneralHighlightLayer.setColoring(ColoringFactory.createTextHighlight((Color)color2));
                if (intervalArray != null) {
                    object = intervalArray;
                    int n = ((Interval[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Interval interval = object[i];
                        if (interval == null) continue;
                        interval = EditorView.this.validateInterval(interval);
                        EditorView.this.fGeneralHighlightList.addMark(EditorView.GENERAL_LAYER_NAME, interval.getStart(), interval.getLength());
                    }
                }
                if ((object = EditorView.this.fTextPane.getEditorKit()) instanceof CoderMKit) {
                    ((CoderMKit)((Object)object)).setHighlightingEnabled((JTextComponent)EditorView.this.fTextPane, false);
                }
            }
        });
    }

    public void clearGeneralHighlights() {
        if (this.fGeneralHighlightList != null) {
            this.fGeneralHighlightList.clear();
        }
    }

    public Point getPointForPosition(int n, int n2) throws BadLocationException {
        if (this.fTextPane == null) {
            return null;
        }
        return this.fTextPane.getPointFromPos(this.fTextPane.getLineStart(n) + n2);
    }

    public Point getPointForVariable(String string) {
        if (this.fTextPane == null) {
            return null;
        }
        String string2 = this.fTextPane.getText();
        for (int i = 0; i < string2.length() && (i = string2.indexOf(string, i)) != -1; ++i) {
            if (i != 0 && (Character.isLetter(string2.charAt(i - 1)) || Character.isDigit(string2.charAt(i - 1))) || i + string.length() != string2.length() && (Character.isLetter(string2.charAt(i + string.length())) || Character.isDigit(string2.charAt(i + string.length())))) continue;
            try {
                this.fEditorSupport.scrollToPosition(i, true);
                Point point = this.fTextPane.getPointFromPos(i);
                return new Point((int)point.getX() + 2, (int)point.getY() + 2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public void forceHoverPointForTesting(Point point) {
        if (this.fPopup != null) {
            this.fPopup.forcePointForTesting(point);
        }
    }

    public int getPosFromPoint(Point point) {
        if (this.fTextPane == null) {
            return -1;
        }
        try {
            return this.fTextPane.getPosFromPoint(point);
        }
        catch (NullPointerException | BadLocationException exception) {
            return -1;
        }
    }

    @Nullable
    public Point getPointFromPos(int n) {
        if (this.fTextPane == null) {
            return null;
        }
        try {
            return this.fTextPane.getPointFromPos(n);
        }
        catch (NullPointerException | BadLocationException exception) {
            return null;
        }
    }

    private void showCloseButton(final @Nullable Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EditorView.this.fCloseButton == null) {
                    EditorView.this.fCloseButton = new GlassPaneCloseButton(EditorView.this.fGlassPane, (Component)EditorView.this.fComponent, new Runnable(){

                        @Override
                        public void run() {
                            Function function;
                            EditorView.this.fCloseButton = null;
                            EditorView.this.selectionChanged(EditorView.this.fContextToOpenOnClose != null && EditorView.this.fContextToOpenOnClose.hasFunction() ? EditorView.this.fContextToOpenOnClose.getFunction() : null);
                            if (EditorView.this.fPopup != null) {
                                EditorView.this.fPopup.setEditorLoadContext(EditorView.this.fContextToOpenOnClose);
                            }
                            File file = null;
                            boolean bl = false;
                            if (EditorView.this.fDefaultFunctionSource != null && EditorView.this.fContextToOpenOnClose != null && (function = (Function)EditorView.this.fDefaultFunctionSource.convert((Object)EditorView.this.fContextToOpenOnClose)) != null) {
                                EditorView.this.displayFunction(function);
                                file = function.getFile();
                                bl = true;
                                EditorView.this.fireSelection(new FunctionSelectionEvent(EditorView.this, function));
                            }
                            if (!bl) {
                                if (EditorView.this.fContextToOpenOnClose != null && EditorView.this.fContextToOpenOnClose.exists()) {
                                    SelectionEvent selectionEvent;
                                    file = EditorView.this.fContextToOpenOnClose.getFile();
                                    EditorView.this.load(EditorView.this.fContextToOpenOnClose);
                                    EditorView editorView = EditorView.this;
                                    if (EditorView.this.fContextToOpenOnClose.hasFunction()) {
                                        selectionEvent = new FunctionSelectionEvent(EditorView.this, EditorView.this.fContextToOpenOnClose.getFunction());
                                    } else {
                                        file = EditorView.this.fContextToOpenOnClose.getFile();
                                        FileSelectionEvent fileSelectionEvent = new FileSelectionEvent(EditorView.this, file);
                                        selectionEvent = fileSelectionEvent;
                                    }
                                    editorView.fireSelection(selectionEvent);
                                } else {
                                    EditorView.this.displayFile(null);
                                }
                            }
                            EditorView.this.setEditable(file != null && EditorView.this.fEditabilityPredicate != null && EditorView.this.fEditabilityPredicate.accept(file));
                            if (runnable != null) {
                                runnable.run();
                            }
                        }
                    }, null, new Dimension(-50, 36));
                }
            }
        });
    }

    private void hideCloseButton(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EditorView.this.fCloseButton != null) {
                    if (bl) {
                        EditorView.this.fCloseButton.close();
                    } else {
                        EditorView.this.fCloseButton.dispose();
                    }
                    EditorView.this.fCloseButton = null;
                }
            }
        });
    }

    private void load(EditorLoadContext editorLoadContext) {
        this.load(editorLoadContext, null);
    }

    private void load(EditorLoadContext editorLoadContext, @Nullable Runnable runnable) {
        this.load(editorLoadContext, 1, false, false, null, runnable);
    }

    private void goToLine(int n) {
        try {
            int n2 = this.fTextPane.getLineStart(n - 1);
            Point point = this.fTextPane.getPointFromPos(n2);
            this.fTextPane.scrollRectToVisible(new Rectangle((int)point.getX(), (int)point.getY() - 4, 16, this.fTextPane.getLineHeight() + 8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void load(EditorLoadContext editorLoadContext, int n, boolean bl) {
        this.load(editorLoadContext, n, bl, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(final @NotNull EditorLoadContext editorLoadContext, int n, final boolean bl, final boolean bl2, final @Nullable Runnable runnable, final @Nullable Runnable runnable2) {
        if (this.fLoadContext != null && this.fTextPane != null && SwingUtilities.isEventDispatchThread() && !bl && editorLoadContext != null && this.fLoadContext.equals(editorLoadContext)) {
            Object object = this.fLoadLock;
            synchronized (object) {
                this.fLoadContext = editorLoadContext;
            }
            if (n != 1) {
                this.goToLine(n);
            } else {
                this.fComponent.revalidate();
                this.fComponent.repaint();
            }
            object = this.fLoadLock;
            synchronized (object) {
                if (this.fLoaded) {
                    this.onLoaded();
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                } else {
                    this.whenLoaded(new Runnable(){

                        @Override
                        public void run() {
                            if (runnable2 != null) {
                                runnable2.run();
                            }
                        }
                    });
                }
            }
            return;
        }
        Object object = this.fLoadLock;
        synchronized (object) {
            this.fLoaded = false;
        }
        try {
            this.fFileViewProvider.setCurrentFile(editorLoadContext.getFile());
            if (this.fLoadContext != null && this.fLoadContext.hasFile()) {
                this.fContextToOpenOnClose = this.fLoadContext;
            }
            this.assignLoadContext(editorLoadContext);
            object = null;
            if (this.fEditManager != null && editorLoadContext.hasFile() && this.fEditManager.isDirty(editorLoadContext.getFile())) {
                object = this.fEditManager.getDirtyText(editorLoadContext.getFile());
            }
            Object object2 = object != null && !bl ? object : editorLoadContext.loadText();
            MJUtilities.runOnEventDispatchThread((Runnable)new LoadRunnable(editorLoadContext, (String)object2, n, runnable2){
                final /* synthetic */ String val$text;
                final /* synthetic */ int val$line;
                final /* synthetic */ Runnable val$continuation;
                {
                    this.val$text = string;
                    this.val$line = n;
                    this.val$continuation = runnable2;
                    super(editorLoadContext3);
                }

                @Override
                void performLoad() {
                    EditorView.this.hideCloseButton(false);
                    if (bl2) {
                        EditorView.this.showCloseButton(runnable);
                    }
                    if (bl) {
                        EditorView.this.fEditManager.clear(editorLoadContext);
                    }
                    if (EditorView.this.fTextPane == null) {
                        EditorView.this.initTextPane();
                    } else {
                        EditorView.this.fTextPane.getDocument().removeDocumentListener(EditorView.this.fDocumentListener);
                    }
                    EditorView.this.fComponent.removeAll();
                    if (EditorView.this.fTextPane.getParent() != null) {
                        EditorView.this.fTextPane.getParent().remove((Component)EditorView.this.fTextPane);
                    }
                    EditorView.this.fTextPane.setContentType(editorLoadContext.getContentType());
                    EditorView.this.fTextPane.setEditable(EditorView.this.isEditable());
                    EditorView.this.silentlySetText(this.val$text, editorLoadContext);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fErrorLayer, 500);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fWarningLayer, 500);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fErrorHighlightLayer, 501);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fWarningHighlightLayer, 501);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fPopupHighlightLayer, 9001);
                    EditorView.this.fTextPane.getEditorUI().addLayer((DrawLayer)EditorView.this.fGeneralHighlightLayer, 499);
                    if (EditorView.this.fEntityLocator != null) {
                        EditorView.this.fEntityLocator.takeCodeSnapshot(editorLoadContext.getFunction(), this.val$text);
                    }
                    EditorView.this.updateMarkList();
                    if (EditorView.this.fEditManager != null) {
                        EditorView.this.fTextPane.getDocument().addDocumentListener(EditorView.this.fDocumentListener);
                    }
                    boolean bl3 = EditorView.this.fFileViewProvider.isShowDisclaimer();
                    if (EditorView.this.fTextPane.getEditorUI() instanceof EditorSupport.CoderEditorUI) {
                        ((EditorSupport.CoderEditorUI)EditorView.this.fTextPane.getEditorUI()).createExtComponent();
                    }
                    if (!EditorView.this.fBorder) {
                        EditorView.this.fTextPane.setBorder(null);
                    }
                    EditorView.this.fComponent.add((Component)(bl3 ? new TextOverPanel(EditorView.this.fTextPane.getDisplayComponent(), EditorView.this.fFileViewProvider.getDisclaimer(), new ParameterRunnable<Boolean>(){

                        public void run(Boolean bl) {
                            ParameterRunnable<Boolean> parameterRunnable = EditorView.this.fFileViewProvider.getDisclaimerCallback();
                            if (parameterRunnable != null) {
                                parameterRunnable.run((Object)bl);
                            }
                            if (bl.booleanValue()) {
                                EditorView.this.onLoaded();
                            }
                        }
                    }) : EditorView.this.fTextPane.getDisplayComponent()));
                    EditorView.this.fComponent.revalidate();
                    EditorView.this.fComponent.repaint();
                    if (this.val$line >= 1) {
                        EditorView.this.goToLine(this.val$line);
                    }
                    EditorView.this.setCoverageModel(EditorView.this.fCoverageModel);
                    EditorView.this.postInitializeTextPane(EditorView.this.fTextPane, editorLoadContext.getFunction());
                    EditorView.this.setVariableHighlightingEnabled(true);
                    if (!bl3) {
                        EditorView.this.onLoaded();
                    }
                    if (this.val$continuation != null) {
                        this.val$continuation.run();
                    }
                }
            });
        }
        catch (IOException iOException) {
            this.displayFailureToLoad(editorLoadContext.getFile());
        }
    }

    private void initTextPane() {
        this.fTextPane = new SyntaxTextPane(){

            public void paintComponent(Graphics graphics) {
                CodeCoverageBar codeCoverageBar;
                super.paintComponent(graphics);
                if (this.getEditorUI() instanceof CoderMKit.CoderMEditorUI && (codeCoverageBar = ((CoderMKit.CoderMEditorUI)this.getEditorUI()).getCoverageBar()) != null && codeCoverageBar.getStretchRatio() > 0.0) {
                    codeCoverageBar.paintComponent(graphics, this.getBackground(), false, (int)((double)this.getWidth() * codeCoverageBar.getStretchRatio()), new Rectangle(0, 0, (int)this.getVisibleRect().getWidth(), (int)this.getVisibleRect().getHeight()));
                }
            }

            public Color getBackground() {
                return this.isEditable() || !EditorView.this.fBaseEditable ? super.getBackground() : new Color(229, 229, 229);
            }
        };
        EditorViewRegistry.registerEditorView(this);
        this.fTextPane.setName("f2f.code");
        this.fTextPane.putClientProperty((Object)CODE_PANE_PROPERTY, (Object)this);
        this.fTextPane.registerEditorKit(CLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new CoderCKit()));
        this.fTextPane.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new CoderMKit(this)));
        this.fTextPane.registerEditorKit(VHDLLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new CoderVHDLKit()));
        this.fTextPane.registerEditorKit(VerilogLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new CoderVerilogKit()));
        this.fTextPane.registerEditorKit(PlainLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new CoderPlainKit(this)));
        this.fTextPane.setContentType(MLanguage.INSTANCE.getMimeType());
        this.fTextPane.setShowRightMargin(false, true);
        this.fTextPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EditorView.this.clearGeneralHighlights();
                if (EditorView.this.isLoaded()) {
                    EditorView.this.fireUserCaretContextChanged(caretEvent.getDot());
                }
            }
        });
        this.fTextPane.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                EditorView.this.fMousePoint = mouseEvent.getPoint();
            }
        });
        this.fTextPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!PlatformInfo.isMacintosh()) {
                    this.handleMenu(mouseEvent);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (PlatformInfo.isMacintosh()) {
                    this.handleMenu(mouseEvent);
                }
            }

            private void handleMenu(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && EditorView.this.fPopup != null) {
                    try {
                        int n = EditorView.this.fTextPane.getPosFromPoint(mouseEvent.getPoint());
                        Function function = EditorView.this.fPopup.getEffectiveFunction(n, true);
                        if (function != null && !function.equals(EditorView.this.fLoadContext.getFunction())) {
                            EditorView.this.fLoadContext = new DefaultEditorLoadContext(function);
                            EditorView.this.selectionChanged(function);
                            EditorView.this.fPopup.setEditorLoadContext(EditorView.this.fLoadContext);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.registerKeyBindings(this.fTextPane);
        this.fProblemMarkList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fSearchMarkList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fErrorHighlightList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fWarningHighlightList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fGeneralHighlightList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fSelectedSearchResultMarkList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fPopupHighlightList = new EditorSupport.SafeMarkList((STPBaseInterface)this.fTextPane);
        this.fAllMarkLists = Arrays.asList(this.fProblemMarkList, this.fSearchMarkList, this.fErrorHighlightList, this.fWarningHighlightList, this.fGeneralHighlightList, this.fSelectedSearchResultMarkList, this.fPopupHighlightList);
        this.fErrorLayer = new ColoringDrawLayer(ERROR_LAYER_NAME, ColoringFactory.createWavyUnderline((Color)EditorPrefsAccessor.getErrorsColoring().getForeColor()));
        this.fWarningLayer = new ColoringDrawLayer(WARNING_LAYER_NAME, ColoringFactory.createWavyUnderline((Color)((Color)SettingsUtil.getValue(MKit.class, (String)ColorPrefs.MatlabColor.WARNING.getKey(), (Object)CodeAnalyzerUtils.getWarningColor()))));
        this.fErrorHighlightLayer = new ColoringDrawLayer(ERROR_HIGHLIGHT_LAYER_NAME, ColoringFactory.createTextHighlight((Color)new Color(255, 223, 223)));
        this.fWarningHighlightLayer = new ColoringDrawLayer(WARNING_HIGHLIGHT_LAYER_NAME, ColoringFactory.createTextHighlight((Color)new Color(255, 220, 185)));
        this.fPopupHighlightLayer = new ColoringDrawLayer(POPUP_LAYER_NAME, ColoringFactory.createTextHighlight((Color)new Color(25, 220, 223)));
        ColoringDrawLayer coloringDrawLayer = new ColoringDrawLayer(SEARCH_LAYER_NAME, ColoringFactory.createTextHighlight((Color)new Color(255, 255, 242)));
        ColoringDrawLayer coloringDrawLayer2 = new ColoringDrawLayer(SELECTED_SEARCH_RESULT_LAYER_NAME, ColoringFactory.createTextHighlight((Color)new Color(255, 255, 170)));
        this.fGeneralHighlightLayer = new ColoringDrawLayer(GENERAL_LAYER_NAME, ColoringFactory.createTextHighlight((Color)Color.YELLOW));
        this.fTextPane.getEditorUI().addLayer((DrawLayer)coloringDrawLayer, 9000);
        this.fTextPane.getEditorUI().addLayer((DrawLayer)coloringDrawLayer2, 10000);
        this.fTextMapper.setTextPane(this.getTextPane());
        if (this.fPopup != null) {
            this.fPopup.setSyntaxTextPane(this.fTextPane);
        }
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!EditorView.this.fInternalChange && EditorView.this.isExplicitFile()) {
                    EditorView.this.fEditManager.setDirty(EditorView.this.fLoadContext, EditorView.this.fTextPane.getText());
                }
                EditorView.this.setCoverageModel(null);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private void silentlySetText(String string, @Nullable EditorLoadContext editorLoadContext) {
        this.fInternalChange = true;
        this.fTextMapper.setMonitoring(false);
        this.fTextPane.setText(string);
        this.fTextPane.discardAllUndoEdits();
        this.fTextPane.setUndoCleanMarker();
        this.fTextMapper.setMonitoring(true);
        this.fInternalChange = false;
    }

    void fireUserCaretContextChanged(int n) {
        if (this.fSuppressCaretChanged || this.fEntityLocator == null || this.fInternalChange) {
            return;
        }
        Collection<CodableEntity> collection = this.fEntityLocator.getEntitiesAtPosition(n);
        Iterator<CodableEntity> iterator = collection.iterator();
        while (iterator.hasNext()) {
            CodableEntity codableEntity = iterator.next();
            if (codableEntity.getEntityType() != CodableEntity.Type.FUNCTION) continue;
            this.fireEditorContentEvent(codableEntity, n, true);
            this.fireSelection(new FunctionSelectionEvent(this, (Function)codableEntity));
            iterator.remove();
            break;
        }
        for (CodableEntity codableEntity : collection) {
            this.fireEditorContentEvent(codableEntity, n, true);
            VariableSelectionEvent variableSelectionEvent = null;
            if (codableEntity.getEntityType() == CodableEntity.Type.VARIABLE) {
                variableSelectionEvent = new VariableSelectionEvent(this, (Variable)codableEntity);
            }
            if (variableSelectionEvent == null) continue;
            this.fireSelection(variableSelectionEvent);
        }
    }

    private void fireEditorContentEvent(CodableEntity codableEntity, int n, boolean bl) {
        EditorViewContentEvent editorViewContentEvent = new EditorViewContentEvent(codableEntity, this, n, bl);
        for (EditorViewContentListener editorViewContentListener : new LinkedList<EditorViewContentListener>(this.fContentListeners)) {
            editorViewContentListener.handleEditorViewContentEvent(editorViewContentEvent);
        }
    }

    private CodePopupController.PopupControllerObserver createPopupControllerObserver() {
        final EnumMap<CodePopupController.PopupFlavor, Coloring> enumMap = new EnumMap<CodePopupController.PopupFlavor, Coloring>(CodePopupController.PopupFlavor.class);
        final Coloring coloring = ColoringFactory.createTextHighlight((Color)VariableHighlightPrefs.getPreferredHighlightColor());
        int n = 150;
        enumMap.put(CodePopupController.PopupFlavor.BUILD_ERROR, ColoringFactory.createTextHighlight((Color)new Color(255, 223, 223, n)));
        enumMap.put(CodePopupController.PopupFlavor.SPECIALIZATION_HINT, ColoringFactory.createTextHighlight((Color)new Color(243, 247, 108, n)));
        enumMap.put(CodePopupController.PopupFlavor.EXPRESSION, ColoringFactory.createTextHighlight((Color)new Color(255, 213, 163, n)));
        return new CodePopupController.PopupControllerObserver(){

            @Override
            public void currentPopupChanged(CodePopupController.PopupFlavor popupFlavor, Interval interval) {
                CoderMKit coderMKit;
                EditorView.this.clearGeneralHighlights();
                EditorView.this.fPopupHighlightList.clear();
                CoderMKit coderMKit2 = coderMKit = EditorView.this.fTextPane != null && EditorView.this.fTextPane.getEditorKit() instanceof CoderMKit ? (CoderMKit)((Object)EditorView.this.fTextPane.getEditorKit()) : null;
                if (interval != null) {
                    if (popupFlavor != null && enumMap.containsKey((Object)popupFlavor)) {
                        EditorView.this.fPopupHighlightLayer.setColoring((Coloring)enumMap.get((Object)popupFlavor));
                    } else {
                        EditorView.this.fPopupHighlightLayer.setColoring(coloring);
                    }
                    EditorView.this.fPopupHighlightList.addMark(EditorView.POPUP_LAYER_NAME, interval.getStart(), interval.getLength());
                }
                if (coderMKit != null) {
                    coderMKit.setHighlightingEnabled((JTextComponent)EditorView.this.fTextPane, interval == null);
                }
            }
        };
    }

    private void setVariableHighlightingEnabled(boolean bl) {
        if (this.fTextPane == null) {
            return;
        }
        EditorKit editorKit = this.fTextPane.getEditorKit();
        if (editorKit instanceof CoderMKit) {
            ((CoderMKit)((Object)editorKit)).setHighlightingEnabled((JTextComponent)this.fTextPane, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoaded() {
        Iterator iterator = this.fLoadLock;
        synchronized (iterator) {
            this.fLoaded = true;
        }
        this.fTextMapper.setCurrent(this.fLoadContext);
        if (this.fPopup != null) {
            this.fPopup.setEditorLoadContext(this.fLoadContext);
        }
        for (Runnable runnable : new LinkedList<Runnable>(this.fWhenLoadedQueue)) {
            runnable.run();
        }
        this.fWhenLoadedQueue.clear();
        for (ParameterRunnable parameterRunnable : new LinkedList<ParameterRunnable<EditorView>>(this.fLoadedObservers)) {
            parameterRunnable.run((Object)this);
        }
    }

    private void whenLoaded(final Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EditorView.this.fLoaded) {
                    runnable.run();
                } else {
                    EditorView.this.fWhenLoadedQueue.offer(runnable);
                }
            }
        });
    }

    public boolean isExplicitFile() {
        return this.fLoadContext != null && this.fLoadContext.hasFile();
    }

    protected void postInitializeTextPane(SyntaxTextPane syntaxTextPane, Function function) {
    }

    protected void selectionChanged(Function function) {
    }

    protected void preShowContextMenu() {
    }

    public boolean isLoaded() {
        assert (MJUtilities.isEventDispatchThread());
        return this.fLoaded;
    }

    public void forNonFoldedLines(ParameterRunnable<Integer> parameterRunnable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 1; i <= this.fTextPane.getNumLines(); ++i) {
            try {
                if (!hashSet.add(this.fTextPane.getPointFromPos((int)this.fTextPane.getLineStart((int)(i - 1))).y)) {
                    continue;
                }
            }
            catch (NullPointerException | BadLocationException exception) {
                // empty catch block
            }
            parameterRunnable.run((Object)i);
        }
    }

    private void displayFailureToLoad(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = MessageFormat.format(CoderResources.getString("f2f.codeLoadError"), file);
                MJLabel mJLabel = new MJLabel(string);
                mJLabel.setHorizontalAlignment(0);
                mJLabel.setName("f2f.codeLoadError.label");
                EditorView.this.fComponent.removeAll();
                EditorView.this.fComponent.add((Component)mJLabel);
                EditorView.this.fComponent.revalidate();
                EditorView.this.fComponent.repaint();
            }
        });
    }

    public boolean isErrorsCloseable() {
        return this.fErrorsCloseable;
    }

    public void setErrorsCloseable(boolean bl) {
        this.fErrorsCloseable = bl;
    }

    private void registerKeyBindings(SyntaxTextPane syntaxTextPane) {
        AbstractSaveAction abstractSaveAction = new AbstractSaveAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditorView.this.isExplicitFile()) {
                    EditorView.this.fEditManager.save(EditorView.this.fLoadContext);
                }
            }
        };
        MInputMap mInputMap = new MInputMap();
        MatlabKeyBindings.getManager().addKeyBindings("MATLABDesktop", "save", (ExtendedInputMap)mInputMap);
        mInputMap.setParent(syntaxTextPane.getInputMap());
        syntaxTextPane.setInputMap(0, (InputMap)mInputMap);
        syntaxTextPane.getActionMap().put(abstractSaveAction.getActionID(), (Action)abstractSaveAction);
    }

    private void assignLoadContext(EditorLoadContext editorLoadContext) {
        EditorLoadContext editorLoadContext2 = this.fLoadContext;
        this.fLoadContext = editorLoadContext;
        if (editorLoadContext != null) {
            this.fLoadContext = editorLoadContext.derive();
            this.fEditManager.setActive(editorLoadContext, false);
        }
    }

    public static interface FileViewProvider {
        public void setCurrentFile(File var1);

        public void provideComponentWhenReady(ParameterRunnable<Component> var1);

        public void dipose();

        public boolean isShowTextView();

        public Runnable getTextViewContinuation();

        public boolean isShowDisclaimer();

        public String getDisclaimer();

        public ParameterRunnable<Boolean> getDisclaimerCallback();
    }

    private abstract class LoadRunnable
    implements Runnable {
        private final EditorLoadContext fLoadContext;

        LoadRunnable(EditorLoadContext editorLoadContext) {
            this.fLoadContext = editorLoadContext;
        }

        abstract void performLoad();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object = EditorView.this.fLoadLock;
            synchronized (object) {
                if (this.fLoadContext.equals(EditorView.this.getLoadContext()) || this.fLoadContext.hasFile() && EditorView.this.getLoadContext() != null && EditorView.this.getLoadContext().hasFile() && this.fLoadContext.isSameFile(EditorView.this.getLoadContext().getFile())) {
                    this.performLoad();
                }
            }
        }
    }

    private class TextOverPanel
    extends MJPanel {
        private final Component fMessage;
        private final Component fContent;
        private final ParameterRunnable<Boolean> fCallback;

        TextOverPanel(Component component, String string, ParameterRunnable<Boolean> parameterRunnable) {
            this.fContent = component;
            this.fCallback = parameterRunnable;
            if (string != null) {
                this.fMessage = this.createMessagePanel(string);
                this.doShowMessage();
            } else {
                this.fMessage = null;
                this.doHideMessage(false);
            }
        }

        private void doShowMessage() {
            if (this.fMessage == null) {
                return;
            }
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.add(this.fMessage);
        }

        private void doHideMessage(boolean bl) {
            if (this.fMessage != null) {
                this.removeAll();
                if (this.fCallback != null) {
                    this.fCallback.run((Object)bl);
                }
            }
            this.setLayout(new BorderLayout());
            this.add(this.fContent);
            this.revalidate();
            this.repaint();
        }

        private Component createMessagePanel(String string) {
            if (string == null) {
                return null;
            }
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(0, 8));
            MJLabel mJLabel = new MJLabel();
            mJLabel.setText(this.computeLabelText(mJPanel2.getWidth(), string));
            mJLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            mJPanel2.add((Component)mJLabel);
            mJPanel.addComponentListener(new ComponentAdapter((JLabel)mJLabel, string){
                final /* synthetic */ JLabel val$textLabel;
                final /* synthetic */ String val$message;
                {
                    this.val$textLabel = jLabel;
                    this.val$message = string;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.val$textLabel.setText(TextOverPanel.this.computeLabelText((int)Math.min(380.0, (double)componentEvent.getComponent().getWidth() * 0.76), this.val$message));
                }
            });
            MJLabel mJLabel2 = new MJLabel("<html><p><font color=blue><a>" + CoderResources.getString("wfa.editor.continueLabel") + "</a></font></p></html>");
            mJLabel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TextOverPanel.this.doHideMessage(true);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setFont(mouseEvent.getComponent().getFont().deriveFont(1));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setFont(mouseEvent.getComponent().getFont().deriveFont(0));
                }
            });
            mJLabel2.setCursor(Cursor.getPredefinedCursor(12));
            mJLabel2.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
            mJPanel2.add((Component)mJLabel2, "South");
            mJPanel.add((Component)mJPanel2);
            mJPanel.setOpaque(true);
            mJPanel2.setBackground(new Color(235, 232, 166));
            mJPanel2.setBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f), new Color(219, 211, 125)));
            mJPanel.addMouseListener(new MouseAdapter(){});
            mJPanel.addMouseWheelListener(new MouseInputAdapter(){});
            return mJPanel;
        }

        private String computeLabelText(int n, String string) {
            return "<html><body style='width:" + n + "'>" + (n > 0 ? string : "") + "</body></html>";
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            for (Component component : this.getComponents()) {
                component.setBounds(insets.left, insets.top, n, n2);
            }
        }
    }

    private static class CoderVerilogKit
    extends VerilogKit {
        private CoderVerilogKit() {
        }

        public String getContentType() {
            return VerilogLanguage.INSTANCE.getMimeType();
        }
    }

    private static class CoderVHDLKit
    extends VHDLKit {
        private CoderVHDLKit() {
        }

        public String getContentType() {
            return VHDLLanguage.INSTANCE.getMimeType();
        }
    }

    private static class CoderPlainKit
    extends PlainKit {
        private final EditorView fEditor;
        private JScrollPane fScrollPane;

        CoderPlainKit(EditorView editorView) {
            this.fEditor = editorView;
        }

        public String getContentType() {
            return PlainLanguage.INSTANCE.getMimeType();
        }

        protected EditorUI createEditorUI() {
            return new PlainEditorUI();
        }

        private class PlainEditorUI
        extends MWEditorUI
        implements EditorSupport.CoderEditorUI {
            private PlainEditorUI() {
            }

            @Override
            public JComponent createExtComponent() {
                LineNumberPane lineNumberPane = new LineNumberPane(FontPrefs.getCodeFont(), CoderPlainKit.this.fEditor);
                CoderPlainKit.this.fScrollPane = EditorSupport.wrapIntoScrollPane((Component)((Object)lineNumberPane), null, null, this.getComponent(), CoderPlainKit.this.fScrollPane);
                return CoderPlainKit.this.fScrollPane;
            }
        }
    }

    private static class CoderCKit
    extends CKit {
        private CoderCKit() {
        }

        public String getContentType() {
            return CLanguage.INSTANCE.getMimeType();
        }
    }
}

