/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestFilter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;

public abstract class AbstractEditableCodePopupContentView
implements CodePopupFrame.CodePopupContentView {
    private final Set<Runnable> fPendingCommits = new HashSet<Runnable>();
    private final RequestFilter fCommit;
    private final boolean fSupportsVariablePopups;
    private final boolean fSupportsFunctionPopups;
    private boolean fSuppressCommit;

    protected AbstractEditableCodePopupContentView() {
        this(true, false);
    }

    protected AbstractEditableCodePopupContentView(boolean bl, boolean bl2) {
        this.fSupportsFunctionPopups = bl2;
        this.fSupportsVariablePopups = bl;
        this.fCommit = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                for (Runnable runnable : AbstractEditableCodePopupContentView.this.pullPendingCommits()) {
                    runnable.run();
                }
            }
        }, 100);
    }

    private synchronized Set<Runnable> pullPendingCommits() {
        HashSet<Runnable> hashSet = new HashSet<Runnable>(this.fPendingCommits);
        this.fPendingCommits.clear();
        return hashSet;
    }

    protected synchronized void pushCommitRequest(CommitContext commitContext) {
        if (!this.isSuppressCommit()) {
            this.fPendingCommits.add(new CommitRequest(commitContext));
            this.fCommit.request();
        }
    }

    public JComponent updateContentView(FunctionScopedKey functionScopedKey) {
        if (!this.fSupportsVariablePopups) {
            return null;
        }
        this.setSuppressCommit(true);
        JComponent jComponent = this.doContentWidgetUpdate(functionScopedKey, null);
        this.setSuppressCommit(false);
        return jComponent;
    }

    @Override
    public JComponent updateContentView(Function function) {
        if (!this.fSupportsFunctionPopups) {
            return null;
        }
        this.setSuppressCommit(true);
        JComponent jComponent = this.doContentWidgetUpdate(null, function);
        this.setSuppressCommit(false);
        return jComponent;
    }

    public boolean isSuppressCommit() {
        return this.fSuppressCommit;
    }

    public void setSuppressCommit(boolean bl) {
        this.fSuppressCommit = bl;
    }

    protected abstract JComponent doContentWidgetUpdate(FunctionScopedKey var1, Function var2);

    protected static class DefaultCommitContext
    implements CommitContext {
        private final Object fKey;
        private final Object fValueObject;
        private final ParameterRunnable<String> fRunnable;

        protected DefaultCommitContext(Object object, Object object2, ParameterRunnable<String> parameterRunnable) {
            this.fKey = object;
            this.fValueObject = object2;
            this.fRunnable = parameterRunnable;
        }

        protected DefaultCommitContext(Object object, Object object2) {
            this(object, object2, null);
        }

        @Override
        public String getValue() {
            return this.fValueObject.toString();
        }

        @Override
        public Object getKey() {
            return this.fKey;
        }

        @Override
        public ParameterRunnable<String> getParameterRunnable() {
            return this.fRunnable;
        }
    }

    public static interface CommitContext {
        public String getValue();

        public Object getKey();

        public ParameterRunnable<String> getParameterRunnable();
    }

    private static class CommitRequest
    implements Runnable {
        private final CommitContext fContext;

        CommitRequest(CommitContext commitContext) {
            this.fContext = commitContext;
        }

        public int hashCode() {
            return this.fContext.getKey().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CommitRequest && this.fContext.getKey() == ((CommitRequest)object).fContext.getKey();
        }

        @Override
        public void run() {
            MJUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CommitRequest.this.fContext.getParameterRunnable().run((Object)CommitRequest.this.fContext.getValue());
                }
            });
        }
    }
}

