/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FunctionSelector;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class CallTreeComboBox
implements FunctionSelector {
    private final ConversionModel fModel;
    private final GlassPaneManager fGlassPane;
    private final MJPanel fComponent;
    private final TSLabel fLabel;
    private final MJComboBox fComboBox;
    private final MulticastChangeListener fChangeListeners;
    private final Map<String, List<Function>> fSpecializations;
    private GlassPaneManager.Blocker fGlassPaneBlocker;
    private Function fForcedFunction;
    private boolean fOverrideSelection;
    private static final Icon FUNCTION_ICON = CoderResources.getIcon("fx_icon_grey.png");

    public CallTreeComboBox(File file, ConversionModel conversionModel, GlassPaneManager glassPaneManager) {
        this.fModel = conversionModel;
        this.fLabel = new TSLabel(CoderResources.getString("f2f.header.function"));
        this.fLabel.setName("f2f.function.label");
        this.fGlassPane = glassPaneManager;
        if (PlatformInfo.isMacintosh()) {
            this.fLabel.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
        }
        this.fChangeListeners = new MulticastChangeListener();
        this.fSpecializations = new LinkedHashMap<String, List<Function>>();
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                Dimension dimension = CallTreeComboBox.this.fLabel.getPreferredSize();
                Dimension dimension2 = CallTreeComboBox.this.fComboBox.getPreferredSize();
                if ((double)this.getWidth() >= dimension2.getWidth() + dimension.getWidth() + 9.0) {
                    CallTreeComboBox.this.fLabel.setBounds(3, (int)((double)(this.getHeight() / 2) - dimension.getHeight() / 2.0), (int)dimension.getWidth(), (int)dimension.getHeight());
                    CallTreeComboBox.this.fComboBox.setBounds((int)(6.0 + dimension.getWidth()), (int)((double)(this.getHeight() / 2) - dimension2.getHeight() / 2.0), (int)((double)this.getWidth() - dimension.getWidth() - 6.0), (int)dimension2.getHeight());
                } else {
                    CallTreeComboBox.this.fLabel.setBounds(0, 0, 0, 0);
                    CallTreeComboBox.this.fComboBox.setBounds(3, (int)((double)(this.getHeight() / 2) - dimension2.getHeight() / 2.0), this.getWidth() - 6, (int)dimension2.getHeight());
                }
            }

            public Dimension getPreferredSize() {
                Dimension dimension = CallTreeComboBox.this.fLabel.getPreferredSize();
                Dimension dimension2 = CallTreeComboBox.this.fComboBox.getPreferredSize();
                return new Dimension((int)Math.min(220.0, dimension.getWidth() + dimension2.getWidth() + 9.0), (int)dimension2.getHeight());
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.setOpaque(false);
        this.fComponent.add((Component)this.fLabel);
        this.fComboBox = new MJComboBox(){

            protected void addImpl(Component component, Object object, int n) {
                super.addImpl(component, object, n);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.putClientProperty("focusable-sibling", (Object)this);
                    this.putClientProperty("focusable-sibling", jComponent);
                }
            }
        };
        this.fComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                CallTreeComboBox.this.fGlassPaneBlocker = CallTreeComboBox.this.fGlassPane.createBlocker();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (CallTreeComboBox.this.fGlassPaneBlocker != null) {
                    CallTreeComboBox.this.fGlassPaneBlocker.dispose();
                    CallTreeComboBox.this.fGlassPaneBlocker = null;
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.popupMenuWillBecomeInvisible(popupMenuEvent);
            }
        });
        this.fComboBox.setName("f2f.function.combobox");
        if (PlatformInfo.isMacintosh()) {
            this.fComboBox.setFont(this.fLabel.getFont());
        }
        this.fComponent.add((Component)this.fComboBox);
        this.fComboBox.setConstrainPopupWidth(false);
        this.fComboBox.addItem((Object)new Function(file, FunctionUtils.getFunctionName(file)));
        this.fComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CallTreeComboBox.this.fForcedFunction != null && CallTreeComboBox.this.fComboBox.getSelectedItem() != CallTreeComboBox.this.fForcedFunction) {
                    CallTreeComboBox.this.fComboBox.removeItem((Object)CallTreeComboBox.this.fForcedFunction);
                    CallTreeComboBox.this.fForcedFunction = null;
                }
                if (!CallTreeComboBox.this.fOverrideSelection) {
                    CallTreeComboBox.this.fChangeListeners.stateChanged(new ChangeEvent(CallTreeComboBox.this));
                }
            }
        });
        this.fComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Function function = (Function)object;
                List list = (List)CallTreeComboBox.this.fSpecializations.get(function.getName());
                if (list == null || list.size() == 1) {
                    this.setText(function.getName());
                } else {
                    this.setText(function.getName() + " > " + (list.indexOf(function) + 1));
                }
                this.setIcon(FUNCTION_ICON);
                return this;
            }
        });
    }

    @Override
    public void select(Function function) {
        this.fComboBox.setSelectedItem((Object)function);
    }

    public void selectSilently(Function function, boolean bl) {
        this.fOverrideSelection = true;
        this.fComboBox.setSelectedItem((Object)function);
        if (bl && (this.fComboBox.getSelectedItem() == null || !this.fComboBox.getSelectedItem().equals(function))) {
            this.fComboBox.addItem((Object)function);
            this.fComboBox.setSelectedItem((Object)function);
            this.fForcedFunction = function;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallTreeComboBox.this.fOverrideSelection = false;
            }
        });
    }

    public void refreshFunctionList() {
        this.fOverrideSelection = true;
        this.fSpecializations.clear();
        final Function function = this.getSelectedFunction();
        MetadataTree<Object> metadataTree = this.fModel.getVariableNames();
        if (this.fModel.hasSimulationRanges()) {
            metadataTree = this.fModel.getSimulationRanges();
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        if (metadataTree != null) {
            Object object;
            for (Function object2 : metadataTree.getFunctions()) {
                object = object2;
                arrayList.add((Function)object);
                List<Function> list = this.fSpecializations.get(((Function)object).getName());
                if (list == null) {
                    list = new LinkedList<Function>();
                    this.fSpecializations.put(((Function)object).getName(), list);
                }
                list.add((Function)object);
            }
            for (final Map.Entry entry : this.fSpecializations.entrySet()) {
                object = new ArrayList((Collection)entry.getValue());
                Collections.sort(object, new Comparator<Function>(){

                    @Override
                    public int compare(Function function, Function function2) {
                        if (function.isSpecialized() && function2.isSpecialized()) {
                            return function.getSpecializationId() - function2.getSpecializationId();
                        }
                        return ((List)entry.getValue()).indexOf(function) - ((List)entry.getValue()).indexOf(function2);
                    }
                });
                entry.setValue(object);
            }
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!CallTreeComboBox.this.fSpecializations.isEmpty()) {
                        CallTreeComboBox.this.fComboBox.removeAllItems();
                        for (Map.Entry entry : CallTreeComboBox.this.fSpecializations.entrySet()) {
                            for (Function function2 : (List)entry.getValue()) {
                                CallTreeComboBox.this.fComboBox.addItem((Object)function2);
                            }
                        }
                        if (function != null) {
                            CallTreeComboBox.this.fComboBox.setSelectedItem((Object)function);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CallTreeComboBox.this.fOverrideSelection = false;
                        }
                    });
                }
            });
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public Function getSelectedFunction() {
        return (Function)this.fComboBox.getSelectedItem();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }
}

