/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.HDLParameterScope;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.UnifiedSerializationStrategy;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class HDLExtendedModel {
    public static final String XML_ROOT = "param.hdlVariables";
    public static final String EXTERNAL_PARAM_KEY_PREFIX = "wfa.hdl.params.";
    public static final String EXTERNAL_PARAM_VALUE_PREFIX = "wfa.hdl.params.value.";
    public static final String PARAM_REGISTER_INPUTS = "RegisterInputs";
    public static final String PARAM_REGISTER_OUTPUTS = "RegisterOutputs";
    public static final String PARAM_DISTRIBUTED_PIPELINING = "DistributedPipelining";
    public static final String PARAM_INPUT_PIPELINE = "InputPipeline";
    public static final String PARAM_OUTPUT_PIPELINE = "OutputPipeline";
    public static final String PARAM_INSTANTIATE_FUNCTIONS = "InstantiateFunctions";
    public static final String PARAM_RESOURCE_SHARING = "ResourceSharing";
    public static final String PARAM_STREAMING_FACTOR = "StreamingFactor";
    public static final String PARAM_INSERT_PIPELINE_REGISTER = "InsertPipelineRegister";
    public static final String PARAM_MAP_TO_RAM = "MapToRAM";
    public static final String PARAM_LOOP_STREAMING_FACTOR = "LoopStreamingFactor";
    public static final String PARAM_LOOP_OPTIMIZATION = "LoopOptimization";
    public static final String PARAM_INLINE_FUNCTION = "InlineFunction";
    private static final String RESOURCE_PREFIX = "wfa.hdl.params.";
    private final PropertyChangeListener fPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (HDLExtendedModel.this.fParamLookup.containsKey(propertyChangeEvent.getPropertyName())) {
                ((HDLParameter)HDLExtendedModel.this.fParamLookup.get(propertyChangeEvent.getPropertyName())).resetToDefault();
            }
        }
    };
    private final PropertyChangeSupport fChangeSupport;
    private final Map<HDLParameterScope, Map<Object, HDLParameter<?>>> fParamMap;
    private final Map<String, HDLParameter<?>> fParamLookup;
    private final Map<String, HDLParameter<?>> fParamShortForms;
    private final Map<Object, String> fStringLookup;
    private final CoderAppModel fAppModel;
    private final InferenceModel fCoreModel;
    private MetadataTree<VariableKind> fVariableKinds;

    public HDLExtendedModel(CoderAppModel coderAppModel) {
        this.fCoreModel = coderAppModel.getInferenceModel();
        this.fAppModel = coderAppModel;
        this.fParamMap = new HashMap();
        this.fParamLookup = new HashMap();
        this.fStringLookup = new HashMap<Object, String>();
        this.fParamShortForms = new HashMap();
        this.fChangeSupport = new PropertyChangeSupport(this);
        this.fStringLookup.put(Boolean.TRUE, "wfa.hdl.params.value.booleanTrue");
        this.fStringLookup.put(Boolean.FALSE, "wfa.hdl.params.value.booleanFalse");
        this.initParameters();
        this.fCoreModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HDLExtendedModel.this.resetAllParams();
            }
        });
    }

    private void initParameters() {
        HDLParameterScope hDLParameterScope = HDLParameterScope.ENTRY_POINT_FUNCTION;
        this.registerParameter(this.createFunctionBooleanParameter(PARAM_REGISTER_INPUTS, hDLParameterScope, true));
        this.registerParameter(this.createFunctionBooleanParameter(PARAM_REGISTER_OUTPUTS, hDLParameterScope, true));
        hDLParameterScope = HDLParameterScope.FUNCTION;
        this.registerParameter(this.createFunctionAbsIntParameter(PARAM_RESOURCE_SHARING, hDLParameterScope, 0));
        this.registerParameter(this.createFunctionAbsIntParameter(PARAM_INPUT_PIPELINE, hDLParameterScope, 0));
        this.registerParameter(this.createFunctionAbsIntParameter(PARAM_OUTPUT_PIPELINE, hDLParameterScope, 0));
        this.registerParameter(this.createFunctionBooleanParameter(PARAM_DISTRIBUTED_PIPELINING, hDLParameterScope, false));
        hDLParameterScope = HDLParameterScope.getCompositeInstance("HDL IPR Scope", HDLParameterScope.VAR_INPUT, HDLParameterScope.VAR_OUTPUT, HDLParameterScope.VAR_LOCAL, HDLParameterScope.VAR_INDEX);
        this.registerParameter(this.createBooleanParameter(PARAM_INSERT_PIPELINE_REGISTER, hDLParameterScope, false));
        hDLParameterScope = HDLParameterScope.VAR_PERSIST;
        this.registerParameter(this.createBooleanParameter(PARAM_MAP_TO_RAM, hDLParameterScope, true));
        hDLParameterScope = HDLParameterScope.VAR_INDEX;
        this.registerParameter(this.createEnumParameter(PARAM_LOOP_OPTIMIZATION, hDLParameterScope, LoopUnrollConstants.class, LoopUnrollConstants.NONE));
        hDLParameterScope = HDLParameterScope.SUB_FUNCTION;
        this.registerParameter(this.createFunctionBooleanParameter(PARAM_INLINE_FUNCTION, hDLParameterScope, true));
    }

    private UnifiedSerializationStrategy.SerializationExtender createSerializationExtender(final FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.SerializationExtender(){

            @Override
            public void serializeFunctionExtensions(Function function, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                this.doSerialize(fixedPointDataAdapter, function, xmlWriter, unifiedSerializationStrategy);
            }

            @Override
            public void serializeVariableExtensions(Variable variable, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                this.doSerialize(fixedPointDataAdapter, variable, xmlWriter, unifiedSerializationStrategy);
            }

            @Override
            public boolean shouldSerializeFunction(Function function) {
                if (!HDLExtendedModel.this.getCoreModel().getFunctionsByFile().containsKey(function.getFile())) {
                    return false;
                }
                for (HDLParameter<?> hDLParameter : HDLExtendedModel.this.getHDLParameters(function)) {
                    if (hDLParameter.isDefaultValue(function)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean shouldSerializeVariable(Variable variable) {
                for (HDLParameter<?> hDLParameter : HDLExtendedModel.this.getHDLParameters(variable)) {
                    if (hDLParameter.isDefaultValue(variable)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void serializeAdditionalExtensions(UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            private void doSerialize(FixedPointDataAdapter fixedPointDataAdapter2, Object object, XmlWriter xmlWriter, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                ParameterSerializationContext parameterSerializationContext = new ParameterSerializationContext(fixedPointDataAdapter2.getConfiguration(), unifiedSerializationStrategy, xmlWriter);
                for (HDLParameter hDLParameter : HDLExtendedModel.this.fParamLookup.values()) {
                    hDLParameter.writeIfNotDefault(object, parameterSerializationContext);
                }
            }
        };
    }

    private UnifiedSerializationStrategy.DeserializationExtender createDeserializationExtender(final FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.DeserializationExtender(){

            @Override
            public void deserializeColumn(Function function, Variable variable, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                this.doDeserializeSingle(variable, xmlReader, bl, unifiedSerializationStrategy);
            }

            @Override
            public void deserializeColumn(Function function, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                this.doDeserializeSingle(function, xmlReader, bl, unifiedSerializationStrategy);
            }

            private void doDeserializeSingle(final Object object, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                final AbstractMap.SimpleEntry<String, String> simpleEntry = unifiedSerializationStrategy.deserializeColumnProperty(xmlReader);
                if (simpleEntry == null) {
                    return;
                }
                ParameterSerializationContext parameterSerializationContext = new ParameterSerializationContext(fixedPointDataAdapter.getConfiguration(), unifiedSerializationStrategy, null){

                    @Override
                    String getParameterValue(Object object2, String string) {
                        assert (object.equals(object2));
                        return (String)simpleEntry.getValue();
                    }
                };
                if (HDLExtendedModel.this.fParamShortForms.containsKey(simpleEntry.getKey())) {
                    ((HDLParameter)HDLExtendedModel.this.fParamShortForms.get(simpleEntry.getKey())).readSingleValue(simpleEntry.getKey(), parameterSerializationContext);
                }
            }
        };
    }

    private UnifiedSerializationStrategy.XmlSourcePolicy createXmlSourcePolicy(final FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.XmlSourcePolicy(){

            @Override
            public void setComputedXML(XmlReader xmlReader) {
                fixedPointDataAdapter.getConfiguration().setParamAsXml("param.hdl.hdlComputedVariables", xmlReader);
            }

            @Override
            public void setAnnotatedXML(XmlReader xmlReader) {
                fixedPointDataAdapter.getConfiguration().setParamAsXml("param.hdl.hdlVariables", xmlReader);
            }

            @Override
            public XmlReader getComputedXML() {
                return (XmlReader)fixedPointDataAdapter.getConfiguration().getParamAsObject("param.hdl.hdlComputedVariables");
            }

            @Override
            public XmlReader getAnnotatedXML() {
                return (XmlReader)fixedPointDataAdapter.getConfiguration().getParamAsObject("param.hdl.hdlVariables");
            }

            @Override
            public String convertFileToReference(File file) {
                return fixedPointDataAdapter.fileToReference(file);
            }

            @Override
            public File convertReferenceToFile(String string) {
                return fixedPointDataAdapter.referenceToFile(string);
            }
        };
    }

    public static String getDisplayString(HDLParameter<?> hDLParameter) {
        String string = hDLParameter.getKey().toString();
        return CoderResources.getString("wfa.hdl.params." + Character.toLowerCase(string.charAt(0)) + string.substring(1));
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.fChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void serialize(FixedPointDataAdapter fixedPointDataAdapter) {
        this.getCoreModel().serialize(this.createXmlSourcePolicy(fixedPointDataAdapter), this.createSerializationExtender(fixedPointDataAdapter));
    }

    public void deserialize(FixedPointDataAdapter fixedPointDataAdapter) {
        this.getCoreModel().deserialize(this.createXmlSourcePolicy(fixedPointDataAdapter), this.createDeserializationExtender(fixedPointDataAdapter), false);
    }

    public InferenceModel getCoreModel() {
        return this.fCoreModel;
    }

    public void saveVariableKindState() {
        this.fVariableKinds = this.getCoreModel().getVariableKinds();
    }

    public void restoreVariableKindState() {
        if (this.fVariableKinds != null) {
            this.getCoreModel().setVariableKinds(this.fVariableKinds);
            this.fVariableKinds = null;
        }
    }

    public Collection<HDLParameter<?>> getHDLParameters(Function function) {
        return function.isEntryPointFunction() ? this.getHDLParameters(HDLParameterScope.ENTRY_POINT_FUNCTION) : this.getHDLParameters(HDLParameterScope.SUB_FUNCTION);
    }

    public Collection<HDLParameter<?>> getHDLParameters(HDLParameterScope hDLParameterScope) {
        LinkedList linkedList = this.fParamMap.containsKey(hDLParameterScope) ? new LinkedList(this.fParamMap.get(hDLParameterScope).values()) : new LinkedList();
        Set<HDLParameterScope> set = hDLParameterScope.getSuperScopes();
        for (HDLParameterScope hDLParameterScope2 : set) {
            if (!this.fParamMap.containsKey(hDLParameterScope2)) continue;
            linkedList.addAll(this.fParamMap.get(hDLParameterScope2).values());
        }
        return linkedList;
    }

    public Collection<HDLParameter<?>> getHDLParameters(FunctionScopedKey<?> functionScopedKey) {
        if (functionScopedKey instanceof Variable) {
            return this.getHDLParameters((Variable)functionScopedKey);
        }
        if (functionScopedKey.getKey() instanceof Function) {
            return this.getHDLParameters((Function)functionScopedKey.getKey());
        }
        return null;
    }

    public Collection<HDLParameter<?>> getHDLParameters(VariableKind variableKind) {
        HDLParameterScope hDLParameterScope = null;
        switch (variableKind) {
            case INPUT: {
                hDLParameterScope = HDLParameterScope.VAR_INPUT;
                break;
            }
            case OUTPUT: {
                hDLParameterScope = HDLParameterScope.VAR_OUTPUT;
                break;
            }
            case PERSISTENT: {
                hDLParameterScope = HDLParameterScope.VAR_PERSIST;
                break;
            }
            case INDEX: {
                hDLParameterScope = HDLParameterScope.VAR_INDEX;
                break;
            }
            case LOCAL: {
                hDLParameterScope = HDLParameterScope.VAR_LOCAL;
                break;
            }
            case TEMP: {
                hDLParameterScope = HDLParameterScope.VAR_TEMP;
            }
        }
        return hDLParameterScope != null ? this.getHDLParameters(hDLParameterScope) : new LinkedList();
    }

    public Collection<HDLParameter<?>> getHDLParameters(Variable variable) {
        return this.getHDLParameters(this.fCoreModel.getVariableKind(variable));
    }

    private static Collection<HDLParameter<?>> merge(Collection<HDLParameter<?>> ... collectionArray) {
        LinkedList linkedList = new LinkedList();
        for (Collection<HDLParameter<?>> collection : collectionArray) {
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    public void addHDLParameterObserver(HDLParameterObserver hDLParameterObserver, HDLParameterScope ... hDLParameterScopeArray) {
        for (HDLParameterScope hDLParameterScope : hDLParameterScopeArray) {
            for (HDLParameter<?> hDLParameter : this.fParamMap.get(hDLParameterScope).values()) {
                hDLParameter.addHDLParameterObserver(hDLParameterObserver);
            }
        }
    }

    public void removeHDLParameterObserver(HDLParameterObserver hDLParameterObserver, HDLParameterScope hDLParameterScope) {
        for (HDLParameter<?> hDLParameter : this.fParamMap.get(hDLParameterScope).values()) {
            hDLParameter.removeHDLParameterObserver(hDLParameterObserver);
        }
    }

    public Collection<HDLParameter<?>> getAllHDLParameters() {
        return this.fParamLookup.values();
    }

    private HDLParameter createFunctionBooleanParameter(String string, HDLParameterScope hDLParameterScope, boolean bl) {
        return new HDLFunctionParameter<Object>(string, hDLParameterScope, Boolean.class, "Boolean", this.createBoundBooleanStrategy(string, bl), new Object[0]);
    }

    private HDLParameter createBooleanParameter(String string, HDLParameterScope hDLParameterScope, boolean bl) {
        return new HDLDistributedParameter<Object>(string, hDLParameterScope, Boolean.class, "Boolean", this.createBoundBooleanStrategy(string, bl), new Object[0]);
    }

    private HDLParameter createAbsIntParameter(String string, HDLParameterScope hDLParameterScope, int n) {
        return new HDLDistributedParameter<Object>(string, hDLParameterScope, Integer.class, "Integer", this.createBoundIntegerStrategy(string, n), new Object[0]);
    }

    private HDLParameter createFunctionAbsIntParameter(String string, HDLParameterScope hDLParameterScope, int n) {
        return new HDLFunctionParameter<Object>(string, hDLParameterScope, Integer.class, "Integer", this.createBoundIntegerStrategy(string, n), new Object[0]);
    }

    private <T extends Enum<?>> HDLParameter createEnumParameter(String string, HDLParameterScope hDLParameterScope, Class<T> clazz, final T t) {
        final HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            String string2 = enum_.toString();
            if (string2 == null) continue;
            this.fStringLookup.put(enum_, string2);
            hashMap.put(string2, enum_);
        }
        return new HDLDistributedParameter<Object>(string, hDLParameterScope, clazz, "String", new ParameterStrategy<T>(){

            @Override
            public T modifyValue(T t2) {
                return t2;
            }

            @Override
            public T getDefaultValue() {
                return t;
            }

            @Override
            public boolean acceptUnmodifiedValue(T t2) {
                return true;
            }

            @Override
            public T deserializeValue(String string) {
                return (Enum)hashMap.get(string);
            }
        }, new Object[0]);
    }

    private ParameterStrategy<Integer> createBoundIntegerStrategy(final String string, final int n) {
        return new ParameterStrategy<Integer>(){
            private final String extKey;
            {
                this.extKey = "wfa.hdl.params." + string;
            }

            @Override
            public Integer modifyValue(Integer n2) {
                return Math.abs(n2);
            }

            @Override
            public Integer getDefaultValue() {
                return n;
            }

            @Override
            public boolean acceptUnmodifiedValue(Integer n2) {
                return n2 >= 0;
            }

            @Override
            public Integer deserializeValue(String string2) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        };
    }

    private ParameterStrategy<Boolean> createBoundBooleanStrategy(final String string, final boolean bl) {
        return new ParameterStrategy<Boolean>(){
            private final String extKey;
            {
                this.extKey = "wfa.hdl.params." + string;
            }

            @Override
            public Boolean modifyValue(Boolean bl2) {
                return bl2;
            }

            @Override
            public Boolean getDefaultValue() {
                return bl;
            }

            @Override
            public boolean acceptUnmodifiedValue(Boolean bl2) {
                return true;
            }

            @Override
            public Boolean deserializeValue(String string2) {
                if (string2.equalsIgnoreCase(Boolean.TRUE.toString()) || string2.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return Boolean.parseBoolean(string2);
                }
                return null;
            }
        };
    }

    private void registerParameter(HDLParameter hDLParameter) {
        Map<Object, HDLParameter<?>> map = this.fParamMap.get(hDLParameter.getScope());
        if (map == null) {
            map = new LinkedHashMap();
            this.fParamMap.put(hDLParameter.getScope(), map);
        }
        map.put(hDLParameter.getKey(), hDLParameter);
        this.fParamLookup.put(hDLParameter.getExternalKey(), hDLParameter);
        this.fParamShortForms.put(hDLParameter.getPersistedKey(), hDLParameter);
    }

    private void resetAllParams() {
        for (HDLParameter<?> hDLParameter : this.fParamLookup.values()) {
            hDLParameter.resetToDefault();
        }
    }

    public static enum LoopUnrollConstants {
        NONE("unrollNone"),
        UNROLL("unrollUnroll"),
        STREAM("unrollStream");

        private final String fResKey;

        private LoopUnrollConstants(String string2) {
            this.fResKey = HDLExtendedModel.EXTERNAL_PARAM_VALUE_PREFIX + string2;
        }

        public String toString() {
            return this.fResKey;
        }
    }

    public static interface HDLParameterObserver {
        public void hdlParameterChanged(HDLParameter<?> var1, Object var2);
    }

    private class ParameterSerializationContext {
        private final Configuration fConfiguration;
        private final UnifiedSerializationStrategy fStrategy;
        private final XmlWriter fWriter;

        ParameterSerializationContext(Configuration configuration, UnifiedSerializationStrategy unifiedSerializationStrategy, XmlWriter xmlWriter) {
            this.fConfiguration = configuration;
            this.fStrategy = unifiedSerializationStrategy;
            this.fWriter = xmlWriter;
        }

        Configuration getConfiguration() {
            return this.fConfiguration;
        }

        UnifiedSerializationStrategy getSerializationStrategy() {
            return this.fStrategy;
        }

        XmlWriter getXmlWriter() {
            return this.fWriter;
        }

        String getParameterValue(Object object, String string) {
            return null;
        }
    }

    private static interface ParameterStrategy<T> {
        public T modifyValue(T var1);

        public T getDefaultValue();

        public T deserializeValue(String var1);

        public boolean acceptUnmodifiedValue(T var1);
    }

    private class HDLDistributedParameter<T>
    extends HDLParameter<T> {
        private final MetadataTree<T> fMetadataTree;

        HDLDistributedParameter(Object object, HDLParameterScope hDLParameterScope, Class<T> clazz, String string, ParameterStrategy<T> parameterStrategy, T ... TArray) {
            super(object, hDLParameterScope, clazz, string, parameterStrategy);
            this.fMetadataTree = new MetadataTree();
        }

        @Override
        public void setValue(Object object, Object object2) {
            if (FunctionScopedKey.class.isInstance(object)) {
                this.setValue((FunctionScopedKey)object, object2);
            }
        }

        @Override
        public void setValue(FunctionScopedKey<?> functionScopedKey, Object object) {
            Object t = this.validateValue(object);
            if (this.hasChanged(this.getValue(functionScopedKey), t)) {
                T t2 = this.getValue(functionScopedKey);
                this.fMetadataTree.put(functionScopedKey, t);
                this.fireValueChanged(functionScopedKey, t2, t);
            }
        }

        @Override
        public T getValue(Object object) {
            if (object != null && object instanceof FunctionScopedKey) {
                T t = this.fMetadataTree.get((FunctionScopedKey)object);
                return t;
            }
            return null;
        }

        @Override
        public void resetToDefault() {
            this.fMetadataTree.reset();
            MetadataTree<?> metadataTree = HDLExtendedModel.this.fCoreModel.getKeyTree();
            if (metadataTree != null) {
                for (Function function : metadataTree.getFunctions()) {
                    for (FunctionScopedKey<?> functionScopedKey : metadataTree.getKeys(function)) {
                        this.resetToDefault(functionScopedKey);
                    }
                }
            }
        }

        private void resetToDefault(FunctionScopedKey<?> functionScopedKey) {
            this.fMetadataTree.put(functionScopedKey, this.getDefaultValue());
            T t = this.getValue(functionScopedKey);
            this.fireValueChanged(functionScopedKey, t, this.getDefaultValue());
        }

        @Override
        public String getPersistedKey() {
            return this.getKey().toString();
        }

        @Override
        public void writeSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            if (object instanceof Variable) {
                parameterSerializationContext.getSerializationStrategy().serializeProperty(parameterSerializationContext.getXmlWriter(), this.getPersistedKey(), this.getTypeString(), this.getValue(object));
            }
        }

        @Override
        public void readSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            Object t;
            if (!Variable.class.isInstance(object)) {
                return;
            }
            String string = parameterSerializationContext.getParameterValue(object, this.getPersistedKey());
            if (string != null && (t = this.getStrategy().deserializeValue(string)) != null) {
                this.setValue(object, t);
            }
        }
    }

    private class HDLFunctionParameter<T>
    extends HDLParameter<T> {
        private final Map<Function, T> fMap;

        HDLFunctionParameter(Object object, HDLParameterScope hDLParameterScope, Class<T> clazz, String string, ParameterStrategy<T> parameterStrategy, T ... TArray) {
            super(object, hDLParameterScope, clazz, string, parameterStrategy);
            this.fMap = new HashMap<Function, T>();
        }

        @Override
        public String getPersistedKey() {
            return this.getKey().toString();
        }

        @Override
        public void resetToDefault() {
            if (this.fMap != null) {
                for (Function function : HDLExtendedModel.this.fCoreModel.getFunctions()) {
                    this.fMap.put(function, this.getDefaultValue());
                }
            }
        }

        @Override
        public void setValue(FunctionScopedKey<?> functionScopedKey, Object object) {
            if (object == null || !this.getValueType().isInstance(object) || !Function.class.isInstance(functionScopedKey.getKey())) {
                return;
            }
            Object object2 = object;
            if (!this.getStrategy().acceptUnmodifiedValue(object2)) {
                object2 = this.getStrategy().modifyValue(object2);
            }
            T t = this.getValue(functionScopedKey);
            this.fMap.put((Function)functionScopedKey.getKey(), object2);
            this.fireValueChanged(functionScopedKey, t, object);
        }

        @Override
        public void setValue(Object object, Object object2) {
            if (object instanceof Function) {
                this.setValue(new FunctionScopedKey<Object>((Function)object, object), object2);
            } else if (object instanceof FunctionScopedKey) {
                this.setValue((FunctionScopedKey)object, object2);
            }
        }

        @Override
        public T getValue(Object object) {
            if (object instanceof FunctionScopedKey) {
                return this.fMap.get(((FunctionScopedKey)object).getKey());
            }
            if (object instanceof Function) {
                return this.fMap.get((Function)object);
            }
            return null;
        }

        @Override
        public void writeSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            if (object instanceof Function) {
                parameterSerializationContext.getSerializationStrategy().serializeProperty(parameterSerializationContext.getXmlWriter(), this.getPersistedKey(), this.getTypeString(), this.getValue(object));
            }
        }

        @Override
        public void readSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            Object t;
            if (!Function.class.isInstance(object)) {
                return;
            }
            String string = parameterSerializationContext.getParameterValue(object, this.getPersistedKey());
            if (string != null && (t = this.getStrategy().deserializeValue(string)) != null) {
                this.setValue(object, t);
            }
        }
    }

    public class HDLGlobalParameter<T>
    extends HDLParameter<T> {
        private final Class<T> fValueType;
        private final Collection<HDLParameterObserver> fObservers;
        private final String fTypeString;
        private T fSingleValue;

        HDLGlobalParameter(Object object, HDLParameterScope hDLParameterScope, Class<T> clazz, String string, ParameterStrategy<T> parameterStrategy) {
            super(object, hDLParameterScope, clazz, string, parameterStrategy);
            this.fValueType = clazz;
            this.fTypeString = string;
            this.fObservers = new LinkedList<HDLParameterObserver>();
        }

        @Override
        public void resetToDefault() {
            this.fSingleValue = this.getDefaultValue();
        }

        @Override
        public void setValue(FunctionScopedKey<?> functionScopedKey, Object object) {
            Object t = this.validateValue(object);
            this.fSingleValue = t;
        }

        @Override
        public void setValue(Object object, Object object2) {
            if (FunctionScopedKey.class.isInstance(object)) {
                this.setValue((FunctionScopedKey)object, object2);
            }
        }

        @Override
        public T getValue(Object object) {
            return this.fSingleValue;
        }

        @Override
        public String getPersistedKey() {
            return this.getExternalKey();
        }

        @Override
        void writeSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            if (object instanceof Variable) {
                parameterSerializationContext.getConfiguration().setParamAsString(this.getPersistedKey(), this.getValue(null).toString());
            }
        }

        @Override
        void readSingleValue(Object object, ParameterSerializationContext parameterSerializationContext) {
            try {
                String string = parameterSerializationContext.getConfiguration().getParamAsString(this.getPersistedKey());
                Object t = this.getStrategy().deserializeValue(string);
                if (t != null) {
                    this.setValue(null, this.getStrategy().deserializeValue(string));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public abstract class HDLParameter<T> {
        private final HDLParameterScope fScope;
        private final Object fKey;
        private final ParameterStrategy<T> fStrategy;
        private final Class<T> fValueType;
        private final Collection<HDLParameterObserver> fObservers;
        private final String fTypeString;
        private final String fExternalKey;

        HDLParameter(Object object, HDLParameterScope hDLParameterScope, Class<T> clazz, String string, ParameterStrategy<T> parameterStrategy) {
            this.fKey = object;
            this.fScope = hDLParameterScope;
            this.fValueType = clazz;
            this.fStrategy = parameterStrategy;
            this.fTypeString = string;
            this.fObservers = new LinkedHashSet<HDLParameterObserver>();
            this.fExternalKey = "wfa.hdl.params." + this.getKey().toString();
        }

        protected final T validateValue(Object object) {
            if (!this.getValueType().isInstance(object)) {
                return null;
            }
            Object object2 = object;
            if (!this.fStrategy.acceptUnmodifiedValue(object2)) {
                object2 = this.fStrategy.modifyValue(object2);
            }
            return (T)(object2 != null ? object2 : this.getDefaultValue());
        }

        public final Class<T> getValueType() {
            return this.fValueType;
        }

        public final String getTypeString() {
            return this.fTypeString;
        }

        public String getValueDisplayKey(Object object) {
            return (String)HDLExtendedModel.this.fStringLookup.get(object);
        }

        public final T getDefaultValue() {
            return this.fStrategy.getDefaultValue();
        }

        public final HDLParameterScope getScope() {
            return this.fScope;
        }

        public final Object getKey() {
            return this.fKey;
        }

        public final void addHDLParameterObserver(HDLParameterObserver hDLParameterObserver) {
            this.fObservers.add(hDLParameterObserver);
        }

        public final void removeHDLParameterObserver(HDLParameterObserver hDLParameterObserver) {
            this.fObservers.remove(hDLParameterObserver);
        }

        protected final void fireValueChanged(Object object, Object object2, Object object3) {
            for (HDLParameterObserver hDLParameterObserver : this.fObservers) {
                hDLParameterObserver.hdlParameterChanged(this, object);
            }
            HDLExtendedModel.this.firePropertyChange(this.getPersistedKey(), object2, object3);
        }

        private final void writeIfNotDefault(Object object, ParameterSerializationContext parameterSerializationContext) {
            if (this.hasChanged(object, this.getDefaultValue())) {
                this.writeSingleValue(object, parameterSerializationContext);
            }
        }

        public final void performSetValue(Object object, Object object2) {
            if (this.hasChanged(object, object2)) {
                this.setValue(object, object2);
            }
        }

        protected boolean hasChanged(Object object, Object object2) {
            return Utilities.areValuesDifferent(this.getValue(object), object2);
        }

        protected boolean isDefaultValue(Object object) {
            return !this.hasChanged(object, this.getDefaultValue());
        }

        public String getExternalKey() {
            return this.fExternalKey;
        }

        abstract String getPersistedKey();

        abstract void resetToDefault();

        public abstract T getValue(Object var1);

        abstract void setValue(FunctionScopedKey<?> var1, Object var2);

        abstract void setValue(Object var1, Object var2);

        abstract void readSingleValue(Object var1, ParameterSerializationContext var2);

        abstract void writeSingleValue(Object var1, ParameterSerializationContext var2);

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HDLParameter hDLParameter = (HDLParameter)object;
            if (!this.fKey.equals(hDLParameter.fKey)) {
                return false;
            }
            return this.fScope == hDLParameter.fScope;
        }

        public int hashCode() {
            int n = this.fScope.hashCode();
            n = 31 * n + this.fKey.hashCode();
            return n;
        }

        public ParameterStrategy<T> getStrategy() {
            return this.fStrategy;
        }
    }
}

