/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.CodableEntityAdapter;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Function
extends CodableEntityAdapter
implements Comparable<Function> {
    public static final int NO_SPECIALIZATION_ID = -1;
    private final File fFile;
    private final String fName;
    private final String fUniqueId;
    private final String fSpecializationName;
    private final int fSpecializationId;
    private final boolean fEntryPointFunction;
    private final boolean fWellFormed;

    public Function(File file, String string) {
        this(file, string, string, null, null, false);
    }

    public Function(File file, String string, String string2) {
        this(file, string, string2 != null ? string2 : string, string2, null, false);
    }

    public Function(@NotNull File file, @NotNull String string, @NotNull String string2, @Nullable String string3, @Nullable Integer n) {
        this(file, string, string2, string3, n, true);
    }

    private Function(@NotNull File file, @NotNull String string, @NotNull String string2, @Nullable String string3, @Nullable Integer n, boolean bl) {
        super(CodableEntity.Type.FUNCTION);
        this.fFile = file;
        this.fName = string;
        this.fUniqueId = string2;
        this.fWellFormed = bl;
        this.fSpecializationName = string3 != null ? string3 : this.fName;
        this.fSpecializationId = n != null ? n : -1;
        this.fEntryPointFunction = CoderFileSupport.isMatlabSourceFile(file) && new FileLocation(file).getNameBeforeDot().equals(string);
    }

    public boolean isEntryPointFunction() {
        return this.fEntryPointFunction;
    }

    @NotNull
    public File getFile() {
        return this.fFile;
    }

    @NotNull
    public String getName() {
        return this.fName;
    }

    @NotNull
    public String getSpecializationName() {
        return this.fSpecializationName;
    }

    @NotNull
    public String getUniqueId() {
        return this.fUniqueId;
    }

    public int getSpecializationId() {
        return this.fSpecializationId;
    }

    public boolean isSpecialized() {
        return this.getSpecializationId() != -1 || !this.getSpecializationName().equals(this.getName());
    }

    public boolean isWellFormed() {
        return this.fWellFormed;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Function function = (Function)object;
        if (!this.fFile.equals(function.fFile)) {
            return false;
        }
        if (!this.fName.equals(function.fName)) {
            return false;
        }
        return this.fSpecializationName.equals(function.fSpecializationName);
    }

    public int hashCode() {
        int n = this.fFile.hashCode();
        n = 31 * n + this.fName.hashCode();
        n = 31 * n + this.fSpecializationName.hashCode();
        return n;
    }

    public String toString() {
        return this.fUniqueId;
    }

    @Override
    public int compareTo(Function function) {
        int n = this.fName.compareTo(function.getName());
        if (n == 0) {
            n = this.fSpecializationName.compareTo(function.getSpecializationName());
        }
        if (n == 0) {
            n = this.fFile.compareTo(function.getFile());
        }
        return n;
    }
}

