/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFimath;

public final class MatlabType {
    private final String fClassName;
    private final int[] fSize;
    private final boolean[] fDynamicSizeFlags;
    private final boolean fComplex;
    private final NumericType fNumericType;
    private final IDPFimath fFimath;
    private final boolean fFimathIsLocal;
    private final TypeFlag fTypeFlag;

    public MatlabType(String string, int[] nArray, boolean[] blArray, boolean bl, TypeFlag typeFlag) {
        this(string, nArray, blArray, bl, null, null, false, typeFlag);
    }

    public MatlabType(String string, int[] nArray, boolean[] blArray, boolean bl) {
        this(string, nArray, blArray, bl, null, null, false);
    }

    public MatlabType(String string, int[] nArray, boolean[] blArray, boolean bl, NumericType numericType, IDPFimath iDPFimath, boolean bl2) {
        this(string, nArray, blArray, bl, numericType, iDPFimath, bl2, null);
    }

    public MatlabType(String string, int[] nArray, boolean[] blArray, boolean bl, NumericType numericType, IDPFimath iDPFimath, boolean bl2, TypeFlag typeFlag) {
        this.fClassName = string;
        this.fSize = (int[])nArray.clone();
        this.fDynamicSizeFlags = (boolean[])blArray.clone();
        this.fComplex = bl;
        this.fNumericType = numericType;
        this.fFimath = iDPFimath;
        this.fFimathIsLocal = bl2;
        this.fTypeFlag = typeFlag;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public int[] getSize() {
        return (int[])this.fSize.clone();
    }

    public boolean[] getDynamicFlags() {
        return (boolean[])this.fDynamicSizeFlags.clone();
    }

    public boolean isComplex() {
        return this.fComplex;
    }

    public String toUniqueString() {
        return this.toUniqueString(false);
    }

    public String toUniqueString(boolean bl) {
        String string = this.fClassName;
        if (this.fNumericType != null) {
            string = this.fNumericType.toString(bl);
        }
        String string2 = this.toDimensionString();
        return (string2.equals("1 x 1") ? "" : string2 + " ") + (this.fComplex ? "complex " : "") + string;
    }

    public String toDimensionString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.fSize.length; ++i) {
            if (i < this.fDynamicSizeFlags.length && this.fDynamicSizeFlags[i]) {
                stringBuilder.append(':');
            }
            if (this.fSize[i] == -1) {
                stringBuilder.append("Inf");
            } else {
                stringBuilder.append(Integer.toString(this.fSize[i]));
            }
            if (i >= this.fSize.length - 1) continue;
            stringBuilder.append(" x ");
        }
        return stringBuilder.toString();
    }

    public NumericType getNumericType() {
        return this.fNumericType;
    }

    public IDPFimath getFimath() {
        return this.fFimath;
    }

    public boolean isFimathLocal() {
        return this.fFimathIsLocal;
    }

    public boolean isStruct() {
        return this.fTypeFlag == TypeFlag.STRUCT;
    }

    public boolean isObject() {
        return this.fTypeFlag == TypeFlag.OBJECT || this.fTypeFlag == TypeFlag.SYSTEM_OBJECT;
    }

    public boolean isSystemObject() {
        return this.fTypeFlag == TypeFlag.SYSTEM_OBJECT;
    }

    public String toString() {
        return this.toUniqueString();
    }

    public static enum TypeFlag {
        STRUCT,
        OBJECT,
        SYSTEM_OBJECT;

    }
}

