/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.logui.LogDisplay;
import com.mathworks.project.impl.logui.LogMessage;
import com.mathworks.project.impl.logui.LogMessageType;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import javax.swing.SwingUtilities;

public final class TestBenchUtils {
    private TestBenchUtils() {
    }

    public static void runTestBench(TestBenchConfig testBenchConfig, ParameterRunnable<TestBenchResult> parameterRunnable) {
        TestBenchUtils.runTestBench(testBenchConfig, null, parameterRunnable);
    }

    public static void runTestBench(TestBenchConfig testBenchConfig, LogDisplay logDisplay, final ParameterRunnable<TestBenchResult> parameterRunnable) {
        String string = testBenchConfig.getRunMode() == TestBenchRunMode.RUN_FORTYPES ? "coder.internal.inferTestBench" : "coder.internal.runTestBench";
        Object[] objectArray = new Object[]{testBenchConfig};
        if (logDisplay == null) {
            new Matlab().fevalConsoleOutput(string, objectArray, 1, new CompletionObserver(){

                public void completed(int n, final Object object) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            parameterRunnable.run((Object)((TestBenchResult)object));
                        }
                    });
                }
            });
        } else {
            Writer writer = TestBenchUtils.createOutputWriter(logDisplay);
            Writer writer2 = TestBenchUtils.createErrorWriter(logDisplay);
            MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(string, Integer.valueOf(1), writer, writer2, objectArray);
            MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
            FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
            futureFevalResult.runWhenDone(new Runnable((FutureResult)futureFevalResult){
                final /* synthetic */ FutureResult val$result;
                {
                    this.val$result = futureResult;
                }

                @Override
                public void run() {
                    try {
                        parameterRunnable.run((Object)((TestBenchResult)this.val$result.get()));
                    }
                    catch (MvmExecutionException | InterruptedException throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static void showTestBenchError(final Component component, final String string, TestBenchResult testBenchResult) {
        String string2 = "<html>" + testBenchResult.getMessage().replaceAll("\n", "<br />").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replaceAll(" ", "&nbsp;") + "</html>";
        string2 = string2.replace("matlab:&nbsp;", "matlab:");
        final HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string2, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                if (string.startsWith("matlab:")) {
                    new Matlab().evalConsoleOutput(string.substring("matlab:".length()));
                }
            }
        }, false, "link.badTestBench.innerComponent", testBenchResult.getMessage());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)component, (Object)hyperlinkTextLabel.getComponent(), (String)string, (int)0);
            }
        });
    }

    public static void interruptTestBench() {
        new Matlab().interrupt();
    }

    public static Writer createOutputWriter(final LogDisplay logDisplay) {
        return new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                logDisplay.write(new LogMessage(String.copyValueOf(cArray, n, n2), LogMessageType.OUTPUT));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private static Writer createErrorWriter(final LogDisplay logDisplay) {
        return new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                logDisplay.write(new LogMessage(String.copyValueOf(cArray, n, n2), LogMessageType.ERROR));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

