/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.screener.ImpactModelBuilder;
import com.mathworks.toolbox.coder.screener.MTreeUtils;
import com.mathworks.toolbox.coder.screener.MatlabFunctionSupport;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Pair;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DependencyFileSystem
implements FileSystem {
    private final ScreenerTarget fTarget;
    private final Map<FileLocation, FileLocation> fDependencyNodeToLocation;

    DependencyFileSystem(FileSystemEntry fileSystemEntry, ScreenerTarget screenerTarget) {
        this.fTarget = screenerTarget;
        this.fDependencyNodeToLocation = new HashMap<FileLocation, FileLocation>();
        this.fDependencyNodeToLocation.put(FileLocation.ROOT, fileSystemEntry.getLocation());
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        return this.wrap(fileLocation, RealFileSystem.getInstance().getEntry(this.getLocationOrThrowException(fileLocation)));
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        return RealFileSystem.getInstance().getInputStream(this.getLocationOrThrowException(fileLocation));
    }

    public boolean exists(FileLocation fileLocation) {
        FileLocation fileLocation2 = this.fDependencyNodeToLocation.get(fileLocation);
        return fileLocation2 != null && RealFileSystem.getInstance().exists(fileLocation2);
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return RealFileSystem.getInstance().followShortcutOrLink(this.unwrap(fileSystemEntry));
    }

    public DependencyFileList getList(FileLocation fileLocation) throws IOException {
        FileLocation fileLocation2 = this.fDependencyNodeToLocation.get(FileLocation.ROOT);
        String string = fileLocation2.getParent().toFile().getAbsolutePath();
        return new DependencyFileList(string, fileLocation);
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new DefaultRecursiveSearchList((FileSystem)this, this.getEntry(fileLocation), searchCriteria, predicate);
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return true;
    }

    public FileSystemTransaction createTransaction() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeName(String string) {
        return RealFileSystem.getInstance().encodeName(string);
    }

    public String decodeName(String string) {
        return RealFileSystem.getInstance().decodeName(string);
    }

    private FileLocation getLocationOrThrowException(FileLocation fileLocation) throws IOException {
        FileLocation fileLocation2 = this.getLocation(fileLocation);
        if (fileLocation2 == null) {
            throw new IOException("Location does not exist in dependency tree: " + fileLocation2);
        }
        return fileLocation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocation getLocation(FileLocation fileLocation) {
        Map<FileLocation, FileLocation> map = this.fDependencyNodeToLocation;
        synchronized (map) {
            return this.fDependencyNodeToLocation.get(fileLocation);
        }
    }

    private FileSystemEntry wrap(FileLocation fileLocation, FileSystemEntry fileSystemEntry) {
        return new FileSystemEntry((FileSystem)this, fileLocation, false, true, fileSystemEntry.getSize(), fileSystemEntry.getDateModified().getTime(), fileSystemEntry.getMode());
    }

    private FileSystemEntry unwrap(FileSystemEntry fileSystemEntry) {
        return new FileSystemEntry(RealFileSystem.getInstance(), this.getLocation(fileSystemEntry.getLocation()), true, false, fileSystemEntry.getSize(), fileSystemEntry.getDateModified().getTime(), fileSystemEntry.getMode());
    }

    public static boolean isInToolbox(String string) {
        FileLocation fileLocation = new FileLocation(Matlab.matlabRoot() + File.separator + "toolbox");
        return new FileLocation(string).hasPrefix(fileLocation);
    }

    private static String getSourceFunctionName(MTree.Node node) {
        MTree.NodeType nodeType;
        MTree.Node node2;
        for (node2 = node; node2 != MTree.NULL_NODE && (nodeType = node2.getType()) != MTree.NodeType.FUNCTION && nodeType != MTree.NodeType.ANON; node2 = node2.getParent()) {
        }
        if (node2.getType() == MTree.NodeType.FUNCTION) {
            return node2.getFunctionName().getText();
        }
        return null;
    }

    public class DependencyFileList
    extends AbstractFileList {
        private final String fProjectPath;
        private final FileLocation fDependencyNode;
        private final Map<CallContext, String> fCallContextToFilenameMap;

        DependencyFileList(String string, FileLocation fileLocation) throws IOException {
            super((FileSystem)DependencyFileSystem.this, fileLocation);
            this.fProjectPath = string;
            this.fDependencyNode = fileLocation;
            this.fCallContextToFilenameMap = new HashMap<CallContext, String>();
        }

        public boolean isEmpty() throws IOException {
            FileLocation fileLocation = DependencyFileSystem.this.getLocation(this.fDependencyNode);
            if (DependencyFileSystem.isInToolbox(fileLocation.toString())) {
                return true;
            }
            String string = CoderFileSupport.readMatlabSource(fileLocation);
            MTree mTree = MTree.parse((String)string, (boolean)true);
            List<MTree.Node> list = MTreeUtils.findAsList(DependencyFileSystem.this.fTarget, string, mTree, MTree.NodeType.CALL, MTree.NodeType.DOT);
            if (list.isEmpty()) {
                List<MTree.Node> list2 = MTreeUtils.findAsList(DependencyFileSystem.this.fTarget, string, mTree, MTree.NodeType.CEXPR);
                for (MTree.Node node : list2) {
                    if (node.getRight().getType() != MTree.NodeType.LT) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
            this.read(asyncReceiver, false);
        }

        public void readFunctions(AsyncReceiver<Call> asyncReceiver) throws IOException {
            this.read(asyncReceiver, true);
        }

        private boolean send(String string, String string2, FileSystemEntry fileSystemEntry, boolean bl, AsyncReceiver asyncReceiver) {
            if (bl) {
                return asyncReceiver.receive((Object)new Call(string, string2, fileSystemEntry));
            }
            return asyncReceiver.receive((Object)fileSystemEntry);
        }

        public void read(final AsyncReceiver asyncReceiver, final boolean bl) throws IOException {
            MTree.Node node2;
            final FileLocation fileLocation = DependencyFileSystem.this.getLocation(this.fDependencyNode);
            final String string = fileLocation.getNameBeforeDot();
            if (DependencyFileSystem.isInToolbox(fileLocation.toString())) {
                asyncReceiver.finished();
                return;
            }
            String string2 = CoderFileSupport.readMatlabSource(fileLocation);
            MTree mTree = MTree.parse((String)string2, (boolean)true);
            List<MTree.Node> list = MTreeUtils.findAsList(DependencyFileSystem.this.fTarget, string2, mTree, MTree.NodeType.CALL);
            final LinkedList<Pair> linkedList = new LinkedList<Pair>();
            for (MTree.Node node2 : list) {
                if (!node2.getLeft().isTextSupported()) continue;
                linkedList.add(new Pair((Object)DependencyFileSystem.getSourceFunctionName(node2), (Object)node2.getLeft().getText()));
            }
            Iterator<MTree.Node> iterator = MTreeUtils.findAsTree(DependencyFileSystem.this.fTarget, string2, mTree, MTree.NodeType.DOT, MTree.NodeType.ID, MTree.NodeType.FIELD);
            node2 = (MTree.Node)iterator.getRoot();
            int n = iterator.getChildCount(node2);
            for (int i = 0; i < n; ++i) {
                String string3;
                MTree.Node node3 = (MTree.Node)iterator.getChild(node2, i);
                if (node3.getType() != MTree.NodeType.DOT || node3.getLeft().getType() != MTree.NodeType.ID || (string3 = DependencyFileSystem.getSourceFunctionName(node3)) == null) continue;
                String string4 = ImpactModelBuilder.assembleQualifiedName(node3);
                linkedList.add(new Pair((Object)string3, (Object)string4));
            }
            for (MTree.Node node3 : MTreeUtils.findAsList(DependencyFileSystem.this.fTarget, string2, mTree, MTree.NodeType.CEXPR)) {
                if (node3.getRight().getType() != MTree.NodeType.LT || node3.getRight().getRight() == MTree.NULL_NODE || !node3.getRight().getRight().isTextSupported() || MatlabFunctionSupport.isPrimitiveBaseClass(node3.getRight().getRight().getText())) continue;
                linkedList.add(new Pair(null, (Object)node3.getRight().getRight().getText()));
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DependencyFileList.this.readFile(string, fileLocation, linkedList, bl, asyncReceiver);
                }
            };
            if (NativeMatlab.nativeIsMatlabThread()) {
                runnable.run();
            } else {
                Matlab.whenAtPrompt((Runnable)runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFile(String string, FileLocation fileLocation, List<Pair<String, String>> list, boolean bl, AsyncReceiver asyncReceiver) {
            try {
                String string2 = string;
                FileLocation fileLocation2 = fileLocation;
                for (Pair<String, String> pair : list) {
                    CallContext callContext = new CallContext(string2, (String)pair.getSecond());
                    if (this.fCallContextToFilenameMap.containsKey(callContext)) continue;
                    String string3 = this.resolveContext(callContext);
                    while (string3 != null && string3.isEmpty() && fileLocation2.getParent() != null && fileLocation2.getParent().getName().startsWith("+")) {
                        fileLocation2 = fileLocation2.getParent();
                        string2 = fileLocation2.getNameBeforeDot().substring(1) + "." + string2;
                        callContext = new CallContext(string2, (String)pair.getSecond());
                        string3 = this.resolveContext(callContext);
                    }
                    if (this.readFileAndEmit(bl, asyncReceiver, pair, string3)) continue;
                    break;
                }
            }
            finally {
                asyncReceiver.finished();
            }
        }

        private String resolveContext(CallContext callContext) {
            String string = null;
            try {
                String string2 = "coder.internal.projectWhich";
                Object[] objectArray = new Object[]{this.fProjectPath, callContext.getCallee(), "in", callContext.getCaller()};
                string = (String)Matlab.mtFeval((String)string2, (Object[])objectArray, (int)1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                this.fCallContextToFilenameMap.put(callContext, string);
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readFileAndEmit(boolean bl, AsyncReceiver asyncReceiver, Pair<String, String> pair, Object object) {
            block8: {
                if (object != null && object instanceof String && ((CharSequence)object).length() != 0) {
                    String string = (String)object;
                    if (string.startsWith("built-in")) {
                        string = string.substring("built-in (".length(), string.length() - 1) + ".m";
                    }
                    FileLocation fileLocation = new FileLocation(string);
                    FileLocation fileLocation2 = new FileLocation(this.fDependencyNode, fileLocation.getName());
                    Map map = DependencyFileSystem.this.fDependencyNodeToLocation;
                    synchronized (map) {
                        DependencyFileSystem.this.fDependencyNodeToLocation.put(fileLocation2, fileLocation);
                    }
                    try {
                        map = DependencyFileSystem.this.wrap(fileLocation2, RealFileSystem.getInstance().getEntry(fileLocation));
                        if (!this.send((String)pair.getFirst(), (String)pair.getSecond(), (FileSystemEntry)map, bl, asyncReceiver)) {
                            return false;
                        }
                    }
                    catch (IOException iOException) {
                        if (!DependencyFileSystem.isInToolbox(string)) break block8;
                        FileSystemEntry fileSystemEntry = new FileSystemEntry(RealFileSystem.getInstance(), fileLocation, false, false, 0L, 0L, 0L);
                        if (this.send((String)pair.getFirst(), (String)pair.getSecond(), DependencyFileSystem.this.wrap(fileLocation2, fileSystemEntry), bl, asyncReceiver)) break block8;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class CallContext {
        private final String fCaller;
        private final String fCallee;

        private CallContext(String string, String string2) {
            this.fCaller = string;
            this.fCallee = string2;
        }

        public int hashCode() {
            return this.getCaller().hashCode() + this.getCallee().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CallContext && this.getCaller().equals(((CallContext)object).getCaller()) && this.getCallee().equals(((CallContext)object).getCallee());
        }

        public String getCaller() {
            return this.fCaller;
        }

        public String getCallee() {
            return this.fCallee;
        }
    }

    public static final class Call {
        private final String fSourceFunctionName;
        private final String fFunctionName;
        private final FileSystemEntry fEntry;

        public Call(String string, String string2, FileSystemEntry fileSystemEntry) {
            this.fSourceFunctionName = string;
            this.fFunctionName = string2;
            this.fEntry = fileSystemEntry;
        }

        public String getSourceFunctionName() {
            return this.fSourceFunctionName;
        }

        public String getFunctionName() {
            return this.fFunctionName;
        }

        public FileSystemEntry getEntry() {
            return this.fEntry;
        }
    }
}

