/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import java.util.HashSet;
import java.util.Set;

public final class FunctionInfo {
    private static final Set<String> BUILTIN_NAMES = new HashSet<String>();
    private static final Set<String> FIXED_POINT_BUILTIN_NAMES = new HashSet<String>();
    private static final Set<String> AUTO_EXTRINSIC_NAMES = new HashSet<String>();
    private static final Set<String> FUNCTIONS_WITH_EML_IMPL = new HashSet<String>();
    private static final Set<String> FUNCTIONS_WITH_FI_SUPPORT = new HashSet<String>();
    private static final Set<String> SYSTEM_OBJECT_CLASSES = new HashSet<String>();
    private static final Set<String> EXEMPT_METHOD_NAMES = new HashSet<String>();
    private static final Set<String> SYSTEM_OBJECTS_WITH_FI_SUPPORT = new HashSet<String>();

    private FunctionInfo() {
    }

    public static boolean isBuiltin(String string) {
        return BUILTIN_NAMES.contains(string);
    }

    public static boolean isFixedPointBuiltin(String string) {
        return FIXED_POINT_BUILTIN_NAMES.contains(string);
    }

    public static boolean isAutoExtrinsic(String string) {
        return AUTO_EXTRINSIC_NAMES.contains(string);
    }

    public static boolean hasEmlImpl(String string) {
        return FUNCTIONS_WITH_EML_IMPL.contains(string);
    }

    public static boolean hasFixedPointSupport(String string) {
        return FUNCTIONS_WITH_FI_SUPPORT.contains(string);
    }

    public static boolean isSystemObjectWithFixedPointSupport(String string) {
        return SYSTEM_OBJECTS_WITH_FI_SUPPORT.contains(string);
    }

    public static boolean isSystemObjectClass(String string) {
        return SYSTEM_OBJECT_CLASSES.contains(string);
    }

    public static boolean isExemptMethodName(String string) {
        return EXEMPT_METHOD_NAMES.contains(string);
    }

    static {
        BUILTIN_NAMES.add("all");
        BUILTIN_NAMES.add("and");
        BUILTIN_NAMES.add("any");
        BUILTIN_NAMES.add("assert");
        BUILTIN_NAMES.add("cast");
        BUILTIN_NAMES.add("char");
        BUILTIN_NAMES.add("class");
        BUILTIN_NAMES.add("complex");
        BUILTIN_NAMES.add("conj");
        BUILTIN_NAMES.add("ctranspose");
        BUILTIN_NAMES.add("double");
        BUILTIN_NAMES.add("eq");
        BUILTIN_NAMES.add("false");
        BUILTIN_NAMES.add("fi");
        BUILTIN_NAMES.add("embedded.fi");
        BUILTIN_NAMES.add("ge");
        BUILTIN_NAMES.add("gt");
        BUILTIN_NAMES.add("horzcat");
        BUILTIN_NAMES.add("imag");
        BUILTIN_NAMES.add("import");
        BUILTIN_NAMES.add("inf");
        BUILTIN_NAMES.add("Inf");
        BUILTIN_NAMES.add("int8");
        BUILTIN_NAMES.add("int16");
        BUILTIN_NAMES.add("int32");
        BUILTIN_NAMES.add("int64");
        BUILTIN_NAMES.add("isa");
        BUILTIN_NAMES.add("iscell");
        BUILTIN_NAMES.add("ischar");
        BUILTIN_NAMES.add("isempty");
        BUILTIN_NAMES.add("isfloat");
        BUILTIN_NAMES.add("isinteger");
        BUILTIN_NAMES.add("islogical");
        BUILTIN_NAMES.add("isnumeric");
        BUILTIN_NAMES.add("isobject");
        BUILTIN_NAMES.add("isreal");
        BUILTIN_NAMES.add("isscalar");
        BUILTIN_NAMES.add("isstruct");
        BUILTIN_NAMES.add("isvector");
        BUILTIN_NAMES.add("ldivide");
        BUILTIN_NAMES.add("le");
        BUILTIN_NAMES.add("load");
        BUILTIN_NAMES.add("logical");
        BUILTIN_NAMES.add("lt");
        BUILTIN_NAMES.add("mfilename");
        BUILTIN_NAMES.add("minus");
        BUILTIN_NAMES.add("mldivide");
        BUILTIN_NAMES.add("mrdivide");
        BUILTIN_NAMES.add("mpower");
        BUILTIN_NAMES.add("mtimes");
        BUILTIN_NAMES.add("nan");
        BUILTIN_NAMES.add("NaN");
        BUILTIN_NAMES.add("nargin");
        BUILTIN_NAMES.add("narginchk");
        BUILTIN_NAMES.add("nargout");
        BUILTIN_NAMES.add("nargoutchk");
        BUILTIN_NAMES.add("ne");
        BUILTIN_NAMES.add("ndims");
        BUILTIN_NAMES.add("not");
        BUILTIN_NAMES.add("numel");
        BUILTIN_NAMES.add("ones");
        BUILTIN_NAMES.add("or");
        BUILTIN_NAMES.add("pi");
        BUILTIN_NAMES.add("plus");
        BUILTIN_NAMES.add("power");
        BUILTIN_NAMES.add("rdivide");
        BUILTIN_NAMES.add("real");
        BUILTIN_NAMES.add("single");
        BUILTIN_NAMES.add("size");
        BUILTIN_NAMES.add("str2func");
        BUILTIN_NAMES.add("strcmp");
        BUILTIN_NAMES.add("struct");
        BUILTIN_NAMES.add("times");
        BUILTIN_NAMES.add("transpose");
        BUILTIN_NAMES.add("true");
        BUILTIN_NAMES.add("uint8");
        BUILTIN_NAMES.add("uint16");
        BUILTIN_NAMES.add("uint32");
        BUILTIN_NAMES.add("uint64");
        BUILTIN_NAMES.add("uminus");
        BUILTIN_NAMES.add("uplus");
        BUILTIN_NAMES.add("vertcat");
        BUILTIN_NAMES.add("zeros");
        BUILTIN_NAMES.add("sldv.assume");
        BUILTIN_NAMES.add("sldv.condition");
        BUILTIN_NAMES.add("sldv.prove");
        BUILTIN_NAMES.add("sldv.stub");
        BUILTIN_NAMES.add("sldv.test");
        BUILTIN_NAMES.add("eml");
        BUILTIN_NAMES.add("eml_ignore");
        BUILTIN_NAMES.add("coder.allowpcode");
        BUILTIN_NAMES.add("eml.allowpcode");
        BUILTIN_NAMES.add("coder.ceval");
        BUILTIN_NAMES.add("eml.ceval");
        BUILTIN_NAMES.add("coder.cinclude");
        BUILTIN_NAMES.add("coder.cstructname");
        BUILTIN_NAMES.add("eml.cstructname");
        BUILTIN_NAMES.add("coder.extrinsic");
        BUILTIN_NAMES.add("eml.extrinsic");
        BUILTIN_NAMES.add("coder.inline");
        BUILTIN_NAMES.add("eml.inline");
        BUILTIN_NAMES.add("coder.isenum");
        BUILTIN_NAMES.add("eml.isenum");
        BUILTIN_NAMES.add("coder.ismatlabthread");
        BUILTIN_NAMES.add("coder.internal.threadid");
        BUILTIN_NAMES.add("coder.internal.atexit");
        BUILTIN_NAMES.add("coder.license");
        BUILTIN_NAMES.add("eml.license");
        BUILTIN_NAMES.add("coder.load");
        BUILTIN_NAMES.add("coder.nullcopy");
        BUILTIN_NAMES.add("eml.nullcopy");
        BUILTIN_NAMES.add("coder.opaque");
        BUILTIN_NAMES.add("eml.opaque");
        BUILTIN_NAMES.add("coder.parallel");
        BUILTIN_NAMES.add("eml.parallel");
        BUILTIN_NAMES.add("coder.ref");
        BUILTIN_NAMES.add("eml.ref");
        BUILTIN_NAMES.add("coder.replace");
        BUILTIN_NAMES.add("coder.rref");
        BUILTIN_NAMES.add("eml.rref");
        BUILTIN_NAMES.add("coder.setwarningflag");
        BUILTIN_NAMES.add("coder.target");
        BUILTIN_NAMES.add("eml.target");
        BUILTIN_NAMES.add("coder.unroll");
        BUILTIN_NAMES.add("eml.unroll");
        BUILTIN_NAMES.add("coder.updateBuildInfo");
        BUILTIN_NAMES.add("coder.varsize");
        BUILTIN_NAMES.add("eml.varsize");
        BUILTIN_NAMES.add("coder.wref");
        BUILTIN_NAMES.add("eml.wref");
        BUILTIN_NAMES.add("coder.const");
        BUILTIN_NAMES.add("eml_acos");
        BUILTIN_NAMES.add("eml_asin");
        BUILTIN_NAMES.add("eml_atan");
        BUILTIN_NAMES.add("eml_atan2");
        BUILTIN_NAMES.add("eml_ceil");
        BUILTIN_NAMES.add("eml_cos");
        BUILTIN_NAMES.add("eml_cosh");
        BUILTIN_NAMES.add("eml_exp");
        BUILTIN_NAMES.add("eml_fabs");
        BUILTIN_NAMES.add("eml_fix");
        BUILTIN_NAMES.add("eml_floor");
        BUILTIN_NAMES.add("eml_fmod");
        BUILTIN_NAMES.add("eml_frexp");
        BUILTIN_NAMES.add("eml_hypot");
        BUILTIN_NAMES.add("eml_isinf");
        BUILTIN_NAMES.add("eml_isnan");
        BUILTIN_NAMES.add("eml_ldexp");
        BUILTIN_NAMES.add("eml_log");
        BUILTIN_NAMES.add("eml_log10");
        BUILTIN_NAMES.add("eml_max");
        BUILTIN_NAMES.add("eml_min");
        BUILTIN_NAMES.add("eml_mod");
        BUILTIN_NAMES.add("eml_pow");
        BUILTIN_NAMES.add("eml_rem");
        BUILTIN_NAMES.add("eml_round");
        BUILTIN_NAMES.add("eml_sin");
        BUILTIN_NAMES.add("eml_sign");
        BUILTIN_NAMES.add("eml_sinh");
        BUILTIN_NAMES.add("eml_sqrt");
        BUILTIN_NAMES.add("eml_tan");
        BUILTIN_NAMES.add("eml_tanh");
        BUILTIN_NAMES.add("eml_all");
        BUILTIN_NAMES.add("eml_and");
        BUILTIN_NAMES.add("eml_any");
        BUILTIN_NAMES.add("eml_bit_rol");
        BUILTIN_NAMES.add("eml_bit_ror");
        BUILTIN_NAMES.add("eml_bitand");
        BUILTIN_NAMES.add("eml_bitandreduce");
        BUILTIN_NAMES.add("eml_bitconcat");
        BUILTIN_NAMES.add("eml_bitleftextend");
        BUILTIN_NAMES.add("eml_bitnot");
        BUILTIN_NAMES.add("eml_bitorreduce");
        BUILTIN_NAMES.add("eml_bitor");
        BUILTIN_NAMES.add("eml_bitrightextend");
        BUILTIN_NAMES.add("eml_bitslice");
        BUILTIN_NAMES.add("eml_bitxor");
        BUILTIN_NAMES.add("eml_bitxorreduce");
        BUILTIN_NAMES.add("eml_ctranspose");
        BUILTIN_NAMES.add("eml_eq");
        BUILTIN_NAMES.add("eml_expand");
        BUILTIN_NAMES.add("eml_ge");
        BUILTIN_NAMES.add("eml_gt");
        BUILTIN_NAMES.add("eml_le");
        BUILTIN_NAMES.add("eml_ldivide");
        BUILTIN_NAMES.add("eml_lshift");
        BUILTIN_NAMES.add("eml_lt");
        BUILTIN_NAMES.add("eml_minus");
        BUILTIN_NAMES.add("eml_mldivide");
        BUILTIN_NAMES.add("eml_mpower");
        BUILTIN_NAMES.add("eml_mrdivide");
        BUILTIN_NAMES.add("eml_mtimes");
        BUILTIN_NAMES.add("eml_ne");
        BUILTIN_NAMES.add("eml_not");
        BUILTIN_NAMES.add("eml_or");
        BUILTIN_NAMES.add("eml_plus");
        BUILTIN_NAMES.add("eml_power");
        BUILTIN_NAMES.add("eml_rdivide");
        BUILTIN_NAMES.add("eml_rshift");
        BUILTIN_NAMES.add("eml_rshift_logical");
        BUILTIN_NAMES.add("eml_times");
        BUILTIN_NAMES.add("eml_transpose");
        BUILTIN_NAMES.add("eml_uminus");
        BUILTIN_NAMES.add("eml_uplus");
        BUILTIN_NAMES.add("eml_virtual_assign");
        BUILTIN_NAMES.add("eml_allow_enum_inputs");
        BUILTIN_NAMES.add("eml_allow_mx_inputs");
        BUILTIN_NAMES.add("eml_ambiguous_complexity");
        BUILTIN_NAMES.add("eml_ambiguous_types");
        BUILTIN_NAMES.add("eml_ambiguous_sizes");
        BUILTIN_NAMES.add("eml_assert");
        BUILTIN_NAMES.add("eml_cast");
        BUILTIN_NAMES.add("eml_check_upperbounds");
        BUILTIN_NAMES.add("eml_colonobj");
        BUILTIN_NAMES.add("coder.internal.const");
        BUILTIN_NAMES.add("eml_const");
        BUILTIN_NAMES.add("coder.internal.prefer_const");
        BUILTIN_NAMES.add("eml_prefer_const");
        BUILTIN_NAMES.add("eml_crash");
        BUILTIN_NAMES.add("eml_dress");
        BUILTIN_NAMES.add("eml_fconst");
        BUILTIN_NAMES.add("eml_fimath");
        BUILTIN_NAMES.add("eml_fimathislocal");
        BUILTIN_NAMES.add("eml_function_handle");
        BUILTIN_NAMES.add("eml_get_enum_default");
        BUILTIN_NAMES.add("eml_getfield");
        BUILTIN_NAMES.add("eml_getfieldname");
        BUILTIN_NAMES.add("eml_guessdouble");
        BUILTIN_NAMES.add("eml_heisenfun");
        BUILTIN_NAMES.add("eml_invariant");
        BUILTIN_NAMES.add("eml_is_const");
        BUILTIN_NAMES.add("eml_is_constant_folding");
        BUILTIN_NAMES.add("coder.internal.isInParallelRegion");
        BUILTIN_NAMES.add("eml_inf");
        BUILTIN_NAMES.add("eml_lib_assert");
        BUILTIN_NAMES.add("eml_max_fi_bits");
        BUILTIN_NAMES.add("eml_rterror");
        BUILTIN_NAMES.add("eml_message");
        BUILTIN_NAMES.add("eml_must_inline");
        BUILTIN_NAMES.add("eml_must_not_inline");
        BUILTIN_NAMES.add("eml_nan");
        BUILTIN_NAMES.add("eml_ndims");
        BUILTIN_NAMES.add("eml_not_const");
        BUILTIN_NAMES.add("eml_numel");
        BUILTIN_NAMES.add("eml_numfields");
        BUILTIN_NAMES.add("eml_option");
        BUILTIN_NAMES.add("eml_pi");
        BUILTIN_NAMES.add("eml_reinterpret");
        BUILTIN_NAMES.add("eml_scalexp_subsref");
        BUILTIN_NAMES.add("eml_sea_get_obj");
        BUILTIN_NAMES.add("eml_sea_method_call");
        BUILTIN_NAMES.add("eml_sea_set_obj");
        BUILTIN_NAMES.add("eml_transient");
        BUILTIN_NAMES.add("eml_typeof");
        BUILTIN_NAMES.add("coder.internal.fileManagerHelper");
        BUILTIN_NAMES.add("coder.internal.runs_in_matlab");
        BUILTIN_NAMES.add("eml_property");
        BUILTIN_NAMES.add("eml_check_reduction_fcn");
        BUILTIN_NAMES.add("coder.internal.is_defined");
        BUILTIN_NAMES.add("coder.internal.getprop_if_defined");
        BUILTIN_NAMES.add("coder.internal.is_noreturn");
        BUILTIN_NAMES.add("coder.internal.defer_inference");
        BUILTIN_NAMES.add("coder.internal.setprop");
        BUILTIN_NAMES.add("coder.internal.indexIntClass");
        BUILTIN_NAMES.add("coder.internal.indexInt");
        BUILTIN_NAMES.add("coder.internal.intMin");
        BUILTIN_NAMES.add("coder.internal.intMax");
        BUILTIN_NAMES.add("coder.internal.int_nbits");
        BUILTIN_NAMES.add("coder.internal.destructor_body");
        BUILTIN_NAMES.add("coder.internal.autoExtrinsic");
        BUILTIN_NAMES.add("coder.internal.compileWarning");
        BUILTIN_NAMES.add("coder.internal.target_csizeof");
        BUILTIN_NAMES.add("coder.internal.prod_csizeof");
        BUILTIN_NAMES.add("coder.internal.fromOpaqueCast");
        FIXED_POINT_BUILTIN_NAMES.add("coder.allowpcode");
        FIXED_POINT_BUILTIN_NAMES.add("coder.const");
        FIXED_POINT_BUILTIN_NAMES.add("coder.load");
        FIXED_POINT_BUILTIN_NAMES.add("coder.inline");
        FIXED_POINT_BUILTIN_NAMES.add("coder.isenum");
        FIXED_POINT_BUILTIN_NAMES.add("coder.license");
        FIXED_POINT_BUILTIN_NAMES.add("coder.load");
        FIXED_POINT_BUILTIN_NAMES.add("coder.nullcopy");
        AUTO_EXTRINSIC_NAMES.add("disp");
        AUTO_EXTRINSIC_NAMES.add("alim");
        AUTO_EXTRINSIC_NAMES.add("alpha");
        AUTO_EXTRINSIC_NAMES.add("alphamap");
        AUTO_EXTRINSIC_NAMES.add("ancestor");
        AUTO_EXTRINSIC_NAMES.add("autumn");
        AUTO_EXTRINSIC_NAMES.add("axes");
        AUTO_EXTRINSIC_NAMES.add("axescheck");
        AUTO_EXTRINSIC_NAMES.add("axis");
        AUTO_EXTRINSIC_NAMES.add("bone");
        AUTO_EXTRINSIC_NAMES.add("box");
        AUTO_EXTRINSIC_NAMES.add("brighten");
        AUTO_EXTRINSIC_NAMES.add("bwcontr");
        AUTO_EXTRINSIC_NAMES.add("camdolly");
        AUTO_EXTRINSIC_NAMES.add("cameramenu");
        AUTO_EXTRINSIC_NAMES.add("cameratoolbar");
        AUTO_EXTRINSIC_NAMES.add("camlight");
        AUTO_EXTRINSIC_NAMES.add("camlookat");
        AUTO_EXTRINSIC_NAMES.add("camorbit");
        AUTO_EXTRINSIC_NAMES.add("campan");
        AUTO_EXTRINSIC_NAMES.add("campos");
        AUTO_EXTRINSIC_NAMES.add("camproj");
        AUTO_EXTRINSIC_NAMES.add("camroll");
        AUTO_EXTRINSIC_NAMES.add("camrotate");
        AUTO_EXTRINSIC_NAMES.add("camtarget");
        AUTO_EXTRINSIC_NAMES.add("camup");
        AUTO_EXTRINSIC_NAMES.add("camva");
        AUTO_EXTRINSIC_NAMES.add("camzoom");
        AUTO_EXTRINSIC_NAMES.add("caxis");
        AUTO_EXTRINSIC_NAMES.add("cla");
        AUTO_EXTRINSIC_NAMES.add("clf");
        AUTO_EXTRINSIC_NAMES.add("close");
        AUTO_EXTRINSIC_NAMES.add("cmpermute");
        AUTO_EXTRINSIC_NAMES.add("cmunique");
        AUTO_EXTRINSIC_NAMES.add("colorcube");
        AUTO_EXTRINSIC_NAMES.add("colormap");
        AUTO_EXTRINSIC_NAMES.add("colornone");
        AUTO_EXTRINSIC_NAMES.add("cool");
        AUTO_EXTRINSIC_NAMES.add("copper");
        AUTO_EXTRINSIC_NAMES.add("copyobj");
        AUTO_EXTRINSIC_NAMES.add("daspect");
        AUTO_EXTRINSIC_NAMES.add("datachildren");
        AUTO_EXTRINSIC_NAMES.add("datacursormode");
        AUTO_EXTRINSIC_NAMES.add("dateTickPicker");
        AUTO_EXTRINSIC_NAMES.add("datetickstr");
        AUTO_EXTRINSIC_NAMES.add("diffuse");
        AUTO_EXTRINSIC_NAMES.add("drawnow");
        AUTO_EXTRINSIC_NAMES.add("figure");
        AUTO_EXTRINSIC_NAMES.add("fill3");
        AUTO_EXTRINSIC_NAMES.add("findall");
        AUTO_EXTRINSIC_NAMES.add("findobj");
        AUTO_EXTRINSIC_NAMES.add("flag");
        AUTO_EXTRINSIC_NAMES.add("gca");
        AUTO_EXTRINSIC_NAMES.add("gcbf");
        AUTO_EXTRINSIC_NAMES.add("gcbo");
        AUTO_EXTRINSIC_NAMES.add("gcf");
        AUTO_EXTRINSIC_NAMES.add("gco");
        AUTO_EXTRINSIC_NAMES.add("getappdata");
        AUTO_EXTRINSIC_NAMES.add("gray");
        AUTO_EXTRINSIC_NAMES.add("grid");
        AUTO_EXTRINSIC_NAMES.add("gtext");
        AUTO_EXTRINSIC_NAMES.add("hgclose");
        AUTO_EXTRINSIC_NAMES.add("hggroup");
        AUTO_EXTRINSIC_NAMES.add("hgload");
        AUTO_EXTRINSIC_NAMES.add("hgsave");
        AUTO_EXTRINSIC_NAMES.add("hgtransform");
        AUTO_EXTRINSIC_NAMES.add("hidden");
        AUTO_EXTRINSIC_NAMES.add("hold");
        AUTO_EXTRINSIC_NAMES.add("hot");
        AUTO_EXTRINSIC_NAMES.add("hsv");
        AUTO_EXTRINSIC_NAMES.add("imapprox");
        AUTO_EXTRINSIC_NAMES.add("isappdata");
        AUTO_EXTRINSIC_NAMES.add("ishandle");
        AUTO_EXTRINSIC_NAMES.add("ishghandle");
        AUTO_EXTRINSIC_NAMES.add("ishold");
        AUTO_EXTRINSIC_NAMES.add("jet");
        AUTO_EXTRINSIC_NAMES.add("light");
        AUTO_EXTRINSIC_NAMES.add("lightangle");
        AUTO_EXTRINSIC_NAMES.add("lighting");
        AUTO_EXTRINSIC_NAMES.add("line");
        AUTO_EXTRINSIC_NAMES.add("lines");
        AUTO_EXTRINSIC_NAMES.add("lineseries");
        AUTO_EXTRINSIC_NAMES.add("linkaxes");
        AUTO_EXTRINSIC_NAMES.add("loglog");
        AUTO_EXTRINSIC_NAMES.add("makehgtform");
        AUTO_EXTRINSIC_NAMES.add("material");
        AUTO_EXTRINSIC_NAMES.add("mesh");
        AUTO_EXTRINSIC_NAMES.add("newplot");
        AUTO_EXTRINSIC_NAMES.add("noanimate");
        AUTO_EXTRINSIC_NAMES.add("nodither");
        AUTO_EXTRINSIC_NAMES.add("objbounds");
        AUTO_EXTRINSIC_NAMES.add("openfig");
        AUTO_EXTRINSIC_NAMES.add("opengl");
        AUTO_EXTRINSIC_NAMES.add("pan");
        AUTO_EXTRINSIC_NAMES.add("pink");
        AUTO_EXTRINSIC_NAMES.add("plot");
        AUTO_EXTRINSIC_NAMES.add("plot3");
        AUTO_EXTRINSIC_NAMES.add("plotyy");
        AUTO_EXTRINSIC_NAMES.add("polar");
        AUTO_EXTRINSIC_NAMES.add("prism");
        AUTO_EXTRINSIC_NAMES.add("rbbox");
        AUTO_EXTRINSIC_NAMES.add("rectangle");
        AUTO_EXTRINSIC_NAMES.add("refresh");
        AUTO_EXTRINSIC_NAMES.add("refreshdata");
        AUTO_EXTRINSIC_NAMES.add("rmappdata");
        AUTO_EXTRINSIC_NAMES.add("rotate3d");
        AUTO_EXTRINSIC_NAMES.add("semilogx");
        AUTO_EXTRINSIC_NAMES.add("semilogy");
        AUTO_EXTRINSIC_NAMES.add("setappdata");
        AUTO_EXTRINSIC_NAMES.add("shading");
        AUTO_EXTRINSIC_NAMES.add("shg");
        AUTO_EXTRINSIC_NAMES.add("specular");
        AUTO_EXTRINSIC_NAMES.add("spring");
        AUTO_EXTRINSIC_NAMES.add("subplot");
        AUTO_EXTRINSIC_NAMES.add("summer");
        AUTO_EXTRINSIC_NAMES.add("surf");
        AUTO_EXTRINSIC_NAMES.add("surface");
        AUTO_EXTRINSIC_NAMES.add("surfl");
        AUTO_EXTRINSIC_NAMES.add("surfnorm");
        AUTO_EXTRINSIC_NAMES.add("tex");
        AUTO_EXTRINSIC_NAMES.add("texlabel");
        AUTO_EXTRINSIC_NAMES.add("text");
        AUTO_EXTRINSIC_NAMES.add("title");
        AUTO_EXTRINSIC_NAMES.add("view");
        AUTO_EXTRINSIC_NAMES.add("viewmtx");
        AUTO_EXTRINSIC_NAMES.add("white");
        AUTO_EXTRINSIC_NAMES.add("whitebg");
        AUTO_EXTRINSIC_NAMES.add("winter");
        AUTO_EXTRINSIC_NAMES.add("xlabel");
        AUTO_EXTRINSIC_NAMES.add("xlim");
        AUTO_EXTRINSIC_NAMES.add("ylabel");
        AUTO_EXTRINSIC_NAMES.add("ylim");
        AUTO_EXTRINSIC_NAMES.add("zlabel");
        AUTO_EXTRINSIC_NAMES.add("zlim");
        AUTO_EXTRINSIC_NAMES.add("zoom");
        AUTO_EXTRINSIC_NAMES.add("pause");
        AUTO_EXTRINSIC_NAMES.add("NumericTypeScope");
        AUTO_EXTRINSIC_NAMES.add("dsp.TimeScope");
        AUTO_EXTRINSIC_NAMES.add("dsp.SpectrumAnalyzer");
        AUTO_EXTRINSIC_NAMES.add("vision.VideoPlayer");
        AUTO_EXTRINSIC_NAMES.add("dsp.LogicAnalyzer");
        FUNCTIONS_WITH_EML_IMPL.add("CheckForUpper");
        FUNCTIONS_WITH_EML_IMPL.add("EqualSpacing");
        FUNCTIONS_WITH_EML_IMPL.add("MaskOutOfRangeValues");
        FUNCTIONS_WITH_EML_IMPL.add("PHIc");
        FUNCTIONS_WITH_EML_IMPL.add("TensorGriddedInterp");
        FUNCTIONS_WITH_EML_IMPL.add("TensorInterp23");
        FUNCTIONS_WITH_EML_IMPL.add("abs");
        FUNCTIONS_WITH_EML_IMPL.add("accumulatefi");
        FUNCTIONS_WITH_EML_IMPL.add("acos");
        FUNCTIONS_WITH_EML_IMPL.add("acosd");
        FUNCTIONS_WITH_EML_IMPL.add("acosh");
        FUNCTIONS_WITH_EML_IMPL.add("acot");
        FUNCTIONS_WITH_EML_IMPL.add("acotd");
        FUNCTIONS_WITH_EML_IMPL.add("acoth");
        FUNCTIONS_WITH_EML_IMPL.add("acsc");
        FUNCTIONS_WITH_EML_IMPL.add("acscd");
        FUNCTIONS_WITH_EML_IMPL.add("acsch");
        FUNCTIONS_WITH_EML_IMPL.add("add");
        FUNCTIONS_WITH_EML_IMPL.add("affine2d");
        FUNCTIONS_WITH_EML_IMPL.add("all");
        FUNCTIONS_WITH_EML_IMPL.add("all_in_integer_range");
        FUNCTIONS_WITH_EML_IMPL.add("all_or_any");
        FUNCTIONS_WITH_EML_IMPL.add("angle");
        FUNCTIONS_WITH_EML_IMPL.add("any");
        FUNCTIONS_WITH_EML_IMPL.add("asec");
        FUNCTIONS_WITH_EML_IMPL.add("asecd");
        FUNCTIONS_WITH_EML_IMPL.add("asech");
        FUNCTIONS_WITH_EML_IMPL.add("asin");
        FUNCTIONS_WITH_EML_IMPL.add("asind");
        FUNCTIONS_WITH_EML_IMPL.add("asinh");
        FUNCTIONS_WITH_EML_IMPL.add("assert_all_constant");
        FUNCTIONS_WITH_EML_IMPL.add("assert_no_varsize");
        FUNCTIONS_WITH_EML_IMPL.add("assert_supported_string");
        FUNCTIONS_WITH_EML_IMPL.add("assert_valid_dim");
        FUNCTIONS_WITH_EML_IMPL.add("assert_valid_pp");
        FUNCTIONS_WITH_EML_IMPL.add("assert_valid_size_arg");
        FUNCTIONS_WITH_EML_IMPL.add("atan");
        FUNCTIONS_WITH_EML_IMPL.add("atan2");
        FUNCTIONS_WITH_EML_IMPL.add("atan2d");
        FUNCTIONS_WITH_EML_IMPL.add("atand");
        FUNCTIONS_WITH_EML_IMPL.add("atanh");
        FUNCTIONS_WITH_EML_IMPL.add("barthannwin");
        FUNCTIONS_WITH_EML_IMPL.add("bartlett");
        FUNCTIONS_WITH_EML_IMPL.add("bchgenpoly");
        FUNCTIONS_WITH_EML_IMPL.add("besselap");
        FUNCTIONS_WITH_EML_IMPL.add("beta");
        FUNCTIONS_WITH_EML_IMPL.add("betacdf");
        FUNCTIONS_WITH_EML_IMPL.add("betainc");
        FUNCTIONS_WITH_EML_IMPL.add("betaincinv");
        FUNCTIONS_WITH_EML_IMPL.add("betainv");
        FUNCTIONS_WITH_EML_IMPL.add("betaln");
        FUNCTIONS_WITH_EML_IMPL.add("betapdf");
        FUNCTIONS_WITH_EML_IMPL.add("betarnd");
        FUNCTIONS_WITH_EML_IMPL.add("betastat");
        FUNCTIONS_WITH_EML_IMPL.add("bi2de");
        FUNCTIONS_WITH_EML_IMPL.add("bin2dec");
        FUNCTIONS_WITH_EML_IMPL.add("binocdf");
        FUNCTIONS_WITH_EML_IMPL.add("binodeviance");
        FUNCTIONS_WITH_EML_IMPL.add("binoinv");
        FUNCTIONS_WITH_EML_IMPL.add("binopdf");
        FUNCTIONS_WITH_EML_IMPL.add("binornd");
        FUNCTIONS_WITH_EML_IMPL.add("binostat");
        FUNCTIONS_WITH_EML_IMPL.add("bitand");
        FUNCTIONS_WITH_EML_IMPL.add("bitandreduce");
        FUNCTIONS_WITH_EML_IMPL.add("bitbinop");
        FUNCTIONS_WITH_EML_IMPL.add("bitcmp");
        FUNCTIONS_WITH_EML_IMPL.add("bitconcat");
        FUNCTIONS_WITH_EML_IMPL.add("bitget");
        FUNCTIONS_WITH_EML_IMPL.add("bitmax");
        FUNCTIONS_WITH_EML_IMPL.add("bitop_index_checks");
        FUNCTIONS_WITH_EML_IMPL.add("bitor");
        FUNCTIONS_WITH_EML_IMPL.add("bitorreduce");
        FUNCTIONS_WITH_EML_IMPL.add("bitreplicate");
        FUNCTIONS_WITH_EML_IMPL.add("bitrevorder");
        FUNCTIONS_WITH_EML_IMPL.add("bitrol");
        FUNCTIONS_WITH_EML_IMPL.add("bitror");
        FUNCTIONS_WITH_EML_IMPL.add("bitset");
        FUNCTIONS_WITH_EML_IMPL.add("bitshift");
        FUNCTIONS_WITH_EML_IMPL.add("bitsliceget");
        FUNCTIONS_WITH_EML_IMPL.add("bitsll");
        FUNCTIONS_WITH_EML_IMPL.add("bitsra");
        FUNCTIONS_WITH_EML_IMPL.add("bitsrl");
        FUNCTIONS_WITH_EML_IMPL.add("bitxor");
        FUNCTIONS_WITH_EML_IMPL.add("bitxorreduce");
        FUNCTIONS_WITH_EML_IMPL.add("blackman");
        FUNCTIONS_WITH_EML_IMPL.add("blackmanharris");
        FUNCTIONS_WITH_EML_IMPL.add("blanks");
        FUNCTIONS_WITH_EML_IMPL.add("blkdiag");
        FUNCTIONS_WITH_EML_IMPL.add("bohmanwin");
        FUNCTIONS_WITH_EML_IMPL.add("boxcar");
        FUNCTIONS_WITH_EML_IMPL.add("bsearch");
        FUNCTIONS_WITH_EML_IMPL.add("bsxfun");
        FUNCTIONS_WITH_EML_IMPL.add("buttap");
        FUNCTIONS_WITH_EML_IMPL.add("butter");
        FUNCTIONS_WITH_EML_IMPL.add("buttord");
        FUNCTIONS_WITH_EML_IMPL.add("bwdist");
        FUNCTIONS_WITH_EML_IMPL.add("bwlookup");
        FUNCTIONS_WITH_EML_IMPL.add("bwmorph");
        FUNCTIONS_WITH_EML_IMPL.add("bwpack");
        FUNCTIONS_WITH_EML_IMPL.add("bwselect");
        FUNCTIONS_WITH_EML_IMPL.add("bwtraceboundary");
        FUNCTIONS_WITH_EML_IMPL.add("bwunpack");
        FUNCTIONS_WITH_EML_IMPL.add("ca2tf");
        FUNCTIONS_WITH_EML_IMPL.add("cart2pol");
        FUNCTIONS_WITH_EML_IMPL.add("cart2sph");
        FUNCTIONS_WITH_EML_IMPL.add("castLike");
        FUNCTIONS_WITH_EML_IMPL.add("cat");
        FUNCTIONS_WITH_EML_IMPL.add("cdf");
        FUNCTIONS_WITH_EML_IMPL.add("ceil");
        FUNCTIONS_WITH_EML_IMPL.add("cfirpm");
        FUNCTIONS_WITH_EML_IMPL.add("char");
        FUNCTIONS_WITH_EML_IMPL.add("charmax");
        FUNCTIONS_WITH_EML_IMPL.add("chckxy");
        FUNCTIONS_WITH_EML_IMPL.add("cheb1ap");
        FUNCTIONS_WITH_EML_IMPL.add("cheb1ord");
        FUNCTIONS_WITH_EML_IMPL.add("cheb2ap");
        FUNCTIONS_WITH_EML_IMPL.add("cheb2ord");
        FUNCTIONS_WITH_EML_IMPL.add("chebwin");
        FUNCTIONS_WITH_EML_IMPL.add("cheby1");
        FUNCTIONS_WITH_EML_IMPL.add("cheby2");
        FUNCTIONS_WITH_EML_IMPL.add("checkSystemObjectInput");
        FUNCTIONS_WITH_EML_IMPL.add("check_complex_index");
        FUNCTIONS_WITH_EML_IMPL.add("check_div_fimath");
        FUNCTIONS_WITH_EML_IMPL.add("check_double_int64_types");
        FUNCTIONS_WITH_EML_IMPL.add("check_numeric_nonempty_finite");
        FUNCTIONS_WITH_EML_IMPL.add("check_same_bias");
        FUNCTIONS_WITH_EML_IMPL.add("checkfimathforbinaryops");
        FUNCTIONS_WITH_EML_IMPL.add("chi2cdf");
        FUNCTIONS_WITH_EML_IMPL.add("chi2inv");
        FUNCTIONS_WITH_EML_IMPL.add("chi2pdf");
        FUNCTIONS_WITH_EML_IMPL.add("chi2rnd");
        FUNCTIONS_WITH_EML_IMPL.add("chi2stat");
        FUNCTIONS_WITH_EML_IMPL.add("chol");
        FUNCTIONS_WITH_EML_IMPL.add("circshift");
        FUNCTIONS_WITH_EML_IMPL.add("cl2tf");
        FUNCTIONS_WITH_EML_IMPL.add("colon");
        FUNCTIONS_WITH_EML_IMPL.add("colonhelper");
        FUNCTIONS_WITH_EML_IMPL.add("colontype");
        FUNCTIONS_WITH_EML_IMPL.add("commblkbchrs");
        FUNCTIONS_WITH_EML_IMPL.add("commblkgentcmenc");
        FUNCTIONS_WITH_EML_IMPL.add("commblkpnseq2");
        FUNCTIONS_WITH_EML_IMPL.add("commblkpsktcmenc");
        FUNCTIONS_WITH_EML_IMPL.add("commblkqamtcmenc");
        FUNCTIONS_WITH_EML_IMPL.add("compan");
        FUNCTIONS_WITH_EML_IMPL.add("computer");
        FUNCTIONS_WITH_EML_IMPL.add("cond");
        FUNCTIONS_WITH_EML_IMPL.add("conj");
        FUNCTIONS_WITH_EML_IMPL.add("conjtimes");
        FUNCTIONS_WITH_EML_IMPL.add("conndef");
        FUNCTIONS_WITH_EML_IMPL.add("const_nonsingleton_dim");
        FUNCTIONS_WITH_EML_IMPL.add("conv");
        FUNCTIONS_WITH_EML_IMPL.add("conv2");
        FUNCTIONS_WITH_EML_IMPL.add("convergent");
        FUNCTIONS_WITH_EML_IMPL.add("convn");
        FUNCTIONS_WITH_EML_IMPL.add("cordic_check_niters_arg");
        FUNCTIONS_WITH_EML_IMPL.add("cordic_check_theta_arg");
        FUNCTIONS_WITH_EML_IMPL.add("cordic_copy_reshape_xy");
        FUNCTIONS_WITH_EML_IMPL.add("cordiccart2pol");
        FUNCTIONS_WITH_EML_IMPL.add("cordiccexp");
        FUNCTIONS_WITH_EML_IMPL.add("cordiccos");
        FUNCTIONS_WITH_EML_IMPL.add("cordicpol2cart");
        FUNCTIONS_WITH_EML_IMPL.add("cordicrotate");
        FUNCTIONS_WITH_EML_IMPL.add("cordicsin");
        FUNCTIONS_WITH_EML_IMPL.add("cordicsincos");
        FUNCTIONS_WITH_EML_IMPL.add("cordicsqrt");
        FUNCTIONS_WITH_EML_IMPL.add("corrcoef");
        FUNCTIONS_WITH_EML_IMPL.add("cos");
        FUNCTIONS_WITH_EML_IMPL.add("cosd");
        FUNCTIONS_WITH_EML_IMPL.add("cosh");
        FUNCTIONS_WITH_EML_IMPL.add("cot");
        FUNCTIONS_WITH_EML_IMPL.add("cotd");
        FUNCTIONS_WITH_EML_IMPL.add("coth");
        FUNCTIONS_WITH_EML_IMPL.add("cov");
        FUNCTIONS_WITH_EML_IMPL.add("createUniqueSComponent");
        FUNCTIONS_WITH_EML_IMPL.add("createsystemobject");
        FUNCTIONS_WITH_EML_IMPL.add("createsystemobjectv2");
        FUNCTIONS_WITH_EML_IMPL.add("cross");
        FUNCTIONS_WITH_EML_IMPL.add("csc");
        FUNCTIONS_WITH_EML_IMPL.add("cscd");
        FUNCTIONS_WITH_EML_IMPL.add("csch");
        FUNCTIONS_WITH_EML_IMPL.add("ctranspose");
        FUNCTIONS_WITH_EML_IMPL.add("cumprod");
        FUNCTIONS_WITH_EML_IMPL.add("cumsum");
        FUNCTIONS_WITH_EML_IMPL.add("cumtrapz");
        FUNCTIONS_WITH_EML_IMPL.add("datawrap");
        FUNCTIONS_WITH_EML_IMPL.add("dct");
        FUNCTIONS_WITH_EML_IMPL.add("de2bi");
        FUNCTIONS_WITH_EML_IMPL.add("deal");
        FUNCTIONS_WITH_EML_IMPL.add("deblank");
        FUNCTIONS_WITH_EML_IMPL.add("dec2bin");
        FUNCTIONS_WITH_EML_IMPL.add("dec2hex");
        FUNCTIONS_WITH_EML_IMPL.add("deconv");
        FUNCTIONS_WITH_EML_IMPL.add("defaultOpt");
        FUNCTIONS_WITH_EML_IMPL.add("del2");
        FUNCTIONS_WITH_EML_IMPL.add("det");
        FUNCTIONS_WITH_EML_IMPL.add("detrend");
        FUNCTIONS_WITH_EML_IMPL.add("dgammainc");
        FUNCTIONS_WITH_EML_IMPL.add("diag");
        FUNCTIONS_WITH_EML_IMPL.add("diff");
        FUNCTIONS_WITH_EML_IMPL.add("dim_to_fore_permutation");
        FUNCTIONS_WITH_EML_IMPL.add("div");
        FUNCTIONS_WITH_EML_IMPL.add("divide");
        FUNCTIONS_WITH_EML_IMPL.add("dlanv2");
        FUNCTIONS_WITH_EML_IMPL.add("dlapy2");
        FUNCTIONS_WITH_EML_IMPL.add("dlapy3");
        FUNCTIONS_WITH_EML_IMPL.add("doppler");
        FUNCTIONS_WITH_EML_IMPL.add("dot");
        FUNCTIONS_WITH_EML_IMPL.add("downsample");
        FUNCTIONS_WITH_EML_IMPL.add("dpss");
        FUNCTIONS_WITH_EML_IMPL.add("dspblkanalytic2");
        FUNCTIONS_WITH_EML_IMPL.add("dvbs2ldpc");
        FUNCTIONS_WITH_EML_IMPL.add("edge");
        FUNCTIONS_WITH_EML_IMPL.add("eig");
        FUNCTIONS_WITH_EML_IMPL.add("ellip");
        FUNCTIONS_WITH_EML_IMPL.add("ellipap");
        FUNCTIONS_WITH_EML_IMPL.add("ellipke");
        FUNCTIONS_WITH_EML_IMPL.add("ellipord");
        FUNCTIONS_WITH_EML_IMPL.add("epipolarLine");
        FUNCTIONS_WITH_EML_IMPL.add("eps");
        FUNCTIONS_WITH_EML_IMPL.add("eq");
        FUNCTIONS_WITH_EML_IMPL.add("erf");
        FUNCTIONS_WITH_EML_IMPL.add("erfc");
        FUNCTIONS_WITH_EML_IMPL.add("erfcinv");
        FUNCTIONS_WITH_EML_IMPL.add("erfcore");
        FUNCTIONS_WITH_EML_IMPL.add("erfcx");
        FUNCTIONS_WITH_EML_IMPL.add("erfinv");
        FUNCTIONS_WITH_EML_IMPL.add("error");
        FUNCTIONS_WITH_EML_IMPL.add("estimateUncalibratedRectification");
        FUNCTIONS_WITH_EML_IMPL.add("evcdf");
        FUNCTIONS_WITH_EML_IMPL.add("evcdfz");
        FUNCTIONS_WITH_EML_IMPL.add("evinv");
        FUNCTIONS_WITH_EML_IMPL.add("evpdf");
        FUNCTIONS_WITH_EML_IMPL.add("evrnd");
        FUNCTIONS_WITH_EML_IMPL.add("evstat");
        FUNCTIONS_WITH_EML_IMPL.add("exp");
        FUNCTIONS_WITH_EML_IMPL.add("expcdf");
        FUNCTIONS_WITH_EML_IMPL.add("expint");
        FUNCTIONS_WITH_EML_IMPL.add("expinv");
        FUNCTIONS_WITH_EML_IMPL.add("expm");
        FUNCTIONS_WITH_EML_IMPL.add("expm1");
        FUNCTIONS_WITH_EML_IMPL.add("exppdf");
        FUNCTIONS_WITH_EML_IMPL.add("exprnd");
        FUNCTIONS_WITH_EML_IMPL.add("expstat");
        FUNCTIONS_WITH_EML_IMPL.add("eye");
        FUNCTIONS_WITH_EML_IMPL.add("factor");
        FUNCTIONS_WITH_EML_IMPL.add("factorial");
        FUNCTIONS_WITH_EML_IMPL.add("fcdf");
        FUNCTIONS_WITH_EML_IMPL.add("fclose");
        FUNCTIONS_WITH_EML_IMPL.add("feof");
        FUNCTIONS_WITH_EML_IMPL.add("feval");
        FUNCTIONS_WITH_EML_IMPL.add("fft");
        FUNCTIONS_WITH_EML_IMPL.add("fft2");
        FUNCTIONS_WITH_EML_IMPL.add("fftn");
        FUNCTIONS_WITH_EML_IMPL.add("fftshift");
        FUNCTIONS_WITH_EML_IMPL.add("fi2sim");
        FUNCTIONS_WITH_EML_IMPL.add("fi_assert_dataTypeNotSupported");
        FUNCTIONS_WITH_EML_IMPL.add("fi_bitshift");
        FUNCTIONS_WITH_EML_IMPL.add("fi_cast_two_inputs");
        FUNCTIONS_WITH_EML_IMPL.add("fi_checkforconst");
        FUNCTIONS_WITH_EML_IMPL.add("fi_checkforerror");
        FUNCTIONS_WITH_EML_IMPL.add("fi_checkforntype");
        FUNCTIONS_WITH_EML_IMPL.add("fi_convergent_helper");
        FUNCTIONS_WITH_EML_IMPL.add("fi_eps_lsb");
        FUNCTIONS_WITH_EML_IMPL.add("fi_getDType");
        FUNCTIONS_WITH_EML_IMPL.add("fi_getRealWorldValAsDType");
        FUNCTIONS_WITH_EML_IMPL.add("fi_getStoredIntValAsDType");
        FUNCTIONS_WITH_EML_IMPL.add("fi_get_numerictype_fimath");
        FUNCTIONS_WITH_EML_IMPL.add("fi_impl");
        FUNCTIONS_WITH_EML_IMPL.add("fi_matlab_style_round_helper");
        FUNCTIONS_WITH_EML_IMPL.add("fi_round_helper");
        FUNCTIONS_WITH_EML_IMPL.add("fi_type_math_and_dtype");
        FUNCTIONS_WITH_EML_IMPL.add("fidCheck");
        FUNCTIONS_WITH_EML_IMPL.add("fileManager");
        FUNCTIONS_WITH_EML_IMPL.add("filter");
        FUNCTIONS_WITH_EML_IMPL.add("filter2");
        FUNCTIONS_WITH_EML_IMPL.add("filtfilt");
        FUNCTIONS_WITH_EML_IMPL.add("fimath");
        FUNCTIONS_WITH_EML_IMPL.add("find");
        FUNCTIONS_WITH_EML_IMPL.add("finv");
        FUNCTIONS_WITH_EML_IMPL.add("fir1");
        FUNCTIONS_WITH_EML_IMPL.add("fir2");
        FUNCTIONS_WITH_EML_IMPL.add("firceqrip");
        FUNCTIONS_WITH_EML_IMPL.add("fircls");
        FUNCTIONS_WITH_EML_IMPL.add("fircls1");
        FUNCTIONS_WITH_EML_IMPL.add("fireqint");
        FUNCTIONS_WITH_EML_IMPL.add("firgr");
        FUNCTIONS_WITH_EML_IMPL.add("firhalfband");
        FUNCTIONS_WITH_EML_IMPL.add("firlpnorm");
        FUNCTIONS_WITH_EML_IMPL.add("firls");
        FUNCTIONS_WITH_EML_IMPL.add("firminphase");
        FUNCTIONS_WITH_EML_IMPL.add("firnyquist");
        FUNCTIONS_WITH_EML_IMPL.add("firpm");
        FUNCTIONS_WITH_EML_IMPL.add("firpmord");
        FUNCTIONS_WITH_EML_IMPL.add("firpr2chfb");
        FUNCTIONS_WITH_EML_IMPL.add("firrcos");
        FUNCTIONS_WITH_EML_IMPL.add("fitgeotrans");
        FUNCTIONS_WITH_EML_IMPL.add("fitool");
        FUNCTIONS_WITH_EML_IMPL.add("fix");
        FUNCTIONS_WITH_EML_IMPL.add("fixpt_times");
        FUNCTIONS_WITH_EML_IMPL.add("flattopwin");
        FUNCTIONS_WITH_EML_IMPL.add("flintmax");
        FUNCTIONS_WITH_EML_IMPL.add("flip");
        FUNCTIONS_WITH_EML_IMPL.add("flipdim");
        FUNCTIONS_WITH_EML_IMPL.add("fliplr");
        FUNCTIONS_WITH_EML_IMPL.add("flipud");
        FUNCTIONS_WITH_EML_IMPL.add("float_model");
        FUNCTIONS_WITH_EML_IMPL.add("float_nbits");
        FUNCTIONS_WITH_EML_IMPL.add("floor");
        FUNCTIONS_WITH_EML_IMPL.add("flt2str");
        FUNCTIONS_WITH_EML_IMPL.add("flt_in_range64");
        FUNCTIONS_WITH_EML_IMPL.add("fminsearch");
        FUNCTIONS_WITH_EML_IMPL.add("fopen");
        FUNCTIONS_WITH_EML_IMPL.add("fpdf");
        FUNCTIONS_WITH_EML_IMPL.add("fprintf");
        FUNCTIONS_WITH_EML_IMPL.add("fread");
        FUNCTIONS_WITH_EML_IMPL.add("freqspace");
        FUNCTIONS_WITH_EML_IMPL.add("freqz");
        FUNCTIONS_WITH_EML_IMPL.add("frewind");
        FUNCTIONS_WITH_EML_IMPL.add("frnd");
        FUNCTIONS_WITH_EML_IMPL.add("fspecial");
        FUNCTIONS_WITH_EML_IMPL.add("fstat");
        FUNCTIONS_WITH_EML_IMPL.add("full");
        FUNCTIONS_WITH_EML_IMPL.add("fzero");
        FUNCTIONS_WITH_EML_IMPL.add("gamcdf");
        FUNCTIONS_WITH_EML_IMPL.add("gaminv");
        FUNCTIONS_WITH_EML_IMPL.add("gamma");
        FUNCTIONS_WITH_EML_IMPL.add("gammainc");
        FUNCTIONS_WITH_EML_IMPL.add("gammaincinv");
        FUNCTIONS_WITH_EML_IMPL.add("gammaln");
        FUNCTIONS_WITH_EML_IMPL.add("gampdf");
        FUNCTIONS_WITH_EML_IMPL.add("gamrnd");
        FUNCTIONS_WITH_EML_IMPL.add("gamstat");
        FUNCTIONS_WITH_EML_IMPL.add("gaussfir");
        FUNCTIONS_WITH_EML_IMPL.add("gausswin");
        FUNCTIONS_WITH_EML_IMPL.add("gcd");
        FUNCTIONS_WITH_EML_IMPL.add("ge");
        FUNCTIONS_WITH_EML_IMPL.add("gentcmconstmapper");
        FUNCTIONS_WITH_EML_IMPL.add("geocdf");
        FUNCTIONS_WITH_EML_IMPL.add("geoinv");
        FUNCTIONS_WITH_EML_IMPL.add("geomean");
        FUNCTIONS_WITH_EML_IMPL.add("geopdf");
        FUNCTIONS_WITH_EML_IMPL.add("geornd");
        FUNCTIONS_WITH_EML_IMPL.add("geostat");
        FUNCTIONS_WITH_EML_IMPL.add("get");
        FUNCTIONS_WITH_EML_IMPL.add("getNumInputs");
        FUNCTIONS_WITH_EML_IMPL.add("getNumOutputs");
        FUNCTIONS_WITH_EML_IMPL.add("get_int_shift_or_bit_index");
        FUNCTIONS_WITH_EML_IMPL.add("get_parameter_value");
        FUNCTIONS_WITH_EML_IMPL.add("getlsb");
        FUNCTIONS_WITH_EML_IMPL.add("getmsb");
        FUNCTIONS_WITH_EML_IMPL.add("getrangefromclass");
        FUNCTIONS_WITH_EML_IMPL.add("gevcdf");
        FUNCTIONS_WITH_EML_IMPL.add("gevinv");
        FUNCTIONS_WITH_EML_IMPL.add("gevpdf");
        FUNCTIONS_WITH_EML_IMPL.add("gevrnd");
        FUNCTIONS_WITH_EML_IMPL.add("gevstat");
        FUNCTIONS_WITH_EML_IMPL.add("gpcdf");
        FUNCTIONS_WITH_EML_IMPL.add("gpinv");
        FUNCTIONS_WITH_EML_IMPL.add("gppdf");
        FUNCTIONS_WITH_EML_IMPL.add("gprnd");
        FUNCTIONS_WITH_EML_IMPL.add("gpstat");
        FUNCTIONS_WITH_EML_IMPL.add("gradient");
        FUNCTIONS_WITH_EML_IMPL.add("grayto16");
        FUNCTIONS_WITH_EML_IMPL.add("grayto8");
        FUNCTIONS_WITH_EML_IMPL.add("gt");
        FUNCTIONS_WITH_EML_IMPL.add("guarded_inf");
        FUNCTIONS_WITH_EML_IMPL.add("guarded_nan");
        FUNCTIONS_WITH_EML_IMPL.add("hadamard");
        FUNCTIONS_WITH_EML_IMPL.add("hamming");
        FUNCTIONS_WITH_EML_IMPL.add("hankel");
        FUNCTIONS_WITH_EML_IMPL.add("hann");
        FUNCTIONS_WITH_EML_IMPL.add("hanning");
        FUNCTIONS_WITH_EML_IMPL.add("harmmean");
        FUNCTIONS_WITH_EML_IMPL.add("hdlfimath");
        FUNCTIONS_WITH_EML_IMPL.add("hex2dec");
        FUNCTIONS_WITH_EML_IMPL.add("hex2num");
        FUNCTIONS_WITH_EML_IMPL.add("hilb");
        FUNCTIONS_WITH_EML_IMPL.add("hist");
        FUNCTIONS_WITH_EML_IMPL.add("histc");
        FUNCTIONS_WITH_EML_IMPL.add("histeq");
        FUNCTIONS_WITH_EML_IMPL.add("hsv2rgb");
        FUNCTIONS_WITH_EML_IMPL.add("hygecdf");
        FUNCTIONS_WITH_EML_IMPL.add("hygeinv");
        FUNCTIONS_WITH_EML_IMPL.add("hygepdf");
        FUNCTIONS_WITH_EML_IMPL.add("hygernd");
        FUNCTIONS_WITH_EML_IMPL.add("hygestat");
        FUNCTIONS_WITH_EML_IMPL.add("hypot");
        FUNCTIONS_WITH_EML_IMPL.add("i");
        FUNCTIONS_WITH_EML_IMPL.add("i64ddiv");
        FUNCTIONS_WITH_EML_IMPL.add("i64dminus");
        FUNCTIONS_WITH_EML_IMPL.add("i64dmul");
        FUNCTIONS_WITH_EML_IMPL.add("i64dplus");
        FUNCTIONS_WITH_EML_IMPL.add("i64relops");
        FUNCTIONS_WITH_EML_IMPL.add("icdf");
        FUNCTIONS_WITH_EML_IMPL.add("idct");
        FUNCTIONS_WITH_EML_IMPL.add("idivide");
        FUNCTIONS_WITH_EML_IMPL.add("ifft");
        FUNCTIONS_WITH_EML_IMPL.add("ifft2");
        FUNCTIONS_WITH_EML_IMPL.add("ifftn");
        FUNCTIONS_WITH_EML_IMPL.add("ifftshift");
        FUNCTIONS_WITH_EML_IMPL.add("ifir");
        FUNCTIONS_WITH_EML_IMPL.add("iircomb");
        FUNCTIONS_WITH_EML_IMPL.add("iirgrpdelay");
        FUNCTIONS_WITH_EML_IMPL.add("iirlpnorm");
        FUNCTIONS_WITH_EML_IMPL.add("iirlpnormc");
        FUNCTIONS_WITH_EML_IMPL.add("iirnotch");
        FUNCTIONS_WITH_EML_IMPL.add("iirpeak");
        FUNCTIONS_WITH_EML_IMPL.add("im2double");
        FUNCTIONS_WITH_EML_IMPL.add("im2int16");
        FUNCTIONS_WITH_EML_IMPL.add("im2single");
        FUNCTIONS_WITH_EML_IMPL.add("im2uint16");
        FUNCTIONS_WITH_EML_IMPL.add("im2uint8");
        FUNCTIONS_WITH_EML_IMPL.add("imadjust");
        FUNCTIONS_WITH_EML_IMPL.add("imbothat");
        FUNCTIONS_WITH_EML_IMPL.add("imclearborder");
        FUNCTIONS_WITH_EML_IMPL.add("imclose");
        FUNCTIONS_WITH_EML_IMPL.add("imcomplement");
        FUNCTIONS_WITH_EML_IMPL.add("imdilate");
        FUNCTIONS_WITH_EML_IMPL.add("imerode");
        FUNCTIONS_WITH_EML_IMPL.add("imextendedmax");
        FUNCTIONS_WITH_EML_IMPL.add("imextendedmin");
        FUNCTIONS_WITH_EML_IMPL.add("imfill");
        FUNCTIONS_WITH_EML_IMPL.add("imfilter");
        FUNCTIONS_WITH_EML_IMPL.add("imhist");
        FUNCTIONS_WITH_EML_IMPL.add("imhmax");
        FUNCTIONS_WITH_EML_IMPL.add("imhmin");
        FUNCTIONS_WITH_EML_IMPL.add("imlincomb");
        FUNCTIONS_WITH_EML_IMPL.add("imopen");
        FUNCTIONS_WITH_EML_IMPL.add("imquantize");
        FUNCTIONS_WITH_EML_IMPL.add("imreconstruct");
        FUNCTIONS_WITH_EML_IMPL.add("imref2d");
        FUNCTIONS_WITH_EML_IMPL.add("imref3d");
        FUNCTIONS_WITH_EML_IMPL.add("imregionalmax");
        FUNCTIONS_WITH_EML_IMPL.add("imregionalmin");
        FUNCTIONS_WITH_EML_IMPL.add("imtophat");
        FUNCTIONS_WITH_EML_IMPL.add("imwarp");
        FUNCTIONS_WITH_EML_IMPL.add("ind2sub");
        FUNCTIONS_WITH_EML_IMPL.add("index_class");
        FUNCTIONS_WITH_EML_IMPL.add("index_minus");
        FUNCTIONS_WITH_EML_IMPL.add("index_plus");
        FUNCTIONS_WITH_EML_IMPL.add("index_prod");
        FUNCTIONS_WITH_EML_IMPL.add("index_rdivide");
        FUNCTIONS_WITH_EML_IMPL.add("index_times");
        FUNCTIONS_WITH_EML_IMPL.add("int");
        FUNCTIONS_WITH_EML_IMPL.add("int16");
        FUNCTIONS_WITH_EML_IMPL.add("int16touint16");
        FUNCTIONS_WITH_EML_IMPL.add("int32");
        FUNCTIONS_WITH_EML_IMPL.add("int32touint32");
        FUNCTIONS_WITH_EML_IMPL.add("int64");
        FUNCTIONS_WITH_EML_IMPL.add("int8");
        FUNCTIONS_WITH_EML_IMPL.add("int8touint8");
        FUNCTIONS_WITH_EML_IMPL.add("int_forloop_overflow_check");
        FUNCTIONS_WITH_EML_IMPL.add("int_nbits");
        FUNCTIONS_WITH_EML_IMPL.add("interp1");
        FUNCTIONS_WITH_EML_IMPL.add("interp1q");
        FUNCTIONS_WITH_EML_IMPL.add("interp2");
        FUNCTIONS_WITH_EML_IMPL.add("interp3");
        FUNCTIONS_WITH_EML_IMPL.add("intersect");
        FUNCTIONS_WITH_EML_IMPL.add("intlut");
        FUNCTIONS_WITH_EML_IMPL.add("intfilt");
        FUNCTIONS_WITH_EML_IMPL.add("intmax");
        FUNCTIONS_WITH_EML_IMPL.add("intmin");
        FUNCTIONS_WITH_EML_IMPL.add("inv");
        FUNCTIONS_WITH_EML_IMPL.add("invhilb");
        FUNCTIONS_WITH_EML_IMPL.add("ipermute");
        FUNCTIONS_WITH_EML_IMPL.add("ipiv2perm");
        FUNCTIONS_WITH_EML_IMPL.add("ippgeotrans");
        FUNCTIONS_WITH_EML_IMPL.add("iptcheckconn");
        FUNCTIONS_WITH_EML_IMPL.add("iptcheckmap");
        FUNCTIONS_WITH_EML_IMPL.add("iqr");
        FUNCTIONS_WITH_EML_IMPL.add("isDone");
        FUNCTIONS_WITH_EML_IMPL.add("isFimathEqualForCodeGen");
        FUNCTIONS_WITH_EML_IMPL.add("isInputDirectFeedthrough");
        FUNCTIONS_WITH_EML_IMPL.add("isLegacyCommand");
        FUNCTIONS_WITH_EML_IMPL.add("is_float_class");
        FUNCTIONS_WITH_EML_IMPL.add("is_integer_class");
        FUNCTIONS_WITH_EML_IMPL.add("is_permutation");
        FUNCTIONS_WITH_EML_IMPL.add("is_positive_integer_scalar");
        FUNCTIONS_WITH_EML_IMPL.add("is_rand_extrinsic");
        FUNCTIONS_WITH_EML_IMPL.add("isa_signed_int");
        FUNCTIONS_WITH_EML_IMPL.add("isa_uint");
        FUNCTIONS_WITH_EML_IMPL.add("isboolean");
        FUNCTIONS_WITH_EML_IMPL.add("iscolumn");
        FUNCTIONS_WITH_EML_IMPL.add("isdeployed");
        FUNCTIONS_WITH_EML_IMPL.add("isdouble");
        FUNCTIONS_WITH_EML_IMPL.add("isequal");
        FUNCTIONS_WITH_EML_IMPL.add("isequal_core");
        FUNCTIONS_WITH_EML_IMPL.add("isequaln");
        FUNCTIONS_WITH_EML_IMPL.add("isequalwithequalnans");
        FUNCTIONS_WITH_EML_IMPL.add("isfi");
        FUNCTIONS_WITH_EML_IMPL.add("isfield");
        FUNCTIONS_WITH_EML_IMPL.add("isfimath");
        FUNCTIONS_WITH_EML_IMPL.add("isfimathlocal");
        FUNCTIONS_WITH_EML_IMPL.add("isfinite");
        FUNCTIONS_WITH_EML_IMPL.add("isfixed");
        FUNCTIONS_WITH_EML_IMPL.add("isfloat");
        FUNCTIONS_WITH_EML_IMPL.add("ishermitian");
        FUNCTIONS_WITH_EML_IMPL.add("isincreasing");
        FUNCTIONS_WITH_EML_IMPL.add("isinf");
        FUNCTIONS_WITH_EML_IMPL.add("isletter");
        FUNCTIONS_WITH_EML_IMPL.add("ismac");
        FUNCTIONS_WITH_EML_IMPL.add("ismatrix");
        FUNCTIONS_WITH_EML_IMPL.add("ismcc");
        FUNCTIONS_WITH_EML_IMPL.add("ismember");
        FUNCTIONS_WITH_EML_IMPL.add("isnan");
        FUNCTIONS_WITH_EML_IMPL.add("isnumerictype");
        FUNCTIONS_WITH_EML_IMPL.add("ispc");
        FUNCTIONS_WITH_EML_IMPL.add("isplaid");
        FUNCTIONS_WITH_EML_IMPL.add("isprime");
        FUNCTIONS_WITH_EML_IMPL.add("isrow");
        FUNCTIONS_WITH_EML_IMPL.add("isscaleddouble");
        FUNCTIONS_WITH_EML_IMPL.add("isscaledtype");
        FUNCTIONS_WITH_EML_IMPL.add("isscalingbinarypoint");
        FUNCTIONS_WITH_EML_IMPL.add("isscalingslopebias");
        FUNCTIONS_WITH_EML_IMPL.add("issigned");
        FUNCTIONS_WITH_EML_IMPL.add("issingle");
        FUNCTIONS_WITH_EML_IMPL.add("isslopebiasscaled");
        FUNCTIONS_WITH_EML_IMPL.add("issorted");
        FUNCTIONS_WITH_EML_IMPL.add("isspace");
        FUNCTIONS_WITH_EML_IMPL.add("issparse");
        FUNCTIONS_WITH_EML_IMPL.add("isstr");
        FUNCTIONS_WITH_EML_IMPL.add("isstrprop");
        FUNCTIONS_WITH_EML_IMPL.add("issymmetric");
        FUNCTIONS_WITH_EML_IMPL.add("istrellis");
        FUNCTIONS_WITH_EML_IMPL.add("isunix");
        FUNCTIONS_WITH_EML_IMPL.add("ixamax");
        FUNCTIONS_WITH_EML_IMPL.add("j");
        FUNCTIONS_WITH_EML_IMPL.add("kaiser");
        FUNCTIONS_WITH_EML_IMPL.add("kaiserord");
        FUNCTIONS_WITH_EML_IMPL.add("kron");
        FUNCTIONS_WITH_EML_IMPL.add("kurtosis");
        FUNCTIONS_WITH_EML_IMPL.add("label2rgb");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgeev");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgehrd");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgeqp3");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgeqrf");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgesvd");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xgetrf");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xggev");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xhseqr");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xpotrf");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xunghr");
        FUNCTIONS_WITH_EML_IMPL.add("lapack_xungqr");
        FUNCTIONS_WITH_EML_IMPL.add("lcm");
        FUNCTIONS_WITH_EML_IMPL.add("ldivide");
        FUNCTIONS_WITH_EML_IMPL.add("le");
        FUNCTIONS_WITH_EML_IMPL.add("length");
        FUNCTIONS_WITH_EML_IMPL.add("levinson");
        FUNCTIONS_WITH_EML_IMPL.add("li_find");
        FUNCTIONS_WITH_EML_IMPL.add("lineToBorderPoints");
        FUNCTIONS_WITH_EML_IMPL.add("linsolve");
        FUNCTIONS_WITH_EML_IMPL.add("linspace");
        FUNCTIONS_WITH_EML_IMPL.add("log");
        FUNCTIONS_WITH_EML_IMPL.add("log10");
        FUNCTIONS_WITH_EML_IMPL.add("log1p");
        FUNCTIONS_WITH_EML_IMPL.add("log2");
        FUNCTIONS_WITH_EML_IMPL.add("logical");
        FUNCTIONS_WITH_EML_IMPL.add("logncdf");
        FUNCTIONS_WITH_EML_IMPL.add("logninv");
        FUNCTIONS_WITH_EML_IMPL.add("lognpdf");
        FUNCTIONS_WITH_EML_IMPL.add("lognrnd");
        FUNCTIONS_WITH_EML_IMPL.add("lognstat");
        FUNCTIONS_WITH_EML_IMPL.add("logspace");
        FUNCTIONS_WITH_EML_IMPL.add("lower");
        FUNCTIONS_WITH_EML_IMPL.add("lowerbound");
        FUNCTIONS_WITH_EML_IMPL.add("lsb");
        FUNCTIONS_WITH_EML_IMPL.add("lt");
        FUNCTIONS_WITH_EML_IMPL.add("ltitr");
        FUNCTIONS_WITH_EML_IMPL.add("lu");
        FUNCTIONS_WITH_EML_IMPL.add("lusolve");
        FUNCTIONS_WITH_EML_IMPL.add("mad");
        FUNCTIONS_WITH_EML_IMPL.add("magic");
        FUNCTIONS_WITH_EML_IMPL.add("make_same_complexity");
        FUNCTIONS_WITH_EML_IMPL.add("makepp");
        FUNCTIONS_WITH_EML_IMPL.add("mantissa_nbits");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_dhseqr");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zgehrd");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zgeqp3");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zgeqr2");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zgetrf");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zggbak");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zggbal");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zggev");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zgghrd");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zhgeqz");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zhseqr");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlangeM");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlanhs");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlarf");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlarfg");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlarfp");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlartg");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zlascl");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zpotrf");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zsvdc");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_ztgevc");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zunghr");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zungqr");
        FUNCTIONS_WITH_EML_IMPL.add("matlab_zunmqr");
        FUNCTIONS_WITH_EML_IMPL.add("matrix_npages");
        FUNCTIONS_WITH_EML_IMPL.add("matrix_vstride");
        FUNCTIONS_WITH_EML_IMPL.add("max");
        FUNCTIONS_WITH_EML_IMPL.add("maxflat");
        FUNCTIONS_WITH_EML_IMPL.add("mean");
        FUNCTIONS_WITH_EML_IMPL.add("mean2");
        FUNCTIONS_WITH_EML_IMPL.add("median");
        FUNCTIONS_WITH_EML_IMPL.add("medfilt2");
        FUNCTIONS_WITH_EML_IMPL.add("meshgrid");
        FUNCTIONS_WITH_EML_IMPL.add("min");
        FUNCTIONS_WITH_EML_IMPL.add("min_or_max");
        FUNCTIONS_WITH_EML_IMPL.add("minus");
        FUNCTIONS_WITH_EML_IMPL.add("mkpp");
        FUNCTIONS_WITH_EML_IMPL.add("mldivide");
        FUNCTIONS_WITH_EML_IMPL.add("mnpdf");
        FUNCTIONS_WITH_EML_IMPL.add("mod");
        FUNCTIONS_WITH_EML_IMPL.add("mode");
        FUNCTIONS_WITH_EML_IMPL.add("moment");
        FUNCTIONS_WITH_EML_IMPL.add("mpower");
        FUNCTIONS_WITH_EML_IMPL.add("mpy");
        FUNCTIONS_WITH_EML_IMPL.add("mrdivide");
        FUNCTIONS_WITH_EML_IMPL.add("mtimes");
        FUNCTIONS_WITH_EML_IMPL.add("mtimes_helper");
        FUNCTIONS_WITH_EML_IMPL.add("multithresh");
        FUNCTIONS_WITH_EML_IMPL.add("nan_sum_or_mean");
        FUNCTIONS_WITH_EML_IMPL.add("nancov");
        FUNCTIONS_WITH_EML_IMPL.add("nanmax");
        FUNCTIONS_WITH_EML_IMPL.add("nanmean");
        FUNCTIONS_WITH_EML_IMPL.add("nanmedian");
        FUNCTIONS_WITH_EML_IMPL.add("nanmin");
        FUNCTIONS_WITH_EML_IMPL.add("nanstd");
        FUNCTIONS_WITH_EML_IMPL.add("nansum");
        FUNCTIONS_WITH_EML_IMPL.add("nanvar");
        FUNCTIONS_WITH_EML_IMPL.add("nargchk");
        FUNCTIONS_WITH_EML_IMPL.add("nbincdf");
        FUNCTIONS_WITH_EML_IMPL.add("nbininv");
        FUNCTIONS_WITH_EML_IMPL.add("nbinpdf");
        FUNCTIONS_WITH_EML_IMPL.add("nbinrnd");
        FUNCTIONS_WITH_EML_IMPL.add("nbinstat");
        FUNCTIONS_WITH_EML_IMPL.add("ncfcdf");
        FUNCTIONS_WITH_EML_IMPL.add("ncfinv");
        FUNCTIONS_WITH_EML_IMPL.add("ncfpdf");
        FUNCTIONS_WITH_EML_IMPL.add("ncfrnd");
        FUNCTIONS_WITH_EML_IMPL.add("ncfstat");
        FUNCTIONS_WITH_EML_IMPL.add("nchoosek");
        FUNCTIONS_WITH_EML_IMPL.add("nctcdf");
        FUNCTIONS_WITH_EML_IMPL.add("nctinv");
        FUNCTIONS_WITH_EML_IMPL.add("nctpdf");
        FUNCTIONS_WITH_EML_IMPL.add("nctrnd");
        FUNCTIONS_WITH_EML_IMPL.add("nctstat");
        FUNCTIONS_WITH_EML_IMPL.add("ncx2cdf");
        FUNCTIONS_WITH_EML_IMPL.add("ncx2rnd");
        FUNCTIONS_WITH_EML_IMPL.add("ncx2stat");
        FUNCTIONS_WITH_EML_IMPL.add("ndgrid");
        FUNCTIONS_WITH_EML_IMPL.add("ndims_varsized");
        FUNCTIONS_WITH_EML_IMPL.add("ne");
        FUNCTIONS_WITH_EML_IMPL.add("nearest");
        FUNCTIONS_WITH_EML_IMPL.add("nextpow2");
        FUNCTIONS_WITH_EML_IMPL.add("nnz");
        FUNCTIONS_WITH_EML_IMPL.add("nonsingleton_dim");
        FUNCTIONS_WITH_EML_IMPL.add("nonzeros");
        FUNCTIONS_WITH_EML_IMPL.add("norm");
        FUNCTIONS_WITH_EML_IMPL.add("normcdf");
        FUNCTIONS_WITH_EML_IMPL.add("normest");
        FUNCTIONS_WITH_EML_IMPL.add("norminv");
        FUNCTIONS_WITH_EML_IMPL.add("normpdf");
        FUNCTIONS_WITH_EML_IMPL.add("normrnd");
        FUNCTIONS_WITH_EML_IMPL.add("normstat");
        FUNCTIONS_WITH_EML_IMPL.add("nthroot");
        FUNCTIONS_WITH_EML_IMPL.add("null");
        FUNCTIONS_WITH_EML_IMPL.add("null_assignment");
        FUNCTIONS_WITH_EML_IMPL.add("num2hex");
        FUNCTIONS_WITH_EML_IMPL.add("numberofelements");
        FUNCTIONS_WITH_EML_IMPL.add("numerictype");
        FUNCTIONS_WITH_EML_IMPL.add("nuttallwin");
        FUNCTIONS_WITH_EML_IMPL.add("ode23");
        FUNCTIONS_WITH_EML_IMPL.add("ode45");
        FUNCTIONS_WITH_EML_IMPL.add("odeget");
        FUNCTIONS_WITH_EML_IMPL.add("odeset");
        FUNCTIONS_WITH_EML_IMPL.add("onesLike");
        FUNCTIONS_WITH_EML_IMPL.add("optimOptNames");
        FUNCTIONS_WITH_EML_IMPL.add("optimget");
        FUNCTIONS_WITH_EML_IMPL.add("optimset");
        FUNCTIONS_WITH_EML_IMPL.add("ordfilt2");
        FUNCTIONS_WITH_EML_IMPL.add("orth");
        FUNCTIONS_WITH_EML_IMPL.add("output");
        FUNCTIONS_WITH_EML_IMPL.add("pad_array");
        FUNCTIONS_WITH_EML_IMPL.add("pad_or_truncate_matrix");
        FUNCTIONS_WITH_EML_IMPL.add("padarray");
        FUNCTIONS_WITH_EML_IMPL.add("padecoef");
        FUNCTIONS_WITH_EML_IMPL.add("parse_parameter_inputs");
        FUNCTIONS_WITH_EML_IMPL.add("partial_strcmp");
        FUNCTIONS_WITH_EML_IMPL.add("parzenwin");
        FUNCTIONS_WITH_EML_IMPL.add("pascal");
        FUNCTIONS_WITH_EML_IMPL.add("pchip");
        FUNCTIONS_WITH_EML_IMPL.add("pdf");
        FUNCTIONS_WITH_EML_IMPL.add("permute");
        FUNCTIONS_WITH_EML_IMPL.add("pinv");
        FUNCTIONS_WITH_EML_IMPL.add("planerot");
        FUNCTIONS_WITH_EML_IMPL.add("plus");
        FUNCTIONS_WITH_EML_IMPL.add("poisscdf");
        FUNCTIONS_WITH_EML_IMPL.add("poissinv");
        FUNCTIONS_WITH_EML_IMPL.add("poisspdf");
        FUNCTIONS_WITH_EML_IMPL.add("poissrnd");
        FUNCTIONS_WITH_EML_IMPL.add("poisstat");
        FUNCTIONS_WITH_EML_IMPL.add("pol2cart");
        FUNCTIONS_WITH_EML_IMPL.add("poly");
        FUNCTIONS_WITH_EML_IMPL.add("poly2trellis");
        FUNCTIONS_WITH_EML_IMPL.add("polyarea");
        FUNCTIONS_WITH_EML_IMPL.add("polyder");
        FUNCTIONS_WITH_EML_IMPL.add("polyfit");
        FUNCTIONS_WITH_EML_IMPL.add("polyint");
        FUNCTIONS_WITH_EML_IMPL.add("polyval");
        FUNCTIONS_WITH_EML_IMPL.add("polyvalm");
        FUNCTIONS_WITH_EML_IMPL.add("pow2");
        FUNCTIONS_WITH_EML_IMPL.add("power");
        FUNCTIONS_WITH_EML_IMPL.add("ppval");
        FUNCTIONS_WITH_EML_IMPL.add("prctile");
        FUNCTIONS_WITH_EML_IMPL.add("primes");
        FUNCTIONS_WITH_EML_IMPL.add("primes_core");
        FUNCTIONS_WITH_EML_IMPL.add("private_sfiufi_constructor");
        FUNCTIONS_WITH_EML_IMPL.add("prod");
        FUNCTIONS_WITH_EML_IMPL.add("prodsize_except_dim");
        FUNCTIONS_WITH_EML_IMPL.add("projective2d");
        FUNCTIONS_WITH_EML_IMPL.add("psi");
        FUNCTIONS_WITH_EML_IMPL.add("pwch");
        FUNCTIONS_WITH_EML_IMPL.add("pwchcore");
        FUNCTIONS_WITH_EML_IMPL.add("qr");
        FUNCTIONS_WITH_EML_IMPL.add("qrsolve");
        FUNCTIONS_WITH_EML_IMPL.add("quad2d");
        FUNCTIONS_WITH_EML_IMPL.add("quadgk");
        FUNCTIONS_WITH_EML_IMPL.add("quantile");
        FUNCTIONS_WITH_EML_IMPL.add("quantize");
        FUNCTIONS_WITH_EML_IMPL.add("quatconj");
        FUNCTIONS_WITH_EML_IMPL.add("quatdivide");
        FUNCTIONS_WITH_EML_IMPL.add("quatinv");
        FUNCTIONS_WITH_EML_IMPL.add("quatmod");
        FUNCTIONS_WITH_EML_IMPL.add("quatmultiply");
        FUNCTIONS_WITH_EML_IMPL.add("quatnorm");
        FUNCTIONS_WITH_EML_IMPL.add("quatnormalize");
        FUNCTIONS_WITH_EML_IMPL.add("rand");
        FUNCTIONS_WITH_EML_IMPL.add("rand_batch_call");
        FUNCTIONS_WITH_EML_IMPL.add("rand_cast_double2single");
        FUNCTIONS_WITH_EML_IMPL.add("rand_mcg16807");
        FUNCTIONS_WITH_EML_IMPL.add("rand_mcg16807_stateful");
        FUNCTIONS_WITH_EML_IMPL.add("rand_mt19937ar");
        FUNCTIONS_WITH_EML_IMPL.add("rand_mt19937ar_stateful");
        FUNCTIONS_WITH_EML_IMPL.add("rand_shr3cong");
        FUNCTIONS_WITH_EML_IMPL.add("rand_shr3cong_stateful");
        FUNCTIONS_WITH_EML_IMPL.add("rand_str2id");
        FUNCTIONS_WITH_EML_IMPL.add("randg");
        FUNCTIONS_WITH_EML_IMPL.add("randi");
        FUNCTIONS_WITH_EML_IMPL.add("randn");
        FUNCTIONS_WITH_EML_IMPL.add("random");
        FUNCTIONS_WITH_EML_IMPL.add("randperm");
        FUNCTIONS_WITH_EML_IMPL.add("range");
        FUNCTIONS_WITH_EML_IMPL.add("rank");
        FUNCTIONS_WITH_EML_IMPL.add("raylcdf");
        FUNCTIONS_WITH_EML_IMPL.add("raylinv");
        FUNCTIONS_WITH_EML_IMPL.add("raylpdf");
        FUNCTIONS_WITH_EML_IMPL.add("raylrnd");
        FUNCTIONS_WITH_EML_IMPL.add("raylstat");
        FUNCTIONS_WITH_EML_IMPL.add("rcond");
        FUNCTIONS_WITH_EML_IMPL.add("rcosdesign");
        FUNCTIONS_WITH_EML_IMPL.add("rcosfir");
        FUNCTIONS_WITH_EML_IMPL.add("rdivide");
        FUNCTIONS_WITH_EML_IMPL.add("reallog");
        FUNCTIONS_WITH_EML_IMPL.add("realmax");
        FUNCTIONS_WITH_EML_IMPL.add("realmin");
        FUNCTIONS_WITH_EML_IMPL.add("realmin_denormal");
        FUNCTIONS_WITH_EML_IMPL.add("realpow");
        FUNCTIONS_WITH_EML_IMPL.add("realsqrt");
        FUNCTIONS_WITH_EML_IMPL.add("rectint");
        FUNCTIONS_WITH_EML_IMPL.add("rectwin");
        FUNCTIONS_WITH_EML_IMPL.add("reinterpretcast");
        FUNCTIONS_WITH_EML_IMPL.add("release");
        FUNCTIONS_WITH_EML_IMPL.add("relop");
        FUNCTIONS_WITH_EML_IMPL.add("rem");
        FUNCTIONS_WITH_EML_IMPL.add("removefimath");
        FUNCTIONS_WITH_EML_IMPL.add("repmat");
        FUNCTIONS_WITH_EML_IMPL.add("resample");
        FUNCTIONS_WITH_EML_IMPL.add("rescale");
        FUNCTIONS_WITH_EML_IMPL.add("reset");
        FUNCTIONS_WITH_EML_IMPL.add("reshape");
        FUNCTIONS_WITH_EML_IMPL.add("rgb2gray");
        FUNCTIONS_WITH_EML_IMPL.add("rgb2hsv");
        FUNCTIONS_WITH_EML_IMPL.add("rgb2ycbcr");
        FUNCTIONS_WITH_EML_IMPL.add("rng");
        FUNCTIONS_WITH_EML_IMPL.add("roots");
        FUNCTIONS_WITH_EML_IMPL.add("rosser");
        FUNCTIONS_WITH_EML_IMPL.add("rot90");
        FUNCTIONS_WITH_EML_IMPL.add("round");
        FUNCTIONS_WITH_EML_IMPL.add("rsf2csf");
        FUNCTIONS_WITH_EML_IMPL.add("rsgenpoly");
        FUNCTIONS_WITH_EML_IMPL.add("rsgenpolycoeffs");
        FUNCTIONS_WITH_EML_IMPL.add("safe_eq");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_abs");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acos");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acosh");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acot");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acoth");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acsc");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_acsch");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_angle");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_asec");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_asech");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_asin");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_asinh");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_atan");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_atan2");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_atanh");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_ceil");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_cos");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_cosd_and_sind");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_cosh");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_cot");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_coth");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_csc");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_csch");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_eg");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_exp");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_expm1");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_fix");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_floor");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_hypot");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_log");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_log10");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_log1p");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_nthroot");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_pow2");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_reallog");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_realpow");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_realsqrt");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_rem90");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_round");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sec");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sech");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sign");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sin");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sinh");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_sqrt");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_tan");
        FUNCTIONS_WITH_EML_IMPL.add("scalar_tanh");
        FUNCTIONS_WITH_EML_IMPL.add("scalexp_alloc");
        FUNCTIONS_WITH_EML_IMPL.add("scalexp_compatible");
        FUNCTIONS_WITH_EML_IMPL.add("scalexp_size");
        FUNCTIONS_WITH_EML_IMPL.add("schur");
        FUNCTIONS_WITH_EML_IMPL.add("sec");
        FUNCTIONS_WITH_EML_IMPL.add("secd");
        FUNCTIONS_WITH_EML_IMPL.add("sech");
        FUNCTIONS_WITH_EML_IMPL.add("set");
        FUNCTIONS_WITH_EML_IMPL.add("setProperties");
        FUNCTIONS_WITH_EML_IMPL.add("setSfunSystemObject");
        FUNCTIONS_WITH_EML_IMPL.add("set_singleton_dim");
        FUNCTIONS_WITH_EML_IMPL.add("setdiff");
        FUNCTIONS_WITH_EML_IMPL.add("setfimath");
        FUNCTIONS_WITH_EML_IMPL.add("setop");
        FUNCTIONS_WITH_EML_IMPL.add("setup");
        FUNCTIONS_WITH_EML_IMPL.add("setxor");
        FUNCTIONS_WITH_EML_IMPL.add("sfi");
        FUNCTIONS_WITH_EML_IMPL.add("sgolay");
        FUNCTIONS_WITH_EML_IMPL.add("shift_checks");
        FUNCTIONS_WITH_EML_IMPL.add("shiftdim");
        FUNCTIONS_WITH_EML_IMPL.add("sign");
        FUNCTIONS_WITH_EML_IMPL.add("sim2fi");
        FUNCTIONS_WITH_EML_IMPL.add("sin");
        FUNCTIONS_WITH_EML_IMPL.add("sind");
        FUNCTIONS_WITH_EML_IMPL.add("sinh");
        FUNCTIONS_WITH_EML_IMPL.add("size_ispow2");
        FUNCTIONS_WITH_EML_IMPL.add("size_prod");
        FUNCTIONS_WITH_EML_IMPL.add("skewness");
        FUNCTIONS_WITH_EML_IMPL.add("sort");
        FUNCTIONS_WITH_EML_IMPL.add("sort_idx");
        FUNCTIONS_WITH_EML_IMPL.add("sort_le");
        FUNCTIONS_WITH_EML_IMPL.add("sort_lt");
        FUNCTIONS_WITH_EML_IMPL.add("sortrows");
        FUNCTIONS_WITH_EML_IMPL.add("sosfilt");
        FUNCTIONS_WITH_EML_IMPL.add("sph2cart");
        FUNCTIONS_WITH_EML_IMPL.add("spline");
        FUNCTIONS_WITH_EML_IMPL.add("sqrt");
        FUNCTIONS_WITH_EML_IMPL.add("sqrtm");
        FUNCTIONS_WITH_EML_IMPL.add("squeeze");
        FUNCTIONS_WITH_EML_IMPL.add("statop_empty_handling");
        FUNCTIONS_WITH_EML_IMPL.add("statop_input_and_index_checks");
        FUNCTIONS_WITH_EML_IMPL.add("statop_validate_and_get_dim");
        FUNCTIONS_WITH_EML_IMPL.add("std");
        FUNCTIONS_WITH_EML_IMPL.add("step");
        FUNCTIONS_WITH_EML_IMPL.add("stirlerr");
        FUNCTIONS_WITH_EML_IMPL.add("storedInteger");
        FUNCTIONS_WITH_EML_IMPL.add("storedIntegerToDouble");
        FUNCTIONS_WITH_EML_IMPL.add("str2double");
        FUNCTIONS_WITH_EML_IMPL.add("strcmp");
        FUNCTIONS_WITH_EML_IMPL.add("strcmpi");
        FUNCTIONS_WITH_EML_IMPL.add("strel");
        FUNCTIONS_WITH_EML_IMPL.add("stretchlim");
        FUNCTIONS_WITH_EML_IMPL.add("strfind");
        FUNCTIONS_WITH_EML_IMPL.add("string_transform");
        FUNCTIONS_WITH_EML_IMPL.add("stripscaling");
        FUNCTIONS_WITH_EML_IMPL.add("strjust");
        FUNCTIONS_WITH_EML_IMPL.add("strncmp");
        FUNCTIONS_WITH_EML_IMPL.add("strncmpi");
        FUNCTIONS_WITH_EML_IMPL.add("strrep");
        FUNCTIONS_WITH_EML_IMPL.add("strtok");
        FUNCTIONS_WITH_EML_IMPL.add("strtrim");
        FUNCTIONS_WITH_EML_IMPL.add("structfun");
        FUNCTIONS_WITH_EML_IMPL.add("sub");
        FUNCTIONS_WITH_EML_IMPL.add("sub2ind");
        FUNCTIONS_WITH_EML_IMPL.add("subspace");
        FUNCTIONS_WITH_EML_IMPL.add("sum");
        FUNCTIONS_WITH_EML_IMPL.add("superiorfloat");
        FUNCTIONS_WITH_EML_IMPL.add("svd");
        FUNCTIONS_WITH_EML_IMPL.add("swapbytes");
        FUNCTIONS_WITH_EML_IMPL.add("switch_helper");
        FUNCTIONS_WITH_EML_IMPL.add("tan");
        FUNCTIONS_WITH_EML_IMPL.add("tand");
        FUNCTIONS_WITH_EML_IMPL.add("tanh");
        FUNCTIONS_WITH_EML_IMPL.add("taylorwin");
        FUNCTIONS_WITH_EML_IMPL.add("tcdf");
        FUNCTIONS_WITH_EML_IMPL.add("tcmconstmapper");
        FUNCTIONS_WITH_EML_IMPL.add("tf2ca");
        FUNCTIONS_WITH_EML_IMPL.add("tf2cl");
        FUNCTIONS_WITH_EML_IMPL.add("times");
        FUNCTIONS_WITH_EML_IMPL.add("tinv");
        FUNCTIONS_WITH_EML_IMPL.add("toeplitz");
        FUNCTIONS_WITH_EML_IMPL.add("tolower");
        FUNCTIONS_WITH_EML_IMPL.add("tpdf");
        FUNCTIONS_WITH_EML_IMPL.add("trace");
        FUNCTIONS_WITH_EML_IMPL.add("trapz");
        FUNCTIONS_WITH_EML_IMPL.add("triang");
        FUNCTIONS_WITH_EML_IMPL.add("tril");
        FUNCTIONS_WITH_EML_IMPL.add("triu");
        FUNCTIONS_WITH_EML_IMPL.add("trnd");
        FUNCTIONS_WITH_EML_IMPL.add("tstat");
        FUNCTIONS_WITH_EML_IMPL.add("tukeywin");
        FUNCTIONS_WITH_EML_IMPL.add("type_relop_const");
        FUNCTIONS_WITH_EML_IMPL.add("typecast");
        FUNCTIONS_WITH_EML_IMPL.add("ufi");
        FUNCTIONS_WITH_EML_IMPL.add("uint16");
        FUNCTIONS_WITH_EML_IMPL.add("uint16toint16");
        FUNCTIONS_WITH_EML_IMPL.add("uint32");
        FUNCTIONS_WITH_EML_IMPL.add("uint64");
        FUNCTIONS_WITH_EML_IMPL.add("uint8");
        FUNCTIONS_WITH_EML_IMPL.add("uminus");
        FUNCTIONS_WITH_EML_IMPL.add("unidcdf");
        FUNCTIONS_WITH_EML_IMPL.add("unidinv");
        FUNCTIONS_WITH_EML_IMPL.add("unidpdf");
        FUNCTIONS_WITH_EML_IMPL.add("unidrnd");
        FUNCTIONS_WITH_EML_IMPL.add("unidstat");
        FUNCTIONS_WITH_EML_IMPL.add("unifcdf");
        FUNCTIONS_WITH_EML_IMPL.add("unifinv");
        FUNCTIONS_WITH_EML_IMPL.add("unifpdf");
        FUNCTIONS_WITH_EML_IMPL.add("unifrnd");
        FUNCTIONS_WITH_EML_IMPL.add("unifstat");
        FUNCTIONS_WITH_EML_IMPL.add("union");
        FUNCTIONS_WITH_EML_IMPL.add("unique");
        FUNCTIONS_WITH_EML_IMPL.add("unmeshgrid");
        FUNCTIONS_WITH_EML_IMPL.add("unmkpp");
        FUNCTIONS_WITH_EML_IMPL.add("unsigned_class");
        FUNCTIONS_WITH_EML_IMPL.add("unwrap");
        FUNCTIONS_WITH_EML_IMPL.add("update");
        FUNCTIONS_WITH_EML_IMPL.add("upfirdn");
        FUNCTIONS_WITH_EML_IMPL.add("uplus");
        FUNCTIONS_WITH_EML_IMPL.add("upper");
        FUNCTIONS_WITH_EML_IMPL.add("upperbound");
        FUNCTIONS_WITH_EML_IMPL.add("upsample");
        FUNCTIONS_WITH_EML_IMPL.add("validateattributes");
        FUNCTIONS_WITH_EML_IMPL.add("validatestring");
        FUNCTIONS_WITH_EML_IMPL.add("vander");
        FUNCTIONS_WITH_EML_IMPL.add("var");
        FUNCTIONS_WITH_EML_IMPL.add("warning");
        FUNCTIONS_WITH_EML_IMPL.add("wblcdf");
        FUNCTIONS_WITH_EML_IMPL.add("wblinv");
        FUNCTIONS_WITH_EML_IMPL.add("wblpdf");
        FUNCTIONS_WITH_EML_IMPL.add("wblrnd");
        FUNCTIONS_WITH_EML_IMPL.add("wblstat");
        FUNCTIONS_WITH_EML_IMPL.add("wilkinson");
        FUNCTIONS_WITH_EML_IMPL.add("xasum");
        FUNCTIONS_WITH_EML_IMPL.add("xaxpy");
        FUNCTIONS_WITH_EML_IMPL.add("xcabs1");
        FUNCTIONS_WITH_EML_IMPL.add("xcopy");
        FUNCTIONS_WITH_EML_IMPL.add("xcorr");
        FUNCTIONS_WITH_EML_IMPL.add("xdot");
        FUNCTIONS_WITH_EML_IMPL.add("xdotc");
        FUNCTIONS_WITH_EML_IMPL.add("xdotu");
        FUNCTIONS_WITH_EML_IMPL.add("xgeev");
        FUNCTIONS_WITH_EML_IMPL.add("xgehrd");
        FUNCTIONS_WITH_EML_IMPL.add("xgemm");
        FUNCTIONS_WITH_EML_IMPL.add("xgemv");
        FUNCTIONS_WITH_EML_IMPL.add("xgeqp3");
        FUNCTIONS_WITH_EML_IMPL.add("xgeqrf");
        FUNCTIONS_WITH_EML_IMPL.add("xger");
        FUNCTIONS_WITH_EML_IMPL.add("xgerc");
        FUNCTIONS_WITH_EML_IMPL.add("xgeru");
        FUNCTIONS_WITH_EML_IMPL.add("xgesvd");
        FUNCTIONS_WITH_EML_IMPL.add("xgetrf");
        FUNCTIONS_WITH_EML_IMPL.add("xggev");
        FUNCTIONS_WITH_EML_IMPL.add("xhseqr");
        FUNCTIONS_WITH_EML_IMPL.add("xnrm2");
        FUNCTIONS_WITH_EML_IMPL.add("xor");
        FUNCTIONS_WITH_EML_IMPL.add("xpotrf");
        FUNCTIONS_WITH_EML_IMPL.add("xrot");
        FUNCTIONS_WITH_EML_IMPL.add("xrotg");
        FUNCTIONS_WITH_EML_IMPL.add("xscal");
        FUNCTIONS_WITH_EML_IMPL.add("xswap");
        FUNCTIONS_WITH_EML_IMPL.add("xtrsm");
        FUNCTIONS_WITH_EML_IMPL.add("xtrsv");
        FUNCTIONS_WITH_EML_IMPL.add("xunghr");
        FUNCTIONS_WITH_EML_IMPL.add("xungqr");
        FUNCTIONS_WITH_EML_IMPL.add("ycbcr2rgb");
        FUNCTIONS_WITH_EML_IMPL.add("yulewalk");
        FUNCTIONS_WITH_EML_IMPL.add("zerosLike");
        FUNCTIONS_WITH_EML_IMPL.add("zp2tf");
        FUNCTIONS_WITH_EML_IMPL.add("zrot_cols");
        FUNCTIONS_WITH_EML_IMPL.add("zrot_rows");
        FUNCTIONS_WITH_EML_IMPL.add("zscore");
        FUNCTIONS_WITH_FI_SUPPORT.add("BitAllocationDialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("InputDataDialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("LegendDialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("NTX");
        FUNCTIONS_WITH_FI_SUPPORT.add("NumericTypeScope");
        FUNCTIONS_WITH_FI_SUPPORT.add("NumericTypeScopeCfg");
        FUNCTIONS_WITH_FI_SUPPORT.add("NumericTypeScopeComponentCfg");
        FUNCTIONS_WITH_FI_SUPPORT.add("ResultingTypeDialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("_colonobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("abs");
        FUNCTIONS_WITH_FI_SUPPORT.add("add");
        FUNCTIONS_WITH_FI_SUPPORT.add("adjustHistAxisSize");
        FUNCTIONS_WITH_FI_SUPPORT.add("all");
        FUNCTIONS_WITH_FI_SUPPORT.add("and");
        FUNCTIONS_WITH_FI_SUPPORT.add("any");
        FUNCTIONS_WITH_FI_SUPPORT.add("area");
        FUNCTIONS_WITH_FI_SUPPORT.add("atan2");
        FUNCTIONS_WITH_FI_SUPPORT.add("bar");
        FUNCTIONS_WITH_FI_SUPPORT.add("barh");
        FUNCTIONS_WITH_FI_SUPPORT.add("base2num");
        FUNCTIONS_WITH_FI_SUPPORT.add("bin");
        FUNCTIONS_WITH_FI_SUPPORT.add("bin2fixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("bin2float");
        FUNCTIONS_WITH_FI_SUPPORT.add("bin2num");
        FUNCTIONS_WITH_FI_SUPPORT.add("bin2ufixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitand");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitandreduce");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitcmp");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitconcat");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitget");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitor");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitorreduce");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitreplicate");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitrol");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitror");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitset");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitshift");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitsliceget");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitsll");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitsra");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitsrl");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitxor");
        FUNCTIONS_WITH_FI_SUPPORT.add("bitxorreduce");
        FUNCTIONS_WITH_FI_SUPPORT.add("buffer");
        FUNCTIONS_WITH_FI_SUPPORT.add("buildAxisContextMenu");
        FUNCTIONS_WITH_FI_SUPPORT.add("buildContextMenu");
        FUNCTIONS_WITH_FI_SUPPORT.add("buildVerticalUnitsMenu");
        FUNCTIONS_WITH_FI_SUPPORT.add("cast");
        FUNCTIONS_WITH_FI_SUPPORT.add("castLike");
        FUNCTIONS_WITH_FI_SUPPORT.add("cat");
        FUNCTIONS_WITH_FI_SUPPORT.add("ceil");
        FUNCTIONS_WITH_FI_SUPPORT.add("changeDTXFracSpanText");
        FUNCTIONS_WITH_FI_SUPPORT.add("changeVerticalUnitsOption");
        FUNCTIONS_WITH_FI_SUPPORT.add("char");
        FUNCTIONS_WITH_FI_SUPPORT.add("checkXAxisLock");
        FUNCTIONS_WITH_FI_SUPPORT.add("clabel");
        FUNCTIONS_WITH_FI_SUPPORT.add("colon");
        FUNCTIONS_WITH_FI_SUPPORT.add("comet");
        FUNCTIONS_WITH_FI_SUPPORT.add("comet3");
        FUNCTIONS_WITH_FI_SUPPORT.add("compass");
        FUNCTIONS_WITH_FI_SUPPORT.add("complex");
        FUNCTIONS_WITH_FI_SUPPORT.add("complexabs");
        FUNCTIONS_WITH_FI_SUPPORT.add("computeDivideType");
        FUNCTIONS_WITH_FI_SUPPORT.add("coneplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("conj");
        FUNCTIONS_WITH_FI_SUPPORT.add("consolidatelogs");
        FUNCTIONS_WITH_FI_SUPPORT.add("contour");
        FUNCTIONS_WITH_FI_SUPPORT.add("contour3");
        FUNCTIONS_WITH_FI_SUPPORT.add("contourc");
        FUNCTIONS_WITH_FI_SUPPORT.add("contourf");
        FUNCTIONS_WITH_FI_SUPPORT.add("conv");
        FUNCTIONS_WITH_FI_SUPPORT.add("convergent");
        FUNCTIONS_WITH_FI_SUPPORT.add("copyNumericTypeToClipboard");
        FUNCTIONS_WITH_FI_SUPPORT.add("copyobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("copyprops");
        FUNCTIONS_WITH_FI_SUPPORT.add("cos");
        FUNCTIONS_WITH_FI_SUPPORT.add("createAppSpecificDialogs");
        FUNCTIONS_WITH_FI_SUPPORT.add("createContent");
        FUNCTIONS_WITH_FI_SUPPORT.add("createContextMenuItem");
        FUNCTIONS_WITH_FI_SUPPORT.add("createDTX");
        FUNCTIONS_WITH_FI_SUPPORT.add("createFLSubdialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("createHistogramUI");
        FUNCTIONS_WITH_FI_SUPPORT.add("createILFLSubdialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("createILSubdialog");
        FUNCTIONS_WITH_FI_SUPPORT.add("createOutOfRangeBins");
        FUNCTIONS_WITH_FI_SUPPORT.add("createXAxisTicks");
        FUNCTIONS_WITH_FI_SUPPORT.add("createXBarData");
        FUNCTIONS_WITH_FI_SUPPORT.add("ctranspose");
        FUNCTIONS_WITH_FI_SUPPORT.add("datamode");
        FUNCTIONS_WITH_FI_SUPPORT.add("datatypeChanged");
        FUNCTIONS_WITH_FI_SUPPORT.add("dec");
        FUNCTIONS_WITH_FI_SUPPORT.add("dec2fixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("dec2ufixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("denormalmax");
        FUNCTIONS_WITH_FI_SUPPORT.add("denormalmin");
        FUNCTIONS_WITH_FI_SUPPORT.add("diag");
        FUNCTIONS_WITH_FI_SUPPORT.add("disp");
        FUNCTIONS_WITH_FI_SUPPORT.add("divide");
        FUNCTIONS_WITH_FI_SUPPORT.add("double");
        FUNCTIONS_WITH_FI_SUPPORT.add("dynamicBar");
        FUNCTIONS_WITH_FI_SUPPORT.add("elementGetSetChecksAndSingleIndex");
        FUNCTIONS_WITH_FI_SUPPORT.add("emptyfirstobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("enableMouse");
        FUNCTIONS_WITH_FI_SUPPORT.add("end");
        FUNCTIONS_WITH_FI_SUPPORT.add("eps");
        FUNCTIONS_WITH_FI_SUPPORT.add("eq");
        FUNCTIONS_WITH_FI_SUPPORT.add("errmean");
        FUNCTIONS_WITH_FI_SUPPORT.add("errorbar");
        FUNCTIONS_WITH_FI_SUPPORT.add("errpdf");
        FUNCTIONS_WITH_FI_SUPPORT.add("errvar");
        FUNCTIONS_WITH_FI_SUPPORT.add("etreeplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("exponentbias");
        FUNCTIONS_WITH_FI_SUPPORT.add("exponentlength");
        FUNCTIONS_WITH_FI_SUPPORT.add("exponentmax");
        FUNCTIONS_WITH_FI_SUPPORT.add("exponentmin");
        FUNCTIONS_WITH_FI_SUPPORT.add("eye");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezcontour");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezcontourf");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezmesh");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezplot3");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezpolar");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezsurf");
        FUNCTIONS_WITH_FI_SUPPORT.add("ezsurfc");
        FUNCTIONS_WITH_FI_SUPPORT.add("false");
        FUNCTIONS_WITH_FI_SUPPORT.add("feather");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi2double");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi2doublecell");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi2sim");
        FUNCTIONS_WITH_FI_SUPPORT.add("fiLicenseCheckout");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi_matlab_style_round_helper");
        FUNCTIONS_WITH_FI_SUPPORT.add("fi_statop_trivial_cases_handler");
        FUNCTIONS_WITH_FI_SUPPORT.add("fifactory");
        FUNCTIONS_WITH_FI_SUPPORT.add("filter");
        FUNCTIONS_WITH_FI_SUPPORT.add("fimath");
        FUNCTIONS_WITH_FI_SUPPORT.add("fimath2use");
        FUNCTIONS_WITH_FI_SUPPORT.add("find");
        FUNCTIONS_WITH_FI_SUPPORT.add("findMinXTickSpacing");
        FUNCTIONS_WITH_FI_SUPPORT.add("fipref");
        FUNCTIONS_WITH_FI_SUPPORT.add("firstobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("fix");
        FUNCTIONS_WITH_FI_SUPPORT.add("flip");
        FUNCTIONS_WITH_FI_SUPPORT.add("flipdim");
        FUNCTIONS_WITH_FI_SUPPORT.add("fliplr");
        FUNCTIONS_WITH_FI_SUPPORT.add("flipud");
        FUNCTIONS_WITH_FI_SUPPORT.add("floor");
        FUNCTIONS_WITH_FI_SUPPORT.add("format");
        FUNCTIONS_WITH_FI_SUPPORT.add("fplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("fractionlength");
        FUNCTIONS_WITH_FI_SUPPORT.add("full");
        FUNCTIONS_WITH_FI_SUPPORT.add("ge");
        FUNCTIONS_WITH_FI_SUPPORT.add("get");
        FUNCTIONS_WITH_FI_SUPPORT.add("getBarData");
        FUNCTIONS_WITH_FI_SUPPORT.add("getBinsForData");
        FUNCTIONS_WITH_FI_SUPPORT.add("getElement");
        FUNCTIONS_WITH_FI_SUPPORT.add("getNumericTypeStrs");
        FUNCTIONS_WITH_FI_SUPPORT.add("getNumInputs");
        FUNCTIONS_WITH_FI_SUPPORT.add("getNumOutputs");
        FUNCTIONS_WITH_FI_SUPPORT.add("getSNR");
        FUNCTIONS_WITH_FI_SUPPORT.add("getSpecifiedSign");
        FUNCTIONS_WITH_FI_SUPPORT.add("getTotalOverflows");
        FUNCTIONS_WITH_FI_SUPPORT.add("getTotalUnderflows");
        FUNCTIONS_WITH_FI_SUPPORT.add("getUnderflowCounts");
        FUNCTIONS_WITH_FI_SUPPORT.add("getVisibleHandles");
        FUNCTIONS_WITH_FI_SUPPORT.add("getWordSize");
        FUNCTIONS_WITH_FI_SUPPORT.add("getlsb");
        FUNCTIONS_WITH_FI_SUPPORT.add("getmsb");
        FUNCTIONS_WITH_FI_SUPPORT.add("gplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("gt");
        FUNCTIONS_WITH_FI_SUPPORT.add("hankel");
        FUNCTIONS_WITH_FI_SUPPORT.add("hdlfimath");
        FUNCTIONS_WITH_FI_SUPPORT.add("hdlram");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2bin");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2dec");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2fixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2float");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2num");
        FUNCTIONS_WITH_FI_SUPPORT.add("hex2ufixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("hist");
        FUNCTIONS_WITH_FI_SUPPORT.add("histc");
        FUNCTIONS_WITH_FI_SUPPORT.add("histplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("holdXAxisLimits");
        FUNCTIONS_WITH_FI_SUPPORT.add("horzcat");
        FUNCTIONS_WITH_FI_SUPPORT.add("imag");
        FUNCTIONS_WITH_FI_SUPPORT.add("init");
        FUNCTIONS_WITH_FI_SUPPORT.add("initHistDisplay");
        FUNCTIONS_WITH_FI_SUPPORT.add("initMainGUIParts");
        FUNCTIONS_WITH_FI_SUPPORT.add("inspect");
        FUNCTIONS_WITH_FI_SUPPORT.add("installDefaultUserSettings");
        FUNCTIONS_WITH_FI_SUPPORT.add("int");
        FUNCTIONS_WITH_FI_SUPPORT.add("int16");
        FUNCTIONS_WITH_FI_SUPPORT.add("int2num");
        FUNCTIONS_WITH_FI_SUPPORT.add("int32");
        FUNCTIONS_WITH_FI_SUPPORT.add("int64");
        FUNCTIONS_WITH_FI_SUPPORT.add("int8");
        FUNCTIONS_WITH_FI_SUPPORT.add("intToCommaSepStr");
        FUNCTIONS_WITH_FI_SUPPORT.add("intmax");
        FUNCTIONS_WITH_FI_SUPPORT.add("intmin");
        FUNCTIONS_WITH_FI_SUPPORT.add("ipermute");
        FUNCTIONS_WITH_FI_SUPPORT.add("isHGHandleOfType");
        FUNCTIONS_WITH_FI_SUPPORT.add("isInputValueValid");
        FUNCTIONS_WITH_FI_SUPPORT.add("isboolean");
        FUNCTIONS_WITH_FI_SUPPORT.add("iscolumn");
        FUNCTIONS_WITH_FI_SUPPORT.add("isdouble");
        FUNCTIONS_WITH_FI_SUPPORT.add("isempty");
        FUNCTIONS_WITH_FI_SUPPORT.add("isequal");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfi");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfimath");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfimathlocal");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfinite");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfixed");
        FUNCTIONS_WITH_FI_SUPPORT.add("isfloat");
        FUNCTIONS_WITH_FI_SUPPORT.add("isinf");
        FUNCTIONS_WITH_FI_SUPPORT.add("isnan");
        FUNCTIONS_WITH_FI_SUPPORT.add("isnone");
        FUNCTIONS_WITH_FI_SUPPORT.add("isnumeric");
        FUNCTIONS_WITH_FI_SUPPORT.add("isnumerictype");
        FUNCTIONS_WITH_FI_SUPPORT.add("isobject");
        FUNCTIONS_WITH_FI_SUPPORT.add("ispropequal");
        FUNCTIONS_WITH_FI_SUPPORT.add("isreal");
        FUNCTIONS_WITH_FI_SUPPORT.add("isrow");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscalar");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscaleddouble");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscaledtype");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscalingbinarypoint");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscalingslopebias");
        FUNCTIONS_WITH_FI_SUPPORT.add("isscalingunspecified");
        FUNCTIONS_WITH_FI_SUPPORT.add("issigned");
        FUNCTIONS_WITH_FI_SUPPORT.add("issingle");
        FUNCTIONS_WITH_FI_SUPPORT.add("isslopebiasscaled");
        FUNCTIONS_WITH_FI_SUPPORT.add("issparse");
        FUNCTIONS_WITH_FI_SUPPORT.add("isvector");
        FUNCTIONS_WITH_FI_SUPPORT.add("le");
        FUNCTIONS_WITH_FI_SUPPORT.add("leftJustifyCellStrs");
        FUNCTIONS_WITH_FI_SUPPORT.add("length");
        FUNCTIONS_WITH_FI_SUPPORT.add("line");
        FUNCTIONS_WITH_FI_SUPPORT.add("loadBlankIcon");
        FUNCTIONS_WITH_FI_SUPPORT.add("loadWarnIcon");
        FUNCTIONS_WITH_FI_SUPPORT.add("loadobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("logical");
        FUNCTIONS_WITH_FI_SUPPORT.add("loglog");
        FUNCTIONS_WITH_FI_SUPPORT.add("logreport");
        FUNCTIONS_WITH_FI_SUPPORT.add("lowerbound");
        FUNCTIONS_WITH_FI_SUPPORT.add("lsb");
        FUNCTIONS_WITH_FI_SUPPORT.add("lt");
        FUNCTIONS_WITH_FI_SUPPORT.add("max");
        FUNCTIONS_WITH_FI_SUPPORT.add("maxlog");
        FUNCTIONS_WITH_FI_SUPPORT.add("mean");
        FUNCTIONS_WITH_FI_SUPPORT.add("median");
        FUNCTIONS_WITH_FI_SUPPORT.add("mesh");
        FUNCTIONS_WITH_FI_SUPPORT.add("meshc");
        FUNCTIONS_WITH_FI_SUPPORT.add("meshz");
        FUNCTIONS_WITH_FI_SUPPORT.add("min");
        FUNCTIONS_WITH_FI_SUPPORT.add("minlog");
        FUNCTIONS_WITH_FI_SUPPORT.add("minus");
        FUNCTIONS_WITH_FI_SUPPORT.add("mod");
        FUNCTIONS_WITH_FI_SUPPORT.add("mode");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseDown");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseDownLocal");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseDragThresholdLine");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseDragWordSizeLine");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseMove");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseMoveLocal");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseUp");
        FUNCTIONS_WITH_FI_SUPPORT.add("mouseUpLocal");
        FUNCTIONS_WITH_FI_SUPPORT.add("mpower");
        FUNCTIONS_WITH_FI_SUPPORT.add("mpy");
        FUNCTIONS_WITH_FI_SUPPORT.add("mrdivide");
        FUNCTIONS_WITH_FI_SUPPORT.add("mtimes");
        FUNCTIONS_WITH_FI_SUPPORT.add("nargin");
        FUNCTIONS_WITH_FI_SUPPORT.add("nargout");
        FUNCTIONS_WITH_FI_SUPPORT.add("ndgrid");
        FUNCTIONS_WITH_FI_SUPPORT.add("ndims");
        FUNCTIONS_WITH_FI_SUPPORT.add("ne");
        FUNCTIONS_WITH_FI_SUPPORT.add("nearest");
        FUNCTIONS_WITH_FI_SUPPORT.add("noperations");
        FUNCTIONS_WITH_FI_SUPPORT.add("not");
        FUNCTIONS_WITH_FI_SUPPORT.add("noverflows");
        FUNCTIONS_WITH_FI_SUPPORT.add("num2base");
        FUNCTIONS_WITH_FI_SUPPORT.add("num2bin");
        FUNCTIONS_WITH_FI_SUPPORT.add("num2hex");
        FUNCTIONS_WITH_FI_SUPPORT.add("num2int");
        FUNCTIONS_WITH_FI_SUPPORT.add("num2sdec");
        FUNCTIONS_WITH_FI_SUPPORT.add("numel");
        FUNCTIONS_WITH_FI_SUPPORT.add("numeric2bin");
        FUNCTIONS_WITH_FI_SUPPORT.add("numeric2hex");
        FUNCTIONS_WITH_FI_SUPPORT.add("numerictype");
        FUNCTIONS_WITH_FI_SUPPORT.add("nunderflows");
        FUNCTIONS_WITH_FI_SUPPORT.add("oct");
        FUNCTIONS_WITH_FI_SUPPORT.add("ones");
        FUNCTIONS_WITH_FI_SUPPORT.add("onesLike");
        FUNCTIONS_WITH_FI_SUPPORT.add("openvar");
        FUNCTIONS_WITH_FI_SUPPORT.add("or");
        FUNCTIONS_WITH_FI_SUPPORT.add("overflowmode");
        FUNCTIONS_WITH_FI_SUPPORT.add("overlayNegBarsIfUnsigned");
        FUNCTIONS_WITH_FI_SUPPORT.add("overlayPosBarsIfSigned");
        FUNCTIONS_WITH_FI_SUPPORT.add("patch");
        FUNCTIONS_WITH_FI_SUPPORT.add("pcolor");
        FUNCTIONS_WITH_FI_SUPPORT.add("performAutoBA");
        FUNCTIONS_WITH_FI_SUPPORT.add("performAutoBA_FLonly");
        FUNCTIONS_WITH_FI_SUPPORT.add("performAutoBA_ILonly");
        FUNCTIONS_WITH_FI_SUPPORT.add("performAutoBA_WLforFL");
        FUNCTIONS_WITH_FI_SUPPORT.add("performAutoBA_WLforIL");
        FUNCTIONS_WITH_FI_SUPPORT.add("permute");
        FUNCTIONS_WITH_FI_SUPPORT.add("pi");
        FUNCTIONS_WITH_FI_SUPPORT.add("plot");
        FUNCTIONS_WITH_FI_SUPPORT.add("plot3");
        FUNCTIONS_WITH_FI_SUPPORT.add("plotmatrix");
        FUNCTIONS_WITH_FI_SUPPORT.add("plotpassthrough");
        FUNCTIONS_WITH_FI_SUPPORT.add("plotyy");
        FUNCTIONS_WITH_FI_SUPPORT.add("plus");
        FUNCTIONS_WITH_FI_SUPPORT.add("polar");
        FUNCTIONS_WITH_FI_SUPPORT.add("pow2");
        FUNCTIONS_WITH_FI_SUPPORT.add("power");
        FUNCTIONS_WITH_FI_SUPPORT.add("qpointstr");
        FUNCTIONS_WITH_FI_SUPPORT.add("qr");
        FUNCTIONS_WITH_FI_SUPPORT.add("qreport");
        FUNCTIONS_WITH_FI_SUPPORT.add("quantize");
        FUNCTIONS_WITH_FI_SUPPORT.add("quantizeVector");
        FUNCTIONS_WITH_FI_SUPPORT.add("quiver");
        FUNCTIONS_WITH_FI_SUPPORT.add("quiver3");
        FUNCTIONS_WITH_FI_SUPPORT.add("randi");
        FUNCTIONS_WITH_FI_SUPPORT.add("randquant");
        FUNCTIONS_WITH_FI_SUPPORT.add("range");
        FUNCTIONS_WITH_FI_SUPPORT.add("rdivide");
        FUNCTIONS_WITH_FI_SUPPORT.add("real");
        FUNCTIONS_WITH_FI_SUPPORT.add("realmax");
        FUNCTIONS_WITH_FI_SUPPORT.add("realmin");
        FUNCTIONS_WITH_FI_SUPPORT.add("reinterpretcast");
        FUNCTIONS_WITH_FI_SUPPORT.add("removefimath");
        FUNCTIONS_WITH_FI_SUPPORT.add("repmat");
        FUNCTIONS_WITH_FI_SUPPORT.add("rescale");
        FUNCTIONS_WITH_FI_SUPPORT.add("reset");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetDataHist");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetHist");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetThresholds");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetgloballog");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetlog");
        FUNCTIONS_WITH_FI_SUPPORT.add("resetlogging");
        FUNCTIONS_WITH_FI_SUPPORT.add("reshape");
        FUNCTIONS_WITH_FI_SUPPORT.add("resizeBody");
        FUNCTIONS_WITH_FI_SUPPORT.add("resizeVisualForToolbarInstall");
        FUNCTIONS_WITH_FI_SUPPORT.add("resizeXRangeIndicators");
        FUNCTIONS_WITH_FI_SUPPORT.add("rgbplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("ribbon");
        FUNCTIONS_WITH_FI_SUPPORT.add("rose");
        FUNCTIONS_WITH_FI_SUPPORT.add("rot90");
        FUNCTIONS_WITH_FI_SUPPORT.add("round");
        FUNCTIONS_WITH_FI_SUPPORT.add("roundmode");
        FUNCTIONS_WITH_FI_SUPPORT.add("saveobj");
        FUNCTIONS_WITH_FI_SUPPORT.add("scatter");
        FUNCTIONS_WITH_FI_SUPPORT.add("scatter3");
        FUNCTIONS_WITH_FI_SUPPORT.add("schema");
        FUNCTIONS_WITH_FI_SUPPORT.add("sdec");
        FUNCTIONS_WITH_FI_SUPPORT.add("semilogx");
        FUNCTIONS_WITH_FI_SUPPORT.add("semilogy");
        FUNCTIONS_WITH_FI_SUPPORT.add("set");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAFLExtraBits");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAFLWidgets");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAILFLWidgets");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAILGuardBits");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAILWidgets");
        FUNCTIONS_WITH_FI_SUPPORT.add("setBAWidgets");
        FUNCTIONS_WITH_FI_SUPPORT.add("setElement");
        FUNCTIONS_WITH_FI_SUPPORT.add("setInteractiveMagnitudes");
        FUNCTIONS_WITH_FI_SUPPORT.add("setXAxisLimits");
        FUNCTIONS_WITH_FI_SUPPORT.add("setYAxisLimits");
        FUNCTIONS_WITH_FI_SUPPORT.add("setdefaultfimathfrompref");
        FUNCTIONS_WITH_FI_SUPPORT.add("setfimath");
        FUNCTIONS_WITH_FI_SUPPORT.add("shiftdata");
        FUNCTIONS_WITH_FI_SUPPORT.add("shiftdim");
        FUNCTIONS_WITH_FI_SUPPORT.add("showOutOfRangeBins");
        FUNCTIONS_WITH_FI_SUPPORT.add("sign");
        FUNCTIONS_WITH_FI_SUPPORT.add("sin");
        FUNCTIONS_WITH_FI_SUPPORT.add("single");
        FUNCTIONS_WITH_FI_SUPPORT.add("size");
        FUNCTIONS_WITH_FI_SUPPORT.add("slice");
        FUNCTIONS_WITH_FI_SUPPORT.add("sort");
        FUNCTIONS_WITH_FI_SUPPORT.add("sparse");
        FUNCTIONS_WITH_FI_SUPPORT.add("spy");
        FUNCTIONS_WITH_FI_SUPPORT.add("sqrt");
        FUNCTIONS_WITH_FI_SUPPORT.add("squeeze");
        FUNCTIONS_WITH_FI_SUPPORT.add("stairs");
        FUNCTIONS_WITH_FI_SUPPORT.add("stem");
        FUNCTIONS_WITH_FI_SUPPORT.add("stem3");
        FUNCTIONS_WITH_FI_SUPPORT.add("step");
        FUNCTIONS_WITH_FI_SUPPORT.add("storedInteger");
        FUNCTIONS_WITH_FI_SUPPORT.add("storedIntegerToDouble");
        FUNCTIONS_WITH_FI_SUPPORT.add("streamribbon");
        FUNCTIONS_WITH_FI_SUPPORT.add("streamslice");
        FUNCTIONS_WITH_FI_SUPPORT.add("streamtube");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringimag");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringreal");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringreshape");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringsize");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringsizem");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringsizen");
        FUNCTIONS_WITH_FI_SUPPORT.add("stringvectorize");
        FUNCTIONS_WITH_FI_SUPPORT.add("stripscaling");
        FUNCTIONS_WITH_FI_SUPPORT.add("struct");
        FUNCTIONS_WITH_FI_SUPPORT.add("sub");
        FUNCTIONS_WITH_FI_SUPPORT.add("subsasgn");
        FUNCTIONS_WITH_FI_SUPPORT.add("subsindex");
        FUNCTIONS_WITH_FI_SUPPORT.add("subsref");
        FUNCTIONS_WITH_FI_SUPPORT.add("sum");
        FUNCTIONS_WITH_FI_SUPPORT.add("surf");
        FUNCTIONS_WITH_FI_SUPPORT.add("surfc");
        FUNCTIONS_WITH_FI_SUPPORT.add("surfl");
        FUNCTIONS_WITH_FI_SUPPORT.add("surfnorm");
        FUNCTIONS_WITH_FI_SUPPORT.add("text");
        FUNCTIONS_WITH_FI_SUPPORT.add("times");
        FUNCTIONS_WITH_FI_SUPPORT.add("todouble");
        FUNCTIONS_WITH_FI_SUPPORT.add("todoublecell");
        FUNCTIONS_WITH_FI_SUPPORT.add("todoubles");
        FUNCTIONS_WITH_FI_SUPPORT.add("toeplitz");
        FUNCTIONS_WITH_FI_SUPPORT.add("tostring");
        FUNCTIONS_WITH_FI_SUPPORT.add("trace");
        FUNCTIONS_WITH_FI_SUPPORT.add("transpose");
        FUNCTIONS_WITH_FI_SUPPORT.add("treeplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("tril");
        FUNCTIONS_WITH_FI_SUPPORT.add("trimesh");
        FUNCTIONS_WITH_FI_SUPPORT.add("triplot");
        FUNCTIONS_WITH_FI_SUPPORT.add("trisurf");
        FUNCTIONS_WITH_FI_SUPPORT.add("triu");
        FUNCTIONS_WITH_FI_SUPPORT.add("true");
        FUNCTIONS_WITH_FI_SUPPORT.add("uint16");
        FUNCTIONS_WITH_FI_SUPPORT.add("uint32");
        FUNCTIONS_WITH_FI_SUPPORT.add("uint64");
        FUNCTIONS_WITH_FI_SUPPORT.add("uint8");
        FUNCTIONS_WITH_FI_SUPPORT.add("uminus");
        FUNCTIONS_WITH_FI_SUPPORT.add("unique");
        FUNCTIONS_WITH_FI_SUPPORT.add("unitquantize");
        FUNCTIONS_WITH_FI_SUPPORT.add("unshiftdata");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateBar");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateBarThreshColor");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXControls");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXHistReadouts");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXLinesYPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXState");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXTextAndLinesYPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateDTXTextYPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateFracTextAndXPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateHistBarPlot");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateHistData");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateIntTextAndXPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateInteractiveMagLinesAndReadouts");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateNumericTypesAndSigns");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateOverflowLineColor");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateOverflowTextAndXPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateRadixLineYExtent");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateSNRForNumericTypeChange");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateSignedStatus");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateSignedTextYPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateThresholdPosition");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateThresholds");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateUnderflowLineColor");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateUnderflowTextAndXPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateVisual");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateVisualFromHistogramLoggingData");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateWordTextAndXPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateXAxisTextPos");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateXTickLabels");
        FUNCTIONS_WITH_FI_SUPPORT.add("updateYAxisTitle");
        FUNCTIONS_WITH_FI_SUPPORT.add("uplus");
        FUNCTIONS_WITH_FI_SUPPORT.add("upperbound");
        FUNCTIONS_WITH_FI_SUPPORT.add("validOverflowXDrag");
        FUNCTIONS_WITH_FI_SUPPORT.add("validUnderflowXDrag");
        FUNCTIONS_WITH_FI_SUPPORT.add("validateInputsToStatFunctions");
        FUNCTIONS_WITH_FI_SUPPORT.add("validate_power_output_type");
        FUNCTIONS_WITH_FI_SUPPORT.add("varargin");
        FUNCTIONS_WITH_FI_SUPPORT.add("varargout");
        FUNCTIONS_WITH_FI_SUPPORT.add("varsize");
        FUNCTIONS_WITH_FI_SUPPORT.add("vertcat");
        FUNCTIONS_WITH_FI_SUPPORT.add("voronoi");
        FUNCTIONS_WITH_FI_SUPPORT.add("voronoin");
        FUNCTIONS_WITH_FI_SUPPORT.add("waterfall");
        FUNCTIONS_WITH_FI_SUPPORT.add("wheelMove");
        FUNCTIONS_WITH_FI_SUPPORT.add("wordlength");
        FUNCTIONS_WITH_FI_SUPPORT.add("xlim");
        FUNCTIONS_WITH_FI_SUPPORT.add("xor");
        FUNCTIONS_WITH_FI_SUPPORT.add("ylim");
        FUNCTIONS_WITH_FI_SUPPORT.add("zeros");
        FUNCTIONS_WITH_FI_SUPPORT.add("zerosLike");
        FUNCTIONS_WITH_FI_SUPPORT.add("zlim");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ArrayVectorAdder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.BiquadFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.FIRFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.FIRRateConverter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.LowerTriangularSolver");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.UpperTriangularSolver");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.AllpoleFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ArrayVectorDivider");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ArrayVectorMultiplier");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ArrayVectorSubtractor");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Autocorrelator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Buffer");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.CICDecimator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.CICInterpolator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Convolver");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Counter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Crosscorrelator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.CumulativeProduct");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.CumulativeSum");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.DCBlocker");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Delay");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.DCT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.DigitalDownConverter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.DigitalFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.DigitalUpConverter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.FFT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.FIRDecimator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.FIRInterpolator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Histogram");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.IDCT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.IFFT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.IIRFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.LDLFactor");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.LMSFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.LUFactor");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.LevinsonSolver");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Maximum");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Mean");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Median");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Minimum");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.NCO");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Normalizer");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.PeakFinder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ScalarQuantizerDecoder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.ScalarQuantizerEncoder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.SignalSink");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.SignalSource");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.SineWave");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.SubbandAnalysisFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.SubbandSynthesisFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.TimeScope");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.VariableFractionalDelay");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Variance");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.VectorQuantizerDecoder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.VectorQuantizerEncoder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("dsp.Window");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("hdl.RAM");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("hdl.BlackBox");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.AlphaBlender");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Autocorrelator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Autothresholder");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.BlobAnalysis");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.BlockMatcher");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.ContrastAdjuster");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Convolver");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.CornerDetector");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Crosscorrelator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.DCT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Deinterlacer");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.DemosaicInterpolator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.EdgeDetector");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.FFT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.GeometricRotator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.GeometricScaler");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.GeometricTranslator");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Histogram");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.HoughLines");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.HoughTransform");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.IDCT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.IFFT");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.ImageDataTypeConverter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.ImageFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.MarkerInserter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Maximum");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Mean");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Median");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.MedianFilter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Minimum");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.OpticalFlow");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.PSNR");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Pyramid");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.SAD");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.ShapeInserter");
        SYSTEM_OBJECTS_WITH_FI_SUPPORT.add("vision.Variance");
        SYSTEM_OBJECT_CLASSES.add("Simulink.IntEnumType");
        SYSTEM_OBJECT_CLASSES.add("SlvnvTag.TaggingMode");
        SYSTEM_OBJECT_CLASSES.add("comm.ACPR");
        SYSTEM_OBJECT_CLASSES.add("comm.AGC");
        SYSTEM_OBJECT_CLASSES.add("comm.APPDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.AWGNChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.AlgebraicDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.AlgebraicInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.BCHDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.BCHEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.BPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.BPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.BarkerCode");
        SYSTEM_OBJECT_CLASSES.add("comm.BinarySymmetricChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.BitToInteger");
        SYSTEM_OBJECT_CLASSES.add("comm.BlockDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.BlockInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.CCDF");
        SYSTEM_OBJECT_CLASSES.add("comm.CPFSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.CPFSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.CPMCarrierPhaseSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.CPMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.CPMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.CRCDetector");
        SYSTEM_OBJECT_CLASSES.add("comm.CRCGenerator");
        SYSTEM_OBJECT_CLASSES.add("comm.ConstellationDiagram");
        SYSTEM_OBJECT_CLASSES.add("comm.ConvolutionalDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.ConvolutionalEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.ConvolutionalInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.DBPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.DBPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.DPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.DPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.DQPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.DQPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.Descrambler");
        SYSTEM_OBJECT_CLASSES.add("comm.DifferentialDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.DifferentialEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.DiscreteTimeVCO");
        SYSTEM_OBJECT_CLASSES.add("comm.EVM");
        SYSTEM_OBJECT_CLASSES.add("comm.EarlyLateGateTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.ErrorRate");
        SYSTEM_OBJECT_CLASSES.add("comm.FSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.FSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GMSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GMSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GMSKTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.GardnerTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.GeneralQAMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GeneralQAMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GeneralQAMTCMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GeneralQAMTCMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.GoldSequence");
        SYSTEM_OBJECT_CLASSES.add("comm.HDLCRCDetector");
        SYSTEM_OBJECT_CLASSES.add("comm.HDLCRCGenerator");
        SYSTEM_OBJECT_CLASSES.add("comm.HDLRSDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.HDLRSEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.HadamardCode");
        SYSTEM_OBJECT_CLASSES.add("comm.HelicalDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.HelicalInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.IntegerToBit");
        SYSTEM_OBJECT_CLASSES.add("comm.IntegrateAndDumpFilter");
        SYSTEM_OBJECT_CLASSES.add("comm.KasamiSequence");
        SYSTEM_OBJECT_CLASSES.add("comm.LDPCDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.LDPCEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.LTEMIMOChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.MER");
        SYSTEM_OBJECT_CLASSES.add("comm.MIMOChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.MLSEEqualizer");
        SYSTEM_OBJECT_CLASSES.add("comm.MSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.MSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.MSKTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.MatrixDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.MatrixHelicalScanDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.MatrixHelicalScanInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.MatrixInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.MemorylessNonlinearity");
        SYSTEM_OBJECT_CLASSES.add("comm.MuellerMullerTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.MultiplexedDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.MultiplexedInterleaver");
        SYSTEM_OBJECT_CLASSES.add("comm.OQPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.OQPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.OSTBCCombiner");
        SYSTEM_OBJECT_CLASSES.add("comm.OSTBCEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.OVSFCode");
        SYSTEM_OBJECT_CLASSES.add("comm.PAMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PAMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PNSequence");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKCarrierPhaseSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKCoarseFrequencyEstimator");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKTCMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PSKTCMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.PhaseFrequencyOffset");
        SYSTEM_OBJECT_CLASSES.add("comm.PhaseNoise");
        SYSTEM_OBJECT_CLASSES.add("comm.QAMCoarseFrequencyEstimator");
        SYSTEM_OBJECT_CLASSES.add("comm.QPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.QPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.RSDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.RSEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.RaisedCosineReceiveFilter");
        SYSTEM_OBJECT_CLASSES.add("comm.RaisedCosineTransmitFilter");
        SYSTEM_OBJECT_CLASSES.add("comm.RayleighChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.RectangularQAMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.RectangularQAMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.RectangularQAMTCMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("comm.RectangularQAMTCMModulator");
        SYSTEM_OBJECT_CLASSES.add("comm.RicianChannel");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRADIFMCOMMSReceiver");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRADIFMCOMMSReceiverRefDes");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRADIFMCOMMSTransmitter");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRADIFMCOMMSTransmitterRefDes");
        SYSTEM_OBJECT_CLASSES.add("comm.SDREpiqBitsharkReceiver");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRuReceiver");
        SYSTEM_OBJECT_CLASSES.add("comm.SDRuTransmitter");
        SYSTEM_OBJECT_CLASSES.add("comm.Scrambler");
        SYSTEM_OBJECT_CLASSES.add("comm.SphereDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.ThermalNoise");
        SYSTEM_OBJECT_CLASSES.add("comm.TurboDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.TurboEncoder");
        SYSTEM_OBJECT_CLASSES.add("comm.ViterbiDecoder");
        SYSTEM_OBJECT_CLASSES.add("comm.WalshCode");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.AlgebraicDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.AlgebraicInterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BCHDecoder");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BCHEncoder");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BlockDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.BlockInterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CPFSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CPFSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CPMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CPMModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CRCDetector");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.CRCGenerator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.ConvolutionalDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.ConvolutionalInterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DBPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DBPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DQPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.DQPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.Descrambler");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.EVM");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.EarlyLateGateTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.ErrorRate");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.FSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.FSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.GMSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.GMSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.GMSKTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.GardnerTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.IntegrateAndDumpFilter");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.KasamiSequence");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MER");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MLSEEqualizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MSKTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MatrixHelicalScanDeinterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MatrixHelicalScanInterleaver");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.MuellerMullerTimingSynchronizer");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.OQPSKDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.OQPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.PAMModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.PSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.PSKTCMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.PhaseFrequencyOffset");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.QPSKModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.RectangularQAMModulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.RectangularQAMTCMDemodulator");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.Scrambler");
        SYSTEM_OBJECT_CLASSES.add("commcodegen.ViterbiDecoder");
        SYSTEM_OBJECT_CLASSES.add("cvmetric.Sldv");
        SYSTEM_OBJECT_CLASSES.add("cvmetric.Structural");
        SYSTEM_OBJECT_CLASSES.add("distributedutil.DmatFileMode");
        SYSTEM_OBJECT_CLASSES.add("dsp.AdaptiveLatticeFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.AffineProjectionFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.AllpassFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.AllpoleFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.AnalyticSignal");
        SYSTEM_OBJECT_CLASSES.add("dsp.ArrayPlot");
        SYSTEM_OBJECT_CLASSES.add("dsp.ArrayVectorAdder");
        SYSTEM_OBJECT_CLASSES.add("dsp.ArrayVectorDivider");
        SYSTEM_OBJECT_CLASSES.add("dsp.ArrayVectorMultiplier");
        SYSTEM_OBJECT_CLASSES.add("dsp.ArrayVectorSubtractor");
        SYSTEM_OBJECT_CLASSES.add("dsp.AudioFileReader");
        SYSTEM_OBJECT_CLASSES.add("dsp.AudioFileWriter");
        SYSTEM_OBJECT_CLASSES.add("dsp.AudioPlayer");
        SYSTEM_OBJECT_CLASSES.add("dsp.AudioRecorder");
        SYSTEM_OBJECT_CLASSES.add("dsp.Autocorrelator");
        SYSTEM_OBJECT_CLASSES.add("dsp.BiquadFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.BlockLMSFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.Buffer");
        SYSTEM_OBJECT_CLASSES.add("dsp.BurgAREstimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.BurgSpectrumEstimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.CICDecimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.CICInterpolator");
        SYSTEM_OBJECT_CLASSES.add("dsp.CepstralToLPC");
        SYSTEM_OBJECT_CLASSES.add("dsp.Chirp");
        SYSTEM_OBJECT_CLASSES.add("dsp.Convolver");
        SYSTEM_OBJECT_CLASSES.add("dsp.Counter");
        SYSTEM_OBJECT_CLASSES.add("dsp.CoupledAllpassFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.CrossSpectrumEstimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.Crosscorrelator");
        SYSTEM_OBJECT_CLASSES.add("dsp.CumulativeProduct");
        SYSTEM_OBJECT_CLASSES.add("dsp.CumulativeSum");
        SYSTEM_OBJECT_CLASSES.add("dsp.DCBlocker");
        SYSTEM_OBJECT_CLASSES.add("dsp.DCT");
        SYSTEM_OBJECT_CLASSES.add("dsp.Delay");
        SYSTEM_OBJECT_CLASSES.add("dsp.DelayLine");
        SYSTEM_OBJECT_CLASSES.add("dsp.DigitalDownConverter");
        SYSTEM_OBJECT_CLASSES.add("dsp.DigitalFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.DigitalUpConverter");
        SYSTEM_OBJECT_CLASSES.add("dsp.DyadicAnalysisFilterBank");
        SYSTEM_OBJECT_CLASSES.add("dsp.DyadicSynthesisFilterBank");
        SYSTEM_OBJECT_CLASSES.add("dsp.FFT");
        SYSTEM_OBJECT_CLASSES.add("dsp.FIRDecimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.FIRFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.FIRInterpolator");
        SYSTEM_OBJECT_CLASSES.add("dsp.FIRRateConverter");
        SYSTEM_OBJECT_CLASSES.add("dsp.FastTransversalFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.FilteredXLMSFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.FrequencyDomainAdaptiveFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.HDLFFT");
        SYSTEM_OBJECT_CLASSES.add("dsp.HDLIFFT");
        SYSTEM_OBJECT_CLASSES.add("dsp.HDLNCO");
        SYSTEM_OBJECT_CLASSES.add("dsp.Histogram");
        SYSTEM_OBJECT_CLASSES.add("dsp.IDCT");
        SYSTEM_OBJECT_CLASSES.add("dsp.IFFT");
        SYSTEM_OBJECT_CLASSES.add("dsp.IIRFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.Interpolator");
        SYSTEM_OBJECT_CLASSES.add("dsp.KalmanFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.LDLFactor");
        SYSTEM_OBJECT_CLASSES.add("dsp.LMSFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.LPCToAutocorrelation");
        SYSTEM_OBJECT_CLASSES.add("dsp.LPCToCepstral");
        SYSTEM_OBJECT_CLASSES.add("dsp.LPCToLSF");
        SYSTEM_OBJECT_CLASSES.add("dsp.LPCToLSP");
        SYSTEM_OBJECT_CLASSES.add("dsp.LPCToRC");
        SYSTEM_OBJECT_CLASSES.add("dsp.LSFToLPC");
        SYSTEM_OBJECT_CLASSES.add("dsp.LSPToLPC");
        SYSTEM_OBJECT_CLASSES.add("dsp.LUFactor");
        SYSTEM_OBJECT_CLASSES.add("dsp.LevinsonSolver");
        SYSTEM_OBJECT_CLASSES.add("dsp.LogicAnalyzer");
        SYSTEM_OBJECT_CLASSES.add("dsp.LowerTriangularSolver");
        SYSTEM_OBJECT_CLASSES.add("dsp.MatFileReader");
        SYSTEM_OBJECT_CLASSES.add("dsp.MatFileWriter");
        SYSTEM_OBJECT_CLASSES.add("dsp.Maximum");
        SYSTEM_OBJECT_CLASSES.add("dsp.Mean");
        SYSTEM_OBJECT_CLASSES.add("dsp.Median");
        SYSTEM_OBJECT_CLASSES.add("dsp.Minimum");
        SYSTEM_OBJECT_CLASSES.add("dsp.NCO");
        SYSTEM_OBJECT_CLASSES.add("dsp.Normalizer");
        SYSTEM_OBJECT_CLASSES.add("dsp.PeakFinder");
        SYSTEM_OBJECT_CLASSES.add("dsp.PeakToPeak");
        SYSTEM_OBJECT_CLASSES.add("dsp.PeakToRMS");
        SYSTEM_OBJECT_CLASSES.add("dsp.PhaseUnwrapper");
        SYSTEM_OBJECT_CLASSES.add("dsp.PulseMetrics");
        SYSTEM_OBJECT_CLASSES.add("dsp.RCToAutocorrelation");
        SYSTEM_OBJECT_CLASSES.add("dsp.RCToLPC");
        SYSTEM_OBJECT_CLASSES.add("dsp.RLSFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.RMS");
        SYSTEM_OBJECT_CLASSES.add("dsp.ScalarQuantizerDecoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.ScalarQuantizerEncoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.SignalLogger");
        SYSTEM_OBJECT_CLASSES.add("dsp.SignalReader");
        SYSTEM_OBJECT_CLASSES.add("dsp.SignalSink");
        SYSTEM_OBJECT_CLASSES.add("dsp.SignalSource");
        SYSTEM_OBJECT_CLASSES.add("dsp.SineWave");
        SYSTEM_OBJECT_CLASSES.add("dsp.SpectrumAnalyzer");
        SYSTEM_OBJECT_CLASSES.add("dsp.SpectrumEstimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.StandardDeviation");
        SYSTEM_OBJECT_CLASSES.add("dsp.StateLevels");
        SYSTEM_OBJECT_CLASSES.add("dsp.SubbandAnalysisFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.SubbandSynthesisFilter");
        SYSTEM_OBJECT_CLASSES.add("dsp.TimeScope");
        SYSTEM_OBJECT_CLASSES.add("dsp.TransferFunctionEstimator");
        SYSTEM_OBJECT_CLASSES.add("dsp.TransitionMetrics");
        SYSTEM_OBJECT_CLASSES.add("dsp.UDPReceiver");
        SYSTEM_OBJECT_CLASSES.add("dsp.UDPSender");
        SYSTEM_OBJECT_CLASSES.add("dsp.UniformDecoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.UniformEncoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.UpperTriangularSolver");
        SYSTEM_OBJECT_CLASSES.add("dsp.VariableFractionalDelay");
        SYSTEM_OBJECT_CLASSES.add("dsp.VariableIntegerDelay");
        SYSTEM_OBJECT_CLASSES.add("dsp.Variance");
        SYSTEM_OBJECT_CLASSES.add("dsp.VectorQuantizerDecoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.VectorQuantizerEncoder");
        SYSTEM_OBJECT_CLASSES.add("dsp.Window");
        SYSTEM_OBJECT_CLASSES.add("dsp.ZeroCrossingDetector");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.AllpoleFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ArrayVectorAdder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ArrayVectorDivider");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ArrayVectorMultiplier");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.AudioFileWriter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Autocorrelator");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.BiquadFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.BlockLMSFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Buffer");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.CepstralToLPC");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Chirp");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Counter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Crosscorrelator");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.CumulativeProduct");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.DCT");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.DyadicAnalysisFilterBank");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.DyadicSynthesisFilterBank");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.FIRDecimator");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.FIRFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.FIRInterpolator");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.FIRRateConverter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Histogram");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.IDCT");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.IIRFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Interpolator");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LDLFactor");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LMSFilter");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LPCToAutocorrelation");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LPCToCepstral");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LPCToLSF");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LPCToLSP");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LPCToRC");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LUFactor");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LevinsonSolver");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.LowerTriangularSolver");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.NCO");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Normalizer");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.PeakFinder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.PhaseUnwrapper");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.RCToAutocorrelation");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.RCToLPC");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.RMS");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ScalarQuantizerDecoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ScalarQuantizerEncoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.SineWave");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.UniformDecoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.UniformEncoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.UpperTriangularSolver");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.VariableIntegerDelay");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.VectorQuantizerDecoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.VectorQuantizerEncoder");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.Window");
        SYSTEM_OBJECT_CLASSES.add("dspcodegen.ZeroCrossingDetector");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.BandlimitedNoiseGenerator");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.DesaTwo");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.FileWriter");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.NoiseFilter");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.NoiseGenerator");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.NotchPeakFilter");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.ParameterTimeTable");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.ParametricEQFilter");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.RMSNormalizer");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.RandomFMToneGenerator");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.TeagerKaiserEnergyOperator");
        SYSTEM_OBJECT_CLASSES.add("dspdemo.TunableFIRFilter");
        SYSTEM_OBJECT_CLASSES.add("embedded.NumericTypeScope");
        SYSTEM_OBJECT_CLASSES.add("fixed.Quantizer");
        SYSTEM_OBJECT_CLASSES.add("hdl.BlackBox");
        SYSTEM_OBJECT_CLASSES.add("hdlverifier.Delay");
        SYSTEM_OBJECT_CLASSES.add("hdlverifier.FILSimulation");
        SYSTEM_OBJECT_CLASSES.add("hdlverifier.HDLCosimulation");
        SYSTEM_OBJECT_CLASSES.add("imaq.VideoDevice");
        SYSTEM_OBJECT_CLASSES.add("matlab.System");
        SYSTEM_OBJECT_CLASSES.add("matlabcoderguitest.OutputTypes");
        SYSTEM_OBJECT_CLASSES.add("matlabcoderguitest.ProjectTabs");
        SYSTEM_OBJECT_CLASSES.add("matlabcoderguitest.SettingsTabs");
        SYSTEM_OBJECT_CLASSES.add("pe.Connection");
        SYSTEM_OBJECT_CLASSES.add("phased.ADPCACanceller");
        SYSTEM_OBJECT_CLASSES.add("phased.AngleDopplerResponse");
        SYSTEM_OBJECT_CLASSES.add("phased.ArrayGain");
        SYSTEM_OBJECT_CLASSES.add("phased.ArrayResponse");
        SYSTEM_OBJECT_CLASSES.add("phased.BarrageJammer");
        SYSTEM_OBJECT_CLASSES.add("phased.BeamscanEstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.BeamscanEstimator2D");
        SYSTEM_OBJECT_CLASSES.add("phased.BeamspaceESPRITEstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.CFARDetector");
        SYSTEM_OBJECT_CLASSES.add("phased.Collector");
        SYSTEM_OBJECT_CLASSES.add("phased.ConformalArray");
        SYSTEM_OBJECT_CLASSES.add("phased.ConstantGammaClutter");
        SYSTEM_OBJECT_CLASSES.add("phased.CosineAntennaElement");
        SYSTEM_OBJECT_CLASSES.add("phased.CrossedDipoleAntennaElement");
        SYSTEM_OBJECT_CLASSES.add("phased.CustomAntennaElement");
        SYSTEM_OBJECT_CLASSES.add("phased.CustomMicrophoneElement");
        SYSTEM_OBJECT_CLASSES.add("phased.DPCACanceller");
        SYSTEM_OBJECT_CLASSES.add("phased.ESPRITEstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.ElementDelay");
        SYSTEM_OBJECT_CLASSES.add("phased.FMCWWaveform");
        SYSTEM_OBJECT_CLASSES.add("phased.FreeSpace");
        SYSTEM_OBJECT_CLASSES.add("phased.FrostBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.HeterogeneousConformalArray");
        SYSTEM_OBJECT_CLASSES.add("phased.HeterogeneousULA");
        SYSTEM_OBJECT_CLASSES.add("phased.HeterogeneousURA");
        SYSTEM_OBJECT_CLASSES.add("phased.IsotropicAntennaElement");
        SYSTEM_OBJECT_CLASSES.add("phased.LCMVBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.LinearFMWaveform");
        SYSTEM_OBJECT_CLASSES.add("phased.MVDRBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.MVDREstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.MVDREstimator2D");
        SYSTEM_OBJECT_CLASSES.add("phased.MatchedFilter");
        SYSTEM_OBJECT_CLASSES.add("phased.OmnidirectionalMicrophoneElement");
        SYSTEM_OBJECT_CLASSES.add("phased.PartitionedArray");
        SYSTEM_OBJECT_CLASSES.add("phased.PhaseCodedWaveform");
        SYSTEM_OBJECT_CLASSES.add("phased.PhaseShiftBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.Platform");
        SYSTEM_OBJECT_CLASSES.add("phased.RadarTarget");
        SYSTEM_OBJECT_CLASSES.add("phased.Radiator");
        SYSTEM_OBJECT_CLASSES.add("phased.RangeDopplerResponse");
        SYSTEM_OBJECT_CLASSES.add("phased.ReceiverPreamp");
        SYSTEM_OBJECT_CLASSES.add("phased.RectangularWaveform");
        SYSTEM_OBJECT_CLASSES.add("phased.ReplicatedSubarray");
        SYSTEM_OBJECT_CLASSES.add("phased.RootMUSICEstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.RootWSFEstimator");
        SYSTEM_OBJECT_CLASSES.add("phased.STAPSMIBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.ShortDipoleAntennaElement");
        SYSTEM_OBJECT_CLASSES.add("phased.SteeringVector");
        SYSTEM_OBJECT_CLASSES.add("phased.SteppedFMWaveform");
        SYSTEM_OBJECT_CLASSES.add("phased.StretchProcessor");
        SYSTEM_OBJECT_CLASSES.add("phased.SubbandPhaseShiftBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.SumDifferenceMonopulseTracker");
        SYSTEM_OBJECT_CLASSES.add("phased.SumDifferenceMonopulseTracker2D");
        SYSTEM_OBJECT_CLASSES.add("phased.TimeDelayBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.TimeDelayLCMVBeamformer");
        SYSTEM_OBJECT_CLASSES.add("phased.TimeVaryingGain");
        SYSTEM_OBJECT_CLASSES.add("phased.Transmitter");
        SYSTEM_OBJECT_CLASSES.add("phased.ULA");
        SYSTEM_OBJECT_CLASSES.add("phased.URA");
        SYSTEM_OBJECT_CLASSES.add("phased.WidebandCollector");
        SYSTEM_OBJECT_CLASSES.add("scopeextensions.AbstractSystemObjectScope");
        SYSTEM_OBJECT_CLASSES.add("seaharness.SignalSource");
        SYSTEM_OBJECT_CLASSES.add("seaharness.seaharnesspref");
        SYSTEM_OBJECT_CLASSES.add("simscape.DependencyType");
        SYSTEM_OBJECT_CLASSES.add("spcharness.seasimstate");
        SYSTEM_OBJECT_CLASSES.add("spcharness.spcsimstate");
        SYSTEM_OBJECT_CLASSES.add("sysobjharness.SignalSource");
        SYSTEM_OBJECT_CLASSES.add("sysobjharness.sysobjharnesspref");
        SYSTEM_OBJECT_CLASSES.add("tic6000.UARTReceive");
        SYSTEM_OBJECT_CLASSES.add("tic6000.UARTSetup");
        SYSTEM_OBJECT_CLASSES.add("tic6000.UARTTransmit");
        SYSTEM_OBJECT_CLASSES.add("video.AlphaBlender");
        SYSTEM_OBJECT_CLASSES.add("video.Autocorrelator2D");
        SYSTEM_OBJECT_CLASSES.add("video.Autothresholder");
        SYSTEM_OBJECT_CLASSES.add("video.BinaryFileReader");
        SYSTEM_OBJECT_CLASSES.add("video.BinaryFileWriter");
        SYSTEM_OBJECT_CLASSES.add("video.BlobAnalysis");
        SYSTEM_OBJECT_CLASSES.add("video.BlockMatcher");
        SYSTEM_OBJECT_CLASSES.add("video.BoundaryTracer");
        SYSTEM_OBJECT_CLASSES.add("video.ChromaResampler");
        SYSTEM_OBJECT_CLASSES.add("video.ColorSpaceConverter");
        SYSTEM_OBJECT_CLASSES.add("video.ConnectedComponentLabeler");
        SYSTEM_OBJECT_CLASSES.add("video.ContrastAdjuster");
        SYSTEM_OBJECT_CLASSES.add("video.Convolver2D");
        SYSTEM_OBJECT_CLASSES.add("video.CornerDetector");
        SYSTEM_OBJECT_CLASSES.add("video.Crosscorrelator2D");
        SYSTEM_OBJECT_CLASSES.add("video.DCT2D");
        SYSTEM_OBJECT_CLASSES.add("video.Deinterlacer");
        SYSTEM_OBJECT_CLASSES.add("video.DemosaicInterpolator");
        SYSTEM_OBJECT_CLASSES.add("video.DeployableVideoPlayer");
        SYSTEM_OBJECT_CLASSES.add("video.EdgeDetector");
        SYSTEM_OBJECT_CLASSES.add("video.FFT2D");
        SYSTEM_OBJECT_CLASSES.add("video.GammaCorrector");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricRotator");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricScaler");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricShearer");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricTransformEstimator");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricTransformer");
        SYSTEM_OBJECT_CLASSES.add("video.GeometricTranslator");
        SYSTEM_OBJECT_CLASSES.add("video.HDL2DFIRFilter");
        SYSTEM_OBJECT_CLASSES.add("video.HDLDeserializer");
        SYSTEM_OBJECT_CLASSES.add("video.HDLMedianFilter");
        SYSTEM_OBJECT_CLASSES.add("video.HDLSerializer");
        SYSTEM_OBJECT_CLASSES.add("video.HDLTimingGenerator");
        SYSTEM_OBJECT_CLASSES.add("video.Histogram");
        SYSTEM_OBJECT_CLASSES.add("video.Histogram2D");
        SYSTEM_OBJECT_CLASSES.add("video.HistogramEqualizer");
        SYSTEM_OBJECT_CLASSES.add("video.HoughLines");
        SYSTEM_OBJECT_CLASSES.add("video.HoughTransform");
        SYSTEM_OBJECT_CLASSES.add("video.IDCT2D");
        SYSTEM_OBJECT_CLASSES.add("video.IFFT2D");
        SYSTEM_OBJECT_CLASSES.add("video.ImageComplementer");
        SYSTEM_OBJECT_CLASSES.add("video.ImageDataTypeConverter");
        SYSTEM_OBJECT_CLASSES.add("video.ImageFilter");
        SYSTEM_OBJECT_CLASSES.add("video.ImagePadder");
        SYSTEM_OBJECT_CLASSES.add("video.LocalMaximaFinder");
        SYSTEM_OBJECT_CLASSES.add("video.MarkerInserter");
        SYSTEM_OBJECT_CLASSES.add("video.Maximum");
        SYSTEM_OBJECT_CLASSES.add("video.Mean");
        SYSTEM_OBJECT_CLASSES.add("video.Median");
        SYSTEM_OBJECT_CLASSES.add("video.MedianFilter2D");
        SYSTEM_OBJECT_CLASSES.add("video.Minimum");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalBottomHat");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalClose");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalDilate");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalErode");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalOpen");
        SYSTEM_OBJECT_CLASSES.add("video.MorphologicalTopHat");
        SYSTEM_OBJECT_CLASSES.add("video.MultimediaFileReader");
        SYSTEM_OBJECT_CLASSES.add("video.MultimediaFileWriter");
        SYSTEM_OBJECT_CLASSES.add("video.OpticalFlow");
        SYSTEM_OBJECT_CLASSES.add("video.PSNR");
        SYSTEM_OBJECT_CLASSES.add("video.Pyramid");
        SYSTEM_OBJECT_CLASSES.add("video.ShapeInserter");
        SYSTEM_OBJECT_CLASSES.add("video.StandardDeviation");
        SYSTEM_OBJECT_CLASSES.add("video.TemplateMatcher");
        SYSTEM_OBJECT_CLASSES.add("video.TextInserter");
        SYSTEM_OBJECT_CLASSES.add("video.Variance");
        SYSTEM_OBJECT_CLASSES.add("video.VideoPlayer");
        SYSTEM_OBJECT_CLASSES.add("vision.AlphaBlender");
        SYSTEM_OBJECT_CLASSES.add("vision.Autocorrelator");
        SYSTEM_OBJECT_CLASSES.add("vision.Autothresholder");
        SYSTEM_OBJECT_CLASSES.add("vision.BinaryFileReader");
        SYSTEM_OBJECT_CLASSES.add("vision.BinaryFileWriter");
        SYSTEM_OBJECT_CLASSES.add("vision.BlobAnalysis");
        SYSTEM_OBJECT_CLASSES.add("vision.BlockMatcher");
        SYSTEM_OBJECT_CLASSES.add("vision.BoundaryTracer");
        SYSTEM_OBJECT_CLASSES.add("vision.CascadeObjectDetector");
        SYSTEM_OBJECT_CLASSES.add("vision.ChromaResampler");
        SYSTEM_OBJECT_CLASSES.add("vision.ColorSpaceConverter");
        SYSTEM_OBJECT_CLASSES.add("vision.ConnectedComponentLabeler");
        SYSTEM_OBJECT_CLASSES.add("vision.ContrastAdjuster");
        SYSTEM_OBJECT_CLASSES.add("vision.Convolver");
        SYSTEM_OBJECT_CLASSES.add("vision.CornerDetector");
        SYSTEM_OBJECT_CLASSES.add("vision.Crosscorrelator");
        SYSTEM_OBJECT_CLASSES.add("vision.DCT");
        SYSTEM_OBJECT_CLASSES.add("vision.Deinterlacer");
        SYSTEM_OBJECT_CLASSES.add("vision.DemosaicInterpolator");
        SYSTEM_OBJECT_CLASSES.add("vision.DeployableVideoPlayer");
        SYSTEM_OBJECT_CLASSES.add("vision.EdgeDetector");
        SYSTEM_OBJECT_CLASSES.add("vision.FFT");
        SYSTEM_OBJECT_CLASSES.add("vision.ForegroundDetector");
        SYSTEM_OBJECT_CLASSES.add("vision.GammaCorrector");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricRotator");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricScaler");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricShearer");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricTransformEstimator");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricTransformer");
        SYSTEM_OBJECT_CLASSES.add("vision.GeometricTranslator");
        SYSTEM_OBJECT_CLASSES.add("vision.Histogram");
        SYSTEM_OBJECT_CLASSES.add("vision.HistogramBasedTracker");
        SYSTEM_OBJECT_CLASSES.add("vision.HistogramEqualizer");
        SYSTEM_OBJECT_CLASSES.add("vision.HoughLines");
        SYSTEM_OBJECT_CLASSES.add("vision.HoughTransform");
        SYSTEM_OBJECT_CLASSES.add("vision.IDCT");
        SYSTEM_OBJECT_CLASSES.add("vision.IFFT");
        SYSTEM_OBJECT_CLASSES.add("vision.ImageComplementer");
        SYSTEM_OBJECT_CLASSES.add("vision.ImageDataTypeConverter");
        SYSTEM_OBJECT_CLASSES.add("vision.ImageFilter");
        SYSTEM_OBJECT_CLASSES.add("vision.ImagePadder");
        SYSTEM_OBJECT_CLASSES.add("vision.LocalMaximaFinder");
        SYSTEM_OBJECT_CLASSES.add("vision.MarkerInserter");
        SYSTEM_OBJECT_CLASSES.add("vision.Maximum");
        SYSTEM_OBJECT_CLASSES.add("vision.Mean");
        SYSTEM_OBJECT_CLASSES.add("vision.Median");
        SYSTEM_OBJECT_CLASSES.add("vision.MedianFilter");
        SYSTEM_OBJECT_CLASSES.add("vision.Minimum");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalBottomHat");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalClose");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalDilate");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalErode");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalOpen");
        SYSTEM_OBJECT_CLASSES.add("vision.MorphologicalTopHat");
        SYSTEM_OBJECT_CLASSES.add("vision.OpticalFlow");
        SYSTEM_OBJECT_CLASSES.add("vision.PSNR");
        SYSTEM_OBJECT_CLASSES.add("vision.PeopleDetector");
        SYSTEM_OBJECT_CLASSES.add("vision.PointTracker");
        SYSTEM_OBJECT_CLASSES.add("vision.Pyramid");
        SYSTEM_OBJECT_CLASSES.add("vision.ShapeInserter");
        SYSTEM_OBJECT_CLASSES.add("vision.StandardDeviation");
        SYSTEM_OBJECT_CLASSES.add("vision.TemplateMatcher");
        SYSTEM_OBJECT_CLASSES.add("vision.TextInserter");
        SYSTEM_OBJECT_CLASSES.add("vision.Variance");
        SYSTEM_OBJECT_CLASSES.add("vision.VideoFileReader");
        SYSTEM_OBJECT_CLASSES.add("vision.VideoFileWriter");
        SYSTEM_OBJECT_CLASSES.add("vision.VideoPlayer");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.AlphaBlender");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Autocorrelator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Autothresholder");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.BinaryFileReader");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.BinaryFileWriter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.BlobAnalysis");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ColorSpaceConverter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ConnectedComponentLabeler");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ContrastAdjuster");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Convolver");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Crosscorrelator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.DCT");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Deinterlacer");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.DemosaicInterpolator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.DeployableVideoPlayer");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.EdgeDetector");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.GammaCorrector");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.GeometricRotator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.GeometricTransformEstimator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.GeometricTransformer");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.GeometricTranslator");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Histogram");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.HistogramEqualizer");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.HoughLines");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.HoughTransform");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.IDCT");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.IFFT");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ImageFilter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ImagePadder");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.LocalMaximaFinder");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.MarkerInserter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.MedianFilter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.Pyramid");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.ShapeInserter");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.StandardDeviation");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.TemplateMatcher");
        SYSTEM_OBJECT_CLASSES.add("visioncodegen.VideoFileWriter");
        SYSTEM_OBJECT_CLASSES.add("zynq.AXIRead");
        SYSTEM_OBJECT_CLASSES.add("zynq.AXIWrite");
        EXEMPT_METHOD_NAMES.add("getContinuousStateSizeImpl");
        EXEMPT_METHOD_NAMES.add("getDescriptiveName");
        EXEMPT_METHOD_NAMES.add("getDiscreteStateSpecificationImpl");
        EXEMPT_METHOD_NAMES.add("getOutputDataTypeImpl");
        EXEMPT_METHOD_NAMES.add("getOutputSizeImpl");
        EXEMPT_METHOD_NAMES.add("isOutputComplexImpl");
        EXEMPT_METHOD_NAMES.add("isOutputFixedSizeImpl");
        EXEMPT_METHOD_NAMES.add("isSupportedContext");
        EXEMPT_METHOD_NAMES.add("updateBuildInfo");
    }
}

