/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;

public class ProxyEventDispatcher<T> {
    private final Collection<T> fObservers;
    private final Class<T> fEventHandlerClass;
    private final T fProxy;
    private boolean fEnabled;

    public ProxyEventDispatcher(Class<T> clazz) {
        this.fEventHandlerClass = clazz;
        this.fObservers = new LinkedList<T>();
        this.fProxy = this.createProxy(clazz);
        this.setEnabled(true);
    }

    public void addObserver(T t) {
        this.fObservers.add(t);
    }

    public void removeObserver(T t) {
        this.fObservers.remove(t);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    public T getProxyDispatcher() {
        return this.fProxy;
    }

    private T createProxy(Class<T> clazz) {
        final HashSet<Method> hashSet = new HashSet<Method>(Arrays.asList(clazz.getMethods()));
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, EventListener.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (ProxyEventDispatcher.this.isEnabled() && hashSet.contains(method)) {
                    try {
                        for (Object e : new LinkedList(ProxyEventDispatcher.this.fObservers)) {
                            method.invoke(e, objectArray);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                }
                return null;
            }
        });
    }
}

