/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentEvent;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentListener;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.build.ArtifactSelector;
import com.mathworks.toolbox.coder.wfa.build.BuildButton;
import com.mathworks.toolbox.coder.wfa.build.BuildConfigurationPanel;
import com.mathworks.toolbox.coder.wfa.build.BuildManager;
import com.mathworks.toolbox.coder.wfa.build.InferenceCodePopupContentView;
import com.mathworks.toolbox.coder.wfa.build.InferenceTable;
import com.mathworks.toolbox.coder.wfa.build.PackageButton;
import com.mathworks.toolbox.coder.wfa.build.SettingsPanel;
import com.mathworks.toolbox.coder.wfa.build.SourceSelector;
import com.mathworks.toolbox.coder.wfa.core.ActionButton;
import com.mathworks.toolbox.coder.wfa.core.AnimationUtils;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.toolbar.SaveButton;
import com.mathworks.toolbox.coder.wfa.toolbar.Separator;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.toolbox.coder.wfa.verification.CTestOptionPanel;
import com.mathworks.toolbox.coder.wfa.verification.HDLTestOptionPanel;
import com.mathworks.toolbox.coder.wfa.verification.TestDropDownButton;
import com.mathworks.toolbox.coder.wfa.verification.TestOptionPanel;
import com.mathworks.toolbox.coder.wfa.verification.TestOutputPanel;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenerateCodeView
extends AbstractCoderStepView {
    private final JComponent fSettingsButton;
    private final SettingsPanel fSettingsPanel;
    private final SaveButton fSaveButton;
    private final BuildButton fBuildButton;
    private final TestDropDownButton fTestButton;
    private final PackageButton fPackageButton;
    private final BuildManager fBuildManager;
    private final List<Component> fToolbarComponents;
    private CTestOptionPanel fCTestOptions;
    private HDLTestOptionPanel fHdlTestOptions;
    private final TestOutputPanel fTestOutputPanel;
    private final IDEContext fContext = this.initIDEContext();
    private ToolbarContext fToolbarContext;
    private boolean fBuildStarted;
    private boolean fAddedTestResultsTab;
    private InferenceTable fInferenceTable;
    private InferenceTable.InferenceTableContext fTableContext;
    private static final String INFERENCE_TAB_KEY = "inference";
    private static final String TEST_RESULTS_KEY = "test-results";

    public GenerateCodeView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fSaveButton = new SaveButton(coderApp);
        this.fToolbarComponents = new ArrayList<Component>();
        this.fBuildManager = new BuildManager(coderApp, this.fContext);
        this.fSettingsButton = this.createSettingsButton();
        this.fBuildButton = new BuildButton(false);
        this.fBuildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateCodeView.this.startBuild();
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GenerateCodeView.this.getTestOptionPanel().runAction();
            }
        };
        ReturnRunnable<Boolean> returnRunnable = new ReturnRunnable<Boolean>(){

            public Boolean run() {
                String string = GenerateCodeView.this.getApp().getModel().getTestSnippets().getLastCommand();
                return string != null && !string.trim().isEmpty();
            }
        };
        this.fTestButton = new TestDropDownButton(this.getApp(), runnable, returnRunnable);
        this.fTestButton.setEnabled(false);
        this.fPackageButton = new PackageButton();
        this.fPackageButton.setEnabled(false);
        this.fPackageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateCodeView.this.startPackage();
            }
        });
        this.fTestOutputPanel = new TestOutputPanel(this.getApp(), new Runnable(){

            @Override
            public void run() {
                if (!GenerateCodeView.this.fAddedTestResultsTab) {
                    GenerateCodeView.this.fAddedTestResultsTab = true;
                    GenerateCodeView.this.fContext.addTab(GenerateCodeView.TEST_RESULTS_KEY, CoderResources.getString("wfa.tab.testResults"), GenerateCodeView.this.fTestOutputPanel.getComponent());
                }
                GenerateCodeView.this.fContext.activateTab(GenerateCodeView.TEST_RESULTS_KEY);
            }
        });
        this.fTestButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (GenerateCodeView.this.fTestButton.isSelected()) {
                    GenerateCodeView.this.getApp().getPopupBarManager().show(GenerateCodeView.this.getTestOptionPanel());
                } else {
                    GenerateCodeView.this.getApp().getPopupBarManager().closePopup();
                }
            }
        });
        this.updateToolbarComponents();
        this.fSettingsPanel = new SettingsPanel(this.getApp(), new Runnable(){

            @Override
            public void run() {
                GenerateCodeView.this.closeSheet(GenerateCodeView.this.fSettingsPanel.getComponent());
            }
        });
        this.fBuildManager.addBuildFinishListener(new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                GenerateCodeView.this.doBuildFinished(bl);
            }
        });
        this.fBuildManager.addPackageFinishListener(new ParameterRunnable<Boolean>(){

            public void run(final Boolean bl) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (bl.booleanValue()) {
                            GenerateCodeView.this.getApp().getIDEView().getCodeInfoView().getNotificationManager().showMessage(CoderResources.getString("wfa.packageSucceeded"));
                        }
                        GenerateCodeView.this.fPackageButton.setEnabled(true);
                        GenerateCodeView.this.fBuildButton.setEnabled(true);
                    }
                });
            }
        });
        this.getApp().getIDEView().getFileSets().addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GenerateCodeView.this.updateSelectedInferenceFunction();
            }
        });
        this.getApp().getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("generic-artifact") || propertyChangeEvent.getPropertyName().equals("artifact") || propertyChangeEvent.getPropertyName().equals("param.UseECoderFeatures") || Configuration.isToolboxEnabledChange((PropertyChangeEvent)propertyChangeEvent)) {
                    GenerateCodeView.this.updateToolbarComponents();
                }
            }
        });
    }

    private TestOptionPanel getTestOptionPanel() {
        boolean bl;
        boolean bl2 = bl = this.getApp().getModel().getGenericArtifact() == GenericArtifact.HDL;
        if (bl) {
            if (this.fHdlTestOptions == null) {
                this.fHdlTestOptions = new HDLTestOptionPanel(this.getApp(), this.fTestButton, this.fTestOutputPanel);
            }
            return this.fHdlTestOptions;
        }
        if (this.fCTestOptions == null) {
            this.fCTestOptions = new CTestOptionPanel(this.getApp(), this.fTestButton, this.fTestOutputPanel);
        }
        return this.fCTestOptions;
    }

    private JComponent createSettingsButton() {
        MJButton mJButton = new MJButton(CoderResources.getString("wfa.generateCode.settings.buttonText"));
        mJButton.setToolTipText(CoderResources.getString("app.action.settings"));
        mJButton.addActionListener(new ActionListener((JButton)mJButton){
            final /* synthetic */ JButton val$button;
            {
                this.val$button = jButton;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateCodeView.this.startSettingsExpandOrCollapse(new Runnable(){

                    @Override
                    public void run() {
                        val$button.setEnabled(true);
                    }
                });
                this.val$button.setEnabled(false);
            }
        });
        return mJButton;
    }

    protected final void updateInferenceTable() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GenerateCodeView.this.fInferenceTable != null) {
                    GenerateCodeView.this.fInferenceTable.getComponent().revalidate();
                    GenerateCodeView.this.fInferenceTable.getComponent().repaint();
                }
            }
        });
    }

    protected BuildConfigurationPanel initBuildConfigPanel() {
        return new BuildConfigurationPanel(){

            @Override
            protected void buildContents() {
                if (GenerateCodeView.this.getApp().getModel().getGenericArtifact() != GenericArtifact.HDL) {
                    this.addSubSection(CoderResources.getString("wfa.generateCode.buildArtifact.desc"), new ArtifactSelector(GenerateCodeView.this.getApp(), GenericArtifact.C, GenerateCodeView.this.getApp().getModel().getArtifact(), false).getComponent());
                }
                this.addSubSection(CoderResources.getString("wfa.generateCode.sourceSelector.desc"), new SourceSelector(GenerateCodeView.this.getApp().getModel()).getComponent());
                this.addSubSection(CoderResources.getString("wfa.generateCode.settings.desc"), GenerateCodeView.this.fSettingsButton);
            }
        };
    }

    protected InferenceTable.InferenceTableContext getInferenceTableContext() {
        if (this.fTableContext == null) {
            this.fTableContext = new InferenceTable.InferenceTableContext(){

                @Override
                public InferenceModel getInferenceModel() {
                    return GenerateCodeView.this.getApp().getModel().getInferenceModel();
                }

                @Override
                public List<PropertyTableColumn<Variable>> getColumnsForFunction(Function function) {
                    return Arrays.asList(new PropertyTableColumn[]{new MatlabTypeColumn(), new TypeSizeColumn()});
                }

                @Override
                public PropertyTableCellEditorFactory<Variable> getCellEditorFactory() {
                    return null;
                }

                @Override
                public void setInferenceTable(InferenceTable inferenceTable) {
                }

                @Override
                public boolean allowGroupSelection() {
                    return false;
                }

                @Override
                public boolean allowMultipleSelection() {
                    return false;
                }

                @Override
                public void setCurrentGroups(Map<Integer, VariableKind> map) {
                }
            };
        }
        return this.fTableContext;
    }

    protected void doBuildFinished(boolean bl) {
        if (bl) {
            this.getApp().getIDEView().getCodeInfoView().getNotificationManager().showMessage(CoderResources.getString("wfa.buildSucceeded"));
        }
        this.fTestButton.setEnabled(bl);
        this.fPackageButton.setEnabled(bl);
        this.getApp().getModel().setBuilt(bl);
        this.getModel().refreshCompletion(this.getStep());
        if (this.fInferenceTable == null) {
            this.fInferenceTable = new InferenceTable(this.getInferenceTableContext());
            this.updateSelectedInferenceFunction();
            final EditorView editorView = this.getApp().getIDEView().getCodeInfoView().getEditorView();
            this.fInferenceTable.addInferenceTableSelectionListener(new ParameterRunnable<Set<Variable>>(){

                public void run(Set<Variable> set) {
                    if (!set.isEmpty()) {
                        editorView.setEditable(true);
                        Variable variable = set.iterator().next();
                        editorView.displayVariable(variable);
                    }
                }
            });
            this.fContext.addTab(INFERENCE_TAB_KEY, CoderResources.getString("wfa.tab.variables"), this.wrapInferenceTable(this.fInferenceTable));
        }
        if (bl) {
            this.fContext.activateTab(INFERENCE_TAB_KEY);
        }
    }

    protected JComponent wrapInferenceTable(InferenceTable inferenceTable) {
        return inferenceTable.getComponent();
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        this.fToolbarContext = toolbarContext;
        toolbarContext.setStepComponents(this.fToolbarComponents);
        this.installIDEView(this.fContext);
        IDEView iDEView = this.getApp().getIDEView();
        if (!this.fBuildStarted) {
            final ActionButton actionButton = new ActionButton(CoderResources.getString("wfa.build.start"), CoderResources.getIcon("Build_24.png"));
            actionButton.setName("button.build.large");
            actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GenerateCodeView.this.animateBuildButton((Component)actionButton);
                    GenerateCodeView.this.startBuild();
                }
            });
            actionButton.setFont(CoderApp.getFont().deriveFont(16.0f));
            MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 0dlu:grow", "0dlu:grow, fill:d, 0dlu:grow"));
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel.add((Component)((Object)actionButton), (Object)cellConstraints.xy(2, 2));
            this.fContext.showBanner((Component)mJPanel);
        } else {
            this.fContext.clearBanner();
        }
        if (iDEView.getFileSets().getSelectedFile() == null) {
            iDEView.getFileSets().select((File)this.getApp().getModel().getEntryPointFileSet().getFiles().iterator().next());
        }
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    protected String getHelpKey() {
        return "help_button_generate_code";
    }

    private boolean isSilSupported() {
        return this.getApp().getModel().getConfiguration().getParamAsBoolean("param.UseECoderFeatures") && (this.getApp().getModel().getArtifact() == Artifact.STATIC_LIBRARY || this.getApp().getModel().getArtifact() == Artifact.SHARED_LIBRARY);
    }

    private void updateToolbarComponents() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GenerateCodeView.this.fToolbarComponents.clear();
                GenerateCodeView.this.fToolbarComponents.add(GenerateCodeView.this.fSaveButton);
                GenerateCodeView.this.fToolbarComponents.add(new Separator());
                GenerateCodeView.this.fToolbarComponents.add(GenerateCodeView.this.fBuildButton);
                if (GenerateCodeView.this.getApp().getModel().getGenericArtifact() == GenericArtifact.HDL || GenerateCodeView.this.getApp().getModel().getArtifact() == Artifact.MEX_FILE || GenerateCodeView.this.isSilSupported()) {
                    GenerateCodeView.this.fToolbarComponents.add(new Separator());
                    GenerateCodeView.this.fToolbarComponents.add(GenerateCodeView.this.fTestButton);
                }
                if (GenerateCodeView.this.getApp().getModel().getGenericArtifact() == GenericArtifact.C && GenerateCodeView.this.getApp().getModel().getArtifact() != Artifact.MEX_FILE) {
                    GenerateCodeView.this.fToolbarComponents.add(new Separator());
                    GenerateCodeView.this.fToolbarComponents.add(GenerateCodeView.this.fPackageButton);
                }
                if (GenerateCodeView.this.fToolbarContext != null) {
                    GenerateCodeView.this.fToolbarContext.setStepComponents(GenerateCodeView.this.fToolbarComponents);
                }
            }
        });
    }

    private void startSettingsExpandOrCollapse(Runnable runnable) {
        this.displaySheet((Component)this.fSettingsPanel.getComponent(), this.fSettingsButton, false, true, runnable);
    }

    private void startBuild() {
        this.fTestButton.setEnabled(false);
        this.fPackageButton.setEnabled(false);
        this.fBuildStarted = true;
        this.getApp().getModel().setBuilt(false);
        this.getModel().refreshCompletion(this.getStep());
        this.closeSheet(this.fSettingsPanel.getComponent());
        this.fContext.clearBanner();
        this.fBuildManager.startBuild();
    }

    private InferenceModel getInferenceModel() {
        return this.getApp().getModel().getInferenceModel();
    }

    private void startPackage() {
        this.closeSheet(this.fSettingsPanel.getComponent());
        this.fContext.clearBanner();
        this.fBuildManager.startPackage();
    }

    private void updateSelectedInferenceFunction() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GenerateCodeView.this.fInferenceTable == null) {
                    return;
                }
                File file = GenerateCodeView.this.getApp().getIDEView().getFileSets().getSelectedFile();
                if (file != null) {
                    Function function = GenerateCodeView.this.getApp().getModel().getInferenceModel().getMainFunction(file);
                    GenerateCodeView.this.fInferenceTable.setSelectedFunction(function);
                }
            }
        });
    }

    private void animateBuildButton(Component component) {
        AnimationUtils.animateMoveInGlassPane(this.getApp().getAnimator(), this.getApp().getGlassPaneManager(), this.getApp().getWindow(), component.getBounds(), component.getParent(), this.fBuildButton.getBounds(), this.fBuildButton.getParent());
    }

    protected GenerateCodeIDEContext initIDEContext() {
        return new GenerateCodeIDEContext(){
            private CodePopupController fPopupController;

            @Override
            public CodePopupController createCodePopupController(Window window, EditorView editorView) {
                if (this.fPopupController == null) {
                    this.fPopupController = new CodePopupController(new CodePopupFrame(window, new InferenceCodePopupContentView(GenerateCodeView.this.getInferenceModel())), editorView, GenerateCodeView.this.getInferenceModel());
                }
                return this.fPopupController;
            }

            @Override
            public void activate(IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
                super.activate(iDEFileSidebar, iDELayout, outputPane, editorView);
                if (editorView.getTextPane() != null) {
                    editorView.getTextPane().addCaretListener(new CaretListener(){

                        @Override
                        public void caretUpdate(CaretEvent caretEvent) {
                            Function function;
                            if (fPopupController != null && (function = fPopupController.getEffectiveFunction(caretEvent.getDot(), true)) != null && GenerateCodeView.this.fInferenceTable != null) {
                                GenerateCodeView.this.fInferenceTable.setSelectedFunction(function);
                            }
                        }
                    });
                }
                iDELayout.setCustomConfigurationView(GenerateCodeView.this.initBuildConfigPanel().getComponent());
            }
        };
    }

    protected abstract class GenerateCodeIDEContext
    extends IDEContext {
        private final Predicate<File> fDefaultOutputFilter;
        private final Predicate<Boolean> fFixptTest;
        private final EditorViewContentListener fContentListener;
        private EditorView fEditorView;

        protected GenerateCodeIDEContext() {
            this.fDefaultOutputFilter = new Predicate<File>(){

                public boolean accept(File file) {
                    for (SourceSet sourceSet : GenerateCodeView.this.getApp().getModel().getInputSourceSets()) {
                        if (!sourceSet.getFiles().contains(file)) continue;
                        return false;
                    }
                    return true;
                }
            };
            this.fFixptTest = new Predicate<Boolean>(){

                public boolean accept(Boolean bl) {
                    if (bl.booleanValue()) {
                        SourceSet sourceSet = GenerateCodeView.this.getApp().getModel().getFixedPointSourceSet();
                        return sourceSet != null && !sourceSet.getFiles().isEmpty();
                    }
                    return true;
                }
            };
            this.fContentListener = new EditorViewContentListener(){

                @Override
                public void handleEditorViewContentEvent(EditorViewContentEvent editorViewContentEvent) {
                    if (editorViewContentEvent.getSourceType().equals((Object)CodableEntity.Type.FUNCTION)) {
                        EditorView editorView = editorViewContentEvent.getEditorView();
                        Function function = (Function)editorViewContentEvent.getSource();
                        if (editorView.getCurrentFunction() != null && function != null || editorView.getCurrentFunction() == null && function == null) {
                            GenerateCodeView.this.fInferenceTable.setSelectedFunction(function);
                        }
                    }
                }
            };
        }

        @Override
        public void activate(IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
            editorView.setEntityLocator(new FunctionScopedEntityLocator(GenerateCodeView.this.getApp().getModel(), GenerateCodeView.this.getApp().getModel().getInferenceModel()));
            super.activate(iDEFileSidebar, iDELayout, outputPane, editorView);
            this.fEditorView = editorView;
            editorView.addEditorViewContentListener(this.fContentListener);
            SourceSet sourceSet = GenerateCodeView.this.getApp().getModel().getFixedPointSourceSet();
            if (sourceSet != null) {
                sourceSet.addActivationPredicate(this.fFixptTest);
            }
        }

        @Override
        public void deactivate() {
            super.deactivate();
            this.fEditorView.removeEditorViewContentListener(this.fContentListener);
            SourceSet sourceSet = GenerateCodeView.this.getApp().getModel().getFixedPointSourceSet();
            if (sourceSet != null) {
                sourceSet.removeActivationPredicate(this.fFixptTest);
            }
        }

        @Override
        public void sidebarFunctionChanged(Function function) {
            if (GenerateCodeView.this.fInferenceTable != null) {
                GenerateCodeView.this.fInferenceTable.setSelectedFunction(function);
            }
        }

        @Override
        public Predicate<File> getOutputFileSetFilter() {
            return this.fDefaultOutputFilter;
        }
    }

    private class TypeSizeColumn
    extends AbstractPropertyTableColumn<Variable> {
        TypeSizeColumn() {
            super(CoderResources.getString("label.size"));
        }

        public String getText(Variable variable) {
            return GenerateCodeView.this.getInferenceModel().getMatlabType(variable).toDimensionString();
        }
    }

    private class MatlabTypeColumn
    extends AbstractPropertyTableColumn<Variable> {
        MatlabTypeColumn() {
            super(CoderResources.getString("f2f.column.matlabType"));
        }

        public String getText(Variable variable) {
            return GenerateCodeView.this.getApp().getModel().getInferenceModel().getMatlabType(variable).toUniqueString();
        }
    }
}

