/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabException;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.app.NotificationManager;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.ImportExportUtils;
import com.mathworks.toolbox.coder.wfa.core.DescriptionLabel;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ImportExportPanel {
    private final MJPanel fComponent;
    private final CoderApp fApp;
    private final MJTextField fVariableNameField;
    private final GlassPaneManager fGlassPaneManager;
    private final NotificationManager fNotificationManager;
    private HintPopupFrame fError;
    private final MJButton fImportButton;
    private final MJButton fExportButton;

    public ImportExportPanel(CoderApp coderApp, Component component) {
        this.fApp = coderApp;
        this.fGlassPaneManager = new GlassPaneManager(SwingUtilities.getRootPane(component));
        this.fNotificationManager = new NotificationManager(this.fGlassPaneManager);
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("10dlu, fill:d, 3dlu, 160px, 6dlu, fill:d, 4dlu, fill:d, 0dlu:grow, 10dlu", "10dlu, fill:d, 12dlu, fill:d, 10dlu"));
        this.fNotificationManager.setComponent((JComponent)this.fComponent);
        this.fVariableNameField = new MJTextField();
        this.fVariableNameField.setText(coderApp.getModel().getDefaultImportExportVariable());
        this.fExportButton = new MJButton(CoderResources.getString("wfa.settings.export"), CoderResources.getIcon("export.png"));
        this.fImportButton = new MJButton(CoderResources.getString("wfa.settings.import"), CoderResources.getIcon("import.png"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)new DescriptionLabel(CoderResources.getString("wfa.settings.importExport.prompt")).getComponent(), (Object)cellConstraints.xyw(2, 2, 8));
        this.fComponent.add((Component)new DescriptionLabel(CoderResources.getString("wfa.settings.importExport.configObjectName")).getComponent(), (Object)cellConstraints.xy(2, 4));
        this.fComponent.add((Component)this.fVariableNameField, (Object)cellConstraints.xy(4, 4));
        this.fComponent.add((Component)this.fExportButton, (Object)cellConstraints.xy(6, 4));
        this.fComponent.add((Component)this.fImportButton, (Object)cellConstraints.xy(8, 4));
        this.fExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImportExportPanel.this.fVariableNameField.getText().trim();
                ImportExportPanel.this.clearOutput();
                ImportExportUtils.exportProjectSettings(ImportExportPanel.this.fApp.getModel().getConfiguration().getProject(), string, new ParameterRunnable<MatlabException>(){

                    public void run(MatlabException matlabException) {
                        ImportExportPanel.this.showError(matlabException.getMessage());
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        ImportExportPanel.this.showSuccess(CoderResources.getString("wfa.settings.export.succeeded"));
                    }
                });
            }
        });
        this.fImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportExportPanel.this.clearOutput();
                String string = ImportExportPanel.this.fVariableNameField.getText().trim();
                ImportExportUtils.importProjectSettings(ImportExportPanel.this.fApp.getModel().getConfiguration().getProject(), string, new ParameterRunnable<MatlabException>(){

                    public void run(MatlabException matlabException) {
                        ImportExportPanel.this.showError(matlabException.getMessage());
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        ImportExportPanel.this.showSuccess(CoderResources.getString("wfa.settings.import.succeeded"));
                    }
                });
            }
        });
        this.fVariableNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                String string = ImportExportPanel.this.fVariableNameField.getText().trim();
                ImportExportPanel.this.fApp.getModel().setDefaultImportExportVariable(string);
                ImportExportPanel.this.clearOutput();
            }
        });
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ImportExportPanel.this.clearOutput();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void clearOutput() {
        if (this.fError != null) {
            this.fError.close();
            this.fError = null;
        }
    }

    private void showError(String string) {
        this.fError = new HintPopupFrame(SwingUtilities.windowForComponent(this.getComponent()), (Component)this.fVariableNameField, StringUtils.stripLinks((String)string), BuildErrorSeverity.ERROR.getIcon(), false, false, new ReturnRunnable<Point>(){

            public Point run() {
                Point point = new Point(ImportExportPanel.this.fVariableNameField.getWidth() / 2, ImportExportPanel.this.fVariableNameField.getHeight());
                SwingUtilities.convertPointToScreen(point, (Component)ImportExportPanel.this.fVariableNameField);
                return point;
            }
        });
    }

    private void showSuccess(String string) {
        this.fNotificationManager.showMessage(string);
    }
}

