/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.toolbox.coder.annot.BoundToProperty;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.widgets.CustomComboBox;
import com.mathworks.toolbox.coder.widgets.CustomComboModelContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;

final class SourceSelector {
    private static final String RESOURCE_KEY_PREFIX = "wfa.generateCode.sourceSelector.";
    private final CustomComboBox<SourceSet> fComponent;
    private final CoderAppModel fAppModel;

    SourceSelector(CoderAppModel coderAppModel) {
        this.fAppModel = coderAppModel;
        this.fComponent = this.createComboBox(coderAppModel);
        coderAppModel.bind(new Binder());
    }

    private CustomComboBox<SourceSet> createComboBox(CoderAppModel coderAppModel) {
        DefaultComboBoxModel<SourceSet> defaultComboBoxModel = new DefaultComboBoxModel<SourceSet>(coderAppModel.getInputSourceSets().toArray(new SourceSet[0]));
        final CustomComboBox<SourceSet> customComboBox = new CustomComboBox<SourceSet>(new SourceModelContext(), defaultComboBoxModel);
        customComboBox.setIconAllowance(new Dimension(16, 16));
        customComboBox.setSelectedItem(coderAppModel.getActiveInputSourceSet());
        customComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceSelector.this.fAppModel.setActiveInputSourceSet((SourceSet)customComboBox.getSelectedItem());
            }
        });
        return customComboBox;
    }

    Component getComponent() {
        return this.fComponent;
    }

    private class SourceModelContext
    implements CustomComboModelContext<SourceSet> {
        private SourceModelContext() {
        }

        @Override
        public String getDescription(Object object) {
            return this.getResourceString(object, "desc");
        }

        @Override
        public String getName(Object object) {
            return this.getResourceString(object, "name");
        }

        @Override
        public String getShortName(Object object) {
            return this.getName(object);
        }

        @Override
        public Icon getIcon(Object object) {
            return null;
        }

        private String getResourceString(Object object, String string) {
            SourceSet sourceSet = (SourceSet)object;
            String string2 = null;
            if (SourceSelector.this.fAppModel.getPrimarySourceSet() != null && sourceSet.equals(SourceSelector.this.fAppModel.getPrimarySourceSet())) {
                string2 = "original";
            } else if (SourceSelector.this.fAppModel.getFixedPointSourceSet() != null && sourceSet.equals(SourceSelector.this.fAppModel.getFixedPointSourceSet())) {
                string2 = "fixedPoint";
            }
            return string2 != null ? CoderResources.getString(SourceSelector.RESOURCE_KEY_PREFIX + string2 + '.' + string) : "";
        }
    }

    private class Binder {
        private Binder() {
        }

        @BoundToProperty(value="registered-source-sets")
        void sourceSetsChanged(Collection<SourceSet> collection) {
            SourceSet sourceSet = (SourceSet)SourceSelector.this.fComponent.getSelectedItem();
            SourceSelector.this.fComponent.setModel(new DefaultComboBoxModel<SourceSet>(collection.toArray(new SourceSet[0])));
            SourceSelector.this.fComponent.setSelectedItem(sourceSet);
        }

        @BoundToProperty(value="active-source-set")
        void activeSourceSetChanged(SourceSet sourceSet) {
            SourceSelector.this.fComponent.setSelectedItem(sourceSet);
        }
    }
}

