/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.GlassPaneWidget;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class AnimationUtils {
    private static final Color DEFAULT_MOVE_COLOR = new Color(80, 80, 80);

    private AnimationUtils() {
    }

    public static void animateMoveInGlassPane(Animator animator, final GlassPaneManager glassPaneManager, Window window, Rectangle rectangle, Component component, Rectangle rectangle2, Component component2, AnimationTrack animationTrack, Color color, final Runnable runnable) {
        Point point = SwingUtilities.convertPoint(component, rectangle.getLocation(), window);
        Point point2 = SwingUtilities.convertPoint(component2, rectangle2.getLocation(), window);
        final MoveOutlineGlassPaneWidget moveOutlineGlassPaneWidget = new MoveOutlineGlassPaneWidget(point, point2, rectangle, rectangle2, color);
        glassPaneManager.add(moveOutlineGlassPaneWidget);
        animator.animate(animationTrack, new Animation(){

            @Override
            public void step(double d) {
                moveOutlineGlassPaneWidget.setRatioReference(d);
                if (d >= 1.0) {
                    glassPaneManager.remove(moveOutlineGlassPaneWidget);
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                glassPaneManager.repaint(moveOutlineGlassPaneWidget);
            }
        });
    }

    public static void animateMoveInGlassPane(Animator animator, GlassPaneManager glassPaneManager, Window window, Rectangle rectangle, Component component, Rectangle rectangle2, Component component2, AnimationTrack animationTrack, Runnable runnable) {
        AnimationUtils.animateMoveInGlassPane(animator, glassPaneManager, window, rectangle, component, rectangle2, component2, animationTrack, DEFAULT_MOVE_COLOR, runnable);
    }

    public static void animateMoveInGlassPane(Animator animator, GlassPaneManager glassPaneManager, Window window, Rectangle rectangle, Component component, Rectangle rectangle2, Component component2, AnimationTrack animationTrack) {
        AnimationUtils.animateMoveInGlassPane(animator, glassPaneManager, window, rectangle, component, rectangle2, component2, animationTrack, null);
    }

    public static void animateMoveInGlassPane(Animator animator, GlassPaneManager glassPaneManager, Window window, Rectangle rectangle, Component component, Rectangle rectangle2, Component component2) {
        AnimationUtils.animateMoveInGlassPane(animator, glassPaneManager, window, rectangle, component, rectangle2, component2, AnimationTrack.HILL);
    }

    public static Graphics2D configureForSpeed(Graphics2D graphics2D) {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHints(renderingHints);
        return graphics2D;
    }

    public static AnimationTrack createLinearTrack(int n) {
        return new AnimationTrack.AbstractAnimationTrack(n){

            @Override
            public double determinePosition(double d) {
                return d / (double)this.getDuration();
            }
        };
    }

    public static AnimationTrack createCubicInOutTrack(int n) {
        return new AnimationTrack.AbstractAnimationTrack(n){

            @Override
            public double determinePosition(double d) {
                double d2 = d / (double)this.getDuration();
                double d3 = 0.0;
                d3 = d2 < 0.5 ? 0.5 * Math.pow(2.0 * d / (double)this.getDuration(), 3.0) : 0.5 * (Math.pow(2.0 * d / (double)this.getDuration() - 2.0, 3.0) + 2.0);
                return d3;
            }
        };
    }

    public static AnimationTrack createLinearAccelerating(int n) {
        final double d = 1.0 / (double)(n * n);
        return new AnimationTrack.AbstractAnimationTrack(n){

            @Override
            public double determinePosition(double d2) {
                return d * d2 * d2;
            }
        };
    }

    public static AnimationTrack createBlinkTrack(final int n, final int n2) {
        final double d = Math.PI * 2 / (double)n;
        return new AnimationTrack.AbstractAnimationTrack(n * n2 + n / 4){

            @Override
            public double determinePosition(double d3) {
                double d2 = Math.sin(d * d3);
                d2 = Math.max(d2, 0.0);
                return d3 / (double)n < (double)n2 ? Math.min(0.99, d2) : d2;
            }
        };
    }

    public static double interpolateQuantity(double d, double d2, double d3) {
        return d * (d3 - d2) + d2;
    }

    public static final class ImageUpdater {
        private final Object fInternalLock = new Object();
        private final ParameterRunnable<BufferedImage> fCallback;
        private volatile ReturnRunnable<BufferedImage> fTask;
        private volatile BufferedImage fImageBuffer;
        private volatile boolean fKeepGoing;

        public ImageUpdater(ParameterRunnable<BufferedImage> parameterRunnable, ReturnRunnable<BufferedImage> returnRunnable) {
            this.fCallback = parameterRunnable;
            this.fKeepGoing = true;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (ImageUpdater.this.isKeepGoing()) {
                        ReturnRunnable returnRunnable;
                        Object object = ImageUpdater.this.fInternalLock;
                        synchronized (object) {
                            returnRunnable = ImageUpdater.this.fTask;
                        }
                        if (returnRunnable != null && ImageUpdater.this.isKeepGoing()) {
                            object = (BufferedImage)ImageUpdater.this.fTask.run();
                            Object object2 = ImageUpdater.this.fInternalLock;
                            synchronized (object2) {
                                ImageUpdater.this.fImageBuffer = (BufferedImage)object;
                                if (ImageUpdater.this.fTask == returnRunnable) {
                                    ImageUpdater.this.fTask = null;
                                }
                            }
                            ImageUpdater.this.fCallback.run(object);
                            continue;
                        }
                        if (returnRunnable != null || !ImageUpdater.this.isKeepGoing()) continue;
                        object = ImageUpdater.this.fInternalLock;
                        synchronized (object) {
                            if (ImageUpdater.this.fTask == null) {
                                try {
                                    ImageUpdater.this.fInternalLock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    ImageUpdater.this.fKeepGoing = false;
                                }
                            }
                        }
                    }
                }
            }).start();
            if (returnRunnable != null) {
                this.requestUpdate(returnRunnable);
            }
        }

        public ImageUpdater(ParameterRunnable<BufferedImage> parameterRunnable) {
            this(parameterRunnable, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getImageBuffer() {
            Object object = this.fInternalLock;
            synchronized (object) {
                return this.fImageBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestUpdate(ReturnRunnable<BufferedImage> returnRunnable) {
            Object object = this.fInternalLock;
            synchronized (object) {
                this.fTask = returnRunnable;
                this.fInternalLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.fInternalLock;
            synchronized (object) {
                this.fKeepGoing = false;
                this.fInternalLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isKeepGoing() {
            Object object = this.fInternalLock;
            synchronized (object) {
                return this.fKeepGoing;
            }
        }
    }

    private static class MoveOutlineGlassPaneWidget
    extends GlassPaneWidget.AbstractGlassPaneWidget {
        private static final double STARTING_OPACITY = 0.27;
        private static final double ENDING_OPACITY = 0.05;
        private final Point fSourceLocation;
        private final Point fDestinationLocation;
        private final Rectangle fStart;
        private final Rectangle fEnd;
        private final Color fColor;
        private Shape fShape;
        private double fRatioReference;

        MoveOutlineGlassPaneWidget(Point point, Point point2, Rectangle rectangle, Rectangle rectangle2, Color color) {
            this.fDestinationLocation = point2;
            this.fSourceLocation = point;
            this.fStart = rectangle;
            this.fEnd = rectangle2;
            this.fColor = color;
            this.setRatioReference(0.0);
        }

        void setRatioReference(double d) {
            this.fRatioReference = d;
            this.fShape = new RoundRectangle2D.Double(this.fSourceLocation.getX() + (this.fDestinationLocation.getX() - this.fSourceLocation.getX()) * this.fRatioReference, this.fSourceLocation.getY() + (this.fDestinationLocation.getY() - this.fSourceLocation.getY()) * this.fRatioReference, this.fStart.getWidth() + (this.fEnd.getWidth() - this.fStart.getWidth()) * this.fRatioReference, this.fStart.getHeight() + (this.fEnd.getHeight() - this.fStart.getHeight()) * this.fRatioReference, 10.0, 10.0);
        }

        @Override
        public void paint(Component component, Graphics2D graphics2D) {
            Graphics2D graphics2D2 = AnimationUtils.configureForSpeed((Graphics2D)graphics2D.create());
            graphics2D2.setColor(new Color(this.fColor.getRed(), this.fColor.getGreen(), this.fColor.getBlue(), (int)(AnimationUtils.interpolateQuantity(this.fRatioReference, 0.27, 0.05) * 255.0)));
            graphics2D2.setStroke(new BasicStroke(1.5f));
            graphics2D2.fill(this.fShape);
            graphics2D2.dispose();
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            return this.fShape.getBounds();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public boolean contains(int n, int n2) {
            return false;
        }
    }
}

