/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Timer;

public final class Animator {
    private static final int MAX_FRAME_RATE = Animator.getScreenRefreshRate();
    private static final int DEFAULT_FRAME_RATE = 60;
    private final List<AnimationContext> fContexts;
    private final double fFrameRate;
    private final int fInterval;
    private Timer fTimer;

    public Animator() {
        this(60);
    }

    public Animator(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Animator frame rate must be greater than zero: " + n);
        }
        this.fFrameRate = Math.min(n, MAX_FRAME_RATE);
        this.fInterval = (int)Math.round(1000.0 / this.fFrameRate);
        this.fContexts = new LinkedList<AnimationContext>();
    }

    public void animate(final AnimationTrack animationTrack, final Animation animation) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Animator.this.fContexts.add(new AnimationContext(animation, animationTrack));
                if (Animator.this.fTimer == null) {
                    Animator.this.fTimer = new Timer(Animator.this.fInterval, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            for (AnimationContext animationContext : new ArrayList(Animator.this.fContexts)) {
                                if (animationContext.step()) continue;
                                Animator.this.fContexts.remove(animationContext);
                            }
                            if (Animator.this.fContexts.isEmpty()) {
                                Animator.this.fTimer.stop();
                                Animator.this.fTimer = null;
                            }
                        }
                    });
                    Animator.this.fTimer.setRepeats(true);
                    Animator.this.fTimer.start();
                }
            }
        });
    }

    private static int getScreenRefreshRate() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = 60;
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            if (displayMode.getRefreshRate() == 0) continue;
            n = Math.max(n, displayMode.getRefreshRate());
        }
        return n;
    }

    private static class AnimationContext {
        private final Animation fAnimation;
        private final AnimationTrack fTrack;
        private long fStartTime;

        AnimationContext(Animation animation, AnimationTrack animationTrack) {
            this.fAnimation = animation;
            this.fTrack = animationTrack;
            this.fStartTime = -1L;
        }

        boolean step() {
            double d = 0.0;
            if (this.fStartTime == -1L) {
                this.fStartTime = System.currentTimeMillis();
            } else {
                d = System.currentTimeMillis() - this.fStartTime;
            }
            double d2 = this.fTrack.determinePosition(d);
            if (this.fTrack.equals(AnimationTrack.PLACEHOLDER) || d2 > 1.0 || d >= (double)this.fTrack.getDuration()) {
                d2 = 1.0;
            }
            this.fAnimation.step(d2);
            return d2 < 1.0;
        }
    }
}

