/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJButton;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.JComponent;

public final class NavigationBar {
    private final MJButton fComponent;
    private final boolean fBack;
    private final CoderApp fApp;
    private final StepModel fModel;
    private boolean fNarrow;
    private double fVisibility;
    private int fTargetWidth;
    private int fAnimationIndex;
    public static final int NORMAL_WIDTH = 24;
    public static final int NARROW_WIDTH = 14;
    private static final Color DEFAULT_BACKGROUND = new Color(250, 250, 250);
    private static final Color ATTENTION_COLOR = new Color(29, 86, 144);

    public NavigationBar(CoderApp coderApp, StepModel stepModel, boolean bl) {
        this.fApp = coderApp;
        this.fBack = bl;
        this.fModel = stepModel;
        this.fVisibility = 1.0;
        this.fTargetWidth = 24;
        this.fComponent = new MJButton(){

            public Dimension getPreferredSize() {
                return new Dimension((int)(NavigationBar.this.fVisibility * (double)NavigationBar.this.fTargetWidth), 100);
            }

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setPaint(null);
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (NavigationBar.this.fVisibility > 0.0) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)NavigationBar.this.fVisibility));
                    if (this.getModel().isRollover()) {
                        graphics2D.setColor(this.getModel().isRollover() ? Color.WHITE : new Color(252, 252, 252));
                        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    } else {
                        graphics2D.setColor(this.getBackground());
                        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (!this.isEnabled()) {
                        graphics2D.setColor(new Color(180, 180, 180));
                    } else {
                        graphics2D.setColor(new Color(125, 125, 125));
                    }
                    graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
                    GeneralPath generalPath = new GeneralPath();
                    int n = this.getWidth() / 3;
                    int n2 = this.getWidth() / 2;
                    if (NavigationBar.this.fBack) {
                        generalPath.append(new Line2D.Double(this.getWidth() / 2 - n / 2, this.getHeight() / 2, this.getWidth() / 2 + n / 2, this.getHeight() / 2 - n2 / 2), false);
                        generalPath.append(new Line2D.Double(this.getWidth() / 2 - n / 2, this.getHeight() / 2, this.getWidth() / 2 + n / 2, this.getHeight() / 2 + n2 / 2), false);
                    } else {
                        generalPath.append(new Line2D.Double(this.getWidth() / 2 + n / 2, this.getHeight() / 2, this.getWidth() / 2 - n / 2, this.getHeight() / 2 - n2 / 2), false);
                        generalPath.append(new Line2D.Double(this.getWidth() / 2 + n / 2, this.getHeight() / 2, this.getWidth() / 2 - n / 2, this.getHeight() / 2 + n2 / 2), false);
                    }
                    graphics2D.draw(generalPath);
                    graphics2D.setColor(new Color(220, 220, 220));
                    graphics2D.setStroke(new BasicStroke(1.0f));
                    if (NavigationBar.this.fBack) {
                        graphics2D.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
                    } else {
                        graphics2D.drawLine(0, 0, 0, this.getHeight());
                    }
                }
                graphics2D.dispose();
            }
        };
        this.fComponent.setName(bl ? "button.back" : "button.next");
        this.fComponent.setBorder(null);
        this.fComponent.setToolTipText(CoderResources.getString(this.fBack ? "wfa.back.tooltip" : "wfa.next.tooltip"));
        this.fComponent.setBackground(DEFAULT_BACKGROUND);
        this.fComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.fComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NavigationBar.this.fBack) {
                    NavigationBar.this.fModel.goToPreviousStep();
                } else {
                    NavigationBar.this.fApp.getEditManager().saveAll();
                    NavigationBar.this.fModel.goToNextStep();
                }
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.fComponent.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fComponent.removeActionListener(actionListener);
    }

    public void setEnabled(boolean bl) {
        this.fComponent.setEnabled(bl);
        this.fComponent.setCursor(Cursor.getPredefinedCursor(bl ? 12 : 0));
    }

    public void setVisible(final boolean bl, boolean bl2) {
        if (!(!bl2 || !bl && this.fVisibility == 0.0 || bl && this.fVisibility == 1.0)) {
            final int n = ++this.fAnimationIndex;
            this.fApp.getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d) {
                    if (n != NavigationBar.this.fAnimationIndex) {
                        return;
                    }
                    NavigationBar.this.fVisibility = bl ? d : 1.0 - d;
                    if (!NavigationBar.this.fBack && d == 1.0 && bl) {
                        NavigationBar.this.animateAppearance();
                    }
                    NavigationBar.this.fComponent.revalidate();
                    NavigationBar.this.fComponent.repaint();
                }
            });
        } else {
            ++this.fAnimationIndex;
            this.fVisibility = bl ? 1.0 : 0.0;
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public void setNarrow(boolean bl) {
        if (bl == this.fNarrow) {
            return;
        }
        this.fNarrow = bl;
        final int n = this.getComponent().getWidth();
        int n2 = bl ? 14 : 24;
        final int n3 = n2 - n;
        if (this.getComponent().getWidth() != n2) {
            this.fApp.getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d) {
                    NavigationBar.this.fTargetWidth = (int)((double)n + d * (double)n3);
                    NavigationBar.this.fComponent.revalidate();
                    NavigationBar.this.fComponent.repaint();
                }
            });
        }
    }

    private void animateAppearance() {
        this.fApp.getAnimator().animate(AnimationTrack.HILL, new Animation(){

            @Override
            public void step(double d) {
                if (d < 0.5) {
                    NavigationBar.this.fComponent.setBackground(NavigationBar.getDifference(DEFAULT_BACKGROUND, ATTENTION_COLOR, d * 2.0));
                } else if (d > 0.5) {
                    NavigationBar.this.fComponent.setBackground(NavigationBar.getDifference(ATTENTION_COLOR, DEFAULT_BACKGROUND, (d - 0.5) * 2.0));
                }
            }
        });
    }

    private static Color getDifference(Color color, Color color2, double d) {
        return new Color(Math.max(1, (int)((double)color.getRed() + (double)(color2.getRed() - color.getRed()) * d)), Math.max(1, (int)((double)color.getGreen() + (double)(color2.getGreen() - color.getGreen()) * d)), Math.max(1, (int)((double)color.getBlue() + (double)(color2.getBlue() - color.getBlue()) * d)));
    }

    public JComponent getComponent() {
        return this.fComponent;
    }
}

