/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class SidebarLayout
implements LayoutManager2 {
    private final Map<Component, Boolean> fHeadlineFlags;
    private final Predicate<Component> fHeadlinePredicate;
    private final int fPadding;
    private final boolean fGrow;

    public SidebarLayout(Predicate<Component> predicate, int n, boolean bl) {
        this.fPadding = n >= 0 ? n : 0;
        this.fGrow = bl;
        this.fHeadlinePredicate = predicate != null ? predicate : new Predicate<Component>(){

            public boolean accept(Component component) {
                return true;
            }
        };
        this.fHeadlineFlags = new HashMap<Component, Boolean>();
    }

    public SidebarLayout(Predicate<Component> predicate, int n) {
        this(predicate, n, true);
    }

    public SidebarLayout(int n) {
        this(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.layout(container);
        }
    }

    private void layout(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        PreferredInitializer preferredInitializer = new PreferredInitializer(container);
        int[] nArray = preferredInitializer.getHeights();
        int n2 = preferredInitializer.getLeftoverHeight();
        if (this.fGrow && n2 > 0) {
            int n3;
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                if ((!this.isHeadline(componentArray[n3]) || n3 <= 0 || !this.isHeadline(componentArray[n3 - 1])) && this.isHeadline(componentArray[n3])) continue;
                n2 -= this.fPadding;
            }
            if (n2 > 0) {
                n3 = (int)((double)n2 / (double)preferredInitializer.getContentCount());
                for (n = 0; n < componentArray.length; ++n) {
                    if (this.isHeadline(componentArray[n])) continue;
                    int n4 = n;
                    nArray[n4] = nArray[n4] + n3;
                }
            }
        }
        Insets insets = container.getInsets();
        n = insets.top;
        int n5 = container.getWidth() - insets.left - insets.right;
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            boolean bl2 = this.isHeadline(component);
            component.setBounds(insets.left, n, n5, nArray[i]);
            n += nArray[i] + (bl2 && !bl ? 0 : this.fPadding);
            bl = bl2;
        }
    }

    boolean isHeadline(Component component) {
        assert (this.fHeadlineFlags.containsKey(component));
        return this.fHeadlineFlags.containsKey(component) ? this.fHeadlineFlags.get(component) : true;
    }

    private static int constrainHeight(Component component, int n) {
        int n2 = 0;
        if (component.getPreferredSize().height <= n) {
            n2 = component.getPreferredSize().height;
        } else if (component.getMinimumSize() != null) {
            n2 = Math.max(n, component.getMinimumSize().height);
        }
        return n2;
    }

    private static Dimension adjustForInsets(int n, int n2, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    private static int getMaximumPreferredWidth(Container container) {
        int n = 0;
        for (Component component : container.getComponents()) {
            n = Math.max(component.getWidth(), n);
        }
        return n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null && !(object instanceof Boolean)) {
                throw new IllegalArgumentException("Unsupported constraint object");
            }
            boolean bl = object != null ? ((Boolean)object).booleanValue() : this.fHeadlinePredicate.accept((Object)component);
            this.fHeadlineFlags.put(component, bl);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.fHeadlineFlags.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        PreferredInitializer preferredInitializer = new PreferredInitializer(container);
        return SidebarLayout.adjustForInsets(SidebarLayout.getMaximumPreferredWidth(container), preferredInitializer.getTotalHeight(), container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        MinimumInitializer minimumInitializer = new MinimumInitializer(container);
        return SidebarLayout.adjustForInsets(SidebarLayout.getMaximumPreferredWidth(container), minimumInitializer.getTotalHeight(), container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    private static class ComponentTransitionContext {
        private final Container fContainer;
        private final Component fComponent;
        private final Rectangle fStart;
        private final Rectangle fEnd;

        private ComponentTransitionContext(Container container, Component component, Rectangle rectangle, Rectangle rectangle2) {
            this.fContainer = container;
            this.fComponent = component;
            this.fStart = rectangle;
            this.fEnd = rectangle2;
        }
    }

    private class AnimatedComponentPlacementPolicy
    implements ComponentPlacementPolicy {
        private final Map<Component, Rectangle> fPreviousBounds = new HashMap<Component, Rectangle>();
        private final Collection<ComponentTransitionContext> fTransitions = new LinkedList<ComponentTransitionContext>();
        private final Animator fAnimator = new Animator();
        private Animation fAnimation;

        private AnimatedComponentPlacementPolicy() {
        }

        @Override
        public void requestPlacement(Container container, Component component, Rectangle rectangle, int n) {
            Component component2;
            Rectangle rectangle2;
            assert (MJUtilities.isEventDispatchThread());
            if (this.fAnimation != null) {
                this.fAnimation = null;
                this.fTransitions.clear();
            }
            if ((rectangle2 = this.fPreviousBounds.get(component)) == null && (component2 = this.findHeadline(container, n)) != null) {
                rectangle2 = new Rectangle(component2.getX(), component2.getY() + component2.getHeight(), component2.getWidth(), 0);
            }
            this.fTransitions.add(new ComponentTransitionContext(container, component, rectangle2, rectangle));
            this.fPreviousBounds.put(component, rectangle);
        }

        @Override
        public void commitPlacements() {
            final LinkedList<ComponentTransitionContext> linkedList = new LinkedList<ComponentTransitionContext>(this.fTransitions);
            this.fTransitions.clear();
            this.fAnimation = new Animation(){

                @Override
                public void step(double d) {
                    if (AnimatedComponentPlacementPolicy.this.fAnimation == null || !AnimatedComponentPlacementPolicy.this.fAnimation.equals(this)) {
                        return;
                    }
                    for (ComponentTransitionContext componentTransitionContext : linkedList) {
                    }
                }
            };
            this.fAnimator.animate(AnimationTrack.HILL, this.fAnimation);
        }

        private Component findHeadline(Container container, int n) {
            Component[] componentArray = container.getComponents();
            Component component = componentArray[n];
            while (component != null && !SidebarLayout.this.isHeadline(component)) {
                component = n - 1 >= 0 ? componentArray[--n] : null;
            }
            return component;
        }
    }

    private class BasicComponentPlacementPolicy
    implements ComponentPlacementPolicy {
        private BasicComponentPlacementPolicy() {
        }

        @Override
        public void requestPlacement(Container container, Component component, Rectangle rectangle, int n) {
            component.setBounds(rectangle);
        }

        @Override
        public void commitPlacements() {
        }
    }

    private static interface ComponentPlacementPolicy {
        public void requestPlacement(Container var1, Component var2, Rectangle var3, int var4);

        public void commitPlacements();
    }

    private class MinimumInitializer
    extends HeightInitializer {
        MinimumInitializer(Container container) {
            super(container);
        }

        @Override
        public int initializeHeights(Component[] componentArray, int[] nArray, int n) {
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                nArray[i] = SidebarLayout.this.isHeadline(component) ? SidebarLayout.constrainHeight(componentArray[i], n) : (component.getMinimumSize() != null ? component.getMinimumSize().height : 0);
                n -= nArray[i];
            }
            return n;
        }
    }

    private class PreferredInitializer
    extends HeightInitializer {
        PreferredInitializer(Container container) {
            super(container);
        }

        @Override
        public int initializeHeights(Component[] componentArray, int[] nArray, int n) {
            for (int i = 0; i < componentArray.length; ++i) {
                nArray[i] = SidebarLayout.constrainHeight(componentArray[i], n);
                n -= nArray[i];
            }
            return n;
        }
    }

    private abstract class HeightInitializer {
        private final int fAvailableHeight;
        private final int fLeftoverHeight;
        private final int fBoundaryCount;
        private final int fContentCount;
        private final int[] fHeights;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HeightInitializer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Component[] componentArray = container.getComponents();
                this.fBoundaryCount = this.calcBoundaryCount(componentArray);
                Insets insets = container.getInsets();
                this.fAvailableHeight = container.getHeight() - insets.top - insets.bottom - this.fBoundaryCount * SidebarLayout.this.fPadding;
                this.fHeights = new int[componentArray.length];
                this.fLeftoverHeight = this.initializeHeights(componentArray, this.fHeights, this.fAvailableHeight);
                int n = 0;
                for (Component component : componentArray) {
                    if (SidebarLayout.this.isHeadline(component)) continue;
                    ++n;
                }
                this.fContentCount = n;
            }
        }

        private int calcBoundaryCount(Component[] componentArray) {
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < componentArray.length; ++i) {
                boolean bl2 = SidebarLayout.this.isHeadline(componentArray[i]);
                if (bl != bl2 && i > 0) {
                    ++n;
                }
                bl = bl2;
            }
            return n;
        }

        int getAvailableHeight() {
            return this.fAvailableHeight;
        }

        int getLeftoverHeight() {
            return this.fLeftoverHeight;
        }

        int getBoundaryCount() {
            return this.fBoundaryCount;
        }

        int getContentCount() {
            return this.fContentCount;
        }

        int getTotalHeight() {
            int n = 0;
            for (int n2 : this.fHeights) {
                n += n2;
            }
            return n;
        }

        int[] getHeights() {
            return this.fHeights;
        }

        abstract int initializeHeights(Component[] var1, int[] var2, int var3);
    }
}

