/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.verification;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.impl.StringSource;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.project.impl.logui.BuildProgressTextArea;
import com.mathworks.project.impl.logui.LogDisplay;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.verification.TestOutputArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public final class TestOutputPanel
implements TestOutputArea {
    private final CoderApp fApp;
    private final Runnable fDisplay;
    private final MJPanel fComponent;
    private final BuildProgressTextArea fOriginalOutput;
    private final BuildProgressTextArea fGeneratedOutput;
    private final MJScrollPane fOriginalOutputScroller;
    private final MJScrollPane fGeneratedOutputScroller;
    private final MJButton fCompareButton;
    private final MJPanel fButtonWrapper;
    private final MJLabel fOriginalLabel;
    private final MJLabel fGeneratedLabel;

    public TestOutputPanel(CoderApp coderApp, Runnable runnable) {
        this.fApp = coderApp;
        this.fDisplay = runnable;
        this.fComponent = new MJPanel();
        this.fOriginalOutput = new BuildProgressTextArea();
        this.fGeneratedOutput = new BuildProgressTextArea();
        this.fOriginalOutputScroller = new MJScrollPane((Component)this.fOriginalOutput.getComponent());
        this.fOriginalOutputScroller.setBorder((Border)new LineBorder(new Color(215, 215, 215)));
        this.fGeneratedOutputScroller = new MJScrollPane((Component)this.fGeneratedOutput.getComponent());
        this.fGeneratedOutputScroller.setBorder((Border)new LineBorder(new Color(215, 215, 215)));
        this.fCompareButton = new MJButton(CoderResources.getIcon("compare_ts_24.png"));
        this.fCompareButton.setToolTipText(CoderResources.getString("wfa.test.compareOutput"));
        this.fCompareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestOutputPanel.this.compareOutput();
            }
        });
        this.fButtonWrapper = new MJPanel((LayoutManager)new FormLayout("fill:d", "0dlu:grow, fill:d, 0dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fButtonWrapper.add((Component)this.fCompareButton, (Object)cellConstraints.xy(1, 2));
        this.fOriginalLabel = new MJLabel(CoderResources.getString("wfa.test.originalOutput"));
        this.fOriginalLabel.setFont(CoderApp.getFont().deriveFont((float)(CoderApp.getFont().getSize() - 1)));
        this.fGeneratedLabel = new MJLabel(CoderResources.getString("wfa.test.generatedOutput"));
        this.fGeneratedLabel.setFont(CoderApp.getFont().deriveFont((float)(CoderApp.getFont().getSize() - 1)));
    }

    public void setMode(TestOutputArea.Mode mode) {
        this.fComponent.removeAll();
        if (mode == TestOutputArea.Mode.BOTH) {
            this.fComponent.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu, fill:d, 3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            this.fComponent.add((Component)this.fOriginalLabel, (Object)cellConstraints.xy(2, 2));
            this.fComponent.add((Component)this.fOriginalOutputScroller, (Object)cellConstraints.xy(2, 4));
            this.fComponent.add((Component)this.fButtonWrapper, (Object)cellConstraints.xy(4, 4));
            this.fComponent.add((Component)this.fGeneratedLabel, (Object)cellConstraints.xy(6, 2));
            this.fComponent.add((Component)this.fGeneratedOutputScroller, (Object)cellConstraints.xy(6, 4));
            this.fComponent.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(220, 220, 220));
                    graphics.drawLine(0, 0, component.getWidth(), 0);
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(1, 0, 0, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
        } else {
            this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.fComponent.add((Component)(mode == TestOutputArea.Mode.ORIGINAL_OUTPUT ? this.fOriginalOutputScroller : this.fGeneratedOutputScroller));
            this.fComponent.setBorder(null);
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void display(TestOutputArea.Mode mode) {
        this.setMode(mode);
        this.fDisplay.run();
    }

    @Override
    public LogDisplay getOriginalOutput() {
        return this.fOriginalOutput.getDisplay();
    }

    @Override
    public LogDisplay getGeneratedOutput() {
        return this.fGeneratedOutput.getDisplay();
    }

    private void compareOutput() {
        StringSource stringSource = new StringSource(CoderResources.getString("wfa.test.diff.original"), this.fOriginalOutput.getPlainText(), null);
        StringSource stringSource2 = new StringSource(CoderResources.getString("wfa.test.diff.generated"), this.fGeneratedOutput.getPlainText(), null);
        ComparisonUtilities.startComparison((ComparisonSource)stringSource, (ComparisonSource)stringSource2);
    }
}

