/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.coder.app.CoderRegistry;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class CoderScrollPane
extends MJScrollPane {
    private static final AWTEventListener GLOBAL_LISTENER = new GlobalMouseWheelAwtListener();
    private static final Set<MouseWheelEvent> REDIRECTED_EVENTS = new HashSet<MouseWheelEvent>();
    private static final Set<CoderScrollPane> ACTIVE_SCROLLPANES = new HashSet<CoderScrollPane>();
    private static boolean sActive;
    private Map<MouseWheelListener, MouseWheelListener> fListenerProxies;
    private Rectangle fAbsoluteBounds;

    public CoderScrollPane() {
    }

    public CoderScrollPane(Component component) {
        super(component);
    }

    public CoderScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
    }

    public CoderScrollPane(int n, int n2) {
        super(n, n2);
    }

    public final void removeNotify() {
        ACTIVE_SCROLLPANES.remove((Object)this);
        CoderScrollPane.enableOrDisableIfNecessary();
        super.removeNotify();
    }

    public final void addNotify() {
        ACTIVE_SCROLLPANES.add(this);
        CoderScrollPane.enableOrDisableIfNecessary();
        super.addNotify();
    }

    private static void enableOrDisableIfNecessary() {
        boolean bl;
        boolean bl2 = bl = !ACTIVE_SCROLLPANES.isEmpty() && CoderRegistry.getInstance().getActiveCount() > 0;
        if (sActive != bl) {
            if (bl) {
                Toolkit.getDefaultToolkit().addAWTEventListener(GLOBAL_LISTENER, 131072L);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(GLOBAL_LISTENER);
            }
            sActive = bl;
        }
    }

    private static boolean isValidWindow(Window window) {
        return window != null && window instanceof MJFrame && CoderRegistry.getInstance().isCoderWindow(window) && window.isFocused();
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.isShowing()) {
            Point point = this.getLocationOnScreen();
            this.fAbsoluteBounds = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        } else {
            this.fAbsoluteBounds = null;
        }
    }

    public final void addMouseWheelListener(final MouseWheelListener mouseWheelListener) {
        MouseWheelListener mouseWheelListener2 = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Window window = SwingUtilities.windowForComponent((Component)mouseWheelEvent.getSource());
                if (CoderScrollPane.isValidWindow(window)) {
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    if (CoderScrollPane.this.fAbsoluteBounds != null && CoderScrollPane.this.fAbsoluteBounds.contains(point)) {
                        mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                    }
                }
            }
        };
        if (this.fListenerProxies == null) {
            this.fListenerProxies = new HashMap<MouseWheelListener, MouseWheelListener>();
        }
        this.fListenerProxies.put(mouseWheelListener2, mouseWheelListener);
        super.addMouseWheelListener(mouseWheelListener2);
    }

    public final void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        super.removeMouseWheelListener(this.fListenerProxies.remove(mouseWheelListener));
    }

    private static CoderScrollPane findCoderScrollPane(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof CoderScrollPane)) continue;
            return (CoderScrollPane)((Object)component2);
        }
        return null;
    }

    static {
        CoderRegistry.getInstance().addChangeObserver(new Runnable(){

            @Override
            public void run() {
                CoderScrollPane.enableOrDisableIfNecessary();
            }
        });
        CoderScrollPane.enableOrDisableIfNecessary();
    }

    private static class GlobalMouseWheelAwtListener
    implements AWTEventListener {
        private GlobalMouseWheelAwtListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            assert (aWTEvent instanceof MouseWheelEvent) : "Proper event mask not passed on addAwtEventListener call";
            if (!(aWTEvent.getSource() instanceof Component) || REDIRECTED_EVENTS.contains(aWTEvent)) {
                REDIRECTED_EVENTS.remove(aWTEvent);
                return;
            }
            Component component = (Component)aWTEvent.getSource();
            Window window = SwingUtilities.getWindowAncestor(component);
            if (CoderScrollPane.isValidWindow(window)) {
                CoderScrollPane coderScrollPane;
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
                Point point = SwingUtilities.convertPoint(component, mouseWheelEvent.getPoint(), window);
                Component component2 = SwingUtilities.getDeepestComponentAt(window, point.x, point.y);
                if (component2 != null && (coderScrollPane = CoderScrollPane.findCoderScrollPane(component2)) != null) {
                    point = SwingUtilities.convertPoint(window, point, (Component)((Object)coderScrollPane));
                    MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent((Component)((Object)coderScrollPane), 507, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                    REDIRECTED_EVENTS.add(mouseWheelEvent2);
                    coderScrollPane.dispatchEvent(mouseWheelEvent2);
                    mouseWheelEvent.consume();
                }
            }
        }
    }
}

