/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolbox.coder.widgets.Transition;
import com.mathworks.toolbox.coder.widgets.TransitionFactory;
import com.mathworks.toolbox.coder.widgets.TransitionTarget;
import com.mathworks.util.Converter;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Collection;
import java.util.LinkedList;

public final class Transitions {
    private Transitions() {
    }

    private static BufferedImage paintIntoImage(TransitionTarget transitionTarget) {
        Dimension dimension = transitionTarget.getTargetSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = new Dimension(1, 1);
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        transitionTarget.paintTarget(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage createFittedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = Math.max(bufferedImage.getWidth(), bufferedImage.getHeight());
        int n2 = Math.max(bufferedImage.getHeight(), bufferedImage.getWidth());
        return new BufferedImage(n, n2, bufferedImage.getType() == bufferedImage2.getType() ? bufferedImage.getType() : 2);
    }

    public static Kernel createGaussianKernel(int n, double d) {
        int n2;
        int n3;
        float[] fArray = new float[n * n];
        float f = 0.0f;
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                fArray[n3 * n + n2] = (float)Math.exp(-1.0 * (Math.pow(n3, 2.0) + Math.pow(n2, 2.0)) / 2.0 / Math.pow(d, 2.0));
                f += fArray[n3 * n + n2];
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = n3 * n + n2;
                fArray[n4] = fArray[n4] / f;
            }
        }
        return new Kernel(n, n, fArray);
    }

    public static TransitionFactory createFrozenStateTransitionFactory() {
        return new TransitionFactory(){

            @Override
            public Transition createTransition(TransitionTarget transitionTarget, TransitionTarget transitionTarget2, Runnable runnable) {
                transitionTarget.init();
                final BufferedImage bufferedImage = Transitions.paintIntoImage(transitionTarget);
                return new AbstractTransition(){

                    @Override
                    public void paintTransition(Graphics2D graphics2D, int n, int n2) {
                        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    }

                    @Override
                    public void start() {
                        this.runStartTasks();
                        this.runCompletionTasks();
                    }
                };
            }
        };
    }

    public static TransitionFactory createFadeTransitionFactory(AnimationTrack animationTrack) {
        return new AnimatorTransitionFactory(animationTrack, new FadeTransitionImplStrategy());
    }

    public static TransitionFactory createBlurTransitionFactory(AnimationTrack animationTrack) {
        return new AnimatorTransitionFactory(animationTrack, new BlurTransitionImplStrategy());
    }

    private static interface TransitionImplStrategy {
        public void performTransition(Graphics2D var1, BufferedImage var2, BufferedImage var3, Dimension var4, double var5);
    }

    private static class AnimatorTransition
    extends AbstractTransition {
        private final AnimationTrack fEasingFunction;
        private final Animator fAnimator;
        private final TransitionImplStrategy fStrategy;
        private final TransitionTarget fStartTarget;
        private final TransitionTarget fEndTarget;
        private final Runnable fUpdateListener;
        private BufferedImage fBuffer;

        private AnimatorTransition(AnimationTrack animationTrack, TransitionImplStrategy transitionImplStrategy, TransitionTarget transitionTarget, TransitionTarget transitionTarget2, Runnable runnable) {
            this.fEasingFunction = animationTrack;
            this.fUpdateListener = runnable;
            this.fStrategy = transitionImplStrategy;
            this.fStartTarget = transitionTarget;
            this.fEndTarget = transitionTarget2;
            this.fAnimator = new Animator();
        }

        @Override
        public void paintTransition(Graphics2D graphics2D, int n, int n2) {
            graphics2D.clearRect(0, 0, n, n2);
            if (this.fBuffer != null) {
                graphics2D.drawImage((Image)this.fBuffer, 0, 0, null);
            }
        }

        @Override
        public void start() {
            this.runStartTasks();
            this.fStartTarget.init();
            this.fEndTarget.init();
            final BufferedImage bufferedImage = Transitions.paintIntoImage(this.fStartTarget);
            final BufferedImage bufferedImage2 = Transitions.paintIntoImage(this.fEndTarget);
            this.fAnimator.animate(this.fEasingFunction, new Animation(){

                @Override
                public void step(double d) {
                    AnimatorTransition.this.fBuffer = Transitions.createFittedImage(bufferedImage, bufferedImage2);
                    Graphics2D graphics2D = AnimatorTransition.this.fBuffer.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    AnimatorTransition.this.fStrategy.performTransition(graphics2D, bufferedImage, bufferedImage2, new Dimension(AnimatorTransition.this.fBuffer.getWidth(), AnimatorTransition.this.fBuffer.getHeight()), d);
                    graphics2D.dispose();
                    AnimatorTransition.this.fUpdateListener.run();
                    if (d >= 1.0) {
                        AnimatorTransition.this.runCompletionTasks();
                    }
                }
            });
        }
    }

    private static abstract class AbstractTransition
    implements Transition {
        private final Collection<Runnable> fCompletionTasks = new LinkedList<Runnable>();
        private final Collection<Runnable> fStartTasks = new LinkedList<Runnable>();

        AbstractTransition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void addCompletionTask(Runnable runnable) {
            Collection<Runnable> collection = this.fCompletionTasks;
            synchronized (collection) {
                this.fCompletionTasks.add(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void addInitialTask(Runnable runnable) {
            Collection<Runnable> collection = this.fStartTasks;
            synchronized (collection) {
                this.fStartTasks.add(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void runStartTasks() {
            Collection<Runnable> collection = this.fStartTasks;
            synchronized (collection) {
                for (Runnable runnable : this.fStartTasks) {
                    runnable.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void runCompletionTasks() {
            Collection<Runnable> collection = this.fCompletionTasks;
            synchronized (collection) {
                for (Runnable runnable : this.fCompletionTasks) {
                    runnable.run();
                }
            }
        }
    }

    private static class AnimatorTransitionFactory
    implements TransitionFactory {
        private final TransitionImplStrategy fStrategy;
        private final AnimationTrack fEasingFunction;

        AnimatorTransitionFactory(AnimationTrack animationTrack, TransitionImplStrategy transitionImplStrategy) {
            this.fStrategy = transitionImplStrategy;
            this.fEasingFunction = animationTrack;
        }

        @Override
        public Transition createTransition(TransitionTarget transitionTarget, TransitionTarget transitionTarget2, Runnable runnable) {
            return new AnimatorTransition(this.fEasingFunction, this.fStrategy, transitionTarget, transitionTarget2, runnable);
        }
    }

    private static class BlurTransitionImplStrategy
    implements TransitionImplStrategy {
        private final Converter<Double, Double> fSigmaFunction;
        private final TransitionImplStrategy fBaseStrategy;

        BlurTransitionImplStrategy(Converter<Double, Double> converter) {
            this.fSigmaFunction = converter;
            this.fBaseStrategy = new FadeTransitionImplStrategy();
        }

        BlurTransitionImplStrategy() {
            this(new Converter<Double, Double>(){

                public Double convert(Double d) {
                    return 0.5 - Math.abs(0.5 - d) * 6.0;
                }
            });
        }

        @Override
        public void performTransition(Graphics2D graphics2D, BufferedImage bufferedImage, BufferedImage bufferedImage2, Dimension dimension, double d) {
            BufferedImage bufferedImage3 = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D2 = bufferedImage3.createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.fBaseStrategy.performTransition(graphics2D2, bufferedImage, bufferedImage2, dimension, d);
            graphics2D2.dispose();
            BufferedImage bufferedImage4 = new BufferedImage(dimension.width, dimension.height, 2);
            Kernel kernel = Transitions.createGaussianKernel(4, (Double)this.fSigmaFunction.convert((Object)d));
            ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
            convolveOp.filter(bufferedImage3, bufferedImage4);
            graphics2D.drawImage((Image)bufferedImage4, 0, 0, null);
        }
    }

    private static class FadeTransitionImplStrategy
    implements TransitionImplStrategy {
        private FadeTransitionImplStrategy() {
        }

        @Override
        public void performTransition(Graphics2D graphics2D, BufferedImage bufferedImage, BufferedImage bufferedImage2, Dimension dimension, double d) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - d)));
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        }
    }
}

