/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import java.io.Closeable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;

public class MWSequenceFileHeader {
    private SequenceFile.Reader reader = null;

    public void openFile(String file) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)URI.create(file), (Configuration)conf);
        Path path = new Path(file);
        this.reader = new SequenceFile.Reader(fs, path, conf);
    }

    public String getKeyClassName() throws Exception {
        return this.reader.getKeyClassName();
    }

    public String getValueClassName() throws Exception {
        return this.reader.getValueClassName();
    }

    public void closeFile() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.reader = null;
        }
    }

    protected void finalize() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.reader = null;
        }
    }

    public void dispose() {
        if (this.reader != null) {
            IOUtils.closeStream((Closeable)this.reader);
            this.reader = null;
        }
    }
}

