/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.debug.Debug;
import ice.ssl.ConnectionState;
import ice.ssl.SessionState;
import ice.ssl.SimpleKey;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

final class WriteRecord
extends FilterOutputStream {
    private boolean I;
    private SessionState J;
    private ConnectionState OEAB;
    private Cipher append;
    private boolean arraycopy;
    private Key blockCipher;
    private ByteArrayOutputStream bulkCipherAlgorithm = new ByteArrayOutputStream();
    private int bulkCipherAlgorithmName = 0;

    public WriteRecord(OutputStream outputStream, SessionState sessionState, ConnectionState connectionState) {
        super(outputStream);
        this.J = sessionState;
        this.OEAB = connectionState;
    }

    public void setHandshake(boolean bl) throws IOException {
        if (this.arraycopy && !bl) {
            this.arraycopy = bl;
            this.bulkCipherAlgorithm.flush();
        }
        this.arraycopy = bl;
    }

    public void close() throws IOException {
        this.I = true;
        super.close();
    }

    public void setStates(ConnectionState connectionState, SessionState sessionState) {
        block10: {
            block9: {
                if (sessionState.nowProto == 1) {
                    connectionState.clientSeqNum = this.OEAB.clientSeqNum;
                }
                this.OEAB = connectionState;
                this.J = sessionState;
                this.append = null;
                if (sessionState.bulkCipherAlgorithm == 0) {
                    return;
                }
                try {
                    if (!sessionState.blockCipher) {
                        this.append = Cipher.getInstance(sessionState.bulkCipherAlgorithmName);
                    } else {
                        Cipher cipher = Cipher.getInstance(sessionState.bulkCipherAlgorithmName + "/CBC");
                        ((FeedbackCipher)((Object)cipher)).setInitializationVector(sessionState.clientWriteIV);
                        this.append = cipher;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!Debug.ex) break block9;
                    Debug.ex((Throwable)noSuchAlgorithmException);
                }
            }
            if (this.append != null) {
                this.blockCipher = new SimpleKey(sessionState.bulkCipherAlgorithmName, connectionState.clientWriteKey);
                try {
                    this.append.initEncrypt(this.blockCipher);
                }
                catch (KeyException keyException) {
                    if (!Debug.ex) break block10;
                    Debug.ex((Throwable)keyException);
                }
            }
        }
    }

    SessionState getSessionState() {
        return this.J;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(23, byArray2);
    }

    void write(int n, byte[] byArray) throws IOException {
        if (n < 20 || n > 23) {
            throw new IllegalArgumentException("Unknown content type : " + n);
        }
        if (n == 23 && this.arraycopy) {
            if (this.bulkCipherAlgorithm != null) {
                this.bulkCipherAlgorithm.write(byArray);
                throw new IOException("error in WriteRecord");
            }
            return;
        }
        if (this.J.nowProto == 1) {
            this.OEAB(n, byArray);
            return;
        }
        int n2 = byArray.length / 16384 + (byArray.length % 16384 == 0 ? 0 : 1);
        int n3 = 0;
        while (n3 < n2) {
            byte[] byArray2 = new byte[Math.min(byArray.length - n3 * 16384, 16384)];
            System.arraycopy(byArray, n3 * 16384, byArray2, 0, byArray2.length);
            byArray2 = this.I(n, this.J(byArray2));
            byte[] byArray3 = new byte[5 + byArray2.length];
            byArray3[0] = (byte)n;
            byArray3[1] = (byte)Util.majorVersion(this.J.nowProto);
            byArray3[2] = (byte)Util.minorVersion(this.J.nowProto);
            byArray3[3] = (byte)(byArray2.length >> 8);
            byArray3[4] = (byte)(byArray2.length & 0xFF);
            System.arraycopy(byArray2, 0, byArray3, 5, byArray2.length);
            if (!this.I) {
                this.out.write(byArray3);
            }
            ++this.OEAB.clientSeqNum;
            ++n3;
        }
    }

    public void write(byte by) throws IOException {
    }

    private byte[] I(int n, byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3 = Util.v3generateHash(false, this.J, this.OEAB, n, byArray);
        if (!this.J.blockCipher) {
            byArray2 = new byte[byArray.length + byArray3.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(byArray3, 0, byArray2, byArray.length, byArray3.length);
        } else {
            int n2 = byArray.length + byArray3.length;
            int n3 = 7 - n2 % 8;
            byArray2 = new byte[n2 + n3 + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(byArray3, 0, byArray2, byArray.length, byArray3.length);
            int n4 = n2;
            while (n4 < n3) {
                byArray2[n4] = (byte)n3;
                ++n4;
            }
            byArray2[n2 + n3] = (byte)n3;
        }
        if (this.append == null) {
            return byArray2;
        }
        return this.append.crypt(byArray2);
    }

    private byte[] J(byte[] byArray) {
        return byArray;
    }

    private void OEAB(int n, byte[] byArray) throws IOException {
        int n2 = (byArray.length - 1) / 16384 + 1;
        int n3 = 0;
        while (n3 < n2) {
            byte[] byArray2;
            byte[] byArray3 = new byte[Math.min(byArray.length - n3 * 16384, 16384)];
            System.arraycopy(byArray, n3 * 16384, byArray3, 0, byArray3.length);
            byArray3 = this.append(n, byArray3);
            if (this.bulkCipherAlgorithmName == 0) {
                byArray2 = new byte[2 + byArray3.length];
                byArray2[0] = (byte)(byArray3.length >> 8 | 0x80);
                byArray2[1] = (byte)(byArray3.length & 0xFF);
                System.arraycopy(byArray3, 0, byArray2, 2, byArray3.length);
            } else {
                byArray2 = new byte[3 + byArray3.length];
                byArray2[0] = (byte)(byArray3.length >> 8);
                byArray2[1] = (byte)(byArray3.length & 0xFF);
                byArray2[2] = (byte)this.bulkCipherAlgorithmName;
                System.arraycopy(byArray3, 0, byArray2, 3, byArray3.length);
            }
            if (!this.I) {
                this.out.write(byArray2);
            }
            ++this.OEAB.clientSeqNum;
            ++n3;
        }
    }

    private byte[] append(int n, byte[] byArray) {
        if (this.J.blockCipher) {
            int n2 = byArray.length + this.J.hashSize;
            int n3 = 8;
            this.bulkCipherAlgorithmName = n3 - n2 % n3;
            byte[] byArray2 = new byte[byArray.length + this.bulkCipherAlgorithmName];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        } else {
            this.bulkCipherAlgorithmName = 0;
        }
        byte[] byArray3 = Util.v2generateHash(false, this.J, this.OEAB, byArray);
        byte[] byArray4 = new byte[byArray.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        if (this.append == null) {
            return byArray4;
        }
        return this.append.crypt(byArray4);
    }
}

