/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.TreeNodeData;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableNodeDataRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TreeTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private TreeList treeList;
    private boolean showExpanderForEmptyParent;
    private final TreeTableCellPanel component = new TreeTableCellPanel();
    private final TreeNodeData treeNodeData = new TreeNodeData();

    public TreeTableCellRenderer(TableCellRenderer delegate, TreeList treeList) {
        this.delegate = delegate == null ? this.createDelegateRenderer() : delegate;
        this.treeList = treeList;
    }

    protected TableCellRenderer createDelegateRenderer() {
        return new DefaultTableCellRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.treeList.getReadWriteLock().readLock().lock();
        try {
            this.treeNodeData.setDepth(this.treeList.depth(row));
            this.treeNodeData.setExpanded(this.treeList.isExpanded(row));
            this.treeNodeData.setHasChildren(this.treeList.hasChildren(row));
            this.treeNodeData.setAllowsChildren(this.treeList.getAllowsChildren(row));
        }
        finally {
            this.treeList.getReadWriteLock().readLock().unlock();
        }
        if (this.delegate instanceof TreeTableNodeDataRenderer) {
            ((TreeTableNodeDataRenderer)this.delegate).setTreeNodeData(this.treeNodeData);
        }
        Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.component.configure(this.treeNodeData, this.showExpanderForEmptyParent, c, hasFocus);
        return this.component;
    }

    void setShowExpanderForEmptyParent(boolean b) {
        this.showExpanderForEmptyParent = b;
    }

    void setDelegate(TableCellRenderer delegate) {
        this.delegate = delegate;
    }

    public TableCellRenderer getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        this.delegate = null;
        this.treeList = null;
    }
}

