/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class MWGroupbox
extends MWPanel {
    public static final int ETCHED = 0;
    public static final int EMBOSSED = 1;
    public static final int RAISED = 2;
    public static final int RECESSED = 3;
    public static final int SIMPLE = 4;
    public static final int NONE = 5;
    public static final int EDGE_NONE = 0;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_LEFT = 2;
    public static final int EDGE_BOTTOM = 3;
    public static final int EDGE_RIGHT = 4;
    private static final int DEFAULT_OFFSET = 4;
    private static final int DEFAULT_MARGIN = 8;
    private static int sAppearance = -1;
    private static Color sTextColor;
    private static Color sHilite;
    private static Color sShadow;
    private static Color sLtHilite;
    private static Color sDkShadow;
    private String fLabel;
    private int fStyle;
    private int fLabelOffset;
    private int fHiddenEdge;
    private Insets fMargins;
    private boolean fIncludeFontInInsets;
    private Insets fBorderInsets;
    private int fBaseline;
    private int fLabelWidth;
    private static final Color EDGE_COLOR_XP;
    private static final Color[] WINDOW_TEXT_XP;
    private static final Color XP_EDGE_COLOR;
    private static final Color XP_EDGE_COLOR_SILVER;

    public MWGroupbox(String string, int n) {
        this.setOpaqueInsets(false);
        this.fLabel = string;
        this.fStyle = n;
        this.fMargins = new Insets(8, 8, 8, 8);
        this.fLabelOffset = 4;
        this.fHiddenEdge = 0;
        this.fIncludeFontInInsets = false;
        this.fBorderInsets = null;
        this.setFont(Decorations.getFont(0));
        if (!PlatformInfo.useWindowsXPAppearance()) {
            this.setBackground(Decorations.getColor(6));
        }
        this.addContainerListener(new EventHandler());
    }

    public MWGroupbox(String string) {
        this(string, 0);
    }

    public MWGroupbox() {
        this("", 0);
    }

    private void calcBorderInsets() {
        switch (this.fStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fBorderInsets = new Insets(2, 2, 2, 2);
                break;
            }
            case 4: {
                this.fBorderInsets = new Insets(1, 1, 1, 1);
                break;
            }
            default: {
                this.fBorderInsets = new Insets(0, 0, 0, 0);
            }
        }
        switch (this.fHiddenEdge) {
            case 1: {
                this.fBorderInsets.top = 0;
                break;
            }
            case 2: {
                this.fBorderInsets.left = 0;
                break;
            }
            case 3: {
                this.fBorderInsets.bottom = 0;
                break;
            }
            case 4: {
                this.fBorderInsets.right = 0;
            }
        }
        if (this.fHiddenEdge != 1 && (this.fLabel != null && this.fLabel.length() > 0 || this.fIncludeFontInInsets)) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.fBaseline = fontMetrics.getMaxAscent();
            this.fBorderInsets.top = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.fLabelWidth = fontMetrics.stringWidth(this.fLabel) + this.fBorderInsets.left + this.fBorderInsets.right;
        } else {
            this.fBaseline = 0;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        if (dimension != null && dimension.width < (n = this.fLabelWidth + this.fLabelOffset + this.fLabelOffset + 2)) {
            dimension.width = n;
        }
        return dimension;
    }

    public int getHiddenEdge() {
        return this.fHiddenEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHiddenEdge(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                MWGroupbox mWGroupbox = this;
                synchronized (mWGroupbox) {
                    this.fHiddenEdge = n;
                    this.fBorderInsets = null;
                }
                this.repaint(5L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown edge: " + n);
            }
        }
    }

    public boolean getIncludeFontInInsets() {
        return this.fIncludeFontInInsets;
    }

    public void setIncludeFontInInsets(boolean bl) {
        this.fIncludeFontInInsets = bl;
        this.repaint(5L);
    }

    public String getLabel() {
        return this.fLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        MWGroupbox mWGroupbox = this;
        synchronized (mWGroupbox) {
            this.fLabel = string;
            this.fBorderInsets = null;
        }
        this.repaint(5L);
    }

    public int getStyle() {
        return this.fStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                MWGroupbox mWGroupbox = this;
                synchronized (mWGroupbox) {
                    this.fStyle = n;
                    this.fBorderInsets = null;
                }
                this.repaint(5L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown style: " + n);
            }
        }
    }

    public Insets getMargins() {
        return this.fMargins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMargins(Insets insets) {
        MWGroupbox mWGroupbox = this;
        synchronized (mWGroupbox) {
            this.fMargins = insets;
        }
    }

    @Override
    public final Insets getInsets() {
        Insets insets = new Insets(this.fMargins.top, this.fMargins.left, this.fMargins.bottom, this.fMargins.right);
        if (this.fBorderInsets == null) {
            this.calcBorderInsets();
        }
        insets.top += this.fBorderInsets.top;
        insets.left += this.fBorderInsets.left;
        insets.bottom += this.fBorderInsets.bottom;
        insets.right += this.fBorderInsets.right;
        return insets;
    }

    private void initColors() {
        if (sAppearance != PlatformInfo.getAppearance()) {
            if (!PlatformInfo.useWindowsXPAppearance()) {
                sTextColor = Decorations.getColor(12);
                sHilite = Decorations.getColor(8);
                sShadow = Decorations.getColor(9);
                sLtHilite = Decorations.getColor(7);
                sDkShadow = Decorations.getColor(10);
            } else {
                sTextColor = WINDOW_TEXT_XP[PlatformInfo.getWindowsXPScheme()];
                sHilite = EDGE_COLOR_XP;
                sShadow = EDGE_COLOR_XP;
                sLtHilite = EDGE_COLOR_XP;
                sDkShadow = EDGE_COLOR_XP;
            }
            sAppearance = PlatformInfo.getAppearance();
        }
    }

    private void drawTopEdge(Graphics graphics) {
        if (this.fBorderInsets.top > 0) {
            int n;
            int n2;
            Insets insets = this.fBorderInsets;
            int n3 = this.getSize().width;
            int n4 = this.fBorderInsets.left;
            int n5 = n2 = n4 + this.fLabelOffset;
            int n6 = n3 - this.fBorderInsets.right;
            int n7 = this.fBaseline > 0 ? this.fBaseline : this.fBorderInsets.top;
            int n8 = this.fBorderInsets.top;
            boolean bl = PlatformInfo.getPlatform() == 0;
            graphics.setColor(this.getBackground());
            switch (this.fStyle) {
                case 5: {
                    graphics.fillRect(0, 0, n3, insets.top);
                    break;
                }
                case 4: {
                    graphics.fillRect(0, 0, n3, n7 - 1);
                    graphics.fillRect(insets.left, n7, n3 - insets.left - insets.right, insets.top - n7);
                    break;
                }
                default: {
                    graphics.fillRect(0, 0, n3, n7 - 2);
                    graphics.fillRect(insets.left, n7, n3 - insets.left - insets.right, insets.top - n7);
                }
            }
            if (this.fLabel != null && this.fLabel.length() > 0) {
                graphics.setFont(this.getFont());
                n5 += graphics.getFontMetrics().stringWidth(this.fLabel) + 4;
                if (this.fStyle == 4) {
                    graphics.drawLine(n2, n7 - 1, n5 - 1, n7 - 1);
                } else if (this.fStyle != 5) {
                    graphics.drawLine(n2, n7 - 1, n5 - 1, n7 - 1);
                    graphics.drawLine(n2, n7 - 2, n5 - 1, n7 - 2);
                }
                n = bl ? n7 : n7 + (n7 >> 1) - 2;
                graphics.setColor(sTextColor);
                graphics.drawString(this.fLabel, n2 + 2, n);
            }
            if (PlatformInfo.useWindowsXPAppearance() && this.fHiddenEdge == 0 && this.fStyle != 5) {
                if (PlatformInfo.getWindowsXPScheme() == 2) {
                    graphics.setColor(XP_EDGE_COLOR_SILVER);
                } else {
                    graphics.setColor(XP_EDGE_COLOR);
                }
                if (n7 + 1 < n8) {
                    graphics.drawLine(0, n7 + 1, 0, n8);
                    graphics.drawLine(n6, n7 + 1, n6, n8);
                }
                if (n4 < n2) {
                    graphics.drawLine(n4, n7 - 1, n2 - 1, n7 - 1);
                }
                if (n5 < n6) {
                    graphics.drawLine(n5, n7 - 1, n6 - 2, n7 - 1);
                }
                graphics.drawLine(1, n7, 2, n7);
                graphics.drawLine(n6 - 2, n7, n6 - 1, n7);
                graphics.drawLine(1, n7 + 1, 1, n7 + 1);
                graphics.drawLine(n6 - 1, n7 + 1, n6 - 1, n7 + 1);
                graphics.setColor(this.getBackground());
                if (n7 + 2 < n8 && insets.left > 1) {
                    graphics.drawLine(1, n7 + 2, 1, n8);
                }
                graphics.drawLine(0, n7 - 1, n4 - 1, n7 - 1);
                graphics.drawLine(n6 - 1, n7 - 1, n6, n7 - 1);
                graphics.drawLine(0, n7, 0, n7);
                graphics.drawLine(n6, n7, n6, n7);
                if (insets.top > 1) {
                    graphics.drawLine(0, n7 - 2, n4 - 1, n7 - 2);
                    graphics.drawLine(n6 - 1, n7 - 2, n6, n7 - 2);
                    if (n4 < n2) {
                        graphics.drawLine(n4, n7 - 2, n2 - 1, n7 - 2);
                    }
                    if (n5 < n6) {
                        graphics.drawLine(n5, n7 - 2, n6 - 2, n7 - 2);
                    }
                }
            } else {
                switch (this.fStyle) {
                    case 0: 
                    case 1: {
                        n = n7 - 1;
                        graphics.setColor(this.fStyle == 1 ? sShadow : sLtHilite);
                        if (n4 > 0) {
                            graphics.drawLine(n4 - 1, n, n4 - 1, n8 - 1);
                        }
                        if (n4 < n2) {
                            graphics.drawLine(n4, n, n2 - 1, n);
                        }
                        if (n5 < n6) {
                            graphics.drawLine(n5, n, n6 - 1, n);
                        }
                        if (this.fBorderInsets.right > 0) {
                            if (!bl) {
                                --n;
                            }
                            graphics.drawLine(n6 + 1, n, n6 + 1, n8 - 1);
                        }
                        n = n7 - 2;
                        graphics.setColor(this.fStyle == 1 ? sLtHilite : sShadow);
                        if (n4 > 0) {
                            graphics.drawLine(n4 - 2, n, n4 - 2, n8 - 1);
                            graphics.drawLine(n4 - 1, n, n4 - 1, n);
                        }
                        if (n4 < n2) {
                            graphics.drawLine(n4, n, n2 - 1, n);
                        }
                        if (n5 < n6) {
                            graphics.drawLine(n5, n, n6 - 1, n);
                        }
                        if (this.fBorderInsets.right <= 0) break;
                        graphics.drawLine(n6, n, n6, n);
                        graphics.drawLine(n6, n7 - 1, n6, n7 - 1);
                        if (n8 <= n7) break;
                        graphics.drawLine(n6, n7, n6, n8 - 1);
                        break;
                    }
                    case 2: 
                    case 3: {
                        graphics.setColor(this.fStyle == 3 ? sDkShadow : sLtHilite);
                        if (n4 > 0) {
                            graphics.drawLine(n4 - 2, n7 - 2, n4 - 2, n8 - 1);
                            graphics.drawLine(n4 - 1, n7 - 2, n4 - 1, n7 - 2);
                        }
                        if (n4 < n2) {
                            graphics.drawLine(n4, n7 - 2, n2 - 1, n7 - 2);
                        }
                        if (n5 < n6) {
                            graphics.drawLine(n5, n7 - 2, n6 - 1, n7 - 2);
                        }
                        if (this.fBorderInsets.right > 0) {
                            graphics.drawLine(n6, n7 - 2, n6 + 1, n7 - 2);
                        }
                        graphics.setColor(this.fStyle == 3 ? sShadow : sHilite);
                        if (n4 > 0) {
                            graphics.drawLine(n4 - 1, n7 - 1, n4 - 1, n8 - 1);
                        }
                        if (n4 < n2) {
                            graphics.drawLine(n4, n7 - 1, n2 - 1, n7 - 1);
                        }
                        if (n5 < n6) {
                            graphics.drawLine(n5, n7 - 1, n6 - 1, n7 - 1);
                        }
                        if (this.fBorderInsets.right <= 0) break;
                        graphics.drawLine(n6, n7 - 1, n6, n7 - 1);
                        graphics.setColor(this.fStyle == 3 ? sHilite : sShadow);
                        if (n8 > n7) {
                            graphics.drawLine(n6, n7, n6, n8 - 1);
                        }
                        graphics.setColor(this.fStyle == 3 ? sLtHilite : sDkShadow);
                        graphics.drawLine(n6 + 1, n7 - 1, n6 + 1, n8 - 1);
                        break;
                    }
                    case 4: {
                        graphics.setColor(sTextColor);
                        if (n4 > 0) {
                            graphics.drawLine(n4 - 1, n7 - 1, n4 - 1, n8 - 1);
                        }
                        if (n4 < n2) {
                            graphics.drawLine(n4, n7 - 1, n2 - 1, n7 - 1);
                        }
                        if (n5 < n6) {
                            graphics.drawLine(n5, n7 - 1, n6 - 1, n7 - 1);
                        }
                        if (this.fBorderInsets.right <= 0) break;
                        graphics.drawLine(n6, n7 - 1, n6, n8 - 1);
                    }
                }
            }
        }
    }

    private void drawLeftEdge(Graphics graphics) {
        if (this.fBorderInsets.left > 0) {
            int n = this.fBorderInsets.top;
            int n2 = this.getSize().height - this.fBorderInsets.bottom;
            if (PlatformInfo.useWindowsXPAppearance() && this.fHiddenEdge == 0 && this.fStyle != 5) {
                if (PlatformInfo.getWindowsXPScheme() == 2) {
                    graphics.setColor(XP_EDGE_COLOR_SILVER);
                } else {
                    graphics.setColor(XP_EDGE_COLOR);
                }
                n = Math.max(n, 2);
                graphics.drawLine(0, n, 0, n2 + this.fBorderInsets.bottom - 3);
                if (this.fBorderInsets.left > 1) {
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(1, n + 1, 1, n2 + this.fBorderInsets.bottom - 3);
                }
            } else if (this.fStyle == 4) {
                graphics.setColor(sTextColor);
                graphics.drawLine(0, n, 0, n2 - 1);
            } else {
                if (this.fStyle == 0) {
                    graphics.setColor(sShadow);
                } else if (this.fStyle == 3) {
                    graphics.setColor(sDkShadow);
                } else {
                    graphics.setColor(sLtHilite);
                }
                graphics.drawLine(0, n, 0, n2 - 1);
                if (this.fStyle == 0) {
                    graphics.setColor(sLtHilite);
                } else if (this.fStyle == 2) {
                    graphics.setColor(sHilite);
                } else {
                    graphics.setColor(sShadow);
                }
                graphics.drawLine(1, n, 1, n2 - 1);
            }
        }
    }

    private void drawBottomEdge(Graphics graphics) {
        if (this.fBorderInsets.bottom > 0) {
            Dimension dimension = this.getSize();
            int n = this.fBorderInsets.left;
            int n2 = dimension.width - this.fBorderInsets.right;
            int n3 = dimension.width;
            int n4 = dimension.height - this.fBorderInsets.bottom;
            if (PlatformInfo.useWindowsXPAppearance() && this.fHiddenEdge == 0 && this.fStyle != 5) {
                if (PlatformInfo.getWindowsXPScheme() == 2) {
                    graphics.setColor(XP_EDGE_COLOR_SILVER);
                } else {
                    graphics.setColor(XP_EDGE_COLOR);
                }
                n4 = dimension.height - 3;
                graphics.drawLine(1, n4, 1, n4);
                graphics.drawLine(n2 - 1, n4, n2 - 1, n4);
                graphics.drawLine(1, ++n4, 2, n4);
                graphics.drawLine(n2 - 2, n4, n2 - 1, n4);
                graphics.drawLine(2, ++n4, n2 - 2, n4);
                graphics.setColor(this.getBackground());
                graphics.drawLine(0, n4, 1, n4);
                graphics.drawLine(n2 - 1, n4, n2, n4);
                graphics.drawLine(0, --n4, 0, n4);
                graphics.drawLine(n2, n4, n2, n4);
                if (this.fBorderInsets.bottom > 1) {
                    graphics.drawLine(3, n4, n2 - 3, n4);
                }
            } else if (this.fStyle == 4) {
                graphics.setColor(sTextColor);
                graphics.drawLine(0, n4, dimension.width - 1, n4);
            } else if (this.fStyle == 0 || this.fStyle == 1) {
                graphics.setColor(this.fStyle == 0 ? sShadow : sLtHilite);
                int n5 = this.fBorderInsets.right > 0 ? n2 : n2 - 1;
                graphics.drawLine(0, n4, n5, n4);
                graphics.setColor(this.fStyle == 0 ? sLtHilite : sShadow);
                n5 = 0;
                if (PlatformInfo.getPlatform() == 0 && this.fBorderInsets.left > 0) {
                    n5 = 1;
                }
                graphics.drawLine(n5, n4 + 1, n3 - 1, n4 + 1);
                if (this.fBorderInsets.right > 0) {
                    graphics.drawLine(n2 + 1, n4, n2 + 1, n4);
                }
            } else {
                graphics.setColor(this.fStyle == 2 ? sShadow : sHilite);
                graphics.drawLine(n, n4, n2 - 1, n4);
                if (this.fBorderInsets.right > 0) {
                    graphics.drawLine(n2, n4, n2, n4);
                }
                if (this.fBorderInsets.left > 0) {
                    graphics.drawLine(n - 1, n4, n - 1, n4);
                }
                graphics.setColor(this.fStyle == 2 ? sDkShadow : sLtHilite);
                graphics.drawLine(n, n4 + 1, n2 - 1, n4 + 1);
                if (this.fBorderInsets.right > 0) {
                    graphics.drawLine(n2, n4 + 1, n2 + 1, n4 + 1);
                    graphics.drawLine(n2 + 1, n4, n2 + 1, n4);
                }
                if (this.fBorderInsets.left > 0) {
                    graphics.drawLine(n - 1, n4 + 1, n - 1, n4 + 1);
                    graphics.setColor(this.fStyle == 2 ? sLtHilite : sDkShadow);
                    graphics.drawLine(n - 2, n4, n - 2, n4);
                }
            }
        }
    }

    private void drawRightEdge(Graphics graphics) {
        if (this.fBorderInsets.right > 0) {
            Dimension dimension = this.getSize();
            int n = this.fBorderInsets.top;
            int n2 = dimension.height - this.fBorderInsets.bottom;
            int n3 = dimension.width - this.fBorderInsets.right;
            if (PlatformInfo.useWindowsXPAppearance() && this.fHiddenEdge == 0 && this.fStyle != 5) {
                if (PlatformInfo.getWindowsXPScheme() == 2) {
                    graphics.setColor(XP_EDGE_COLOR_SILVER);
                } else {
                    graphics.setColor(XP_EDGE_COLOR);
                }
                n = Math.max(n, 2);
                graphics.drawLine(n3, n, n3, n2 + this.fBorderInsets.bottom - 3);
                if (this.fBorderInsets.right > 1) {
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(n3 + 1, 0, n3 + 1, n2 + this.fBorderInsets.bottom);
                }
            } else if (this.fStyle == 4) {
                graphics.setColor(sTextColor);
                graphics.drawLine(n3, n, n3, n2 - 1);
            } else {
                if (this.fStyle == 3) {
                    graphics.setColor(sHilite);
                } else if (this.fStyle == 1) {
                    graphics.setColor(sLtHilite);
                } else {
                    graphics.setColor(sShadow);
                }
                graphics.drawLine(n3, n, n3, n2 - 1);
                if (this.fStyle == 1) {
                    graphics.setColor(sShadow);
                } else if (this.fStyle == 2) {
                    graphics.setColor(sDkShadow);
                } else {
                    graphics.setColor(sLtHilite);
                }
                graphics.drawLine(n3 + 1, n, n3 + 1, n2 - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferedPaint(Graphics graphics) {
        super.bufferedPaint(graphics);
        this.initColors();
        MWGroupbox mWGroupbox = this;
        synchronized (mWGroupbox) {
            if (this.fBorderInsets == null) {
                this.calcBorderInsets();
            }
            Insets insets = this.fBorderInsets;
            Insets insets2 = this.getMargins();
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            graphics.setColor(this.getBackground());
            if (insets2.top > 0) {
                graphics.fillRect(insets.left, insets.top, n - insets.left - insets.right, insets2.top);
            }
            if (insets2.bottom > 0) {
                graphics.fillRect(insets.left, n2 - insets.bottom - insets2.bottom, n - insets.left - insets.right, insets2.bottom);
            }
            if (insets2.left > 0) {
                graphics.fillRect(insets.left, insets.top + insets2.top, insets2.left, n2 - insets.top - insets.bottom - insets2.top - insets2.bottom);
            }
            if (insets2.right > 0) {
                graphics.fillRect(n - insets.right - insets2.right, insets.top + insets2.top, insets2.right, n2 - insets.top - insets.bottom - insets2.top - insets2.bottom);
            }
            this.drawTopEdge(graphics);
            this.drawLeftEdge(graphics);
            this.drawBottomEdge(graphics);
            this.drawRightEdge(graphics);
        }
    }

    static {
        EDGE_COLOR_XP = new Color(145, 155, 156);
        WINDOW_TEXT_XP = new Color[]{new Color(0, 70, 213), new Color(153, 84, 10), new Color(0, 70, 213)};
        XP_EDGE_COLOR = new Color(208, 208, 191);
        XP_EDGE_COLOR_SILVER = new Color(191, 184, 191);
    }

    private class EventHandler
    implements ContainerListener,
    KeyListener {
        private EventHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addKeyListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeKeyListener(this);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getModifiers() == 0 && !keyEvent.isConsumed()) {
                Component component = (Component)keyEvent.getSource();
                int n = MWGroupbox.this.getComponentCount() - 1;
                switch (keyEvent.getKeyCode()) {
                    case 37: 
                    case 38: {
                        for (int i = 0; i <= n; ++i) {
                            Component component2 = MWGroupbox.this.getComponent(i);
                            if (component2 != component) continue;
                            while (i > 0) {
                                if (!(component2 = MWGroupbox.this.getComponent(--i)).isVisible() || !component2.isFocusTraversable()) continue;
                                keyEvent.setKeyCode(9);
                                keyEvent.setModifiers(1);
                                break;
                            }
                            n = 0;
                        }
                        break;
                    }
                    case 39: 
                    case 40: {
                        for (int i = 0; i < n; ++i) {
                            Component component3 = MWGroupbox.this.getComponent(i);
                            if (component3 != component) continue;
                            while (i < n) {
                                if (!(component3 = MWGroupbox.this.getComponent(++i)).isVisible() || !component3.isFocusTraversable()) continue;
                                keyEvent.setKeyCode(9);
                                break;
                            }
                            n = 0;
                        }
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

