/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.decorations;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.decorations.HiliteFilter;
import com.mathworks.mwt.decorations.MacColors;
import com.mathworks.mwt.decorations.PlatformDecorations;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.FilteredImageSource;
import java.util.Locale;

class MacintoshDecorations
extends PlatformDecorations {
    private static final int DIR_UP = 0;
    private static final int DIR_LEFT = 1;
    private static final int DIR_DOWN = 2;
    private static final int DIR_RIGHT = 3;
    private static final int kMacRadioUpOff = 0;
    private static final int kMacRadioUpOn = 1;
    private static final int kMacRadioDownOff = 2;
    private static final int kMacRadioDownOn = 3;
    private static final int kMacRadioDisOff = 4;
    private static final int kMacRadioDisOn = 5;
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static final Font DEFAULT_FONT_JA = new Font("SansSerif", 0, 12);
    private static Image[] sMacRadioImages = null;
    private int fChecksize = 12;

    MacintoshDecorations() {
    }

    @Override
    Font getFont(int n) {
        Font font = null;
        switch (n) {
            case 0: {
                font = Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE) ? DEFAULT_FONT_JA : DEFAULT_FONT;
            }
        }
        return font;
    }

    @Override
    Color getColor(int n) {
        Color color = null;
        switch (n) {
            case 0: {
                color = MacColors.WHITE;
                break;
            }
            case 1: {
                color = MacColors.SHADE_DD;
                break;
            }
            case 2: {
                color = MacColors.SHADE_EE;
                break;
            }
            case 3: {
                color = MacColors.WHITE;
                break;
            }
            case 4: {
                color = MacColors.SELECTION_HILITE;
                break;
            }
            case 5: {
                color = MacColors.SELECTION_TEXT;
                if (color.getRGB() != -1 || MacColors.SELECTION_HILITE.getRGB() != -16777088) break;
                color = Color.black;
                break;
            }
            case 6: {
                color = MacColors.SHADE_DD;
                break;
            }
            case 7: {
                color = MacColors.WHITE;
                break;
            }
            case 8: {
                color = MacColors.SHADE_DD;
                break;
            }
            case 9: {
                color = MacColors.SHADE_AA;
                break;
            }
            case 10: {
                color = MacColors.SHADE_55;
                break;
            }
            case 11: {
                color = MacColors.BLACK;
                break;
            }
            case 12: {
                color = MacColors.BLACK;
                break;
            }
            case 13: {
                color = SystemColor.text;
                break;
            }
            case 14: {
                color = SystemColor.textText;
                if (color.getRGB() != Color.black.getRGB()) break;
                color = Color.black;
                break;
            }
            case 15: {
                color = SystemColor.textInactiveText;
                break;
            }
            case 17: {
                color = SystemColor.activeCaptionText;
                if (color.getRGB() != -1 || SystemColor.activeCaption.getRGB() != -16777088) break;
                color = Color.black;
                break;
            }
            case 16: {
                color = SystemColor.activeCaption;
                if (color.getRGB() != -16777088) break;
                color = MacColors.SHADE_BB;
                break;
            }
            case 19: {
                color = SystemColor.inactiveCaptionText;
                break;
            }
            case 18: {
                color = SystemColor.inactiveCaption;
            }
        }
        return color;
    }

    @Override
    void drawBevelFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(1, 1, n3 - 3, n4 - 3);
        graphics.setColor(this.getColor(9));
        graphics.drawLine(0, n4 - 2, 0, 0);
        graphics.drawLine(1, 0, n3 - 2, 0);
        graphics.setColor(this.getColor(7));
        graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 2, n4 - 1, 1, n4 - 1);
        graphics.setColor(this.getColor(6));
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
        graphics.translate(-n, -n2);
    }

    @Override
    void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        if (string != null) {
            if (!bl2) {
                graphics.setColor(MacColors.SHADE_88);
            } else if (bl) {
                graphics.setColor(MacColors.WHITE);
            } else {
                graphics.setColor(MacColors.BLACK);
            }
            graphics.drawString(string, n, n2);
        }
    }

    @Override
    void drawButtonLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2);
    }

    @Override
    void drawButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width - 1;
        int n2 = rectangle.height - 1;
        if (bl3) {
            Color color = bl ? MacColors.SHADE_11 : MacColors.SHADE_66;
            Color color2 = bl ? MacColors.SHADE_44 : MacColors.SHADE_33;
            Color color3 = bl ? MacColors.SHADE_55 : MacColors.WHITE;
            Color color4 = bl ? MacColors.SHADE_AA : MacColors.SHADE_88;
            Color color5 = bl ? MacColors.SHADE_22 : MacColors.SHADE_55;
            Color color6 = bl ? MacColors.SHADE_77 : MacColors.SHADE_CC;
            Color color7 = bl ? MacColors.SHADE_88 : MacColors.SHADE_CC;
            graphics.setColor(color);
            graphics.drawLine(0, n2 - 1, 0, 0);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.setColor(color2);
            graphics.drawLine(n, 1, n, n2);
            graphics.drawLine(n, n2, 1, n2);
            graphics.setColor(color3);
            graphics.drawLine(1, n2 - 2, 1, 1);
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.setColor(color4);
            graphics.drawLine(n - 1, 2, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, 2, n2 - 1);
            graphics.setColor(color7);
            graphics.fillRect(2, 2, n - 3, n2 - 3);
            graphics.setColor(color6);
            graphics.drawLine(1, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, 1);
            graphics.setColor(color5);
            graphics.drawLine(n, 0, n, 0);
            graphics.drawLine(0, n2, 0, n2);
        } else {
            Color color = bl2 ? MacColors.SHADE_77 : MacColors.SHADE_AA;
            Color color8 = MacColors.SHADE_99;
            Color color9 = bl2 ? MacColors.SHADE_88 : MacColors.SHADE_AA;
            Color color10 = bl2 ? MacColors.SHADE_BB : MacColors.SHADE_DD;
            graphics.setColor(color);
            graphics.drawLine(0, n2 - 1, 0, 0);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.setColor(color8);
            graphics.drawLine(n, 1, n, n2);
            graphics.drawLine(n, n2, 1, n2);
            graphics.setColor(color10);
            graphics.fillRect(1, 1, n - 1, n2 - 1);
            graphics.setColor(color9);
            graphics.drawLine(n, 0, n, 0);
            graphics.drawLine(0, n2, 0, n2);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawTBButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this.drawButtonBevel(graphics, rectangle, bl, bl2, bl3);
    }

    @Override
    void drawTextButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(this.getColor(6));
        graphics.drawLine(0, 0, 1, 0);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(0, n2 - 2, 0, n2 - 1);
        graphics.drawLine(1, n2 - 1, 1, n2 - 1);
        graphics.drawLine(n - 2, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
        graphics.drawLine(n - 1, 1, n - 1, 0);
        graphics.drawLine(n - 2, 0, n - 2, 0);
        if (bl3) {
            graphics.setColor(MacColors.BLACK);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(3, 0, n - 4, 0);
            graphics.drawLine(n - 2, 1, n - 2, 1);
            graphics.drawLine(n - 1, 3, n - 1, n2 - 4);
            graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 4, n2 - 1, 3, n2 - 1);
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
            graphics.drawLine(0, n2 - 4, 0, 3);
            graphics.setColor(MacColors.SHADE_22);
            graphics.drawLine(2, 0, 2, 0);
            graphics.drawLine(n - 3, 0, n - 3, 0);
            graphics.drawLine(n - 1, 2, n - 1, 2);
            graphics.drawLine(n - 1, n2 - 3, n - 1, n2 - 3);
            graphics.drawLine(n - 3, n2 - 1, n - 3, n2 - 1);
            graphics.drawLine(2, n2 - 1, 2, n2 - 1);
            graphics.drawLine(0, n2 - 3, 0, n2 - 3);
            graphics.drawLine(0, 2, 0, 2);
            if (!bl) {
                graphics.setColor(MacColors.SHADE_BB);
                graphics.drawLine(1, 2, 2, 1);
                graphics.drawLine(n - 3, 1, n - 2, 2);
                graphics.drawLine(1, n2 - 3, 2, n2 - 2);
                graphics.setColor(MacColors.SHADE_AA);
                graphics.drawLine(3, n2 - 3, n - 4, n2 - 3);
                graphics.drawLine(n - 4, n2 - 4, n - 4, n2 - 4);
                graphics.drawLine(n - 3, n2 - 4, n - 3, 3);
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(3, n2 - 2, n - 3, n2 - 2);
                graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
                graphics.drawLine(n - 2, n2 - 3, n - 2, 3);
                graphics.setColor(MacColors.WHITE);
                graphics.drawLine(2, n2 - 4, 2, 2);
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(3, 2, n - 4, 2);
                graphics.setColor(MacColors.SHADE_DD);
                graphics.fillRect(3, 3, n - 6, n2 - 6);
                graphics.drawLine(3, 1, n - 4, 1);
                graphics.drawLine(n - 3, 2, n - 3, 2);
                graphics.drawLine(2, n2 - 3, 2, n2 - 3);
                graphics.drawLine(1, n2 - 4, 1, 3);
            } else {
                graphics.setColor(MacColors.SHADE_44);
                graphics.drawLine(1, n2 - 3, 1, 2);
                graphics.drawLine(2, 2, 2, 2);
                graphics.drawLine(2, 1, n - 3, 1);
                graphics.setColor(MacColors.SHADE_55);
                graphics.drawLine(2, n2 - 4, 2, 3);
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(3, 2, n - 4, 2);
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(2, n2 - 2, 2, n2 - 2);
                graphics.drawLine(3, n2 - 3, n - 4, n2 - 3);
                graphics.drawLine(n - 4, n2 - 4, n - 4, n2 - 4);
                graphics.drawLine(n - 3, n2 - 4, n - 3, 3);
                graphics.drawLine(n - 2, 2, n - 2, 2);
                graphics.setColor(MacColors.SHADE_88);
                graphics.drawLine(3, n2 - 2, n - 3, n2 - 2);
                graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
                graphics.drawLine(n - 2, n2 - 3, n - 2, 3);
                graphics.setColor(MacColors.SHADE_66);
                graphics.fillRect(3, 3, n - 6, n2 - 6);
                graphics.drawLine(n - 3, 2, n - 3, 2);
                graphics.drawLine(2, n2 - 3, 2, n2 - 3);
            }
        } else {
            graphics.setColor(MacColors.SHADE_DD);
            graphics.fillRect(1, 1, n - 2, n2 - 2);
            graphics.setColor(MacColors.SHADE_88);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(2, 0, n - 3, 0);
            graphics.drawLine(n - 2, 1, n - 2, 1);
            graphics.drawLine(n - 1, 2, n - 1, n2 - 3);
            graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 3, n2 - 1, 2, n2 - 1);
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
            graphics.drawLine(0, n2 - 3, 0, 2);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    MWImageResource[] drawButtonImage(MWImageResource[] mWImageResourceArray, Graphics graphics, MWImageResource mWImageResource, int n, int n2, boolean bl, boolean bl2) {
        MWImageResource[] mWImageResourceArray2 = mWImageResourceArray;
        if (mWImageResource != null) {
            if (bl) {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2, 0);
                graphics.drawImage(mWImageResourceArray2[0].getImage(), n, n2, this);
            } else if (bl2) {
                graphics.drawImage(mWImageResource.getImage(), n, n2, this);
            } else {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2, 1);
                graphics.drawImage(mWImageResourceArray2[1].getImage(), n, n2, this);
            }
        }
        return mWImageResourceArray2;
    }

    @Override
    Image[] drawButtonImage(Image[] imageArray, Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        Image[] imageArray2 = imageArray;
        if (image != null) {
            if (bl) {
                imageArray2 = this.buildCache(image, imageArray2, 0);
                graphics.drawImage(imageArray2[0], n, n2, this);
            } else if (bl2) {
                graphics.drawImage(image, n, n2, this);
            } else {
                imageArray2 = this.buildCache(image, imageArray2, 1);
                graphics.drawImage(imageArray2[1], n, n2, this);
            }
        }
        return imageArray2;
    }

    private MWImageResource[] buildCache(MWImageResource mWImageResource, MWImageResource[] mWImageResourceArray, int n) {
        if (mWImageResourceArray == null) {
            mWImageResourceArray = new MWImageResource[2];
        }
        if (mWImageResourceArray[n] == null) {
            if (n == 1) {
                FilteredImageSource filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(1));
                mWImageResourceArray[1] = new MWImageResource(mWImageResource.getResourceName() + "1", filteredImageSource);
            } else {
                FilteredImageSource filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(0));
                mWImageResourceArray[0] = new MWImageResource(mWImageResource.getResourceName() + "0", filteredImageSource);
            }
        }
        return mWImageResourceArray;
    }

    private Image[] buildCache(Image image, Image[] imageArray, int n) {
        if (imageArray == null) {
            imageArray = new Image[2];
        }
        if (imageArray[n] == null) {
            switch (n) {
                case 0: {
                    FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(0));
                    imageArray[0] = this.createImage(filteredImageSource);
                    this.waitForImage(imageArray[0]);
                    break;
                }
                case 1: {
                    FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(1));
                    imageArray[1] = this.createImage(filteredImageSource);
                    this.waitForImage(imageArray[1]);
                    break;
                }
            }
        }
        return imageArray;
    }

    @Override
    void drawButtonImage(Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        this.drawButtonImage(null, graphics, image, n, n2, bl, bl2);
    }

    private boolean waitForImage(Image image) {
        boolean bl = true;
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 2013);
            try {
                mediaTracker.waitForID(2013);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    int getChecksize() {
        return 12;
    }

    @Override
    void drawCheckbox(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        if (!bl4) {
            graphics.setColor(MacColors.SHADE_DD);
            graphics.fillRect(1, 1, this.fChecksize - 2, this.fChecksize - 2);
            graphics.setColor(MacColors.SHADE_88);
            graphics.drawRect(0, 0, this.fChecksize - 1, this.fChecksize - 1);
            if (bl3) {
                this.drawMixedMark(graphics, bl, bl4);
            } else if (bl2) {
                graphics.drawLine(2, 5, 5, 8);
                graphics.drawLine(5, 8, 12, 1);
                graphics.drawLine(11, 1, 5, 7);
                graphics.drawLine(5, 7, 3, 5);
            }
        } else {
            Color color = bl ? MacColors.SHADE_77 : MacColors.SHADE_DD;
            Color color2 = bl ? MacColors.SHADE_55 : MacColors.WHITE;
            Color color3 = bl ? MacColors.SHADE_99 : MacColors.SHADE_88;
            graphics.setColor(color);
            graphics.fillRect(1, 1, this.fChecksize - 2, this.fChecksize - 2);
            graphics.setColor(color2);
            graphics.drawLine(1, this.fChecksize - 3, 1, 1);
            graphics.drawLine(2, 1, this.fChecksize - 3, 1);
            graphics.setColor(color3);
            graphics.drawLine(2, this.fChecksize - 2, this.fChecksize - 2, this.fChecksize - 2);
            graphics.drawLine(this.fChecksize - 2, this.fChecksize - 2, this.fChecksize - 2, 2);
            graphics.setColor(MacColors.BLACK);
            graphics.drawRect(0, 0, this.fChecksize - 1, this.fChecksize - 1);
            if (bl3) {
                this.drawMixedMark(graphics, bl, bl4);
            } else if (bl2) {
                graphics.drawLine(2, 5, 5, 8);
                graphics.drawLine(5, 8, 12, 1);
                graphics.drawLine(11, 1, 5, 7);
                graphics.drawLine(5, 7, 3, 5);
                Color color4 = bl ? MacColors.SHADE_44 : MacColors.SHADE_77;
                Color color5 = bl ? MacColors.SHADE_55 : MacColors.SHADE_AA;
                graphics.setColor(color4);
                graphics.drawLine(5, 9, 10, 4);
                graphics.drawLine(12, 2, 12, 2);
                graphics.setColor(color5);
                graphics.drawLine(3, 7, 4, 8);
                graphics.drawLine(6, 9, 9, 6);
                graphics.drawLine(12, 3, 13, 2);
            }
        }
        graphics.translate(-n, -n2);
    }

    @Override
    void drawRadiobutton(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.loadMacImages();
        int n3 = bl4 ? (bl3 && bl ? 2 : (bl3 && !bl ? 0 : (bl2 && bl ? 3 : (bl2 && !bl ? 1 : (!bl2 && bl ? 2 : 0))))) : (!bl2 || bl3 ? 4 : 5);
        if (sMacRadioImages[n3] != null) {
            boolean bl6;
            boolean bl7 = bl6 = System.getProperty("java.vendor").indexOf("Apple") != -1;
            if (bl6) {
                boolean bl8 = this.waitForImage(sMacRadioImages[n3]);
            }
            graphics.drawImage(sMacRadioImages[n3], n, n2, this);
        }
        if (bl3) {
            graphics.translate(n, n2);
            this.drawMixedMark(graphics, bl, bl4);
            graphics.translate(-n, -n2);
        }
    }

    private void drawMixedMark(Graphics graphics, boolean bl, boolean bl2) {
        if (bl2) {
            graphics.setColor(MacColors.BLACK);
        } else {
            graphics.setColor(MacColors.SHADE_88);
        }
        graphics.drawLine(3, 5, 8, 5);
        graphics.drawLine(3, 6, 8, 6);
        if (bl2) {
            Color color = bl ? MacColors.SHADE_55 : MacColors.SHADE_AA;
            graphics.setColor(color);
            graphics.drawLine(4, 7, 8, 7);
            graphics.drawLine(9, 6, 9, 7);
        }
    }

    @Override
    void drawScrollTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        if (n2 == 0) {
            graphics.setColor(MacColors.BLACK);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            if (!bl2) {
                graphics.setColor(MacColors.SHADE_EE);
                graphics.fillRect(1, 0, rectangle.width - 2, rectangle.height);
            } else {
                if (n == 3) {
                    graphics.translate(0, 1);
                }
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(1, rectangle.height - 1, 1, 0);
                graphics.drawLine(2, 0, rectangle.width - 3, 0);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.setColor(MacColors.SHADE_88);
                graphics.drawLine(2, rectangle.height - 1, 2, 1);
                graphics.drawLine(3, 1, rectangle.width - 4, 1);
                graphics.setColor(MacColors.SHADE_BB);
                graphics.drawLine(rectangle.width - 3, 1, rectangle.width - 3, rectangle.height - 1);
                graphics.setColor(MacColors.SHADE_AA);
                graphics.fillRect(3, 2, rectangle.width - 6, rectangle.height - 2);
                if (n == 3) {
                    graphics.translate(0, -1);
                }
            }
        } else {
            graphics.setColor(MacColors.BLACK);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            if (!bl2) {
                graphics.setColor(MacColors.SHADE_EE);
                graphics.fillRect(0, 1, rectangle.width, rectangle.height - 2);
            } else {
                if (n == 3) {
                    graphics.translate(1, 0);
                }
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(rectangle.width - 1, 1, 0, 1);
                graphics.drawLine(0, 2, 0, rectangle.height - 3);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.setColor(MacColors.SHADE_88);
                graphics.drawLine(rectangle.width - 1, 2, 1, 2);
                graphics.drawLine(1, 3, 1, rectangle.height - 4);
                graphics.setColor(MacColors.SHADE_BB);
                graphics.drawLine(1, rectangle.height - 3, rectangle.width - 1, rectangle.height - 3);
                graphics.setColor(MacColors.SHADE_AA);
                graphics.fillRect(2, 3, rectangle.width - 2, rectangle.height - 6);
                if (n == 3) {
                    graphics.translate(-1, 0);
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawSliderTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(MacColors.BLACK);
        if (bl) {
            if (n == 2) {
                if (n2 == 0) {
                    graphics.drawLine(0, 4, rectangle.width - 2, 4);
                    graphics.drawLine(0, 8, rectangle.width - 2, 8);
                    graphics.drawLine(rectangle.width - 1, 5, rectangle.width - 1, 7);
                    graphics.setColor(MacColors.SHADE_CC);
                    graphics.drawLine(0, 3, rectangle.width - 1, 3);
                    graphics.drawLine(rectangle.width, 4, rectangle.width - 1, 4);
                    graphics.setColor(MacColors.SHADE_AA);
                    graphics.fillRect(0, 5, rectangle.width - 1, 3);
                } else {
                    graphics.drawLine(4, 0, 4, rectangle.height - 2);
                    graphics.drawLine(8, 0, 8, rectangle.height - 2);
                    graphics.drawLine(5, rectangle.height - 1, 7, rectangle.height - 1);
                    graphics.setColor(MacColors.SHADE_CC);
                    graphics.drawLine(3, 0, 3, rectangle.height - 1);
                    graphics.drawLine(4, rectangle.height, 4, rectangle.height - 1);
                    graphics.setColor(MacColors.SHADE_AA);
                    graphics.fillRect(5, 0, 3, rectangle.height - 1);
                }
            } else if (n2 == 0) {
                graphics.drawLine(1, 4, rectangle.width, 4);
                graphics.drawLine(1, 8, rectangle.width, 8);
                graphics.drawLine(0, 5, 0, 7);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(0, 3, rectangle.width, 3);
                graphics.drawLine(0, 4, 0, 4);
                graphics.drawLine(-1, 4, -1, 7);
                graphics.setColor(MacColors.SHADE_AA);
                graphics.fillRect(1, 5, rectangle.width, 3);
            } else {
                graphics.drawLine(4, 1, 4, rectangle.height);
                graphics.drawLine(8, 1, 8, rectangle.height);
                graphics.drawLine(5, 0, 7, 0);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(3, 0, 3, rectangle.height);
                graphics.drawLine(4, 0, 4, 0);
                graphics.drawLine(4, -1, 7, -1);
                graphics.setColor(MacColors.SHADE_AA);
                graphics.fillRect(5, 1, 3, rectangle.height);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawScrollThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        if (n == 0) {
            n5 = 1;
            n4 = 0;
            n3 = rectangle.width - 2;
            n2 = rectangle.height;
        } else {
            n5 = 0;
            n4 = 1;
            n3 = rectangle.width;
            n2 = rectangle.height - 2;
        }
        if (bl2) {
            Color color = bl ? MacColors.SHADE_AA : MacColors.SHADE_CC;
            Color color2 = bl ? MacColors.SHADE_55 : MacColors.SHADE_77;
            Color color3 = bl ? MacColors.SHADE_77 : MacColors.SHADE_AA;
            graphics.setColor(color);
            graphics.drawLine(n5, n4 + n2 - 2, n5, n4);
            graphics.drawLine(n5 + 1, n4, n5 + n3 - 2, n4);
            graphics.setColor(color2);
            graphics.drawLine(n5 + n3 - 1, n4 + 1, n5 + n3 - 1, n4 + n2 - 1);
            graphics.drawLine(n5 + n3 - 2, n4 + n2 - 1, n5 + 1, n4 + n2 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n5, n4 + n2 - 1, n5, n4 + n2 - 1);
            graphics.drawLine(n5 + n3 - 1, n4, n5 + n3 - 1, n4);
            graphics.fillRect(n5 + 1, n4 + 1, n3 - 2, n2 - 2);
        } else {
            graphics.setColor(MacColors.SHADE_EE);
            graphics.fillRect(n5, n4, n3, n2);
        }
        if (n == 0) {
            graphics.setColor(MacColors.BLACK);
            if (bl2) {
                graphics.drawRect(0, -1, rectangle.width - 1, rectangle.height + 1);
            } else {
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            }
        } else {
            graphics.setColor(MacColors.BLACK);
            if (bl2) {
                graphics.drawRect(-1, 0, rectangle.width + 1, rectangle.height - 1);
            } else {
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        if (bl2) {
            this.drawThumbKnurl(graphics, rectangle, n, bl);
        }
    }

    @Override
    int sliderThumbLength() {
        return 15;
    }

    @Override
    void drawSliderThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = rectangle.width;
        int n3 = rectangle.height - 2;
        if (bl2) {
            if (n == 0) {
                graphics.setColor(MacColors.BLACK);
                graphics.drawLine(1, 0, 13, 0);
                graphics.drawLine(0, 1, 0, 9);
                graphics.drawLine(0, 9, 6, 15);
                graphics.drawLine(6, 15, 8, 15);
                graphics.drawLine(8, 15, 14, 9);
                graphics.drawLine(14, 1, 14, 9);
                graphics.setColor(MacColors.SHADE_AA);
                for (int i = 0; i < 5; ++i) {
                    graphics.drawLine(3 + i, 10 + i, 11 - i, 10 + i);
                }
                graphics.fillRect(2, 2, 11, 8);
                graphics.setColor(MacColors.WHITE);
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(4, 3, 4, 3);
                graphics.drawLine(6, 3, 6, 3);
                graphics.drawLine(8, 3, 8, 3);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(2, 1, 12, 1);
                graphics.drawLine(1, 2, 1, 9);
                graphics.drawLine(4, 4, 4, 8);
                graphics.drawLine(6, 4, 6, 8);
                graphics.drawLine(8, 4, 8, 8);
                graphics.setColor(MacColors.SHADE_55);
                graphics.drawLine(5, 4, 5, 9);
                graphics.drawLine(7, 4, 7, 9);
                graphics.drawLine(9, 4, 9, 9);
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(2, 10, 6, 14);
                graphics.drawLine(6, 14, 8, 14);
                graphics.drawLine(8, 14, 13, 9);
                graphics.drawLine(13, 9, 13, 2);
                graphics.setColor(MacColors.SHADE_DD);
                graphics.drawLine(13, 1, 13, 1);
            } else {
                graphics.setColor(MacColors.BLACK);
                graphics.drawLine(0, 1, 0, 13);
                graphics.drawLine(1, 0, 9, 0);
                graphics.drawLine(9, 0, 15, 6);
                graphics.drawLine(15, 6, 15, 8);
                graphics.drawLine(15, 8, 9, 14);
                graphics.drawLine(1, 14, 9, 14);
                graphics.setColor(MacColors.SHADE_AA);
                for (int i = 0; i < 5; ++i) {
                    graphics.drawLine(10 + i, 3 + i, 10 + i, 11 - i);
                }
                graphics.fillRect(2, 2, 8, 11);
                graphics.setColor(MacColors.WHITE);
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(3, 4, 3, 4);
                graphics.drawLine(3, 6, 3, 6);
                graphics.drawLine(3, 8, 3, 8);
                graphics.setColor(MacColors.SHADE_CC);
                graphics.drawLine(1, 2, 1, 12);
                graphics.drawLine(2, 1, 9, 1);
                graphics.drawLine(4, 4, 8, 4);
                graphics.drawLine(4, 6, 8, 6);
                graphics.drawLine(4, 8, 8, 8);
                graphics.setColor(MacColors.SHADE_55);
                graphics.drawLine(4, 5, 9, 5);
                graphics.drawLine(4, 7, 9, 7);
                graphics.drawLine(4, 9, 9, 9);
                graphics.setColor(MacColors.SHADE_77);
                graphics.drawLine(10, 2, 14, 6);
                graphics.drawLine(14, 6, 14, 8);
                graphics.drawLine(14, 8, 9, 13);
                graphics.drawLine(9, 13, 2, 13);
                graphics.setColor(MacColors.SHADE_DD);
                graphics.drawLine(1, 13, 1, 13);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawScrollArrowButton(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n3 = n == 0 ? (n2 == 0 ? 0 : 2) : (n2 == 0 ? 1 : 3);
        graphics.translate(rectangle.x, rectangle.y);
        if (bl2) {
            Color color = bl ? MacColors.SHADE_55 : MacColors.WHITE;
            Color color2 = bl ? MacColors.SHADE_99 : MacColors.SHADE_BB;
            Color color3 = bl ? MacColors.SHADE_77 : MacColors.SHADE_DD;
            graphics.setColor(MacColors.BLACK);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color);
            graphics.drawLine(1, rectangle.height - 2, 1, 1);
            graphics.drawLine(2, 1, rectangle.width - 3, 1);
            graphics.setColor(color2);
            graphics.drawLine(rectangle.width - 2, 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 3, rectangle.height - 2, 2, rectangle.height - 2);
            graphics.setColor(color3);
            graphics.drawLine(1, rectangle.height - 2, 1, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, 1);
            graphics.fillRect(2, 2, rectangle.width - 4, rectangle.height - 4);
            graphics.setColor(MacColors.BLACK);
        } else {
            graphics.setColor(MacColors.BLACK);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(MacColors.SHADE_55);
            switch (n3) {
                case 0: {
                    graphics.drawLine(1, rectangle.height - 1, rectangle.width - 2, rectangle.height - 1);
                    break;
                }
                case 2: {
                    graphics.drawLine(1, 0, rectangle.width - 2, 0);
                    break;
                }
                case 1: {
                    graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 2);
                    break;
                }
                case 3: {
                    graphics.drawLine(0, 1, 0, rectangle.height - 2);
                }
            }
            graphics.setColor(MacColors.SHADE_EE);
            graphics.fillRect(1, 1, rectangle.width - 2, rectangle.height - 2);
            graphics.setColor(MacColors.SHADE_88);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        this.drawScrollArrow(graphics, rectangle, n3);
    }

    private void drawThumbKnurl(Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Color color;
        Rectangle rectangle2 = new Rectangle();
        Color color2 = bl ? MacColors.SHADE_CC : MacColors.SHADE_EE;
        Color color3 = bl ? MacColors.SHADE_AA : MacColors.SHADE_CC;
        Color color4 = color = bl ? MacColors.SHADE_22 : MacColors.SHADE_55;
        if (n == 1) {
            rectangle2.setBounds(rectangle.x + (rectangle.width - rectangle.height) / 2, rectangle.y, rectangle.height, rectangle.height);
            if (rectangle2.width > rectangle.width) {
                rectangle2.width = rectangle.width;
            }
        } else {
            rectangle2.setBounds(rectangle.x, rectangle.y + (rectangle.height - rectangle.width) / 2, rectangle.width, rectangle.width);
            if (rectangle2.height > rectangle.height) {
                rectangle2.height = rectangle.height;
            }
        }
        if (rectangle2.isEmpty()) {
            return;
        }
        graphics.translate(rectangle2.x, rectangle2.y);
        if (n == 0) {
            for (int i = 4; i < rectangle2.height - 5; i += 2) {
                graphics.setColor(color2);
                graphics.drawLine(4, i, 4, i);
                graphics.setColor(color3);
                graphics.drawLine(5, i, rectangle2.width - 6, i);
                graphics.setColor(color);
                graphics.drawLine(5, i + 1, rectangle2.width - 5, i + 1);
            }
        } else {
            for (int i = 4; i < rectangle2.width - 5; i += 2) {
                graphics.setColor(color2);
                graphics.drawLine(i, 4, i, 4);
                graphics.setColor(color3);
                graphics.drawLine(i, 5, i, rectangle2.height - 6);
                graphics.setColor(color);
                graphics.drawLine(i + 1, 5, i + 1, rectangle2.height - 5);
            }
        }
        graphics.translate(-rectangle2.x, -rectangle2.y);
    }

    private void drawScrollArrow(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3 = rectangle.width / 2;
        boolean bl = n3 % 2 == 0;
        int n4 = bl ? n3 / 2 : n3 / 2 + 1;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        if (bl) {
            nArray[0] = n4 - 1;
            nArray2[0] = n4;
        } else {
            nArray[0] = n4 - 1;
            nArray2[0] = n4 - 1;
        }
        for (n2 = 1; n2 < n4; ++n2) {
            nArray[n2] = nArray[n2 - 1] - 1;
            nArray2[n2] = nArray2[n2 - 1] + 1;
        }
        int n5 = (rectangle.width - n3) / 2;
        int n6 = (rectangle.width - n4) / 2;
        if (n == 0 || n == 2) {
            graphics.translate(n5 += rectangle.x, n6 += rectangle.y);
            for (n2 = 0; n2 < n4; ++n2) {
                int n7 = n == 0 ? n2 : n4 - n2 - 1;
                graphics.drawLine(nArray[n7], n2, nArray2[n7], n2);
            }
            graphics.translate(-n5, -n6);
        } else {
            graphics.translate(n6 += rectangle.x, n5 += rectangle.y);
            for (n2 = 0; n2 < n4; ++n2) {
                int n8 = n == 1 ? n2 : n4 - n2 - 1;
                graphics.drawLine(n2, nArray[n8], n2, nArray2[n8]);
            }
            graphics.translate(-n6, -n5);
        }
    }

    private void loadMacImages() {
        ResLoader resLoader = null;
        if (sMacRadioImages == null) {
            sMacRadioImages = new Image[6];
        }
        for (int i = 0; i < 6; ++i) {
            if (sMacRadioImages[i] != null) continue;
            if (resLoader == null) {
                resLoader = new ResLoader((Component)this);
            }
            MacintoshDecorations.sMacRadioImages[i] = resLoader.loadImage("resources/MacRadio" + i + ".gif");
        }
        if (resLoader != null) {
            resLoader.waitForPendingImages();
        }
    }

    @Override
    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = n - n2;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.getColor(6));
        graphics.drawLine(0, 0, 1, 0);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(0, n2 - 2, 0, n2 - 1);
        graphics.drawLine(1, n2 - 1, 1, n2 - 1);
        graphics.drawLine(n - 2, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
        graphics.drawLine(n - 1, 1, n - 1, 0);
        graphics.drawLine(n - 2, 0, n - 2, 0);
        if (bl2) {
            Color color = bl ? MacColors.SHADE_DD : MacColors.SHADE_DD;
            Color color2 = bl ? MacColors.BLACK : MacColors.BLACK;
            Color color3 = bl ? MacColors.SHADE_22 : MacColors.SHADE_22;
            Color color4 = bl ? MacColors.WHITE : MacColors.WHITE;
            Color color5 = bl ? MacColors.SHADE_EE : MacColors.SHADE_EE;
            Color color6 = bl ? MacColors.SHADE_BB : MacColors.SHADE_BB;
            Color color7 = bl ? MacColors.SHADE_AA : MacColors.SHADE_AA;
            Color color8 = bl ? MacColors.SHADE_77 : MacColors.SHADE_77;
            graphics.setColor(color4);
            graphics.drawLine(1, n2 - 3, 1, 2);
            graphics.drawLine(2, 1, n3 - 3, 1);
            graphics.drawLine(n3, n2 - 4, n3, 2);
            graphics.drawLine(n3 + 1, 2, n - 4, 2);
            graphics.setColor(color5);
            graphics.drawLine(n3 - 2, 1, n3 - 2, 1);
            graphics.setColor(color6);
            graphics.drawLine(n - 3, 1, n - 3, 1);
            graphics.drawLine(n3 - 1, n2 - 2, n3 - 1, n2 - 2);
            graphics.setColor(color7);
            graphics.drawLine(2, n2 - 2, n3 - 2, n2 - 2);
            graphics.drawLine(n3 - 2, n2 - 3, n3 - 2, 2);
            graphics.drawLine(n3 + 1, n2 - 3, n - 4, n2 - 3);
            graphics.drawLine(n - 3, n2 - 4, n - 3, 3);
            graphics.drawLine(n - 2, 2, n - 2, 2);
            graphics.setColor(color8);
            graphics.drawLine(n3, n2 - 2, n - 3, n2 - 2);
            graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
            graphics.drawLine(n - 2, n2 - 3, n - 2, 3);
            graphics.setColor(color);
            graphics.fillRect(2, 2, n3 - 4, n2 - 4);
            graphics.fillRect(n3 + 1, 3, n2 - 4, n2 - 6);
            graphics.drawLine(n3, n2 - 3, n3 - 1, n2 - 3);
            graphics.drawLine(n3 - 1, n2 - 4, n3 - 1, 1);
            graphics.drawLine(n3, 1, n - 4, 1);
            graphics.setColor(color2);
            graphics.drawLine(3, 0, n - 4, 0);
            graphics.drawLine(n - 2, 1, n - 2, 1);
            graphics.drawLine(n - 1, 3, n - 1, n2 - 4);
            graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 4, n2 - 1, 3, n2 - 1);
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
            graphics.drawLine(0, n2 - 4, 0, 3);
            graphics.drawLine(1, 1, 1, 1);
            this.drawScrollArrow(graphics, new Rectangle(n3, 0, n2, n2), 2);
            graphics.setColor(color3);
            graphics.drawLine(2, 0, 2, 0);
            graphics.drawLine(n - 3, 0, n - 3, 0);
            graphics.drawLine(n - 1, 2, n - 1, 2);
            graphics.drawLine(n - 1, n2 - 3, n - 1, n2 - 3);
            graphics.drawLine(n - 3, n2 - 1, n - 3, n2 - 1);
            graphics.drawLine(2, n2 - 1, 2, n2 - 1);
            graphics.drawLine(0, n2 - 3, 0, n2 - 3);
            graphics.drawLine(0, 2, 0, 2);
        } else {
            graphics.setColor(MacColors.SHADE_DD);
            graphics.fillRect(1, 1, n - 2, n2 - 2);
            graphics.setColor(MacColors.SHADE_88);
            graphics.drawLine(2, 0, n - 3, 0);
            graphics.drawLine(n - 2, 1, n - 2, 1);
            graphics.drawLine(n - 1, 2, n - 1, n2 - 3);
            graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 3, n2 - 1, 2, n2 - 1);
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
            graphics.drawLine(0, n2 - 3, 0, 2);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(n3 - 2, 1, n3 - 2, n2 - 2);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        string = this.shortenString(string, fontMetrics, n - n2 - 4);
        n2 = rectangle.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2;
        if (fontMetrics.getLeading() > fontMetrics.getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE))) {
            n2 += (fontMetrics.getMaxAscent() >> 3) - fontMetrics.getLeading();
        }
        this.drawLabel(graphics, string, rectangle.x + 4, n2, bl, bl2);
    }

    @Override
    void drawComboControl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x + n - n2;
        int n4 = rectangle.y;
        Color color = MacColors.SHADE_DD;
        Color color2 = MacColors.BLACK;
        Color color3 = MacColors.WHITE;
        Color color4 = MacColors.SHADE_AA;
        Color color5 = MacColors.SHADE_77;
        graphics.translate(n3, n4);
        graphics.fillRect(-2, 0, 2, n2);
        graphics.drawLine(0, 0, 1, 0);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(n2 - 2, 0, n2 - 1, 0);
        graphics.drawLine(n2 - 1, 1, n2 - 1, 1);
        graphics.drawLine(0, n2 - 1, 1, n2 - 1);
        graphics.drawLine(0, n2 - 2, 0, n2 - 2);
        graphics.drawLine(n2 - 2, n2 - 1, n2 - 1, n2 - 1);
        graphics.drawLine(n2 - 1, n2 - 2, n2 - 1, n2 - 2);
        if (bl2) {
            graphics.setColor(color2);
        } else {
            graphics.setColor(MacColors.SHADE_88);
        }
        graphics.drawLine(2, 0, n2 - 3, 0);
        graphics.drawLine(n2 - 2, 1, n2 - 2, 1);
        graphics.drawLine(n2 - 1, 2, n2 - 1, n2 - 3);
        graphics.drawLine(n2 - 2, n2 - 2, n2 - 2, n2 - 2);
        graphics.drawLine(n2 - 3, n2 - 1, 2, n2 - 1);
        graphics.drawLine(1, n2 - 2, 1, n2 - 2);
        graphics.drawLine(0, n2 - 3, 0, 2);
        graphics.drawLine(1, 1, 1, 1);
        graphics.setColor(color3);
        graphics.drawLine(2, n2 - 4, 2, 2);
        graphics.drawLine(3, 2, n2 - 4, 2);
        graphics.setColor(color4);
        graphics.drawLine(n2 - 3, 1, n2 - 2, 2);
        graphics.drawLine(n2 - 3, 3, n2 - 3, n2 - 4);
        graphics.drawLine(n2 - 4, n2 - 3, 3, n2 - 3);
        graphics.setColor(color5);
        graphics.drawLine(2, n2 - 2, n2 - 3, n2 - 2);
        graphics.drawLine(n2 - 3, n2 - 3, n2 - 3, n2 - 3);
        graphics.drawLine(n2 - 2, n2 - 3, n2 - 2, 3);
        graphics.setColor(color);
        graphics.drawLine(2, n2 - 3, 2, n2 - 3);
        graphics.drawLine(1, n2 - 3, 1, 2);
        graphics.drawLine(2, 1, n2 - 4, 1);
        graphics.drawLine(n2 - 3, 2, n2 - 3, 2);
        graphics.fillRect(3, 3, n2 - 6, n2 - 6);
        if (bl2) {
            graphics.setColor(color2);
        } else {
            graphics.setColor(MacColors.SHADE_88);
        }
        this.drawScrollArrow(graphics, new Rectangle(0, 0, n2, n2), 2);
        graphics.translate(-n3, -n4);
    }
}

