/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.dialog;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMouseWheelTarget;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.SynchronousInvokeUtility;
import com.mathworks.mwt.floater.FloaterContainer;
import com.mathworks.mwt.floater.FloaterContainerSupport;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.window.FullWindowRegistry;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.MatlabWindowBlocker;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Random;

public class MWDialog
extends Dialog
implements ComponentListener,
ContainerListener,
FloaterContainer,
KeyListener,
WindowListener,
MWFocusChain,
HWndProvider {
    private long hWnd = 0L;
    private boolean fNativeEventsEnabled = false;
    private MatlabWindowBlocker fBlocker;
    private boolean fActive;
    private boolean fUsePlatformBG = true;
    private int fBackgroundType = 1;
    private MWButton fDefaultButton;
    private boolean fDefaultBehavior;
    private boolean fIsKeyEvent;
    private Component fFocus;
    private Component fUnixFocus;
    private String fTitle;
    private boolean fHasUniqueTitle;
    private MWFrame fFrame;
    private boolean fUsePrivateFrame = false;
    private boolean fInHide = false;
    private boolean fHasPeer;
    private static int sUniqueId = new Random().nextInt();

    public MWDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public MWDialog(Dialog dialog, boolean bl) {
        this(dialog, null, bl);
    }

    public MWDialog(Frame frame, String string, boolean bl) {
        super(frame, MWDialog.uniqueTitle(string), bl);
        this.fTitle = string;
        this.fHasUniqueTitle = string != MWDialog.uniqueTitle(string);
        this.InitMWDialog();
    }

    public MWDialog(Dialog dialog, String string, boolean bl) {
        this(string, bl);
    }

    public MWDialog(String string, boolean bl) {
        this(new MWFrame(), string, bl);
        this.fFrame = (MWFrame)this.getParent();
        this.fUsePrivateFrame = true;
    }

    private void InitMWDialog() {
        this.enableEvents(8L);
        this.setLayout(new MWBorderLayout());
        this.setBackground(Decorations.getColor(this.fBackgroundType));
        this.addComponentListener(this);
        this.addContainerListener(this);
        this.addWindowListener(this);
        if (this.isModal()) {
            this.fBlocker = new MatlabWindowBlocker();
        }
    }

    private static synchronized String uniqueTitle(String string) {
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            return Integer.toString(sUniqueId++);
        }
        return string;
    }

    public long getHWnd() {
        return this.hWnd;
    }

    @Override
    public String getTitle() {
        return this.fHasUniqueTitle ? this.fTitle : super.getTitle();
    }

    @Override
    public void setTitle(String string) {
        this.fTitle = string;
        if (!this.fHasUniqueTitle) {
            super.setTitle(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.fIsKeyEvent) {
            return;
        }
        try {
            this.fIsKeyEvent = true;
            if (keyEvent.getID() == 401 && !keyEvent.isConsumed()) {
                if ((keyEvent.getModifiers() & 0xFFFFFFFE) == 0) {
                    if (keyEvent.getKeyCode() == 10 && this.fDefaultButton != null) {
                        if (!this.fDefaultButton.equals(keyEvent.getSource()) && !this.fDefaultButton.equals(this.getFocusOwner()) && this.fDefaultButton.isShowing()) {
                            this.doDefaultButtonBehavior();
                        }
                    } else if (keyEvent.getKeyCode() == 27) {
                        keyEvent.consume();
                        if (this.isModal()) {
                            this.setVisible(false);
                        } else {
                            WindowEvent windowEvent = new WindowEvent(this, 201);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent);
                        }
                    } else {
                        Component component = this.getFocusOwner();
                        if (component != null && component instanceof MWButton) {
                            ((MWButton)component).processKeyEvent(keyEvent);
                        }
                        if (!keyEvent.isConsumed()) {
                            this.processMnemonic(this, keyEvent);
                        }
                    }
                } else if ((keyEvent.getModifiers() & 0xFFFFFFFE) == 8) {
                    this.processMnemonic(this, keyEvent);
                }
            }
        }
        finally {
            this.fIsKeyEvent = false;
        }
        if (!this.fDefaultBehavior) {
            super.processKeyEvent(keyEvent);
        }
    }

    private void processMnemonic(Container container, KeyEvent keyEvent) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof MWButton && component.isVisible()) {
                ((MWButton)component).processKeyEvent(keyEvent);
            } else if (component instanceof Container) {
                this.processMnemonic((Container)component, keyEvent);
            }
            if (keyEvent.isConsumed()) break;
        }
    }

    private void doDefaultButtonBehavior() {
        if (this.fDefaultButton != null && this.fDefaultButton.isDefault()) {
            this.fDefaultBehavior = true;
            KeyEvent keyEvent = new KeyEvent(this.fDefaultButton, 401, 0L, 0, 10, '\r');
            this.fDefaultButton.processKeyEvent(keyEvent);
            this.fDefaultBehavior = false;
        }
    }

    public void setDefaultButton(MWButton mWButton) {
        Component component;
        if (this.fDefaultButton != null && this.fDefaultButton.isDefault() && mWButton != this.fDefaultButton) {
            this.fDefaultButton.setDefault(false);
            this.fDefaultButton.repaint();
        }
        this.fDefaultButton = mWButton;
        if (!(mWButton == null || mWButton.isDefault() || (component = this.getFocusOwner()) != null && component instanceof MWButton)) {
            mWButton.setDefault(true);
            mWButton.repaint();
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof MWBorderLayout) {
            super.setLayout(layoutManager);
        } else if (!(layoutManager instanceof BorderLayout)) {
            throw new IllegalArgumentException("MWDialog's layout manager must be MWBorderLayout");
        }
    }

    private boolean isMatlabThread() {
        return Thread.currentThread().getName().equals("main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void superShow() {
        if (PlatformInfo.isWindows() && this.isModal() && this.fUsePrivateFrame) {
            this.fFrame.surrogateSetState(1);
            this.fFrame.setTitle(this.getTitle());
            this.fFrame.superShow();
        }
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            NativeJava.detachThreadInput();
        }
        try {
            super.show();
        }
        finally {
            if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
                NativeJava.attachThreadInput();
            }
        }
        if (PlatformInfo.isWindows() && this.isModal() && this.fUsePrivateFrame) {
            this.fFrame.dispose();
        }
        if (PlatformInfo.isMacintosh()) {
            NativeJava.macActivateIgnoringOtherApps();
        }
    }

    @Override
    public void show() {
        if (this.isModal() && this.isMatlabThread()) {
            DoShow doShow = new DoShow();
            SynchronousInvokeUtility.SynchronousEventAdapter synchronousEventAdapter = new SynchronousInvokeUtility.SynchronousEventAdapter(doShow);
            SynchronousInvokeUtility.queueSynchronousEvent(synchronousEventAdapter);
            if (synchronousEventAdapter.isInterruptPending()) {
                this.setVisible(false);
            }
        } else {
            this.superShow();
        }
    }

    protected void superDispose() {
        super.dispose();
    }

    @Override
    public void dispose() {
        if (this.isModal() && this.isMatlabThread()) {
            DoDispose doDispose = new DoDispose();
            SynchronousInvokeUtility.queueSynchronousEvent(new SynchronousInvokeUtility.SynchronousEventAdapter(doDispose));
        } else {
            this.superDispose();
        }
    }

    protected void superHide() {
        super.hide();
    }

    @Override
    public void hide() {
        if (!this.isVisible() && PlatformInfo.isBlackdownVM()) {
            return;
        }
        if (this.isModal() && this.isMatlabThread()) {
            DoHide doHide = new DoHide();
            SynchronousInvokeUtility.queueSynchronousEvent(new SynchronousInvokeUtility.SynchronousEventAdapter(doHide));
        } else if (this.isModal() && !this.fInHide) {
            this.fInHide = true;
            this.superDispose();
            this.fInHide = false;
        } else {
            this.superHide();
        }
    }

    public void setNonBlockingVisible(boolean bl) {
        if (bl) {
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    MWDialog.this.setVisible(true);
                }
            });
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FullWindowRegistry.register(this);
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            this.hWnd = NativeJava.getHWnd((Dialog)this);
            if (this.hWnd != 0L) {
                if (this.fNativeEventsEnabled) {
                    NativeJava.disableNativeEvents((long)this.hWnd);
                }
                if (this.isModal()) {
                    NativeJava.enableNativeDialogEvents((Window)this, (long)this.hWnd);
                } else {
                    NativeJava.enableNativeEvents((Window)this, (long)this.hWnd);
                }
                this.fNativeEventsEnabled = true;
            }
            this.fHasUniqueTitle = false;
            this.setTitle(this.fTitle);
        }
        this.fHasPeer = true;
        if (this.fBlocker != null) {
            this.fBlocker.componentShown(null);
        }
    }

    @Override
    public void removeNotify() {
        if (this.hWnd != 0L && this.fNativeEventsEnabled) {
            NativeJava.disableNativeEvents((long)this.hWnd);
            this.fNativeEventsEnabled = false;
        }
        if (this.fBlocker != null && this.fHasPeer) {
            this.fBlocker.componentHidden(null);
        }
        this.fHasPeer = false;
        FullWindowRegistry.unregister(this);
        super.removeNotify();
    }

    protected void processNativeEvent(NativeEvent nativeEvent) {
        block3: {
            block2: {
                if (NativeEvent.WM_IME_CHAR != nativeEvent.getNativeMessage()) break block2;
                Component component = this.getFocusOwner();
                if (component == null || !(component instanceof MWComponent)) break block3;
                int n = (int)nativeEvent.getLParam();
                KeyEvent keyEvent = new KeyEvent(component, 401, 0L, 0, n, (char)n);
                ((MWComponent)component).processKeyEvent(keyEvent);
                break block3;
            }
            if (NativeEvent.WM_MOUSEWHEEL == nativeEvent.getNativeMessage()) {
                for (Component component = this.getFocusOwner(); component != null; component = component.getParent()) {
                    if (!(component instanceof MWMouseWheelTarget)) continue;
                    long l = nativeEvent.getWParam();
                    long l2 = l >> 16;
                    ((MWMouseWheelTarget)((Object)component)).mouseWheelTurned(l2 > 0L ? -3 : 3, (int)l & 0xFFFF);
                    break;
                }
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof NativeEvent) {
            this.processNativeEvent((NativeEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    private void traverseContainer(MWContainer mWContainer, boolean bl) {
        if (bl) {
            mWContainer.addContainerListener(this);
        } else {
            mWContainer.removeContainerListener(this);
        }
        int n = mWContainer.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = mWContainer.getComponent(i);
            if (component instanceof MWTextField) {
                if (bl) {
                    ((MWTextField)component).addKeyListener(this);
                    continue;
                }
                ((MWTextField)component).removeKeyListener(this);
                continue;
            }
            if (component instanceof MWButton) {
                if ((MWButton)component == this.fDefaultButton || bl) continue;
                ((MWButton)component).setDefault(false);
                continue;
            }
            if (!(component instanceof MWContainer)) continue;
            this.traverseContainer((MWContainer)component, bl);
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof MWTextField) {
            ((MWTextField)component).addKeyListener(this);
        } else if (component instanceof MWContainer) {
            this.traverseContainer((MWContainer)component, true);
        } else if (component instanceof MWButton && ((MWButton)component).isDefault()) {
            this.fDefaultButton = (MWButton)component;
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof MWTextField) {
            ((MWTextField)component).removeKeyListener(this);
        } else if (component instanceof MWContainer) {
            this.traverseContainer((MWContainer)component, false);
        } else if (component instanceof MWButton) {
            if ((MWButton)component == this.fDefaultButton) {
                this.fDefaultButton = null;
            } else {
                ((MWButton)component).setDefault(false);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.fActive = true;
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.fActive = false;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean isFrameActive() {
        return this.fActive;
    }

    @Override
    public void focusEvent(FocusEvent focusEvent) {
        if (this.fDefaultButton != null && focusEvent.getID() == 1004) {
            if (focusEvent.getSource() instanceof MWButton) {
                MWButton mWButton = (MWButton)focusEvent.getSource();
                if (!this.fDefaultButton.equals(mWButton)) {
                    this.fDefaultButton.setDefault(false);
                    this.fDefaultButton.repaint();
                }
            } else if (!this.fDefaultButton.isDefault()) {
                this.fDefaultButton.setDefault(true);
                this.fDefaultButton.repaint();
            }
        }
    }

    @Override
    public void focusSwitch(KeyEvent keyEvent) {
    }

    @Override
    public void focusMousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.getKeyCode() != 10 || this.fDefaultButton == null) && keyEvent.getKeyCode() == 27) {
            this.fDefaultBehavior = true;
            this.processKeyEvent(keyEvent);
            this.fDefaultBehavior = false;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void hideFloaters(FloaterOwner floaterOwner) {
        FloaterContainerSupport.hideFloaters(this, floaterOwner);
    }

    public void setBackgroundType(int n) {
        if (n != this.fBackgroundType) {
            this.fBackgroundType = n;
            if (this.fUsePlatformBG) {
                this.setBackground(Decorations.getColor(this.fBackgroundType));
                this.repaint(5L);
            }
        }
    }

    public void setUsePlatformBG(boolean bl) {
        if (bl != this.fUsePlatformBG) {
            this.fUsePlatformBG = bl;
            if (this.fUsePlatformBG) {
                this.setBackground(Decorations.getColor(this.fBackgroundType));
            } else {
                this.setBackground(null);
            }
            this.repaint(5L);
        }
    }

    private Component eraseFocusOutline(Graphics graphics) {
        Rectangle rectangle;
        Component component = this.getFocusOwner();
        if (component != this.fFocus && this.fFocus != null && (rectangle = MWUtils.getFocusBounds(this.fFocus)) != null) {
            Rectangle rectangle2 = graphics.getClipBounds();
            rectangle2 = MWUtils.unionRect(rectangle2, rectangle, rectangle2);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        this.fFocus = component;
        return component;
    }

    private void drawFocusOutline(Graphics graphics, Component component) {
        Rectangle rectangle;
        if (component != null && (rectangle = MWUtils.getFocusBounds(component)) != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Decorations.getColor(4));
            if (PlatformInfo.getAppearance() == 0) {
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4, 4);
                graphics.drawRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, 4, 4);
            } else {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Component component = this.eraseFocusOutline(graphics);
        if (PlatformInfo.getAppearance() == 2 && this.isFrameActive()) {
            if (component != this) {
                this.fUnixFocus = component;
                if (component != null) {
                    Container container = component.getParent();
                    if (container != null) {
                        container = container.getParent();
                    }
                    if (container != null && container instanceof MWTextView && !((MWTextView)container).hasFocus()) {
                        component.requestFocus();
                        component.dispatchEvent(new FocusEvent(container, 1004));
                    }
                }
            }
            if (component == this && this.fUnixFocus != null) {
                this.fUnixFocus.requestFocus();
            }
        }
        super.paint(graphics);
        this.drawFocusOutline(graphics, component);
    }

    @Override
    public void update(Graphics graphics) {
        Object object;
        Component component = null;
        Rectangle rectangle = null;
        if (this.getLayout() instanceof MWBorderLayout && ((MWBorderLayout)(object = (MWBorderLayout)this.getLayout())).getFloaterCount() > 0) {
            rectangle = graphics.getClipBounds();
            component = ((MWBorderLayout)object).getFloaterContainingRect(rectangle);
        }
        if (component == null) {
            this.paint(graphics);
        } else {
            object = component.getGraphics();
            if (object != null) {
                Rectangle rectangle2 = component.getBounds();
                rectangle.translate(-rectangle2.x, -rectangle2.y);
                ((Graphics)object).clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Component component2 = this.eraseFocusOutline(graphics);
                component.update((Graphics)object);
                this.drawFocusOutline(graphics, component2);
                ((Graphics)object).dispose();
            }
        }
    }

    @Override
    public void toFront() {
        super.toFront();
        if (this.isMinimized()) {
            this.setMinimized(false);
        }
    }

    public boolean isMinimized() {
        return NativeJava.isMinimized((Window)this);
    }

    public void setMinimized(boolean bl) {
        NativeJava.setMinimized((Window)this, (boolean)bl);
    }

    public boolean isMaximized() {
        return NativeJava.isMaximized((Window)this);
    }

    public void setMaximized(boolean bl) {
        NativeJava.setMaximized((Window)this, (boolean)bl);
    }

    public Dimension getRestoredSize() {
        return NativeJava.getRestoredSize((Window)this);
    }

    public void setRestoredSize(Dimension dimension) {
        NativeJava.setRestoredSize((Window)this, (Dimension)dimension);
    }

    public void setRestoredSize(int n, int n2) {
        NativeJava.setRestoredSize((Window)this, (int)n, (int)n2);
    }

    public Point getRestoredLocation() {
        return NativeJava.getRestoredLocation((Window)this);
    }

    public void setRestoredLocation(Point point) {
        NativeJava.setRestoredLocation((Window)this, (Point)point);
    }

    public void setRestoredLocation(int n, int n2) {
        NativeJava.setRestoredLocation((Window)this, (int)n, (int)n2);
    }

    private class DoHide
    extends QueueEvent
    implements Runnable {
        private boolean fDone = false;

        private DoHide() {
        }

        public boolean isDone() {
            return this.fDone;
        }

        @Override
        public void run() {
            this.dispatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            try {
                if (MWDialog.this.fInHide) {
                    MWDialog.this.superHide();
                } else {
                    MWDialog.this.fInHide = true;
                    MWDialog.this.superDispose();
                    MWDialog.this.fInHide = false;
                }
            }
            finally {
                this.fDone = true;
            }
        }
    }

    private class DoDispose
    extends QueueEvent
    implements Runnable {
        private boolean fDone = false;

        private DoDispose() {
        }

        public boolean isDone() {
            return this.fDone;
        }

        @Override
        public void run() {
            this.dispatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            try {
                MWDialog.this.superDispose();
            }
            finally {
                this.fDone = true;
            }
        }
    }

    private class DoShow
    extends QueueEvent
    implements Runnable {
        private boolean fDone = false;

        private DoShow() {
        }

        public boolean isDone() {
            return this.fDone;
        }

        @Override
        public void run() {
            this.dispatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            try {
                MWDialog.this.superShow();
            }
            finally {
                this.fDone = true;
            }
        }
    }
}

