/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TreeData;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class CellBoolean
extends Cell {
    private boolean fMouseIn = false;
    private Rectangle fTrackRect = null;
    private boolean fHasRollover;

    public CellBoolean(Table table) {
        super(67, table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof Boolean) {
            boolean bl2 = (Boolean)object;
            Point point = this.getTable().getTrackingCell();
            boolean bl3 = this.fMouseIn && point.x == n2 && point.y == n;
            graphics.translate(rectangle.x, rectangle.y);
            Point point2 = this.getCheckboxLocation(rectangle.width, rectangle.height, style);
            Decorations.drawCheckbox(graphics, point2.x, point2.y, bl3, bl2, false, style.isEditable(), this.fHasRollover);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private Point getCheckboxLocation(int n, int n2, Style style) {
        int n3 = Decorations.getChecksize();
        Point point = new Point();
        Insets insets = style.getMargins();
        switch (style.getHAlignment()) {
            case 0: {
                point.x = insets.left;
                break;
            }
            case 1: {
                point.x = insets.left + (n - insets.left - insets.right - n3) / 2;
                break;
            }
            case 2: {
                point.x = n - insets.right - n3;
            }
        }
        switch (style.getVAlignment()) {
            case 0: {
                point.y = insets.top;
                break;
            }
            case 1: {
                point.y = insets.top + (n2 - insets.top - insets.bottom - n3) / 2;
                break;
            }
            case 2: {
                point.y = n2 - insets.bottom - n3;
            }
        }
        return point;
    }

    private final void getCheckBounds(int n, int n2, Rectangle rectangle) {
        if (rectangle != null) {
            this.getTable().getCellBoundsInternal(n, n2, true, rectangle);
            Style style = this.getTable().getCellStyle(n, n2);
            int n3 = Decorations.getChecksize();
            Point point = this.getCheckboxLocation(rectangle.width, rectangle.height, style);
            rectangle.x += point.x;
            rectangle.y += point.y;
            rectangle.width = n3;
            rectangle.height = n3;
        }
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl = false;
        if (this.getTable().getCellStyle(n, n2).isEditable()) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            this.getCheckBounds(n, n2, rectangle);
            this.fTrackRect = null;
            this.fMouseIn = rectangle.contains(point.x, point.y);
            if (this.fMouseIn) {
                this.getTable().setTrackingCell(n, n2);
                this.fTrackRect = rectangle;
                this.getTable().repaintCells(n, n2, n, n2);
                this.getTable().select(n, n2);
                bl = true;
            }
        }
        return bl;
    }

    private final boolean trackMouse(Point point, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.fTrackRect != null && this.fTrackRect.contains(point);
        if (this.fMouseIn != bl) {
            this.fMouseIn = bl;
            this.getTable().repaintCells(n, n2, n, n2);
        }
        return this.fMouseIn;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        if (this.fTrackRect == null) {
            return false;
        }
        Point point = this.getTable().getTrackingCell();
        if (point.x == n2 && point.y == n) {
            boolean bl = this.trackMouse(mouseEvent.getPoint(), n, n2);
            this.getTable().setTrackingCell(-2, -2);
            if (bl) {
                Boolean bl2 = (Boolean)this.getTable().getCellData(n, n2);
                boolean bl3 = bl2;
                if (this.getTable().getTreeData() != null) {
                    TreeData treeData = this.getTable().getTreeData();
                    int n3 = treeData.getItemId(n);
                    treeData.setItem(n3, n2, new Boolean(!bl3));
                } else {
                    this.getTable().setCellData(n, n2, new Boolean(!bl3));
                }
                this.getTable().repaintCells(n, n2, n, n2);
                this.getTable().fireValueChangedEvent(n, n2, bl2);
            }
        }
        return true;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        if (point.x == n2 && point.y == n) {
            this.trackMouse(mouseEvent.getPoint(), n, n2);
        }
        return this.fTrackRect != null;
    }
}

