/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.decorations.Decorations;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;

public class Style {
    public static final int NO_PROPS = 0;
    public static final int FONT = 1;
    public static final int FOREGROUND = 2;
    public static final int BACKGROUND = 4;
    public static final int HGRID_VISIBLE = 8;
    public static final int HGRID_COLOR = 16;
    public static final int VGRID_VISIBLE = 32;
    public static final int VGRID_COLOR = 64;
    public static final int MARGINS = 128;
    public static final int H_ALIGNMENT = 256;
    public static final int V_ALIGNMENT = 512;
    public static final int EDITABLE = 1024;
    public static final int CUSTOM_HILITE = 2048;
    public static final int ALL_PROPS = -1;
    public static final int H_ALIGN_LEFT = 0;
    public static final int H_ALIGN_CENTER = 1;
    public static final int H_ALIGN_RIGHT = 2;
    public static final int V_ALIGN_TOP = 0;
    public static final int V_ALIGN_CENTER = 1;
    public static final int V_ALIGN_BOTTOM = 2;
    private int fMask;
    private Style fBaseStyle;
    private Font fFont;
    private Color fForeground;
    private Color fBackground;
    private boolean fHGridVisible;
    private Color fHGridColor;
    private boolean fVGridVisible;
    private Color fVGridColor;
    private Insets fMargins;
    private int fHAlignment;
    private int fVAlignment;
    private boolean fEditable;
    private boolean fCustomHilite;

    public Style(int n) {
        this.fMask = n;
        this.fBaseStyle = null;
        this.fFont = Decorations.getFont(0);
        this.fForeground = Color.black;
        this.fBackground = Decorations.getColor(2);
        this.fHGridVisible = true;
        this.fHGridColor = Decorations.getColor(3);
        this.fVGridVisible = true;
        this.fVGridColor = Decorations.getColor(3);
        this.fMargins = new Insets(2, 2, 2, 2);
        this.fHAlignment = 0;
        this.fVAlignment = 2;
        this.fEditable = false;
        this.fCustomHilite = false;
    }

    public Style() {
        this(-1);
    }

    public Style getBaseStyle() {
        return this.fBaseStyle;
    }

    public void setBaseStyle(Style style) {
        this.fBaseStyle = style;
    }

    public int getMask() {
        return this.fMask;
    }

    public void setMask(int n) {
        this.fMask = n;
    }

    public Font getFont() {
        if ((this.fMask & 1) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getFont();
        }
        return this.fFont;
    }

    public void setFont(Font font) {
        this.fFont = font;
    }

    public Color getForeground() {
        if ((this.fMask & 2) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getForeground();
        }
        return this.fForeground;
    }

    public void setForeground(Color color) {
        this.fForeground = color;
    }

    public Color getBackground() {
        if ((this.fMask & 4) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getBackground();
        }
        return this.fBackground;
    }

    public void setBackground(Color color) {
        this.fBackground = color;
    }

    public boolean isHGridVisible() {
        if ((this.fMask & 8) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.isHGridVisible();
        }
        return this.fHGridVisible;
    }

    public void setHGridVisible(boolean bl) {
        this.fHGridVisible = bl;
    }

    public Color getHGridColor() {
        if ((this.fMask & 0x10) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getHGridColor();
        }
        return this.fHGridColor;
    }

    public void setHGridColor(Color color) {
        this.fHGridColor = color;
    }

    public boolean isVGridVisible() {
        if ((this.fMask & 0x20) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.isVGridVisible();
        }
        return this.fVGridVisible;
    }

    public void setVGridVisible(boolean bl) {
        this.fVGridVisible = bl;
    }

    public Color getVGridColor() {
        if ((this.fMask & 0x40) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getVGridColor();
        }
        return this.fVGridColor;
    }

    public void setVGridColor(Color color) {
        this.fVGridColor = color;
    }

    public Insets getMargins() {
        if ((this.fMask & 0x80) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getMargins();
        }
        return this.fMargins;
    }

    public void setMargins(Insets insets) {
        this.fMargins = insets;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.fMargins = new Insets(n, n2, n3, n4);
    }

    public int getHAlignment() {
        if ((this.fMask & 0x100) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getHAlignment();
        }
        return this.fHAlignment;
    }

    public void setHAlignment(int n) {
        this.fHAlignment = n;
    }

    public int getVAlignment() {
        if ((this.fMask & 0x200) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getVAlignment();
        }
        return this.fVAlignment;
    }

    public void setVAlignment(int n) {
        this.fVAlignment = n;
    }

    public boolean isEditable() {
        if ((this.fMask & 0x400) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.isEditable();
        }
        return this.fEditable;
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
    }

    public boolean getCustomHilite() {
        if ((this.fMask & 0x800) == 0 && this.fBaseStyle != null) {
            return this.fBaseStyle.getCustomHilite();
        }
        return this.fCustomHilite;
    }

    public void setCustomHilite(boolean bl) {
        this.fCustomHilite = bl;
    }
}

