/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.LineMgr;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.text.StyleMgr;
import com.mathworks.mwt.text.TextUndoRelay;
import com.mathworks.mwt.undo.UndoListener;
import com.mathworks.mwt.undo.UndoableEdit;
import com.mathworks.util.Assert;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Range;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class MWTextModel {
    public static final String EDITABLE_PROPERTY = "Editable";
    private static final int DEFAULT_CAPACITY = 16;
    private static final int DEFAULT_INCREMENT = 256;
    private static final char[] EMPTY_ARRAY = new char[0];
    private char[] fSingletonArray1;
    private char[] fSingletonArray2;
    private char[] fSingletonArray3;
    private static Font[] sFonts = null;
    private static FontMetrics[] sFontMetrics = null;
    private static Font[] sBoldFonts = null;
    private static FontMetrics[] sBoldMetrics = null;
    private static Font[] sItalicFonts = null;
    private static FontMetrics[] sItalicMetrics = null;
    private static Font[] sBoldItalicFonts = null;
    private static FontMetrics[] sBoldItalicMetrics = null;
    private CharBuffer fText;
    private StyleMgr fStyleMgr;
    private LineMgr fLineMgr;
    private TextUndoRelay fUndoRelay;
    private int fCommandNestingDepth;
    private Font fBoldFont;
    private FontMetrics fBoldMetrics;
    private Font fItalicFont;
    private FontMetrics fItalicMetrics;
    private Font fBoldItalicFont;
    private FontMetrics fBoldItalicMetrics;
    private Font fFont;
    private FontMetrics fFontMetrics;
    private int fFontBaseline;
    private int fFontHeight;
    private int fFontWidth;
    private int fIntlAdjust;
    private boolean fFontMonospaced;
    private boolean fLocaleMonospaced;
    private boolean fEditable;
    private boolean fCRMode;
    private int fSpacesPerTab = 8;
    private int fInitialCapacity;
    private int fIncrement;
    private Vector fViews;
    private Vector fViewsListeners;
    private Vector fListeners;
    private PropertyChangeSupport fPropertyChangeSupport;
    private int fSuspendTextEventCnt;
    private int fDeferStyleEvents;
    private int fDeferStyleMinPos;
    private int fDeferStyleMaxPos;
    private boolean fDeferChangeEvents;
    private boolean fSuppressChangeEvents;
    private String fLineTerminator;
    private MWTextEvent fDeleteEvent;
    private MWTextEvent fInsertEvent;

    public MWTextModel() {
        this(16);
    }

    public MWTextModel(int n) {
        this(n, 256);
    }

    public MWTextModel(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("MWTextModel(int,int): initialCapacity (" + n + ") must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("MWTextModel(int,int): increment (" + n2 + ") must be > 0");
        }
        this.fViews = new Vector();
        this.fViewsListeners = new Vector();
        this.fListeners = new Vector();
        this.fInitialCapacity = n;
        this.fIncrement = n2;
        this.fText = new CharBuffer(this.fInitialCapacity, this.fIncrement);
        this.fLineMgr = new LineMgr(this, Math.max(1, this.fInitialCapacity / 40), 256);
        this.fStyleMgr = new StyleMgr(this);
        this.fUndoRelay = new TextUndoRelay(this);
        this.fEditable = true;
        this.fText.setGrowthMode(4);
        this.fLocaleMonospaced = Locale.getDefault().getLanguage().equals("en");
        this.setDefaultFont(Decorations.getFont(0));
        this.fPropertyChangeSupport = new PropertyChangeSupport(this);
        this.checkValid();
    }

    void setCRMode(boolean bl) {
        this.fCRMode = bl;
    }

    boolean isCRMode() {
        return this.fCRMode;
    }

    public int getSpacesPerTab() {
        return this.fSpacesPerTab;
    }

    public void setSpacesPerTab(int n) {
        if (n != this.fSpacesPerTab) {
            this.fSpacesPerTab = n;
            this.notifyListeners(MWTextEvent.createStyleChangeEvent(this, 0, this.length()));
        }
    }

    public int expandedWidthInChars(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (this.fText.getAt(i) == '\t') {
                int n5 = n3 + n4;
                int n6 = this.nextTabCol(n5) - n5;
                n4 += n6;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    int nextTabCol(int n) {
        if (this.fSpacesPerTab == 0) {
            return n;
        }
        return n + this.fSpacesPerTab - n % this.fSpacesPerTab;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.fPropertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public int length() {
        return this.fText.length();
    }

    public int getNumLines() {
        return this.fLineMgr.getNumLines();
    }

    public int lineFromPos(int n) {
        this.checkPos(n);
        return this.fLineMgr.lineFromPos(n);
    }

    public int getLineStart(int n) {
        this.checkLine(n);
        return this.fLineMgr.getLineStart(n);
    }

    public int colFromPos(int n) {
        this.checkPos(n);
        return n - this.getLineStart(this.lineFromPos(n));
    }

    public int getLineLength(int n) {
        return this.getLineEnd(n) - this.getLineStart(n);
    }

    public int getLineLengthNoEOL(int n) {
        return this.getLineEndNoEOL(n) - this.getLineStart(n);
    }

    public int getLineEnd(int n) {
        this.checkLine(n);
        if (n < this.getNumLines() - 1) {
            return this.getLineStart(n + 1);
        }
        return this.length();
    }

    public int getLineEndNoEOL(int n) {
        return this.getLineEnd(n) - this.getTerminatorLength(n);
    }

    public int getTerminatorLength(int n) {
        int n2 = 0;
        int n3 = this.getLineEnd(n);
        if (n3 != this.getLineStart(n) && n3 > 0) {
            char c = this.fText.getAt(n3 - 1);
            if (c == '\r') {
                n2 = 1;
            } else if (c == '\n') {
                n2 = 1;
                if (n3 > 1 && this.fText.getAt(n3 - 2) == '\r') {
                    n2 = 2;
                }
            }
        }
        return n2;
    }

    public String getTerminator() {
        if (this.fLineTerminator == null) {
            this.fLineTerminator = System.getProperty("line.separator");
        }
        return this.fLineTerminator;
    }

    public int nextPos(int n) {
        this.checkPos(n);
        if (n == this.length()) {
            return -1;
        }
        int n2 = this.lineFromPos(n);
        if (n == this.getLineEndNoEOL(n2)) {
            return n + this.getTerminatorLength(n2);
        }
        return n + 1;
    }

    public int prevPos(int n) {
        this.checkPos(n);
        if (n == 0) {
            return -1;
        }
        if (this.colFromPos(n) > 0) {
            return n - 1;
        }
        return n - this.getTerminatorLength(this.lineFromPos(n) - 1);
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean bl) {
        if (bl == this.fEditable) {
            return;
        }
        this.fEditable = bl;
        Boolean bl2 = !this.fEditable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = this.fEditable ? Boolean.TRUE : Boolean.FALSE;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl3);
    }

    public char charAt(int n) {
        this.checkPos(n);
        return this.fText.getAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char charAtNoExc(int n) {
        char c = '\uffff';
        try {
            c = this.charAt(n);
            return c;
        }
        finally {
            return c;
        }
    }

    public String getText() {
        return this.getText(0, this.length());
    }

    public String getText(Range range) {
        return this.getText(range.getStart(), range.getEnd());
    }

    public String getText(int n, int n2) {
        this.checkPos(n);
        this.checkPos(n2);
        return this.fText.toString(Math.min(n, n2), Math.max(n, n2));
    }

    public String getLineText(int n) {
        return this.getText(this.getLineStart(n), this.getLineEnd(n));
    }

    public String getLineTextNoEOL(int n) {
        return this.getText(this.getLineStart(n), this.getLineEndNoEOL(n));
    }

    public char[] getRawCharBuf() {
        return this.fText.getRawBuf();
    }

    public CharBuffer getCharBuffer() {
        return this.fText;
    }

    public void setCharBuffer(CharBuffer charBuffer) {
        if (charBuffer == this.fText) {
            int n;
            this.fLineTerminator = null;
            char[] cArray = charBuffer.getRawBuf();
            int n2 = charBuffer.length();
            for (n = 0; n < n2; ++n) {
                if (cArray[n] == '\r') {
                    this.fLineTerminator = ++n < n2 && cArray[n] == '\n' ? "\r\n" : "\r";
                    n = n2 + 1;
                    continue;
                }
                if (cArray[n] != '\n') continue;
                this.fLineTerminator = "\n";
                n = n2 + 1;
            }
            if (this.fLineTerminator == null) {
                this.fLineTerminator = this.getTerminator();
            }
            if (n2 >= 160) {
                n = n2 / 40;
                this.fLineMgr.setGrowthFactor(n);
                this.fStyleMgr.setGrowthFactor(n * 2);
            }
            MWTextEvent mWTextEvent = MWTextEvent.createInsertEvent(this, 0, charBuffer.length());
            MWTextModel.notifyListener(this.fLineMgr, mWTextEvent);
            MWTextModel.notifyListener(this.fStyleMgr, mWTextEvent);
            this.checkValid();
            if (this.getNumLines() > 1) {
                this.fIntlAdjust = 0;
            }
            this.notifyListeners(mWTextEvent);
            if (this.getNumLines() != 0) {
                mWTextEvent = MWTextEvent.createLineChangeEvent(this, 7, 0, this.getNumLines());
                this.notifyListeners(mWTextEvent);
            }
        }
    }

    public synchronized void setText(String string) {
        this.fLineTerminator = null;
        int n = string.indexOf(10);
        this.fLineTerminator = n != -1 ? (n > 0 && string.charAt(n - 1) == '\r' ? "\r\n" : "\n") : ((n = string.indexOf(13)) != -1 ? "\r" : this.getTerminator());
        if (string.length() >= 160) {
            n = string.length() / 40;
            this.fLineMgr.setGrowthFactor(n);
            this.fStyleMgr.setGrowthFactor(n * 2);
        }
        this.replace(0, this.length(), string);
    }

    public int findString(String string, int n, boolean bl) {
        if (n < 0 || n > this.fText.length() - 1) {
            return -1;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = n;
        int n5 = this.fText.length();
        boolean bl2 = false;
        while (!bl2) {
            char c = string.charAt(n3);
            char c2 = this.fText.getAt(n4++);
            if (!bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c2 == c) {
                ++n3;
            } else if (c2 != '\r' || !this.fCRMode) {
                if (n3 > 0) {
                    n4 -= n3;
                }
                n3 = 0;
            }
            if (n3 < n2 && n4 < n5) continue;
            bl2 = true;
        }
        if (n3 >= n2) {
            return n4 - n2;
        }
        return -1;
    }

    public int findStringBackwards(String string, int n, boolean bl) {
        if (n < 0 || n > this.fText.length() - 1) {
            return -1;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = n;
        int n5 = this.fText.length();
        boolean bl2 = false;
        while (!bl2) {
            char c = string.charAt(n3);
            char c2 = this.fText.getAt(n4--);
            if (!bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c2 == c) {
                --n3;
            } else if (c2 != '\r' || !this.fCRMode) {
                if (n3 < n2) {
                    n4 += n2 - n3 - 1;
                }
                n3 = n2 - 1;
            }
            if (n4 >= 0 && n3 >= 0) continue;
            bl2 = true;
        }
        if (n3 < 0) {
            return n4 + 1;
        }
        return -1;
    }

    public Font getDefaultFont() {
        return this.fFont;
    }

    public void setDefaultFont(Font font) {
        int n = 0;
        if (!font.equals(this.fFont)) {
            if (sFonts == null) {
                sFonts = new Font[5];
                sFontMetrics = new FontMetrics[5];
                MWTextModel.sFonts[0] = font;
                MWTextModel.sFontMetrics[0] = Toolkit.getDefaultToolkit().getFontMetrics(font);
                sBoldFonts = new Font[5];
                sBoldMetrics = new FontMetrics[5];
                sItalicFonts = new Font[5];
                sItalicMetrics = new FontMetrics[5];
                sBoldItalicFonts = new Font[5];
                sBoldItalicMetrics = new FontMetrics[5];
            }
            while (n < 5) {
                if (font.equals(sFonts[n])) {
                    this.fFontMetrics = sFontMetrics[n];
                    break;
                }
                if (++n == 5) {
                    this.fFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                    break;
                }
                if (sFonts[n] != null) continue;
                MWTextModel.sFonts[n] = font;
                MWTextModel.sFontMetrics[n] = Toolkit.getDefaultToolkit().getFontMetrics(font);
            }
            this.fFont = font;
            this.fFontBaseline = this.fFontMetrics.getAscent() + this.fFontMetrics.getLeading();
            this.fFontHeight = this.fFontMetrics.getHeight();
            this.fFontWidth = this.fFontMetrics.charWidth('M');
            this.fFontMonospaced = this.isMonospaced(this.fFontMetrics);
            this.fIntlAdjust = PlatformInfo.isMacintosh() && !this.fLocaleMonospaced && this.getNumLines() <= 1 && this.fFontMetrics.getLeading() > this.fFontMetrics.getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE)) ? (this.fFontMetrics.getMaxAscent() >> 3) - this.fFontMetrics.getLeading() : 0;
            this.notifyListeners(MWTextEvent.createStyleChangeEvent(this, 0, this.length()));
        }
    }

    private boolean isMonospaced(FontMetrics fontMetrics) {
        boolean bl = false;
        if (this.fLocaleMonospaced) {
            int n = fontMetrics.charWidth('M');
            int n2 = fontMetrics.charWidth('\u007f');
            if (n2 == n + 1) {
                n2 = 0;
            }
            bl = n == fontMetrics.charWidth('i') && (n2 == 0 || n == n2);
        }
        return bl;
    }

    public int getFontBaseline() {
        return this.fFontBaseline + this.fIntlAdjust;
    }

    public int getFontWidth() {
        return this.fFontWidth;
    }

    public int getFontHeight() {
        return this.fFontHeight + this.fIntlAdjust;
    }

    public boolean isFontMonospaced() {
        return this.fFontMonospaced;
    }

    public FontMetrics getFontMetrics() {
        return this.fFontMetrics;
    }

    public FontMetrics getStyleMetrics(int n) {
        FontMetrics fontMetrics;
        if ((n & 0xC0) == 192) {
            if (this.fBoldItalicMetrics == null) {
                this.setupFontInfo(3, sBoldItalicFonts, sBoldItalicMetrics);
            }
            fontMetrics = this.fBoldItalicMetrics;
        } else if ((n & 0x80) != 0) {
            if (this.fBoldMetrics == null) {
                this.setupFontInfo(1, sBoldFonts, sBoldMetrics);
            }
            fontMetrics = this.fBoldMetrics;
        } else if ((n & 0x40) != 0) {
            if (this.fItalicMetrics == null) {
                this.setupFontInfo(2, sItalicFonts, sItalicMetrics);
            }
            fontMetrics = this.fItalicMetrics;
        } else {
            fontMetrics = this.getFontMetrics();
        }
        return fontMetrics;
    }

    Font getStyleFont(int n) {
        Font font;
        if ((n & 0xC0) == 192) {
            if (this.fBoldItalicFont == null) {
                this.setupFontInfo(3, sBoldItalicFonts, sBoldItalicMetrics);
            }
            font = this.fBoldItalicFont;
        } else if ((n & 0x80) != 0) {
            if (this.fBoldFont == null) {
                this.setupFontInfo(1, sBoldFonts, sBoldMetrics);
            }
            font = this.fBoldFont;
        } else if ((n & 0x40) != 0) {
            if (this.fItalicFont == null) {
                this.setupFontInfo(2, sItalicFonts, sItalicMetrics);
            }
            font = this.fItalicFont;
        } else {
            font = this.getDefaultFont();
        }
        return font;
    }

    private void setupFontInfo(int n, Font[] fontArray, FontMetrics[] fontMetricsArray) {
        int n2;
        for (n2 = 0; n2 < sFonts.length && this.fFont != sFonts[n2]; ++n2) {
        }
        if (n2 < fontArray.length) {
            if (fontArray[n2] == null) {
                fontArray[n2] = new Font(this.fFont.getName(), this.fFont.getStyle() | n, this.fFont.getSize());
                fontMetricsArray[n2] = Toolkit.getDefaultToolkit().getFontMetrics(fontArray[n2]);
            }
            switch (n) {
                case 1: {
                    this.fBoldFont = fontArray[n2];
                    this.fBoldMetrics = fontMetricsArray[n2];
                    break;
                }
                case 2: {
                    this.fItalicFont = fontArray[n2];
                    this.fItalicMetrics = fontMetricsArray[n2];
                    break;
                }
                case 3: {
                    this.fBoldItalicFont = fontArray[n2];
                    this.fBoldItalicMetrics = fontMetricsArray[n2];
                }
            }
        } else {
            switch (n) {
                case 1: {
                    this.fBoldFont = new Font(this.fFont.getName(), this.fFont.getStyle() | 1, this.fFont.getSize());
                    this.fBoldMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fBoldFont);
                    break;
                }
                case 2: {
                    this.fItalicFont = new Font(this.fFont.getName(), this.fFont.getStyle() | 2, this.fFont.getSize());
                    this.fItalicMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fItalicFont);
                    break;
                }
                case 3: {
                    this.fBoldItalicFont = new Font(this.fFont.getName(), this.fFont.getStyle() | 1 | 2, this.fFont.getSize());
                    this.fBoldItalicMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fBoldItalicFont);
                }
            }
        }
    }

    public void insert(int n, char c) {
        if (this.fSingletonArray1 == null) {
            this.fSingletonArray1 = new char[1];
        }
        this.fSingletonArray1[0] = c;
        this.insert(n, this.fSingletonArray1);
    }

    public void insert(int n, String string) {
        this.insert(n, string.toCharArray());
    }

    public void insert(int n, char[] cArray, int n2) {
        this.insert(n, cArray, 0, n2);
    }

    public synchronized void insert(int n, char[] cArray, int n2, int n3) {
        MWTextEvent mWTextEvent;
        if (n3 == 0) {
            return;
        }
        this.checkPos(n);
        this.checkValid();
        int n4 = this.getNumLines();
        this.fText.replace(n, n, cArray, n2, n3);
        if (this.fSuppressChangeEvents) {
            if (this.fInsertEvent == null) {
                this.fInsertEvent = MWTextEvent.createInsertEvent(this, n, n3);
            } else {
                MWTextEvent.initInsertEvent(this.fInsertEvent, n, n3);
            }
            mWTextEvent = this.fInsertEvent;
        } else {
            mWTextEvent = MWTextEvent.createInsertEvent(this, n, n3);
        }
        MWTextModel.notifyListener(this.fLineMgr, mWTextEvent);
        MWTextModel.notifyListener(this.fStyleMgr, mWTextEvent);
        this.checkValid();
        if (this.getNumLines() > 1) {
            this.fIntlAdjust = 0;
        }
        if (!this.fSuppressChangeEvents) {
            this.notifyListeners(mWTextEvent);
            if (n4 != this.getNumLines()) {
                int n5 = this.lineFromPos(n);
                mWTextEvent = MWTextEvent.createLineChangeEvent(this, 7, n5, n5 + (this.getNumLines() - n4));
                this.notifyListeners(mWTextEvent);
            }
        } else {
            int n6 = this.fViewsListeners.size();
            for (int i = 0; i < n6; ++i) {
                MWTextListener mWTextListener = (MWTextListener)this.fViewsListeners.elementAt(i);
                if (mWTextListener == null) continue;
                MWTextModel.notifyListener(mWTextListener, mWTextEvent);
            }
        }
    }

    public synchronized void insert(int n, char[] cArray) {
        this.insert(n, cArray, cArray.length);
    }

    public synchronized void delete(Range range) {
        this.delete(range.getStart(), range.getEnd());
    }

    public void suspendTextEventNotification() {
        this.fSuppressChangeEvents = true;
        ++this.fSuspendTextEventCnt;
    }

    public void resumeTextEventNotification() {
        --this.fSuspendTextEventCnt;
        if (this.fSuspendTextEventCnt <= 0) {
            this.fSuspendTextEventCnt = 0;
            this.fSuppressChangeEvents = false;
        }
    }

    boolean isTextEventNotificationSuspended() {
        return this.fSuppressChangeEvents;
    }

    public synchronized void delete(int n, int n2) {
        MWTextEvent mWTextEvent;
        if (n == n2) {
            return;
        }
        this.checkPos(n);
        this.checkPos(n2);
        this.checkValid();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        boolean bl = n <= n2;
        int n5 = this.lineFromPos(n4);
        int n6 = this.getNumLines();
        if (this.fSuppressChangeEvents) {
            if (this.fDeleteEvent == null) {
                this.fDeleteEvent = MWTextEvent.createDeleteEvent(this, n3, n4, bl, null, n5);
            } else {
                MWTextEvent.initDeleteEvent(this.fDeleteEvent, n3, n4, bl, null, n5);
            }
            mWTextEvent = this.fDeleteEvent;
        } else {
            String string = this.getText(n3, n4);
            mWTextEvent = MWTextEvent.createDeleteEvent(this, n3, n4, bl, string, n5);
        }
        this.fText.delete(n3, n4);
        MWTextModel.notifyListener(this.fLineMgr, mWTextEvent);
        MWTextModel.notifyListener(this.fStyleMgr, mWTextEvent);
        this.checkValid();
        if (!this.fSuppressChangeEvents) {
            this.notifyListeners(mWTextEvent);
            if (n6 != this.getNumLines()) {
                mWTextEvent = MWTextEvent.createLineChangeEvent(this, 8, n5 - (n6 - this.getNumLines()), n5);
                this.notifyListeners(mWTextEvent);
            }
        } else {
            int n7 = this.fViewsListeners.size();
            for (int i = 0; i < n7; ++i) {
                MWTextListener mWTextListener = (MWTextListener)this.fViewsListeners.elementAt(i);
                if (mWTextListener == null) continue;
                MWTextModel.notifyListener(mWTextListener, mWTextEvent);
            }
        }
    }

    public void replace(Range range, char c) {
        if (this.fSingletonArray2 == null) {
            this.fSingletonArray2 = new char[1];
        }
        this.fSingletonArray2[0] = c;
        this.replace(range, this.fSingletonArray2, 1);
    }

    public void replace(int n, int n2, char c) {
        if (this.fSingletonArray3 == null) {
            this.fSingletonArray3 = new char[1];
        }
        this.fSingletonArray3[0] = c;
        this.replace(n, n2, this.fSingletonArray3, 1);
    }

    public void replace(Range range, String string) {
        this.replace(range, string.toCharArray(), string.length());
    }

    public void replace(int n, int n2, String string) {
        this.replace(n, n2, string.toCharArray(), string.length());
    }

    public void replace(Range range, char[] cArray) {
        this.replace(range, cArray, cArray.length);
    }

    public synchronized void replace(Range range, char[] cArray, int n) {
        this.replace(range.getStart(), range.getEnd(), cArray, n);
    }

    public synchronized void replace(int n, int n2, char[] cArray, int n3) {
        if (n != n2) {
            this.fDeferChangeEvents = true;
            this.delete(n, n2);
        }
        if (cArray.length != 0) {
            this.fDeferChangeEvents = true;
            this.insert(Math.min(n, n2), cArray, n3);
        }
        if (this.fDeferChangeEvents) {
            this.fDeferChangeEvents = false;
            if (!this.fSuppressChangeEvents) {
                MWTextEvent mWTextEvent = MWTextEvent.createTextChangedEvent(this);
                this.notifyListeners(mWTextEvent);
            }
        }
    }

    StyleMgr getStyleMgr() {
        return this.fStyleMgr;
    }

    public void morphStyles(MWStyle[] mWStyleArray, MWStyle[] mWStyleArray2) {
        this.fStyleMgr.morphStyles(mWStyleArray, mWStyleArray2);
    }

    public int numRuns() {
        return this.fStyleMgr.numRuns();
    }

    public MWStyle getDefaultStyle() {
        return this.fStyleMgr.getDefaultStyle();
    }

    public MWStyle getStyleAt(int n) {
        return this.fStyleMgr.getStyleAt(n);
    }

    public Range getStyleRangeAt(int n, Range range) {
        int n2 = this.runIndexFromPos(n);
        if (range instanceof StyleRun) {
            StyleRun styleRun = (StyleRun)range;
            this.fStyleMgr.getStyleRunAt(n2, styleRun);
        } else {
            StyleRun styleRun = new StyleRun();
            if (n2 < this.fStyleMgr.numRuns() - 1) {
                this.fStyleMgr.getStyleRunAt(n2, styleRun);
            }
            if (range != null) {
                range.setValues(styleRun.getStart(), styleRun.getEnd());
            } else {
                range = styleRun;
            }
        }
        return range;
    }

    int runIndexFromPos(int n) {
        this.checkPos(n);
        return this.fStyleMgr.runIndexFromPos(n);
    }

    StyleRun getStyleRunAt(int n, StyleRun styleRun) {
        return this.fStyleMgr.getStyleRunAt(n, styleRun);
    }

    public void setStyle(Range range, MWStyle mWStyle) {
        this.setStyle(range.getStart(), range.getEnd(), mWStyle);
    }

    public void setStyle(int n, int n2, MWStyle mWStyle) {
        this.checkPos(n);
        this.checkPos(n2);
        this.checkValid();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.fStyleMgr.setStyle(n, n2, mWStyle);
        if (this.fDeferStyleEvents > 0) {
            this.fDeferStyleMinPos = Math.min(this.fDeferStyleMinPos, n3);
            this.fDeferStyleMaxPos = Math.max(this.fDeferStyleMaxPos, n4);
        } else {
            this.notifyListeners(MWTextEvent.createStyleChangeEvent(this, n3, n4));
        }
        this.checkValid();
    }

    public void deferStyleChangeNotification() {
        ++this.fDeferStyleEvents;
    }

    public void resumeStyleChangeNotification() {
        --this.fDeferStyleEvents;
        if (this.fDeferStyleEvents == 0) {
            this.notifyListeners(MWTextEvent.createStyleChangeEvent(this, this.fDeferStyleMinPos, this.fDeferStyleMaxPos));
            this.fDeferStyleMinPos = 0;
            this.fDeferStyleMaxPos = 0;
        }
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        this.fUndoRelay.addEdit(undoableEdit);
    }

    public boolean canUndo() {
        return this.fUndoRelay.canUndo();
    }

    public void undo() {
        if (this.fUndoRelay.canUndo()) {
            this.fUndoRelay.undo();
        }
    }

    public boolean canRedo() {
        return this.fUndoRelay.canRedo();
    }

    public void redo() {
        if (this.fUndoRelay.canRedo()) {
            this.fUndoRelay.redo();
        }
    }

    public void clearUndoHistory() {
        this.fUndoRelay.clearUndoHistory();
    }

    public void startCommand(String string) {
        ++this.fCommandNestingDepth;
        if (this.fCommandNestingDepth == 1) {
            this.notifyListeners(MWTextEvent.createCommandStartEvent(this, string));
        }
    }

    public void endCommand() {
        --this.fCommandNestingDepth;
        if (this.fCommandNestingDepth == 0) {
            this.notifyListeners(MWTextEvent.createCommandEndEvent(this));
        }
    }

    public boolean isCommandInProgress() {
        return this.fCommandNestingDepth > 0;
    }

    public void addUndoListener(UndoListener undoListener) {
        this.fUndoRelay.addUndoListener(undoListener);
    }

    public void removeUndoListener(UndoListener undoListener) {
        this.fUndoRelay.removeUndoListener(undoListener);
    }

    public void suspendUndoNotification() {
        this.fUndoRelay.suspendUndoNotification();
    }

    public void resumeUndoNotification() {
        this.fUndoRelay.resumeUndoNotification();
    }

    public MWTextView createNewView() {
        return new MWTextView(this);
    }

    public Vector getViews() {
        return this.fViews;
    }

    public void addView(MWTextView mWTextView, MWTextListener mWTextListener) {
        this.fViews.addElement(mWTextView);
        this.fViewsListeners.addElement(mWTextListener);
    }

    public boolean removeView(MWTextView mWTextView) {
        int n = this.fViews.indexOf(mWTextView);
        if (n >= 0) {
            this.fViews.removeElementAt(n);
            this.fViewsListeners.removeElementAt(n);
        }
        return n >= 0;
    }

    public MWTextView getActiveView() {
        if (this.fViews.size() == 0) {
            return null;
        }
        return (MWTextView)this.fViews.lastElement();
    }

    protected synchronized void viewWasActivated(MWTextView mWTextView) {
        int n = this.fViews.indexOf(mWTextView);
        if (n >= 0 && n != this.fViews.size() - 1) {
            this.fViews.removeElementAt(n);
            this.fViews.addElement(mWTextView);
            Object e = this.fViewsListeners.elementAt(n);
            this.fViewsListeners.removeElementAt(n);
            this.fViewsListeners.addElement(e);
        }
    }

    public void addTextListener(MWTextListener mWTextListener) {
        Assert._assert((mWTextListener != null ? 1 : 0) != 0);
        this.fListeners.addElement(mWTextListener);
    }

    public boolean removeTextListener(MWTextListener mWTextListener) {
        Assert._assert((mWTextListener != null ? 1 : 0) != 0);
        return this.fListeners.removeElement(mWTextListener);
    }

    private void notifyListeners(MWTextEvent mWTextEvent) {
        MWTextListener mWTextListener;
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            mWTextListener = (MWTextListener)enumeration.nextElement();
            MWTextModel.notifyListener(mWTextListener, mWTextEvent);
        }
        int n = mWTextEvent.getType();
        if (!(this.fDeferChangeEvents || n != 1 && n != 2)) {
            MWTextEvent mWTextEvent2 = MWTextEvent.createTextChangedEvent(this);
            enumeration = this.fListeners.elements();
            while (enumeration.hasMoreElements()) {
                mWTextListener = (MWTextListener)enumeration.nextElement();
                MWTextModel.notifyListener(mWTextListener, mWTextEvent2);
            }
        }
    }

    private static void notifyListener(MWTextListener mWTextListener, MWTextEvent mWTextEvent) {
        switch (mWTextEvent.getType()) {
            case 1: {
                mWTextListener.textInserted(mWTextEvent);
                break;
            }
            case 2: {
                mWTextListener.textDeleted(mWTextEvent);
                break;
            }
            case 3: {
                mWTextListener.styleChanged(mWTextEvent);
                break;
            }
            case 4: {
                mWTextListener.commandStarted(mWTextEvent);
                break;
            }
            case 5: {
                mWTextListener.commandEnded(mWTextEvent);
                break;
            }
            case 6: {
                mWTextListener.textChanged(mWTextEvent);
                break;
            }
            case 7: 
            case 8: {
                mWTextListener.lineChange(mWTextEvent);
            }
        }
    }

    public final void checkPos(int n) {
        if (this.isBadPos(n)) {
            System.err.println("Warning: checkPos: Invalid position (" + n + ") should be in the range [0," + this.length() + "]");
        }
    }

    public final void checkLine(int n) {
        if (this.isBadLine(n)) {
            System.err.println("\nWarning: checkLine: Invalid line (" + n + ") should be in the range [0," + this.getNumLines() + "]");
        }
    }

    private void checkValid() {
    }

    private boolean isBadPos(int n) {
        return n < 0 || n > this.length();
    }

    private boolean isBadLine(int n) {
        return n < 0 || n > this.getNumLines();
    }

    protected static class StyleRun
    extends Range {
        private MWStyle fStyle;

        public StyleRun() {
        }

        public StyleRun(MWStyle mWStyle, int n, int n2) {
            super(n, n2);
            this.fStyle = mWStyle;
        }

        public MWStyle getStyle() {
            return this.fStyle;
        }

        public void setStyle(MWStyle mWStyle) {
            this.fStyle = mWStyle;
        }

        public String toString() {
            return "[" + this.fStyle.toString() + "," + this.getStart() + "," + this.getEnd() + "]";
        }
    }
}

