/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class BaseKit
extends DefaultEditorKit {
    public static final String splitLineAction = "split-line";
    public static final String annotationsCyclingAction = "annotations-cycling";
    public static final String collapseFoldAction = "collapse-fold";
    public static final String expandFoldAction = "expand-fold";
    public static final String collapseAllFoldsAction = "collapse-all-folds";
    public static final String expandAllFoldsAction = "expand-all-folds";
    public static final String selectionPageUpAction = "selection-page-up";
    public static final String selectionPageDownAction = "selection-page-down";
    public static final String removeTabAction = "remove-tab";
    public static final String removeSelectionAction = "remove-selection";
    public static final String abbrevExpandAction = "abbrev-expand";
    public static final String abbrevResetAction = "abbrev-reset";
    public static final String removePreviousWordAction = "remove-word-previous";
    public static final String removeNextWordAction = "remove-word-next";
    public static final String removeLineBeginAction = "remove-line-begin";
    public static final String removeLineAction = "remove-line";
    public static final String toggleTypingModeAction = "toggle-typing-mode";
    public static final String toUpperCaseAction = "to-upper-case";
    public static final String toLowerCaseAction = "to-lower-case";
    public static final String switchCaseAction = "switch-case";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleHighlightSearchAction = "toggle-highlight-search";
    public static final String findSelectionAction = "find-selection";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String wordMatchNextAction = "word-match-next";
    public static final String wordMatchPrevAction = "word-match-prev";
    public static final String reindentLineAction = "reindent-line";
    public static final String shiftLineRightAction = "shift-line-right";
    public static final String shiftLineLeftAction = "shift-line-left";
    public static final String adjustWindowCenterAction = "adjust-window-center";
    public static final String adjustWindowTopAction = "adjust-window-top";
    public static final String adjustWindowBottomAction = "adjust-window-bottom";
    public static final String adjustCaretCenterAction = "adjust-caret-center";
    public static final String adjustCaretTopAction = "adjust-caret-top";
    public static final String adjustCaretBottomAction = "adjust-caret-bottom";
    public static final String formatAction = "format";
    public static final String firstNonWhiteAction = "first-non-white";
    public static final String lastNonWhiteAction = "last-non-white";
    public static final String selectionFirstNonWhiteAction = "selection-first-non-white";
    public static final String selectionLastNonWhiteAction = "selection-last-non-white";
    public static final String selectIdentifierAction = "select-identifier";
    public static final String selectNextParameterAction = "select-next-parameter";
    public static final String jumpListNextAction = "jump-list-next";
    public static final String jumpListPrevAction = "jump-list-prev";
    public static final String jumpListNextComponentAction = "jump-list-next-component";
    public static final String jumpListPrevComponentAction = "jump-list-prev-component";
    public static final String scrollUpAction = "scroll-up";
    public static final String scrollDownAction = "scroll-down";
    public static final String macroActionPrefix = "macro-";
    public static final String startMacroRecordingAction = "start-macro-recording";
    public static final String stopMacroRecordingAction = "stop-macro-recording";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String insertDateTimeAction = "insert-date-time";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    public static final String generateGutterPopupAction = "generate-gutter-popup";
    public static final String toggleLineNumbersAction = "toggle-line-numbers";
    public static final String pasteFormatedAction = "paste-formated";
    public static final String startNewLineAction = "start-new-line";
    public static final String cutToLineBeginAction = "cut-to-line-begin";
    public static final String cutToLineEndAction = "cut-to-line-end";
    private static final int KIT_CNT_PREALLOC = 7;
    static final long serialVersionUID = -8570495408376659348L;
    static Map kits = new HashMap(7);
    static Map kitKeymaps = new HashMap(7);
    static Map kitActions = new HashMap(7);
    static Map kitActionMaps = new HashMap(7);
    private static CopyAction copyActionDef = new CopyAction();
    private static CutAction cutActionDef = new CutAction();
    private static PasteAction pasteActionDef = new PasteAction(false);
    private static DeleteCharAction deletePrevCharActionDef = new DeleteCharAction("delete-previous", false);
    private static DeleteCharAction deleteNextCharActionDef = new DeleteCharAction("delete-next", true);
    private static ActionFactory.UndoAction undoActionDef = new ActionFactory.UndoAction();
    private static ActionFactory.RedoAction redoActionDef = new ActionFactory.RedoAction();
    public static final int MAGIC_POSITION_MAX = 0x7FFFFFFE;
    static SettingsChangeListener settingsListener = new SettingsChangeListener(){

        @Override
        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            boolean bl;
            String string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
            boolean bl2 = bl = string == null || "custom-action-list".equals(string) || "macro-map".equals(string);
            if (bl || "key-bindings".equals(string)) {
                kitKeymaps.clear();
            }
            if (bl) {
                kitActions.clear();
                kitActionMaps.clear();
            } else {
                for (Map.Entry entry : kitActions.entrySet()) {
                    BaseKit.updateActionSettings((Action[])entry.getValue(), settingsChangeEvent, (Class)entry.getKey());
                }
            }
        }
    };

    private static void updateActionSettings(Action[] actionArray, SettingsChangeEvent settingsChangeEvent, Class clazz) {
        for (int i = 0; i < actionArray.length; ++i) {
            if (!(actionArray[i] instanceof BaseAction)) continue;
            ((BaseAction)actionArray[i]).settingsChange(settingsChangeEvent, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseKit getKit(Class clazz) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            BaseKit baseKit;
            if (clazz == null || !BaseKit.class.isAssignableFrom(clazz)) {
                clazz = BaseKit.class;
            }
            if ((baseKit = (BaseKit)kits.get(clazz)) == null) {
                try {
                    baseKit = (BaseKit)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Utilities.annotateLoggable(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Utilities.annotateLoggable(instantiationException);
                }
                kits.put(clazz, baseKit);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return baseKit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseKit() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (kits.get(this.getClass()) == null) {
                kits.put(this.getClass(), this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public ViewFactory getViewFactory() {
        return null;
    }

    @Override
    public Caret createCaret() {
        return new BaseCaret();
    }

    @Override
    public Document createDefaultDocument() {
        return new BaseDocument(this.getClass(), true);
    }

    public Syntax createSyntax(Document document) {
        return new Syntax();
    }

    public Syntax createFormatSyntax(Document document) {
        return this.createSyntax(document);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new SyntaxSupport(baseDocument);
    }

    public Formatter createFormatter() {
        return new Formatter(this.getClass());
    }

    protected BaseTextUI createTextUI() {
        return new BaseTextUI();
    }

    protected EditorUI createEditorUI() {
        return new EditorUI();
    }

    protected EditorUI createPrintEditorUI(BaseDocument baseDocument) {
        return new EditorUI(baseDocument);
    }

    protected EditorUI createPrintEditorUI(BaseDocument baseDocument, boolean bl, boolean bl2) {
        return new EditorUI(baseDocument, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            MultiKeymap multiKeymap = (MultiKeymap)kitKeymaps.get(this.getClass());
            if (multiKeymap == null) {
                multiKeymap = new MultiKeymap("Keymap for " + this.getClass());
                Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "key-bindings");
                for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
                    List list = (List)kitAndValueArray[i].value;
                    JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[list.size()];
                    list.toArray(keyBindingArray);
                    multiKeymap.load(keyBindingArray, this.getActionMap());
                }
                multiKeymap.setDefaultAction((Action)this.getActionMap().get("default-typed"));
                kitKeymaps.put(this.getClass(), multiKeymap);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return multiKeymap;
        }
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).read(reader, n);
        } else {
            super.read(reader, document, n);
        }
    }

    @Override
    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).write(writer, n, n2);
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public static Map actionsToMap(Action[] actionArray) {
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
        }
        return hashMap;
    }

    public static Action[] mapToActions(Map map) {
        Action[] actionArray = new Action[map.size()];
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            actionArray[n++] = (Action)iterator.next();
        }
        return actionArray;
    }

    @Override
    public void install(JEditorPane jEditorPane) {
        assert (SwingUtilities.isEventDispatchThread()) : "BaseKit.install() incorrectly called from non-AWT thread.";
        BaseTextUI baseTextUI = this.createTextUI();
        jEditorPane.setUI(baseTextUI);
        String string = "netbeans.editor.noinputmethods";
        String string2 = System.getProperty(string);
        boolean bl = string2 != null ? !Boolean.getBoolean(string) : SettingsUtil.getBoolean(this.getClass(), "input-methods-enabled", true);
        jEditorPane.enableInputMethods(bl);
        this.executeInstallActions(jEditorPane);
        jEditorPane.putClientProperty("context-api-aware", Boolean.TRUE);
    }

    protected void executeInstallActions(JEditorPane jEditorPane) {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "kit-install-action-name-list");
        for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
            List list = (List)kitAndValueArray[i].value;
            if ((list = this.translateActionNameList(list)) == null) continue;
            for (Action action : list) {
                action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
            }
        }
    }

    @Override
    public void deinstall(JEditorPane jEditorPane) {
        assert (SwingUtilities.isEventDispatchThread());
        BaseTextUI.uninstallUIWatcher(jEditorPane);
        this.executeDeinstallActions(jEditorPane);
        jEditorPane.updateUI();
        if (jEditorPane.getClientProperty("ancestorOverride") != null) {
            jEditorPane.putClientProperty("ancestorOverride", Boolean.FALSE);
        }
    }

    protected void executeDeinstallActions(JEditorPane jEditorPane) {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "kit-deinstall-action-name-list");
        for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
            List list = (List)kitAndValueArray[i].value;
            if ((list = this.translateActionNameList(list)) == null) continue;
            for (Action action : list) {
                action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
            }
        }
    }

    protected void initDocument(BaseDocument baseDocument) {
    }

    protected Action[] createActions() {
        return new Action[]{new DefaultKeyTypedAction(), new InsertContentAction(), new InsertBreakAction(), new InsertTabAction(), deletePrevCharActionDef, deleteNextCharActionDef, new ReadOnlyAction(), new WritableAction(), cutActionDef, copyActionDef, pasteActionDef, new PasteAction(true), new BeepAction(), new UpAction("caret-up", false), new UpAction("selection-up", true), new PageUpAction("page-up", false), new PageUpAction(selectionPageUpAction, true), new DownAction("caret-down", false), new DownAction("selection-down", true), new PageDownAction(selectionPageDownAction, true), new PageDownAction("page-down", false), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new BeginLineAction(lineFirstColumnAction, false, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new ActionFactory.RemoveTabAction(), new ActionFactory.RemoveWordPreviousAction(), new ActionFactory.RemoveWordNextAction(), new ActionFactory.ToggleTypingModeAction(), new ActionFactory.ChangeCaseAction(toUpperCaseAction, 0), new ActionFactory.ChangeCaseAction(toLowerCaseAction, 1), new ActionFactory.ChangeCaseAction(switchCaseAction, 2), undoActionDef, redoActionDef, new ActionFactory.ShiftLineAction(shiftLineLeftAction, false), new ActionFactory.ShiftLineAction(shiftLineRightAction, true), new ActionFactory.FormatAction(), new ActionFactory.JumpListPrevAction(), new ActionFactory.JumpListNextAction(), new ActionFactory.ScrollUpAction(), new ActionFactory.ScrollDownAction(), new ActionFactory.CollapseFold(), new ActionFactory.ExpandFold(), new ActionFactory.CollapseAllFolds(), new ActionFactory.ExpandAllFolds(), new ActionFactory.DumpViewHierarchyAction(), new ActionFactory.StartNewLine()};
    }

    protected Action[] getCustomActions() {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "custom-action-list");
        if (kitAndValueArray.length == 0) {
            return null;
        }
        if (kitAndValueArray.length == 1) {
            List list = (List)kitAndValueArray[0].value;
            return list.toArray(new Action[list.size()]);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
            arrayList.addAll((List)kitAndValueArray[i].value);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected Action[] getMacroActions() {
        Class<?> clazz = this.getClass();
        Map map = (Map)Settings.getValue(clazz, "macro-map");
        if (map == null) {
            return null;
        }
        ArrayList<ActionFactory.RunMacroAction> arrayList = new ArrayList<ActionFactory.RunMacroAction>();
        for (String string : map.keySet()) {
            arrayList.add(new ActionFactory.RunMacroAction(string));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Action[] getActions() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Class<?> clazz2 = this.getClass();
            Action[] actionArray = (Action[])kitActions.get(clazz2);
            if (actionArray == null) {
                Action[] actionArray2;
                Action[] actionArray3 = this.createActions();
                BaseKit.updateActionSettings(actionArray3, null, clazz2);
                Map map = BaseKit.actionsToMap(actionArray3);
                Action[] actionArray4 = this.getCustomActions();
                if (actionArray4 != null) {
                    BaseKit.updateActionSettings(actionArray4, null, clazz2);
                    map.putAll(BaseKit.actionsToMap(actionArray4));
                }
                if ((actionArray2 = this.getMacroActions()) != null) {
                    BaseKit.updateActionSettings(actionArray2, null, clazz2);
                    map.putAll(BaseKit.actionsToMap(actionArray2));
                }
                kitActionMaps.put(clazz2, map);
                actionArray = BaseKit.mapToActions(map);
                kitActions.put(clazz2, actionArray);
                this.updateActions();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return actionArray;
        }
    }

    Map getActionMap() {
        Map map = (Map)kitActionMaps.get(this.getClass());
        if (map == null) {
            this.getActions();
            map = (Map)kitActionMaps.get(this.getClass());
            if (map == null) {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    protected void updateActions() {
    }

    public Action getActionByName(String string) {
        return string != null ? (Action)this.getActionMap().get(string) : null;
    }

    public List translateActionNameList(List list) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Action action = this.getActionByName((String)iterator.next());
                if (action == null) continue;
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    static {
        Settings.addSettingsChangeListener(settingsListener);
    }

    public static class SelectAllAction
    extends KitCompoundAction {
        static final long serialVersionUID = -3502499718130556524L;

        public SelectAllAction() {
            super("select-all", new String[]{"caret-begin", "selection-end"});
        }
    }

    public static class SelectLineAction
    extends KitCompoundAction {
        static final long serialVersionUID = -7407681863035740281L;

        public SelectLineAction() {
            super("select-line", new String[]{BaseKit.lineFirstColumnAction, "selection-end-line", "selection-forward"});
        }
    }

    public static class SelectWordAction
    extends KitCompoundAction {
        static final long serialVersionUID = 7678848538073016357L;

        public SelectWordAction() {
            super("select-word", new String[]{"caret-begin-word", "selection-end-word"});
        }
    }

    public static class EndWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3812523676620144633L;

        public EndWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3991338381212491110L;

        public BeginWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordStart(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PreviousWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5465143382669785799L;

        public PreviousWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getPreviousWord(jTextComponent, caret.getDot());
                    if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        if (this.select) {
                            baseCaret.moveDot(n);
                        } else {
                            baseCaret.setDot(n, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class NextWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5909906947175434032L;

        public NextWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = caret.getDot();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        if (this.select) {
                            baseCaret.moveDot(n);
                        } else {
                            baseCaret.setDot(n, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class EndAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8547506353130203657L;

        public EndAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = jTextComponent.getDocument().getLength();
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class BeginAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3463563396210234361L;

        public BeginAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = 0;
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class EndLineAction
    extends LocalBaseAction {
        protected boolean select;
        static final long serialVersionUID = 5216077634055190170L;

        public EndLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    Rectangle rectangle = jTextComponent.modelToView(n);
                    if (rectangle != null) {
                        Point point = new Point(0x7FFFFFFE, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginLineAction
    extends LocalBaseAction {
        protected boolean select;
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public BeginLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
            this.homeKeyColumnOne = false;
        }

        public BeginLineAction(String string, boolean bl, boolean bl2) {
            this(string, bl);
            this.homeKeyColumnOne = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    if (this.homeKeyColumnOne) {
                        n = n2;
                    } else {
                        int n3 = Utilities.getRowFirstNonWhite(baseDocument, n2);
                        if (n3 < 0) {
                            n3 = Utilities.getRowEnd(jTextComponent, n2);
                        }
                        n = n == n2 ? n3 : (n <= n3 ? n2 : n3);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -3048379822817847356L;

        public BackwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) return;
            Caret caret = jTextComponent.getCaret();
            try {
                int n;
                if (!this.select && caret.isSelectionVisible()) {
                    n = jTextComponent.getSelectionStart();
                    if (n == caret.getDot()) {
                        caret.setDot(n);
                        return;
                    }
                    ++n;
                } else {
                    n = caret.getDot();
                }
                int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Backward, 7, null);
                if (this.select) {
                    caret.moveDot(n2);
                    return;
                }
                caret.setDot(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PageDownAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8942534850985048862L;

        public PageDownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Rectangle rectangle;
                    int n;
                    Rectangle rectangle2;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = caret.getDot();
                    Rectangle rectangle3 = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n2);
                    if (rectangle3 == null) {
                        return;
                    }
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle3.x, rectangle3.y);
                    }
                    if ((rectangle2 = jTextComponent.getVisibleRect()).contains(rectangle3)) {
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        int n3 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y + rectangle2.height));
                        Rectangle rectangle5 = jTextComponent.modelToView(n3);
                        rectangle4.y = rectangle5.y;
                        int n4 = rectangle3.y - rectangle2.y;
                        int n5 = rectangle4.y + n4;
                        n = jTextComponent.viewToModel(new Point(point.x, n5));
                        rectangle = jTextComponent.modelToView(n);
                        if (rectangle.y > n5) {
                            n = jTextComponent.viewToModel(new Point(point.x, rectangle.y - rectangle.height));
                            rectangle = jTextComponent.modelToView(n);
                        }
                        rectangle4.y = rectangle.y - n4;
                        jTextComponent.scrollRectToVisible(rectangle4);
                    } else {
                        Point point2 = new Point(point.x, rectangle3.y + rectangle2.height);
                        n = jTextComponent.viewToModel(point2);
                        rectangle = jTextComponent.modelToView(n);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    point.y = rectangle.y;
                    caret.setMagicCaretPosition(point);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ForwardAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8007293230193334414L;

        public ForwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) return;
            Caret caret = jTextComponent.getCaret();
            try {
                int n;
                if (!this.select && caret.isSelectionVisible()) {
                    n = jTextComponent.getSelectionEnd();
                    if (n == caret.getDot()) {
                        caret.setDot(n);
                        return;
                    }
                    --n;
                } else {
                    n = caret.getDot();
                }
                int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, 3, null);
                if (this.select) {
                    caret.moveDot(n2);
                    return;
                }
                caret.setDot(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PageUpAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -3107382148581661079L;

        public PageUpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Rectangle rectangle;
                    int n;
                    Rectangle rectangle2;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = caret.getDot();
                    Rectangle rectangle3 = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n2);
                    if (rectangle3 == null) {
                        return;
                    }
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle3.x, rectangle3.y);
                    }
                    if ((rectangle2 = jTextComponent.getVisibleRect()).contains(rectangle3)) {
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        int n3 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                        Rectangle rectangle5 = jTextComponent.modelToView(n3);
                        if (rectangle5.y != rectangle2.y) {
                            rectangle4.y = rectangle5.y + rectangle5.height;
                        }
                        rectangle4.y -= rectangle2.height;
                        int n4 = rectangle3.y - rectangle2.y;
                        int n5 = rectangle4.y + n4;
                        n = jTextComponent.viewToModel(new Point(point.x, n5));
                        rectangle = jTextComponent.modelToView(n);
                        if (rectangle.y < n5) {
                            n = jTextComponent.viewToModel(new Point(point.x, rectangle.y + rectangle.height));
                            rectangle = jTextComponent.modelToView(n);
                        }
                        rectangle4.y = rectangle.y - n4;
                        jTextComponent.scrollRectToVisible(rectangle4);
                    } else {
                        Point point2 = new Point(point.x, rectangle3.y - rectangle2.height);
                        n = jTextComponent.viewToModel(point2);
                        rectangle = jTextComponent.modelToView(n);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    point.y = rectangle.y;
                    caret.setMagicCaretPosition(point);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class DownAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5635702355125266822L;

        public DownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    try {
                        Caret caret = jTextComponent.getCaret();
                        int n = this.select ? caret.getDot() : Math.max(caret.getDot(), caret.getMark());
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            Rectangle rectangle = jTextComponent.modelToView(n);
                            if (rectangle != null) {
                                point = new Point(rectangle.x, rectangle.y);
                                caret.setMagicCaretPosition(point);
                            } else {
                                return;
                            }
                        }
                        try {
                            n = Utilities.getPositionBelow(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block9;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UpAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 4621760742646981563L;

        public UpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    try {
                        Caret caret = jTextComponent.getCaret();
                        int n = this.select ? caret.getDot() : Math.min(caret.getDot(), caret.getMark());
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            Rectangle rectangle = jTextComponent.modelToView(n);
                            if (rectangle != null) {
                                point = new Point(rectangle.x, rectangle.y);
                                caret.setMagicCaretPosition(point);
                            } else {
                                return;
                            }
                        }
                        try {
                            n = Utilities.getPositionAbove(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block9;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class BeepAction
    extends LocalBaseAction {
        static final long serialVersionUID = -4474054576633223968L;

        public BeepAction() {
            super("beep");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PasteAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5839791453996432149L;
        private boolean formated;

        public PasteAction(boolean bl) {
            super(bl ? BaseKit.pasteFormatedAction : "paste-from-clipboard", 156);
            this.formated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument == null) {
                    return;
                }
                baseDocument.atomicLock();
                try {
                    if (this.formated) {
                        Caret caret = jTextComponent.getCaret();
                        int n = jTextComponent.getSelectionStart();
                        jTextComponent.paste();
                        int n2 = caret.getDot();
                        PasteAction.indentBlock(baseDocument, n, n2);
                    } else {
                        jTextComponent.paste();
                    }
                }
                catch (Exception exception) {
                    jTextComponent.getToolkit().beep();
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
        }

        public static void indentBlock(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            char[] cArray = baseDocument.getChars(n, n2 - n);
            String[] stringArray = PasteAction.toLines(new String(cArray));
            baseDocument.remove(n, n2 - n);
            int n3 = n;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                String string = PasteAction.getIndentString(baseDocument, n3, stringArray[i]);
                String string2 = string + stringArray[i].trim() + '\n';
                baseDocument.insertString(n3, string2, null);
                n3 += string2.length();
            }
            baseDocument.insertString(n3, stringArray[stringArray.length - 1], null);
        }

        private static String[] toLines(String string) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\n') continue;
                vector.add(string.substring(n, i + 1));
                n = i + 1;
            }
            if (n < string.length()) {
                vector.add(string.substring(n, string.length()));
            } else {
                vector.add("");
            }
            return vector.toArray(new String[0]);
        }

        private static String getIndentString(BaseDocument baseDocument, int n, String string) {
            try {
                int n2;
                Formatter formatter = baseDocument.getFormatter();
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                Writer writer = formatter.createWriter(baseDocument, n, charArrayWriter);
                writer.write(string, 0, string.length());
                writer.close();
                String string2 = new String(charArrayWriter.toCharArray());
                for (n2 = 0; n2 < string2.length() && (string2.charAt(n2) == ' ' || string2.charAt(n2) == '\t'); ++n2) {
                }
                return string2.substring(0, n2);
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    public static class CopyAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5119779005431986964L;

        public CopyAction() {
            super("copy-to-clipboard", 156);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class CutAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6377157040901778853L;

        public CutAction() {
            super("cut-to-clipboard", 156);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.cut();
            }
        }
    }

    public static class WritableAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5982547952800937954L;

        public WritableAction() {
            super("set-writable");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    public static class ReadOnlyAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9204335480208463193L;

        public ReadOnlyAction() {
            super("set-read-only");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    public static class DeleteCharAction
    extends LocalBaseAction {
        protected boolean nextChar;
        static final long serialVersionUID = -4321971925753148556L;

        public DeleteCharAction(String string, boolean bl) {
            super(string, 22);
            this.nextChar = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    try {
                        if (n != n2) {
                            baseDocument.remove(Math.min(n, n2), Math.abs(n - n2));
                            break block9;
                        }
                        if (this.nextChar) {
                            baseDocument.remove(n, 1);
                            break block9;
                        }
                        baseDocument.atomicLock();
                        try {
                            char c = baseDocument.getChars(n - 1, 1)[0];
                            baseDocument.remove(n - 1, 1);
                            this.charBackspaced(baseDocument, n - 1, caret, c);
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        }
    }

    public static class InsertStringAction
    extends LocalBaseAction {
        String text;
        static final long serialVersionUID = -2755852016584693328L;

        public InsertStringAction(String string, String string2) {
            super(string, 22);
            this.text = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection(this.text);
            }
        }
    }

    public static class InsertContentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5647751370952797218L;

        public InsertContentAction() {
            super("insert-content", 22);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KitCompoundAction
    extends LocalBaseAction {
        private String[] actionNames;
        static final long serialVersionUID = 8415246475764264835L;

        public KitCompoundAction(String string, String[] stringArray) {
            this(string, 0, stringArray);
        }

        public KitCompoundAction(String string, int n, String[] stringArray) {
            super(string, n);
            this.actionNames = stringArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            BaseKit baseKit;
            if (jTextComponent != null && (baseKit = Utilities.getKit(jTextComponent)) != null) {
                for (int i = 0; i < this.actionNames.length; ++i) {
                    Action action = baseKit.getActionByName(this.actionNames[i]);
                    if (action == null) continue;
                    if (action instanceof BaseAction) {
                        ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                        continue;
                    }
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    public static class CompoundAction
    extends LocalBaseAction {
        Action[] actions;
        static final long serialVersionUID = 1649688300969753758L;

        public CompoundAction(String string, Action[] actionArray) {
            this(string, 0, actionArray);
        }

        public CompoundAction(String string, int n, Action[] actionArray) {
            super(string, n);
            this.actions = actionArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                for (int i = 0; i < this.actions.length; ++i) {
                    Action action = this.actions[i];
                    if (action instanceof BaseAction) {
                        ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                        continue;
                    }
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    public static class InsertTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3379768531715989243L;

        public InsertTabAction() {
            super("insert-tab", 22);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), 1);
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    int n;
                    int n2 = caret.getDot();
                    try {
                        n = baseDocument.getVisColFromPos(n2);
                    }
                    catch (BadLocationException badLocationException) {
                        Utilities.annotateLoggable(badLocationException);
                        n = 0;
                    }
                    try {
                        int n3;
                        int n4 = 0;
                        if (n4 == -1) {
                            n4 = 0;
                        }
                        if ((n3 = Utilities.getRowIndent(baseDocument, n2)) == -1) {
                            n3 = n4 > n ? n4 : Utilities.getNextTabColumn(baseDocument, n2);
                            int n5 = Utilities.getRowStart(baseDocument, n2);
                            baseDocument.getFormatter().changeRowIndent(baseDocument, n2, n3);
                            int n6 = baseDocument.getOffsetFromVisCol(n3, n5);
                            if (n6 >= 0) {
                                caret.setDot(n6);
                            }
                        } else {
                            baseDocument.getFormatter().insertTabString(baseDocument, n2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class SplitLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public SplitLineAction() {
            super(BaseKit.splitLineAction, 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                baseDocument.atomicLock();
                try {
                    jTextComponent.replaceSelection("");
                    int n2 = n;
                    baseDocument.getFormatter().indentNewLine(baseDocument, n);
                    caret.setDot(n2);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public InsertBreakAction() {
            super("insert-break", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection("");
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.atomicLock();
                try {
                    Object object = this.beforeBreak(jTextComponent, baseDocument, caret);
                    int n = caret.getDot();
                    int n2 = baseDocument.getFormatter().indentNewLine(baseDocument, n);
                    caret.setDot(n2);
                    this.afterBreak(jTextComponent, baseDocument, caret, object);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
        }

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
        }
    }

    public static class DefaultKeyTypedAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3069164318144463899L;
        private static final boolean isMac = Utilities.isOSX();

        public DefaultKeyTypedAction() {
            super("default-typed", 162);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                boolean bl;
                boolean bl2;
                int n = actionEvent.getModifiers();
                boolean bl3 = bl2 = (n & 2) != 0;
                boolean bl4 = isMac ? (n & 4) != 0 : (bl = (n & 8) != 0);
                if (bl || bl2) {
                    return;
                }
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() == 1) {
                    baseDocument.atomicLock();
                    DocumentUtilities.setTypingModification(baseDocument, true);
                    try {
                        block18: {
                            char c = string.charAt(0);
                            if (c >= ' ' && c != '\u007f') {
                                editorUI.getWordMatch().clear();
                                Boolean bl5 = (Boolean)editorUI.getProperty("overwriteMode");
                                try {
                                    boolean bl6 = true;
                                    if (!bl6) break block18;
                                    if (caret.isSelectionVisible()) {
                                        boolean bl7 = bl5 != null && bl5 != false;
                                        this.replaceSelection(jTextComponent, caret.getDot(), caret, string, bl7);
                                        break block18;
                                    }
                                    int n2 = caret.getDot();
                                    if (bl5 != null && bl5.booleanValue() && n2 < baseDocument.getLength() && baseDocument.getChars(n2, 1)[0] != '\n') {
                                        baseDocument.atomicLock();
                                        try {
                                            this.insertString(baseDocument, n2, caret, string, true);
                                            break block18;
                                        }
                                        finally {
                                            baseDocument.atomicUnlock();
                                        }
                                    }
                                    baseDocument.atomicLock();
                                    try {
                                        this.insertString(baseDocument, n2, caret, string, false);
                                    }
                                    finally {
                                        baseDocument.atomicUnlock();
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    jTextComponent.getToolkit().beep();
                                }
                            }
                        }
                        this.checkIndent(jTextComponent, string);
                    }
                    finally {
                        DocumentUtilities.setTypingModification(baseDocument, false);
                        baseDocument.atomicUnlock();
                    }
                }
            }
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            if (bl) {
                baseDocument.remove(n, 1);
            }
            baseDocument.insertString(n, string, null);
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            jTextComponent.replaceSelection(string);
        }

        protected void checkIndent(JTextComponent jTextComponent, String string) {
        }
    }
}

