/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import org.netbeans.editor.DrawContext;
import org.netbeans.editor.MarkFactory;

public interface DrawLayer {
    public static final String TEXT_FRAME_START_POSITION_COMPONENT_PROPERTY = "text-frame-start-position";
    public static final String TEXT_FRAME_END_POSITION_COMPONENT_PROPERTY = "text-frame-end-position";

    public String getName();

    public boolean extendsEOL();

    public boolean extendsEmptyLine();

    public int getNextActivityChangeOffset(DrawContext var1);

    public void init(DrawContext var1);

    public boolean isActive(DrawContext var1, MarkFactory.DrawMark var2);

    public void updateContext(DrawContext var1);

    public int updateLineNumberContext(int var1, DrawContext var2);

    public static abstract class AbstractLayer
    implements DrawLayer {
        private String name;
        int nextActivityChangeOffset = Integer.MAX_VALUE;

        public AbstractLayer(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean extendsEOL() {
            return false;
        }

        @Override
        public boolean extendsEmptyLine() {
            return false;
        }

        @Override
        public int getNextActivityChangeOffset(DrawContext drawContext) {
            return this.nextActivityChangeOffset;
        }

        public void setNextActivityChangeOffset(int n) {
            this.nextActivityChangeOffset = n;
        }

        @Override
        public void init(DrawContext drawContext) {
        }

        @Override
        public int updateLineNumberContext(int n, DrawContext drawContext) {
            return n;
        }

        public String toString() {
            return "Layer " + this.getClass() + ", name='" + this.name;
        }
    }
}

