/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DocumentFinder;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;
import org.openide.util.NbBundle;

public class FindSupport {
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String WRAP_BLOCK_START_LOCALE = "find-block-wrap-start";
    private static final String WRAP_BLOCK_END_LOCALE = "find-block-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    private static final String SEARCH_BLOCK_START = "search-block-start";
    private static final String SEARCH_BLOCK_END = "search-block-end";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    static FindSupport findSupport;
    private Map findProps;
    WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport();
    SearchPatternWrapper lastSelected;
    List historyList;

    private FindSupport() {
    }

    public static FindSupport getFindSupport() {
        if (findSupport == null) {
            findSupport = new FindSupport();
        }
        return findSupport;
    }

    public Map getDefaultFindProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Class<BaseKit> clazz = BaseKit.class;
        hashMap.put("find-what", Settings.getValue(clazz, "find-what"));
        hashMap.put("find-replace-with", Settings.getValue(clazz, "find-replace-with"));
        hashMap.put("find-highlight-search", Settings.getValue(clazz, "find-highlight-search"));
        hashMap.put("find-inc-search", Settings.getValue(clazz, "find-inc-search"));
        hashMap.put("find-backward-search", Settings.getValue(clazz, "find-backward-search"));
        hashMap.put("find-wrap-search", Settings.getValue(clazz, "find-wrap-search"));
        hashMap.put("find-match-case", Settings.getValue(clazz, "find-match-case"));
        hashMap.put("find-smart-case", Settings.getValue(clazz, "find-smart-case"));
        hashMap.put("find-whole-words", Settings.getValue(clazz, "find-whole-words"));
        hashMap.put("find-reg-exp", Settings.getValue(clazz, "find-reg-exp"));
        hashMap.put("find-history", Settings.getValue(clazz, "find-history"));
        return hashMap;
    }

    private int getBlockEndOffset() {
        Position position = (Position)this.getFindProperties().get("find-block-search-end");
        return position != null ? position.getOffset() : -1;
    }

    public Map getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.getDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String string) {
        return this.getFindProperties().get(string);
    }

    private Map getValidFindProperties(Map map) {
        return map != null ? map : this.getFindProperties();
    }

    int[] getBlocks(int[] nArray, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        Map map = this.getValidFindProperties(null);
        Boolean bl = (Boolean)map.get("find-block-search");
        boolean bl2 = bl != null && bl != false;
        Integer n3 = (Integer)map.get("find-block-search-start");
        int n4 = n3 != null ? n3 : -1;
        int n5 = this.getBlockEndOffset();
        if (bl2 && n4 > -1 && n5 > 0) {
            if (n2 >= n4 && n <= n5) {
                n = Math.max(n4, n);
                n2 = Math.min(n5, n2);
            } else {
                return nArray;
            }
        }
        return DocumentFinder.findBlocks(baseDocument, n, n2, map, nArray);
    }

    Object getPropertyNoInit(String string) {
        if (this.findProps == null) {
            return null;
        }
        return this.getFindProperty(string);
    }

    public void putFindProperty(String string, Object object) {
        Object object2 = this.getFindProperty(string);
        if (object2 == null && object == null || object2 != null && object2.equals(object)) {
            return;
        }
        if (object != null) {
            this.getFindProperties().put(string, object);
        } else {
            this.getFindProperties().remove(string);
        }
        this.firePropertyChange(string, object2, object);
    }

    public void putFindProperties(Map map) {
        if (!this.getFindProperties().equals(map)) {
            this.getFindProperties().putAll(map);
            this.firePropertyChange(null, null, null);
        }
    }

    public void setBlockSearchHighlight(int n, int n2) {
        boolean bl;
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
        DrawLayerFactory.BlockSearchLayer blockSearchLayer = (DrawLayerFactory.BlockSearchLayer)editorUI.findLayer("block-search-layer");
        Boolean bl2 = (Boolean)this.getFindProperties().get("find-backward-search");
        boolean bl3 = bl = bl2 != null && bl2 != false;
        if (n >= n2) {
            if (blockSearchLayer != null && blockSearchLayer.isEnabled()) {
                blockSearchLayer.setEnabled(false);
                try {
                    editorUI.repaintBlock(blockSearchLayer.getOffset(), blockSearchLayer.getOffset() + blockSearchLayer.getLength());
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
        } else {
            if (blockSearchLayer == null) {
                blockSearchLayer = new DrawLayerFactory.BlockSearchLayer();
                if (!editorUI.addLayer(blockSearchLayer, 8500)) {
                    return;
                }
            } else if (blockSearchLayer.isEnabled()) {
                blockSearchLayer.setEnabled(false);
                try {
                    editorUI.repaintOffset(blockSearchLayer.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
            blockSearchLayer.setEnabled(true);
            blockSearchLayer.setArea(n, n2 - n);
            try {
                editorUI.repaintBlock(n, n2);
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
                return;
            }
            jTextComponent.getCaret().setDot(bl ? n2 : n);
        }
    }

    public IncSearchReturn incSearch(Map map, int n) {
        Boolean bl = (Boolean)(map = this.getValidFindProperties(map)).get("find-reg-exp");
        if (bl != null && bl.booleanValue()) {
            return new IncSearchReturn(false, 0, 0);
        }
        bl = (Boolean)map.get("find-inc-search");
        if (bl != null && bl.booleanValue()) {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
                int n2;
                Object object;
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                bl = (Boolean)map.get("find-backward-search");
                boolean bl2 = bl != null && bl != false;
                bl = (Boolean)map.get("find-block-search");
                boolean bl3 = bl != null && bl != false;
                Integer n3 = (Integer)map.get("find-block-search-start");
                int n4 = n3 != null ? n3 : -1;
                Position position = (Position)map.get("find-block-search-end");
                int n5 = position != null ? position.getOffset() : -1;
                int n6 = bl2 ? 0 : -1;
                String string = (String)map.get("find-what");
                try {
                    int n7;
                    int n8 = bl3 && n4 > -1 ? n4 : 0;
                    int n9 = n7 = bl3 && n5 > 0 ? n5 : -1;
                    if (n8 > 0 && n7 == -1) {
                        return new IncSearchReturn(false, n8, 0);
                    }
                    object = this.findInBlock(jTextComponent, n, n8, n7, map, false);
                    if (object == null) {
                        this.incSearchReset();
                        Utilities.setStatusBoldText(jTextComponent, "'" + string + "' " + NbBundle.getBundle(BaseKit.class).getString(NOT_FOUND_LOCALE));
                        return new IncSearchReturn(false, n8, 0);
                    }
                    n2 = object[0];
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                    return new IncSearchReturn(false, 0, 0);
                }
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                EditorUI editorUI = baseTextUI.getEditorUI();
                object = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
                if (object == null) {
                    object = new DrawLayerFactory.IncSearchLayer();
                    if (!editorUI.addLayer((DrawLayer)object, 9500)) {
                        return new IncSearchReturn(false, n2, 0);
                    }
                } else if (object.isEnabled()) {
                    object.setEnabled(false);
                    try {
                        editorUI.repaintOffset(object.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        Utilities.annotateLoggable(badLocationException);
                    }
                }
                if (n2 >= 0) {
                    int n10;
                    int n11 = n10 = string != null ? string.length() : 0;
                    if (n10 > 0) {
                        if (jTextComponent.getSelectionEnd() > jTextComponent.getSelectionStart()) {
                            jTextComponent.select(n, n);
                        }
                        JumpList.checkAddEntry(jTextComponent, n2);
                        object.setInversion(false);
                        object.setEnabled(true);
                        object.setArea(n2, n10);
                        Map map2 = this.getValidFindProperties(null);
                        String string2 = (String)map2.get("find-what");
                        if (string2 != null && string2.length() > 0) {
                            map2.put("find-what", "");
                            editorUI.getComponent().repaint();
                        }
                        try {
                            editorUI.repaintOffset(n2);
                            this.ensureVisible(jTextComponent, n2, n2, bl2);
                        }
                        catch (BadLocationException badLocationException) {
                            Utilities.annotateLoggable(badLocationException);
                        }
                        String string3 = "'" + string + "' " + NbBundle.getBundle(BaseKit.class).getString(FOUND_LOCALE) + ' ' + Utilities.debugPosition((BaseDocument)jTextComponent.getDocument(), n2);
                        Utilities.setStatusText(jTextComponent, string3);
                        return new IncSearchReturn(true, n2, n10);
                    }
                } else {
                    Utilities.setStatusBoldText(jTextComponent, "'" + string + "' " + NbBundle.getBundle(BaseKit.class).getString(NOT_FOUND_LOCALE));
                }
            }
        } else {
            this.incSearchReset();
        }
        return new IncSearchReturn(false, 0, 0);
    }

    public void incSearchReset() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
        DrawLayerFactory.IncSearchLayer incSearchLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
        if (incSearchLayer != null && incSearchLayer.isEnabled()) {
            incSearchLayer.setEnabled(false);
            try {
                editorUI.repaintOffset(incSearchLayer.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
        }
    }

    private boolean isBackSearch(Map map, boolean bl) {
        boolean bl2;
        Boolean bl3 = (Boolean)map.get("find-backward-search");
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            bl2 = !bl2;
        }
        return bl2;
    }

    private void selectText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        Caret caret = jTextComponent.getCaret();
        this.ensureVisible(jTextComponent, n, n2, bl);
        if (bl) {
            caret.setDot(n2);
            caret.moveDot(n);
        } else {
            caret.setDot(n);
            caret.moveDot(n2);
        }
    }

    private void ensureVisible(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        Class<BaseKit> clazz = Utilities.getKitClass(jTextComponent);
        if (clazz == null) {
            clazz = BaseKit.class;
        }
        Insets insets = (Insets)Settings.getValue(clazz, "scroll-find-insets");
        if (bl) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        }
        this.ensureVisible(jTextComponent, n, n2, insets, bl);
    }

    private void ensureVisible(JTextComponent jTextComponent, int n, int n2, Insets insets, boolean bl) {
        try {
            Rectangle rectangle = jTextComponent.modelToView(n);
            Rectangle rectangle2 = jTextComponent.modelToView(n2);
            if (rectangle != null && rectangle2 != null) {
                rectangle.add(rectangle2);
                if (insets != null) {
                    int n3;
                    Rectangle rectangle3 = jTextComponent.getVisibleRect();
                    int n4 = insets.top < 0 ? -insets.top * rectangle3.height / 100 : insets.top * rectangle2.height;
                    int n5 = n3 = insets.bottom < 0 ? -insets.bottom * rectangle3.height / 100 : insets.bottom * rectangle2.height;
                    if (rectangle3.contains(rectangle)) {
                        Rectangle rectangle4 = new Rectangle(rectangle);
                        if (!bl) {
                            rectangle4.height += n4;
                        } else {
                            rectangle4.y -= n3;
                            rectangle4.height += n3;
                        }
                        if (rectangle3.contains(rectangle4)) {
                            return;
                        }
                    }
                    rectangle.y -= n4;
                    rectangle.height += n4;
                    rectangle.height += n3;
                    int n6 = insets.left < 0 ? -insets.left * rectangle3.width / 100 : insets.left * rectangle2.width;
                    rectangle.x -= n6;
                    rectangle.width += n6;
                    rectangle.width = rectangle.width + (insets.right < 0 ? -insets.right * rectangle3.width / 100 : insets.right * rectangle2.width);
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private DocumentFinder.FindReplaceResult findReplaceImpl(String string, Map map, boolean bl) {
        this.incSearchReset();
        map = this.getValidFindProperties(map);
        boolean bl2 = this.isBackSearch(map, bl);
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        Object v = map.get("find-what");
        if (v == null) {
            return null;
        }
        String string2 = "'" + v + "' ";
        if (jTextComponent != null) {
            Object object;
            boolean bl3;
            Utilities.clearStatusText(jTextComponent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            if (v.equals(jTextComponent.getSelectedText()) && n == (bl ^ (bl3 = (object = map.get("find-backward-search")) != null ? (Boolean)object : false) ? jTextComponent.getSelectionEnd() : jTextComponent.getSelectionStart())) {
                n += bl ^ bl3 ? -1 : 1;
            }
            bl3 = (object = (Boolean)map.get("find-block-search")) != null && ((Boolean)object).booleanValue();
            Integer n2 = (Integer)map.get("find-block-search-start");
            int n3 = n2 != null ? n2 : -1;
            int n4 = this.getBlockEndOffset();
            try {
                DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceInBlock(string, jTextComponent, n, bl3 && n3 > -1 ? n3 : 0, bl3 && n4 > 0 ? n4 : -1, map, bl);
                int[] nArray = null;
                if (findReplaceResult != null) {
                    nArray = findReplaceResult.getFoundPositions();
                }
                if (nArray != null) {
                    this.selectText(jTextComponent, nArray[0], nArray[1], bl2);
                    JumpList.checkAddEntry();
                    String string3 = string2 + NbBundle.getBundle(BaseKit.class).getString(FOUND_LOCALE) + ' ' + Utilities.debugPosition((BaseDocument)jTextComponent.getDocument(), nArray[0]);
                    if (nArray[2] == 1) {
                        string3 = string3 + "; ";
                        string3 = bl3 && n4 > 0 && n3 > -1 ? string3 + (bl2 ? NbBundle.getBundle(BaseKit.class).getString(WRAP_BLOCK_END_LOCALE) : NbBundle.getBundle(BaseKit.class).getString(WRAP_BLOCK_START_LOCALE)) : string3 + (bl2 ? NbBundle.getBundle(BaseKit.class).getString(WRAP_END_LOCALE) : NbBundle.getBundle(BaseKit.class).getString(WRAP_START_LOCALE));
                        Utilities.setStatusBoldText(jTextComponent, string3);
                        jTextComponent.getToolkit().beep();
                    } else {
                        Utilities.setStatusText(jTextComponent, string3);
                    }
                    return findReplaceResult;
                }
                Utilities.setStatusBoldText(jTextComponent, string2 + NbBundle.getBundle(BaseKit.class).getString(NOT_FOUND_LOCALE));
                jTextComponent.getCaret().setDot(jTextComponent.getCaret().getDot());
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
        }
        return null;
    }

    public boolean find(Map map, boolean bl) {
        DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceImpl(null, map, bl);
        return findReplaceResult != null;
    }

    private DocumentFinder.FindReplaceResult findReplaceInBlock(String string, JTextComponent jTextComponent, int n, int n2, int n3, Map map, boolean bl) throws BadLocationException {
        if (jTextComponent != null) {
            int[] nArray;
            map = this.getValidFindProperties(map);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n4 = -1;
            boolean bl2 = false;
            String string2 = null;
            boolean bl3 = this.isBackSearch(map, bl);
            Boolean bl4 = (Boolean)map.get("find-wrap-search");
            boolean bl5 = bl4 != null && bl4 != false;
            int n5 = baseDocument.getLength();
            if (n3 == -1) {
                n3 = n5;
            }
            while (true) {
                int n6;
                int n7;
                DocumentFinder.FindReplaceResult findReplaceResult;
                if ((findReplaceResult = DocumentFinder.findReplaceResult(string, baseDocument, Math.min(n7 = n, n6 = bl3 ? n2 : n3), Math.max(n7, n6), map, bl)) == null) {
                    return null;
                }
                nArray = findReplaceResult.getFoundPositions();
                string2 = findReplaceResult.getReplacedString();
                if (nArray == null || (n4 = nArray[0]) != -1 || !bl5) break;
                n = bl3 ? n3 : n2;
                bl2 = true;
                bl5 = false;
            }
            if (n4 != -1) {
                int[] nArray2 = new int[]{n4, nArray[1], bl2 ? 1 : 0};
                return new DocumentFinder.FindReplaceResult(nArray2, string2);
            }
        }
        return null;
    }

    public int[] findInBlock(JTextComponent jTextComponent, int n, int n2, int n3, Map map, boolean bl) throws BadLocationException {
        DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceInBlock(null, jTextComponent, n, n2, n3, map, bl);
        return findReplaceResult == null ? null : findReplaceResult.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Map map, boolean bl) throws BadLocationException {
        boolean bl2;
        this.incSearchReset();
        map = this.getValidFindProperties(map);
        Boolean bl3 = (Boolean)map.get("find-backward-search");
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            bl2 = !bl2;
        }
        boolean bl5 = (bl3 = (Boolean)map.get("find-block-search")) != null && bl3 != false;
        Integer n = (Integer)map.get("find-block-search-start");
        int n2 = n != null ? n : -1;
        int n3 = this.getBlockEndOffset();
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            DocumentFinder.FindReplaceResult findReplaceResult;
            int n4;
            Object object;
            String string = (String)map.get("find-replace-with");
            Caret caret = jTextComponent.getCaret();
            if (caret.isSelectionVisible()) {
                int n5 = caret.getDot();
                object = map.get("find-backward-search");
                n4 = (object != null ? (Boolean)object : 0) ? 1 : 0;
                n5 = bl ^ n4 ? jTextComponent.getSelectionEnd() : jTextComponent.getSelectionStart();
                jTextComponent.setCaretPosition(n5);
            }
            if ((findReplaceResult = this.findReplaceImpl(string, map, bl)) == null) {
                return false;
            }
            string = findReplaceResult.getReplacedString();
            object = (BaseDocument)jTextComponent.getDocument();
            n4 = jTextComponent.getSelectionStart();
            int n6 = jTextComponent.getSelectionEnd() - n4;
            ((BaseDocument)object).atomicLock();
            try {
                if (n6 > 0) {
                    ((BaseDocument)object).remove(n4, n6);
                }
                if (string != null && string.length() > 0) {
                    ((BaseDocument)object).insertString(n4, string, null);
                }
            }
            finally {
                ((BaseDocument)object).atomicUnlock();
                if (bl5) {
                    this.setBlockSearchHighlight(n2, this.getBlockEndOffset());
                }
            }
            int n7 = bl2 || string == null ? n4 : n4 + string.length();
            caret.setDot(n7);
        }
        return true;
    }

    public void replaceAll(Map map) {
        this.replaceAll(map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Map hashMap, boolean bl) {
        Integer n;
        boolean bl2;
        this.incSearchReset();
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        int n2 = baseDocument.getLength();
        int n3 = 0;
        int n4 = 0;
        hashMap = this.getValidFindProperties(hashMap);
        hashMap = new HashMap<String, Boolean>(hashMap);
        String string = (String)hashMap.get("find-replace-with");
        Boolean bl3 = (Boolean)hashMap.get("find-block-search");
        boolean bl4 = bl3 != null && bl3 != false;
        bl3 = (Boolean)hashMap.get("find-wrap-search");
        boolean bl5 = bl3 != null && bl3 != false;
        bl3 = (Boolean)hashMap.get("find-backward-search");
        boolean bl6 = bl2 = bl3 != null && bl3 != false;
        if (bl5) {
            hashMap.put("find-wrap-search", Boolean.FALSE);
            hashMap.put("find-backward-search", Boolean.FALSE);
            this.firePropertyChange(null, null, null);
        }
        int n5 = (n = (Integer)hashMap.get("find-block-search-start")) != null ? n : -1;
        int n6 = this.getBlockEndOffset();
        if (jTextComponent != null) {
            baseDocument.atomicLock();
            try {
                Object object;
                Object object2;
                int n7;
                int n8 = 0;
                int n9 = -1;
                int n10 = jTextComponent.getCaret().getDot();
                if (!bl5) {
                    if (bl2) {
                        n8 = 0;
                        n9 = n10;
                    } else {
                        n8 = n10;
                        n9 = -1;
                    }
                }
                int n11 = n7 = bl5 ? 0 : jTextComponent.getSelectionStart();
                int n12 = bl4 && n5 > -1 ? (bl2 ? n6 : n5) : n7;
                while (true) {
                    n6 = this.getBlockEndOffset();
                    object2 = this.findReplaceInBlock(string, jTextComponent, n12, bl4 && n5 > -1 ? n5 : n8, bl4 && n6 > 0 ? n6 : n9, hashMap, false);
                    if (object2 == null) break;
                    object = ((DocumentFinder.FindReplaceResult)object2).getFoundPositions();
                    String string2 = ((DocumentFinder.FindReplaceResult)object2).getReplacedString();
                    if (object == null) break;
                    ++n4;
                    int n13 = object[1] - object[0];
                    boolean bl7 = false;
                    try {
                        baseDocument.remove(object[0], n13);
                    }
                    catch (GuardedException guardedException) {
                        bl7 = true;
                    }
                    if (bl7) {
                        n12 = object[0] + n13;
                        continue;
                    }
                    if (string2 != null && string2.length() > 0) {
                        baseDocument.insertString(object[0], string2, null);
                    }
                    n12 = !bl ? object[0] + (string2 != null ? string2.length() : 0) : object[0] + n13;
                    ++n3;
                }
                if (n4 == 0) {
                    object2 = hashMap.get("find-what");
                    object = "'' ";
                    if (object2 != null) {
                        object = "'" + object2 + "' ";
                    }
                    Utilities.setStatusBoldText(jTextComponent, (String)object + NbBundle.getBundle(BaseKit.class).getString(NOT_FOUND_LOCALE));
                } else {
                    object2 = new MessageFormat(NbBundle.getBundle(BaseKit.class).getString(ITEMS_REPLACED_LOCALE));
                    object = ((Format)object2).format(new Object[]{new Integer(n3), new Integer(n4)});
                    Utilities.setStatusText(jTextComponent, (String)object);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            finally {
                baseDocument.atomicUnlock();
                if (bl4) {
                    this.setBlockSearchHighlight(n5, this.getBlockEndOffset());
                }
            }
        }
    }

    public int getWrapSearchMarkPos(BaseDocument baseDocument) {
        Mark mark = (Mark)baseDocument.getProperty("wrap-search-mark");
        try {
            return mark != null ? mark.getOffset() : baseDocument.getLength();
        }
        catch (InvalidMarkException invalidMarkException) {
            throw new RuntimeException();
        }
    }

    public void setWrapSearchMarkPos(BaseDocument baseDocument, int n) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(this, string, object, object2);
    }

    public void setHistory(List list) {
        this.historyList = new ArrayList(list);
        this.firePropertyChange(FIND_HISTORY_CHANGED_PROP, null, null);
    }

    public List getHistory() {
        return this.historyList;
    }

    public void setLastSelected(SearchPatternWrapper searchPatternWrapper) {
        this.lastSelected = searchPatternWrapper;
        Map map = this.getFindProperties();
        if (searchPatternWrapper == null) {
            return;
        }
        map.put("find-what", searchPatternWrapper.getSearchExpression());
        map.put("find-match-case", searchPatternWrapper.isMatchCase());
        map.put("find-reg-exp", searchPatternWrapper.isRegExp());
        map.put("find-whole-words", searchPatternWrapper.isWholeWords());
    }

    public SearchPatternWrapper getLastSelected() {
        return this.lastSelected;
    }

    public void addToHistory(SearchPatternWrapper searchPatternWrapper) {
        if (searchPatternWrapper == null) {
            return;
        }
        this.firePropertyChange(FIND_HISTORY_PROP, null, searchPatternWrapper);
    }

    public static class SearchPatternWrapper {
        private String searchExpression;
        private boolean wholeWords;
        private boolean matchCase;
        private boolean regExp;

        public SearchPatternWrapper(String string, boolean bl, boolean bl2, boolean bl3) {
            this.searchExpression = string;
            this.wholeWords = bl;
            this.matchCase = bl2;
            this.regExp = bl3;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchPatternWrapper)) {
                return false;
            }
            SearchPatternWrapper searchPatternWrapper = (SearchPatternWrapper)object;
            return this.searchExpression.equals(searchPatternWrapper.getSearchExpression()) && this.wholeWords == searchPatternWrapper.isWholeWords() && this.matchCase == searchPatternWrapper.isMatchCase() && this.regExp == searchPatternWrapper.isRegExp();
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + (this.wholeWords ? 1 : 0);
            n = 37 * n + (this.matchCase ? 1 : 0);
            n = 37 * n + (this.regExp ? 1 : 0);
            n = 37 * n + this.searchExpression.hashCode();
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            stringBuffer.append('\n');
            stringBuffer.append("wholeWords:");
            stringBuffer.append(this.wholeWords);
            stringBuffer.append('\n');
            stringBuffer.append("matchCase:");
            stringBuffer.append(this.matchCase);
            stringBuffer.append('\n');
            stringBuffer.append("regExp:");
            stringBuffer.append(this.regExp);
            return stringBuffer.toString();
        }
    }

    public class IncSearchReturn {
        private boolean fFoundText = false;
        private int fPos = 0;
        private int fLen = 0;

        public IncSearchReturn(boolean bl, int n, int n2) {
            this.fFoundText = bl;
            this.fPos = n;
            this.fLen = n2;
        }

        public int getLength() {
            return this.fLen;
        }

        public int getPos() {
            return this.fPos;
        }

        public boolean getFoundText() {
            return this.fFoundText;
        }
    }
}

