/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;

public class CCSyntax
extends Syntax {
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_BSLASH = 7;
    private static final int ISI_CHAR = 8;
    private static final int ISI_CHAR_A_BSLASH = 9;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_EQ = 12;
    private static final int ISA_GT = 13;
    private static final int ISA_GTGT = 14;
    private static final int ISA_LT = 16;
    private static final int ISA_LTLT = 17;
    private static final int ISA_PLUS = 18;
    private static final int ISA_MINUS = 19;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT = 21;
    private static final int ISA_PIPE = 22;
    private static final int ISA_PERCENT = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_XOR = 25;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_OCTAL = 29;
    private static final int ISI_DOUBLE = 30;
    private static final int ISI_DOUBLE_EXP = 31;
    private static final int ISI_HEX = 32;
    private static final int ISA_DOT = 33;
    private static final int ISA_HASH = 34;
    private static final int ISA_HASH_WS = 35;
    private static final int ISA_BACKSLASH = 36;
    private static final int ISA_LINE_CONTINUATION = 37;
    private static final int ISA_COMMA = 38;
    private static final int ISA_INCLUDE = 39;
    private static final int ISA_INCLUDE_A_WS = 40;
    private static final int ISI_SYS_INCLUDE = 41;
    private static final int ISI_USR_START_INCLUDE = 42;
    private static final int ISI_USR_INCLUDE = 43;
    private static final int ISA_COLON = 44;
    private static final int ISA_ARROW = 45;
    protected static final String IS_CPLUSPLUS = "C++";
    protected static final String IS_C = "C";
    protected String lang;

    public CCSyntax() {
        this.tokenContextPath = CCTokenContext.contextPath;
        this.lang = IS_CPLUSPLUS;
    }

    @Override
    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '\"': {
                            this.state = 6;
                            break block0;
                        }
                        case '\'': {
                            this.state = 8;
                            break block0;
                        }
                        case '/': {
                            this.state = 11;
                            break block0;
                        }
                        case '\\': {
                            this.state = 36;
                            break block0;
                        }
                        case '=': {
                            this.state = 12;
                            break block0;
                        }
                        case '>': {
                            this.state = 13;
                            break block0;
                        }
                        case '<': {
                            this.state = 16;
                            break block0;
                        }
                        case '+': {
                            this.state = 18;
                            break block0;
                        }
                        case '-': {
                            this.state = 19;
                            break block0;
                        }
                        case '*': {
                            this.state = 20;
                            break block0;
                        }
                        case '|': {
                            this.state = 22;
                            break block0;
                        }
                        case '%': {
                            this.state = 23;
                            break block0;
                        }
                        case '&': {
                            this.state = 24;
                            break block0;
                        }
                        case '^': {
                            this.state = 25;
                            break block0;
                        }
                        case '~': {
                            ++this.offset;
                            return CCTokenContext.NEG;
                        }
                        case '!': {
                            this.state = 26;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                        case ',': {
                            ++this.offset;
                            return CCTokenContext.COMMA;
                        }
                        case ';': {
                            ++this.offset;
                            return CCTokenContext.SEMICOLON;
                        }
                        case ':': {
                            this.state = 44;
                            break block0;
                        }
                        case '?': {
                            ++this.offset;
                            return CCTokenContext.QUESTION;
                        }
                        case '(': {
                            ++this.offset;
                            return CCTokenContext.LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return CCTokenContext.RPAREN;
                        }
                        case '[': {
                            ++this.offset;
                            return CCTokenContext.LBRACKET;
                        }
                        case ']': {
                            ++this.offset;
                            return CCTokenContext.RBRACKET;
                        }
                        case '{': {
                            ++this.offset;
                            return CCTokenContext.LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return CCTokenContext.RBRACE;
                        }
                        case '#': {
                            this.state = 34;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        this.state = 28;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 10;
                        break;
                    }
                    ++this.offset;
                    return CCTokenContext.INVALID_CHAR;
                }
                case 2: {
                    if (Character.isWhitespace(c)) break;
                    this.state = -1;
                    return CCTokenContext.WHITESPACE;
                }
                case 4: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return CCTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (c) {
                        case '*': {
                            this.state = 21;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\\': {
                            this.state = 7;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 6;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\\': {
                            this.state = 9;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.CHAR_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.CHAR_LITERAL;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 8;
                    break;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID == null && (tokenID = CCSyntax.matchCPPKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset)) != null && (tokenID.getNumericID() == 146 || tokenID.getNumericID() == 147)) {
                        this.state = 39;
                    }
                    return tokenID != null ? tokenID : CCTokenContext.IDENTIFIER;
                }
                case 39: {
                    if (!CCSyntax.isSpaceChar(c) && c != '\"' && c != '<') {
                        this.state = -1;
                        return CCTokenContext.CPPINCLUDE;
                    }
                    this.state = 40;
                    break;
                }
                case 40: {
                    if (CCSyntax.isSpaceChar(c)) {
                        this.state = 40;
                        break;
                    }
                    switch (c) {
                        case '<': {
                            this.state = 41;
                            break;
                        }
                        case '\"': {
                            this.state = 42;
                            break;
                        }
                        default: {
                            this.state = Character.isJavaIdentifierStart(c) ? 10 : -1;
                        }
                    }
                    return CCTokenContext.WHITESPACE;
                }
                case 41: {
                    switch (c) {
                        case '>': {
                            ++this.offset;
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.SYS_INCLUDE;
                            return this.offset - this.tokenOffset <= 2 ? CCTokenContext.INCOMPLETE_SYS_INCLUDE : CCTokenContext.SYS_INCLUDE;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.SYS_INCLUDE;
                            return CCTokenContext.INCOMPLETE_SYS_INCLUDE;
                        }
                    }
                    break;
                }
                case 42: {
                    switch (c) {
                        case '\"': {
                            this.state = 43;
                            break block0;
                        }
                    }
                    break;
                }
                case 43: {
                    switch (c) {
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.USR_INCLUDE;
                            return this.offset - this.tokenOffset <= 2 ? CCTokenContext.INCOMPLETE_USR_INCLUDE : CCTokenContext.USR_INCLUDE;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.USR_INCLUDE;
                            return CCTokenContext.INCOMPLETE_USR_INCLUDE;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DIV_EQ;
                        }
                        case '/': {
                            this.state = 4;
                            break block0;
                        }
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.DIV;
                }
                case 36: {
                    switch (c) {
                        case '\n': {
                            this.state = 37;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.INVALID_BACKSLASH;
                }
                case 37: {
                    this.state = -1;
                    return CCTokenContext.BACKSLASH;
                }
                case 34: {
                    if (CCSyntax.isSpaceChar(c)) {
                        this.state = 35;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 10;
                        break;
                    }
                    this.state = -1;
                    if (c == '#') {
                        ++this.offset;
                        return CCTokenContext.DOUBLE_HASH;
                    }
                    return CCTokenContext.HASH;
                }
                case 35: {
                    if (CCSyntax.isSpaceChar(c)) {
                        this.state = 35;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 10;
                        break;
                    }
                    this.state = -1;
                    return CCTokenContext.HASH;
                }
                case 12: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.EQ_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.EQ;
                }
                case 13: {
                    switch (c) {
                        case '>': {
                            this.state = 14;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.GT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.GT;
                }
                case 14: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.RSSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.RSSHIFT;
                }
                case 16: {
                    switch (c) {
                        case '<': {
                            this.state = 17;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.LT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.LT;
                }
                case 17: {
                    switch (c) {
                        case '<': {
                            this.state = -1;
                            ++this.offset;
                            return CCTokenContext.INVALID_OPERATOR;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.LSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.LSHIFT;
                }
                case 18: {
                    switch (c) {
                        case '+': {
                            ++this.offset;
                            return CCTokenContext.PLUS_PLUS;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.PLUS_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.PLUS;
                }
                case 19: {
                    switch (c) {
                        case '-': {
                            ++this.offset;
                            return CCTokenContext.MINUS_MINUS;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.MINUS_EQ;
                        }
                        case '>': {
                            this.state = 45;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MINUS;
                }
                case 45: {
                    switch (c) {
                        case '*': {
                            this.state = -1;
                            ++this.offset;
                            return CCTokenContext.ARROWMBR;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.ARROW;
                }
                case 38: {
                    this.state = -1;
                    return CCTokenContext.COMMA;
                }
                case 44: {
                    switch (c) {
                        case ':': {
                            ++this.offset;
                            return CCTokenContext.SCOPE;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.COLON;
                }
                case 20: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.MUL_EQ;
                        }
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.INVALID_COMMENT_END;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MUL;
                }
                case 21: {
                    switch (c) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 22: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.OR_EQ;
                        }
                        case '|': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.OR_OR;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.OR;
                }
                case 23: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.MOD_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MOD;
                }
                case 24: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.AND_EQ;
                        }
                        case '&': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.AND_AND;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.AND;
                }
                case 25: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.XOR_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.XOR;
                }
                case 26: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.NOT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.NOT;
                }
                case 27: {
                    switch (c) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            this.state = 32;
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.LONG_LITERAL;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case '8': 
                        case '9': {
                            this.state = -1;
                            ++this.offset;
                            return CCTokenContext.INVALID_OCTAL_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (Character.isDigit(c)) {
                        this.state = 29;
                        break;
                    }
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (c) {
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.LONG_LITERAL;
                        }
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') break;
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 29: {
                    if (c >= '0' && c <= '7') break;
                    this.state = -1;
                    return CCTokenContext.OCTAL_LITERAL;
                }
                case 30: {
                    switch (c) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9' || c == '.') break;
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 31: {
                    switch (c) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                    }
                    if (Character.isDigit(c) || c == '-' || c == '+') break;
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || Character.isDigit(c)) break;
                    this.state = -1;
                    return CCTokenContext.HEX_LITERAL;
                }
                case 33: {
                    if (Character.isDigit(c)) {
                        this.state = 30;
                        break;
                    }
                    if (c == '*') {
                        this.state = -1;
                        ++this.offset;
                        return CCTokenContext.DOTMBR;
                    }
                    this.state = -1;
                    return CCTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return CCTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID == null && (tokenID = CCSyntax.matchCPPKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset)) != null && tokenID.getNumericID() == 146) {
                        this.state = 39;
                    }
                    return tokenID != null ? tokenID : CCTokenContext.IDENTIFIER;
                }
                case 4: {
                    return CCTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return CCTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 7: {
                    return CCTokenContext.STRING_LITERAL;
                }
                case 41: {
                    return CCTokenContext.INCOMPLETE_SYS_INCLUDE;
                }
                case 39: {
                    return CCTokenContext.CPPINCLUDE;
                }
                case 40: {
                    return CCTokenContext.WHITESPACE;
                }
                case 43: {
                    return CCTokenContext.INCOMPLETE_USR_INCLUDE;
                }
                case 8: 
                case 9: {
                    return CCTokenContext.CHAR_LITERAL;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 29: {
                    this.state = -1;
                    return CCTokenContext.OCTAL_LITERAL;
                }
                case 30: 
                case 31: {
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    this.state = -1;
                    return CCTokenContext.HEX_LITERAL;
                }
                case 36: {
                    this.state = -1;
                    return CCTokenContext.BACKSLASH;
                }
                case 37: {
                    this.state = -1;
                    return CCTokenContext.LINE_CONTINUATION;
                }
                case 33: {
                    this.state = -1;
                    return CCTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return CCTokenContext.DIV;
                }
                case 12: {
                    this.state = -1;
                    return CCTokenContext.EQ;
                }
                case 13: {
                    this.state = -1;
                    return CCTokenContext.GT;
                }
                case 14: {
                    this.state = -1;
                    return CCTokenContext.RSSHIFT;
                }
                case 16: {
                    this.state = -1;
                    return CCTokenContext.LT;
                }
                case 17: {
                    this.state = -1;
                    return CCTokenContext.LSHIFT;
                }
                case 18: {
                    this.state = -1;
                    return CCTokenContext.PLUS;
                }
                case 19: {
                    this.state = -1;
                    return CCTokenContext.MINUS;
                }
                case 45: {
                    this.state = -1;
                    return CCTokenContext.ARROW;
                }
                case 38: {
                    this.state = -1;
                    return CCTokenContext.COMMA;
                }
                case 20: {
                    this.state = -1;
                    return CCTokenContext.MUL;
                }
                case 22: {
                    this.state = -1;
                    return CCTokenContext.OR;
                }
                case 23: {
                    this.state = -1;
                    return CCTokenContext.MOD;
                }
                case 24: {
                    this.state = -1;
                    return CCTokenContext.AND;
                }
                case 25: {
                    this.state = -1;
                    return CCTokenContext.XOR;
                }
                case 26: {
                    this.state = -1;
                    return CCTokenContext.NOT;
                }
                case 34: {
                    this.state = -1;
                    return CCTokenContext.HASH;
                }
                case 44: {
                    this.state = -1;
                    return CCTokenContext.COLON;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return CCTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    @Override
    public String getStateName(int n) {
        switch (n) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_BSLASH";
            }
            case 8: {
                return "ISI_CHAR";
            }
            case 9: {
                return "ISI_CHAR_A_BSLASH";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 36: {
                return "ISA_BACKSLASH";
            }
            case 12: {
                return "ISA_EQ";
            }
            case 13: {
                return "ISA_GT";
            }
            case 14: {
                return "ISA_GTGT";
            }
            case 16: {
                return "ISA_LT";
            }
            case 17: {
                return "ISA_LTLT";
            }
            case 18: {
                return "ISA_PLUS";
            }
            case 19: {
                return "ISA_MINUS";
            }
            case 38: {
                return "ISA_COMMA";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT";
            }
            case 22: {
                return "ISA_PIPE";
            }
            case 23: {
                return "ISA_PERCENT";
            }
            case 24: {
                return "ISA_AND";
            }
            case 25: {
                return "ISA_XOR";
            }
            case 26: {
                return "ISA_EXCLAMATION";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 29: {
                return "ISI_OCTAL";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 31: {
                return "ISI_DOUBLE_EXP";
            }
            case 32: {
                return "ISI_HEX";
            }
            case 33: {
                return "ISA_DOT";
            }
            case 34: {
                return "ISA_HASH";
            }
            case 39: {
                return "ISA_INCLUDE";
            }
            case 40: {
                return "ISA_INCLUDE_A_WS";
            }
            case 41: {
                return "ISI_SYS_INCLUDE";
            }
            case 43: {
                return "ISI_USR_INCLUDE";
            }
            case 42: {
                return "ISI_USR_START_INCLUDE";
            }
        }
        return super.getStateName(n);
    }

    public TokenID matchKeyword(char[] cArray, int n, int n2) {
        if (n2 > 16) {
            return null;
        }
        if (n2 <= 1) {
            return null;
        }
        switch (cArray[n++]) {
            case 'a': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 's': {
                        return this.lang == IS_CPLUSPLUS && n2 == 3 && cArray[n++] == 'm' ? CCTokenContext.ASM : null;
                    }
                    case 'u': {
                        return n2 == 4 && cArray[n++] == 't' && cArray[n++] == 'o' ? CCTokenContext.AUTO : null;
                    }
                }
                return null;
            }
            case 'b': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'o': {
                        return this.lang == IS_CPLUSPLUS && n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 'l' ? CCTokenContext.BOOLEAN : null;
                    }
                    case 'r': {
                        return n2 == 5 && cArray[n++] == 'e' && cArray[n++] == 'a' && cArray[n++] == 'k' ? CCTokenContext.BREAK : null;
                    }
                }
                return null;
            }
            case 'c': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 4 && cArray[n++] == 'e' ? CCTokenContext.CASE : null;
                            }
                            case 't': {
                                return this.lang == IS_CPLUSPLUS && n2 == 5 && cArray[n++] == 'c' && cArray[n++] == 'h' ? CCTokenContext.CATCH : null;
                            }
                        }
                        return null;
                    }
                    case 'h': {
                        return n2 == 4 && cArray[n++] == 'a' && cArray[n++] == 'r' ? CCTokenContext.CHAR : null;
                    }
                    case 'l': {
                        return this.lang == IS_CPLUSPLUS && n2 == 5 && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 's' ? CCTokenContext.CLASS : null;
                    }
                    case 'o': {
                        if (n2 <= 4) {
                            return null;
                        }
                        if (cArray[n++] != 'n') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 's': {
                                if (this.lang == IS_CPLUSPLUS && n2 == 5) {
                                    return cArray[n++] == 't' ? CCTokenContext.CONST : null;
                                }
                                if (this.lang == IS_CPLUSPLUS && n2 == 10) {
                                    return cArray[n++] == 't' && cArray[n++] == '_' && cArray[n++] == 'c' && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 't' ? CCTokenContext.CONST_CAST : null;
                                }
                                return null;
                            }
                            case 't': {
                                return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'u' && cArray[n++] == 'e' ? CCTokenContext.CONTINUE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'd': {
                if (n2 <= 1) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'e': {
                        switch (cArray[n++]) {
                            case 'f': {
                                return n2 == 7 && cArray[n++] == 'a' && cArray[n++] == 'u' && cArray[n++] == 'l' && cArray[n++] == 't' ? CCTokenContext.DEFAULT : null;
                            }
                            case 'l': {
                                return this.lang == IS_CPLUSPLUS && n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 't' && cArray[n++] == 'e' ? CCTokenContext.DELETE : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        if (n2 == 2) {
                            return CCTokenContext.DO;
                        }
                        return n2 == 6 && cArray[n++] == 'u' && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'e' ? CCTokenContext.DOUBLE : null;
                    }
                    case 'y': {
                        return this.lang == IS_CPLUSPLUS && n2 == 12 && cArray[n++] == 'n' && cArray[n++] == 'a' && cArray[n++] == 'm' && cArray[n++] == 'i' && cArray[n++] == 'c' && cArray[n++] == '_' && cArray[n++] == 'c' && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 't' ? CCTokenContext.DYNAMIC_CAST : null;
                    }
                }
                return null;
            }
            case 'e': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'l': {
                        return n2 == 4 && cArray[n++] == 's' && cArray[n++] == 'e' ? CCTokenContext.ELSE : null;
                    }
                    case 'n': {
                        return n2 == 4 && cArray[n++] == 'u' && cArray[n++] == 'm' ? CCTokenContext.ENUM : null;
                    }
                    case 'x': {
                        switch (cArray[n++]) {
                            case 'p': {
                                switch (cArray[n++]) {
                                    case 'l': {
                                        return this.lang == IS_CPLUSPLUS && n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'c' && cArray[n++] == 'i' && cArray[n++] == 't' ? CCTokenContext.EXPLICIT : null;
                                    }
                                    case 'o': {
                                        return this.lang == IS_CPLUSPLUS && n2 == 6 && cArray[n++] == 'r' && cArray[n++] == 't' ? CCTokenContext.EXPORT : null;
                                    }
                                }
                                return null;
                            }
                            case 't': {
                                return n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 'r' && cArray[n++] == 'n' ? CCTokenContext.EXTERN : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'f': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return this.lang == IS_CPLUSPLUS && n2 == 5 && cArray[n++] == 'l' && cArray[n++] == 's' && cArray[n++] == 'e' ? CCTokenContext.FALSE : null;
                    }
                    case 'l': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'a' && cArray[n++] == 't' ? CCTokenContext.FLOAT : null;
                    }
                    case 'o': {
                        return n2 == 3 && cArray[n++] == 'r' ? CCTokenContext.FOR : null;
                    }
                    case 'r': {
                        return this.lang == IS_CPLUSPLUS && n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 'e' && cArray[n++] == 'n' && cArray[n++] == 'd' ? CCTokenContext.FRIEND : null;
                    }
                }
                return null;
            }
            case 'g': {
                return n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 't' && cArray[n++] == 'o' ? CCTokenContext.GOTO : null;
            }
            case 'i': {
                switch (cArray[n++]) {
                    case 'f': {
                        return n2 == 2 ? CCTokenContext.IF : null;
                    }
                    case 'n': {
                        switch (cArray[n++]) {
                            case 't': {
                                return n2 == 3 ? CCTokenContext.INT : null;
                            }
                            case 'l': {
                                return n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'e' ? CCTokenContext.INLINE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'l': {
                return n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 'n' && cArray[n++] == 'g' ? CCTokenContext.LONG : null;
            }
            case 'm': {
                return this.lang == IS_CPLUSPLUS && n2 == 7 && cArray[n++] == 'u' && cArray[n++] == 't' && cArray[n++] == 'a' && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'e' ? CCTokenContext.MUTABLE : null;
            }
            case 'n': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return this.lang == IS_CPLUSPLUS && n2 == 9 && cArray[n++] == 'm' && cArray[n++] == 'e' && cArray[n++] == 's' && cArray[n++] == 'p' && cArray[n++] == 'a' && cArray[n++] == 'c' && cArray[n++] == 'e' ? CCTokenContext.NAMESPACE : null;
                    }
                    case 'e': {
                        return this.lang == IS_CPLUSPLUS && n2 == 3 && cArray[n++] == 'w' ? CCTokenContext.NEW : null;
                    }
                }
                return null;
            }
            case 'o': {
                return this.lang == IS_CPLUSPLUS && n2 == 8 && cArray[n++] == 'p' && cArray[n++] == 'e' && cArray[n++] == 'r' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'o' && cArray[n++] == 'r' ? CCTokenContext.OPERATOR : null;
            }
            case 'p': {
                if (this.lang == IS_C || n2 <= 5) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'r': {
                        if (n2 <= 6) {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 7 && cArray[n++] == 'v' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'e' ? CCTokenContext.PRIVATE : null;
                            }
                            case 'o': {
                                return n2 == 9 && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'c' && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'd' ? CCTokenContext.PROTECTED : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return n2 == 6 && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'i' && cArray[n++] == 'c' ? CCTokenContext.PUBLIC : null;
                    }
                }
                return null;
            }
            case 'r': {
                if (n2 < 6 || cArray[n++] != 'e') {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'g': {
                        return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 's' && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'r' ? CCTokenContext.REGISTER : null;
                    }
                    case 'i': {
                        return this.lang == IS_CPLUSPLUS && n2 == 16 && cArray[n++] == 'n' && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'r' && cArray[n++] == 'p' && cArray[n++] == 'r' && cArray[n++] == 'e' && cArray[n++] == 't' && cArray[n++] == '_' && cArray[n++] == 'c' && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 't' ? CCTokenContext.REINTERPRET_CAST : null;
                    }
                    case 's': {
                        return this.lang == IS_C && n2 == 8 && cArray[n++] == 't' && cArray[n++] == 'r' && cArray[n++] == 'i' && cArray[n++] == 'c' && cArray[n++] == 't' ? CCTokenContext.RESTRICT : null;
                    }
                    case 't': {
                        return n2 == 6 && cArray[n++] == 'u' && cArray[n++] == 'r' && cArray[n++] == 'n' ? CCTokenContext.RETURN : null;
                    }
                }
                return null;
            }
            case 's': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'h': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'r' && cArray[n++] == 't' ? CCTokenContext.SHORT : null;
                    }
                    case 'i': {
                        switch (cArray[n++]) {
                            case 'z': {
                                return n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 'o' && cArray[n++] == 'f' ? CCTokenContext.SIZEOF : null;
                            }
                            case 'g': {
                                return n2 == 6 && cArray[n++] == 'n' && cArray[n++] == 'e' && cArray[n++] == 'd' ? CCTokenContext.SIGNED : null;
                            }
                        }
                        return null;
                    }
                    case 't': {
                        switch (cArray[n++]) {
                            case 'r': {
                                return n2 == 6 && cArray[n++] == 'u' && cArray[n++] == 'c' && cArray[n++] == 't' ? CCTokenContext.STRUCT : null;
                            }
                            case 'a': {
                                if (n2 == 6) {
                                    return cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'c' ? CCTokenContext.STATIC : null;
                                }
                                if (this.lang == IS_CPLUSPLUS && n2 == 11) {
                                    return cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'c' && cArray[n++] == '_' && cArray[n++] == 'c' && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 't' ? CCTokenContext.STATIC_CAST : null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'w': {
                        return n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 't' && cArray[n++] == 'c' && cArray[n++] == 'h' ? CCTokenContext.SWITCH : null;
                    }
                }
                return null;
            }
            case 't': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'e': {
                        return this.lang == IS_CPLUSPLUS && n2 == 8 && cArray[n++] == 'm' && cArray[n++] == 'p' && cArray[n++] == 'l' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'e' ? CCTokenContext.TEMPLATE : null;
                    }
                    case 'h': {
                        switch (cArray[n++]) {
                            case 'i': {
                                return this.lang == IS_CPLUSPLUS && n2 == 4 && cArray[n++] == 's' ? CCTokenContext.THIS : null;
                            }
                            case 'r': {
                                return this.lang == IS_CPLUSPLUS && n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'w' ? CCTokenContext.THROW : null;
                            }
                        }
                        return null;
                    }
                    case 'r': {
                        switch (cArray[n++]) {
                            case 'u': {
                                return this.lang == IS_CPLUSPLUS && n2 == 4 && cArray[n++] == 'e' ? CCTokenContext.TRUE : null;
                            }
                            case 'y': {
                                return this.lang == IS_CPLUSPLUS && n2 == 3 ? CCTokenContext.TRY : null;
                            }
                        }
                        return null;
                    }
                    case 'y': {
                        if (n2 <= 5 || cArray[n++] != 'p' || cArray[n++] != 'e') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'd': {
                                return n2 == 7 && cArray[n++] == 'e' && cArray[n++] == 'f' ? CCTokenContext.TYPEDEF : null;
                            }
                            case 'i': {
                                return this.lang == IS_CPLUSPLUS && n2 == 6 && cArray[n++] == 'd' ? CCTokenContext.TYPEID : null;
                            }
                            case 'n': {
                                return this.lang == IS_CPLUSPLUS && n2 == 8 && cArray[n++] == 'a' && cArray[n++] == 'm' && cArray[n++] == 'e' ? CCTokenContext.TYPENAME : null;
                            }
                            case 'o': {
                                return this.lang == IS_C && n2 == 6 && cArray[n++] == 'f' ? CCTokenContext.TYPEOF : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'u': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 's': {
                        return this.lang == IS_CPLUSPLUS && n2 == 5 && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'g' ? CCTokenContext.USING : null;
                    }
                    case 'n': {
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'n' ? CCTokenContext.UNION : null;
                            }
                            case 's': {
                                return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'g' && cArray[n++] == 'n' && cArray[n++] == 'e' && cArray[n++] == 'd' ? CCTokenContext.UNSIGNED : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'v': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'i': {
                        return this.lang == IS_CPLUSPLUS && n2 == 7 && cArray[n++] == 'r' && cArray[n++] == 't' && cArray[n++] == 'u' && cArray[n++] == 'a' && cArray[n++] == 'l' ? CCTokenContext.VIRTUAL : null;
                    }
                    case 'o': {
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 4 && cArray[n++] == 'd' ? CCTokenContext.VOID : null;
                            }
                            case 'l': {
                                return n2 == 8 && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'l' && cArray[n++] == 'e' ? CCTokenContext.VOLATILE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'w': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'c': {
                        return this.lang == IS_CPLUSPLUS && n2 == 7 && cArray[n++] == 'h' && cArray[n++] == 'a' && cArray[n++] == 'r' && cArray[n++] == '_' && cArray[n++] == 't' ? CCTokenContext.WCHAR_T : null;
                    }
                    case 'h': {
                        return n2 == 5 && cArray[n++] == 'i' && cArray[n++] == 'l' && cArray[n++] == 'e' ? CCTokenContext.WHILE : null;
                    }
                }
                return null;
            }
            case '_': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'B': {
                        return this.lang == IS_C && n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'o' && cArray[n++] == 'l' ? CCTokenContext._BOOL : null;
                    }
                    case 'C': {
                        return this.lang == IS_C && n2 == 8 && cArray[n++] == 'o' && cArray[n++] == 'm' && cArray[n++] == 'p' && cArray[n++] == 'l' && cArray[n++] == 'e' && cArray[n++] == 'x' ? CCTokenContext._COMPLEX : null;
                    }
                    case 'I': {
                        return this.lang == IS_C && n2 == 10 && cArray[n++] == 'm' && cArray[n++] == 'a' && cArray[n++] == 'g' && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'a' && cArray[n++] == 'r' && cArray[n++] == 'y' ? CCTokenContext._IMAGINARY : null;
                    }
                }
            }
        }
        return null;
    }

    public static TokenID matchCPPKeyword(char[] cArray, int n, int n2) {
        if (cArray[n] != '#') {
            return null;
        }
        --n2;
        ++n;
        while (n2 > 0 && Character.isWhitespace(cArray[n])) {
            ++n;
            --n2;
        }
        BaseImageTokenID baseImageTokenID = CCTokenContext.CPPIDENTIFIER;
        if (n2 > 15) {
            return baseImageTokenID;
        }
        if (n2 <= 1) {
            return baseImageTokenID;
        }
        switch (cArray[n++]) {
            case 'd': {
                return n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 'f' && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'e' ? CCTokenContext.CPPDEFINE : baseImageTokenID;
            }
            case 'e': {
                if (n2 <= 3) {
                    return baseImageTokenID;
                }
                switch (cArray[n++]) {
                    case 'l': {
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 4 && cArray[n++] == 'e' ? CCTokenContext.CPPELSE : baseImageTokenID;
                            }
                            case 'i': {
                                return n2 == 4 && cArray[n++] == 'f' ? CCTokenContext.CPPELIF : baseImageTokenID;
                            }
                        }
                        return baseImageTokenID;
                    }
                    case 'n': {
                        return n2 == 5 && cArray[n++] == 'd' && cArray[n++] == 'i' && cArray[n++] == 'f' ? CCTokenContext.CPPENDIF : baseImageTokenID;
                    }
                    case 'r': {
                        return n2 == 5 && cArray[n++] == 'r' && cArray[n++] == 'o' && cArray[n++] == 'r' ? CCTokenContext.CPPERROR : baseImageTokenID;
                    }
                }
                return baseImageTokenID;
            }
            case 'i': {
                switch (cArray[n++]) {
                    case 'f': {
                        if (n2 == 2) {
                            return CCTokenContext.CPPIF;
                        }
                        switch (cArray[n++]) {
                            case 'd': {
                                return n2 == 5 && cArray[n++] == 'e' && cArray[n++] == 'f' ? CCTokenContext.CPPIFDEF : baseImageTokenID;
                            }
                            case 'n': {
                                return n2 == 6 && cArray[n++] == 'd' && cArray[n++] == 'e' && cArray[n++] == 'f' ? CCTokenContext.CPPIFNDEF : baseImageTokenID;
                            }
                        }
                        return baseImageTokenID;
                    }
                    case 'n': {
                        if (n2 >= 7 && cArray[n++] == 'c' && cArray[n++] == 'l' && cArray[n++] == 'u' && cArray[n++] == 'd' && cArray[n++] == 'e') {
                            if (n2 == 7) {
                                return CCTokenContext.CPPINCLUDE;
                            }
                            if (n2 == 12 && cArray[n++] == '_' && cArray[n++] == 'n' && cArray[n++] == 'e' && cArray[n++] == 'x' && cArray[n++] == 't') {
                                return CCTokenContext.CPPINCLUDE_NEXT;
                            }
                            return baseImageTokenID;
                        }
                        return baseImageTokenID;
                    }
                }
                return baseImageTokenID;
            }
            case 'l': {
                if (n2 != 4) {
                    return baseImageTokenID;
                }
                return cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'e' ? CCTokenContext.CPPLINE : baseImageTokenID;
            }
            case 'p': {
                return n2 == 6 && cArray[n++] == 'r' && cArray[n++] == 'a' && cArray[n++] == 'g' && cArray[n++] == 'm' && cArray[n++] == 'a' ? CCTokenContext.CPPPRAGMA : baseImageTokenID;
            }
            case 'u': {
                if (n2 != 5) {
                    return baseImageTokenID;
                }
                return cArray[n++] == 'n' && cArray[n++] == 'd' && cArray[n++] == 'e' && cArray[n++] == 'f' ? CCTokenContext.CPPUNDEF : baseImageTokenID;
            }
            case 'w': {
                if (n2 != 7) {
                    return baseImageTokenID;
                }
                return cArray[n++] == 'a' && cArray[n++] == 'r' && cArray[n++] == 'n' && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'g' ? CCTokenContext.CPPWARNING : baseImageTokenID;
            }
        }
        return baseImageTokenID;
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar(c) || c == '\t';
    }

    public static boolean isLineSeparator(char c) {
        return c == '\n' || c == '\r';
    }
}

