/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.search.SearchResults;

public class ResultPages {
    public static final int RESULTS_PER_PAGE = 10;
    static final int NUM_PAGE_LINKS_EACH_SIDE = 4;
    private final int fStart;
    private final int fEnd;
    private final int fSelectedPage;
    private final int fNumPages;

    public ResultPages(int selectedPage, int numPages, int numLinksEachSide) {
        this.fSelectedPage = selectedPage;
        this.fNumPages = numPages;
        boolean nearBeginning = selectedPage <= numLinksEachSide + 2;
        boolean nearEnd = numPages - selectedPage - 1 <= numLinksEachSide + 2;
        int start = 0;
        int end = numPages;
        if (nearBeginning && !nearEnd) {
            end = Math.min(numPages, numLinksEachSide * 2 + 3);
            if (end >= numPages - 2) {
                end = numPages;
            }
        } else if (nearEnd && !nearBeginning) {
            start = Math.max(0, numPages - numLinksEachSide * 2 - 3);
            if (start <= 2) {
                start = 0;
            }
        } else if (!nearBeginning && !nearEnd) {
            start = selectedPage - numLinksEachSide;
            end = selectedPage + numLinksEachSide + 1;
        }
        this.fStart = start;
        this.fEnd = end;
    }

    public ResultPages(SearchResults<DocumentationSearchResult> results) {
        this(ResultPages.getSelectedPage(results), ResultPages.getNumPages(results), 4);
    }

    private static int getSelectedPage(SearchResults results) {
        return results.getStart() / 10;
    }

    private static int getNumPages(SearchResults results) {
        int fullPages = results.getFullResultCount() / 10;
        boolean partialPage = results.getFullResultCount() % 10 > 0;
        return partialPage ? fullPages + 1 : fullPages;
    }

    public int getPageListingStart() {
        return this.fStart;
    }

    public int getPageListingEnd() {
        return this.fEnd;
    }

    public int getNumPages() {
        return this.fNumPages;
    }

    public int getSelectedPage() {
        return this.fSelectedPage;
    }
}

