/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocSetItemVisitor;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.HelpLocationRegistry;

public class SeeAlsoLink {
    private final DocProduct fProduct;
    private final String fRelativePath;
    private final String fLabel;

    public SeeAlsoLink(DocProduct product, String relativePath, String label) {
        this.fProduct = product;
        this.fRelativePath = relativePath;
        this.fLabel = label;
    }

    public static SeeAlsoLink fromProductLink(DocumentationSet docSet, DocProduct product, DocLink link) {
        switch (link.getLocation()) {
            case IN_PRODUCT: {
                return new SeeAlsoLink(product, link.getPath(), link.getLabel());
            }
            case CROSS_PRODUCT: {
                return SeeAlsoLink.createCrossProductSeeAlsoLink(docSet, link);
            }
        }
        return null;
    }

    private static SeeAlsoLink createCrossProductSeeAlsoLink(DocumentationSet docSet, final DocLink link) {
        HelpLocationRegistry registry = new HelpLocationRegistry(docSet);
        String[] pathParts = link.getPath().split("/");
        final StringBuilder path = new StringBuilder();
        for (String pathPart : pathParts) {
            if (path.length() > 0) {
                path.append('/');
            }
            path.append(pathPart);
            DocSetItem item = registry.getItemByHelpLocation(path.toString());
            if (item == null) continue;
            return item.accept(new DocSetItemVisitor<SeeAlsoLink>(){

                @Override
                public SeeAlsoLink visitDocProduct(DocProduct product) {
                    return new SeeAlsoLink(product, link.getPath().substring(path.length() + 1), link.getLabel());
                }

                @Override
                public SeeAlsoLink visitDocAddOn(DocAddOn addOn) {
                    return null;
                }
            });
        }
        return null;
    }

    public DocProduct getProduct() {
        return this.fProduct;
    }

    public String getRelativePath() {
        return this.fRelativePath;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public int hashCode() {
        return this.fProduct.getShortName().hashCode() + this.fLabel.hashCode() + this.fRelativePath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SeeAlsoLink) {
            SeeAlsoLink other = (SeeAlsoLink)obj;
            return this.fProduct.getShortName().equals(other.fProduct.getShortName()) && this.fLabel.equals(other.fLabel) && this.fRelativePath.equals(other.fRelativePath);
        }
        return false;
    }
}

