/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.csh;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class CshFileBundle {
    private final File fBaseFile;
    private final LocalizedFileLocator fLocator;

    CshFileBundle(File baseFile, DocLanguage language) {
        this(baseFile, new LocaleFileLocator(language.getLocale()));
    }

    protected CshFileBundle(File baseFile, LocalizedFileLocator locator) {
        this.fBaseFile = baseFile;
        this.fLocator = locator;
    }

    protected Map<String, String> getCshFileEntries() throws IOException {
        LinkedHashMap<String, String> allEntries = new LinkedHashMap<String, String>();
        List<File> bundleFiles = this.getBundleFiles();
        for (File bundleFile : bundleFiles) {
            allEntries.putAll(this.parseCshFile(bundleFile));
        }
        return allEntries;
    }

    private List<File> getBundleFiles() {
        File localized = this.fLocator.findLocalizedFile(this.fBaseFile);
        if (localized != null && !localized.equals(this.fBaseFile)) {
            return Arrays.asList(this.fBaseFile, localized);
        }
        return Arrays.asList(this.fBaseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> parseCshFile(File cshFile) throws IOException {
        try (BufferedReader reader = this.toBufferedReader(cshFile);){
            Map<String, String> map = CshFileBundle.parseCshFile(reader);
            return map;
        }
    }

    protected BufferedReader toBufferedReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    static Map<String, String> parseCshFile(BufferedReader reader) throws IOException {
        if (reader != null) {
            try {
                StreamTokenizer tokenizer = new StreamTokenizer(reader);
                tokenizer.resetSyntax();
                tokenizer.commentChar(37);
                tokenizer.whitespaceChars(32, 32);
                tokenizer.whitespaceChars(9, 9);
                tokenizer.wordChars(33, 33);
                tokenizer.wordChars(35, 36);
                tokenizer.wordChars(38, 38);
                tokenizer.wordChars(40, 47);
                tokenizer.wordChars(48, 57);
                tokenizer.wordChars(58, 64);
                tokenizer.wordChars(65, 90);
                tokenizer.wordChars(91, 95);
                tokenizer.wordChars(97, 122);
                tokenizer.wordChars(123, 126);
                tokenizer.eolIsSignificant(false);
                LinkedHashMap<String, String> topicMap = new LinkedHashMap<String, String>();
                while (tokenizer.nextToken() != -1) {
                    String location;
                    if (tokenizer.ttype != -3) continue;
                    String id = tokenizer.sval;
                    tokenizer.nextToken();
                    if (tokenizer.ttype != -3 || (location = tokenizer.sval) == null) continue;
                    topicMap.put(id, location);
                }
                return topicMap;
            }
            catch (IOException e2) {
                System.out.println("Map parse error: " + e2);
            }
        }
        return Collections.emptyMap();
    }

    File getBaseFile() {
        return this.fBaseFile;
    }
}

