/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.index.DocumentParser;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.DomDocumentBuilder;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;

public class SingleDocumentHandler<T extends SearchField> {
    private final File fDocRoot;
    private final DocSetItem fDocSetItem;
    private final LocalizedFileLocator fLocator;
    private final DomDocumentBuilder fDomDocumentBuilder;
    private final DocumentParser fDocumentParser;
    private final IndexDocumentBuilder<T> fIndexDocBuilder;

    public SingleDocumentHandler(File docRoot, DocSetItem docSetItem, LocalizedFileLocator fileLocator, DomDocumentBuilder domDocBuilder, DocumentParser docParser, IndexDocumentBuilder<T> indexDocBuilder) {
        this.fDocRoot = docRoot;
        this.fDocSetItem = docSetItem;
        this.fLocator = fileLocator;
        this.fDomDocumentBuilder = domDocBuilder;
        this.fDocumentParser = docParser;
        this.fIndexDocBuilder = indexDocBuilder;
    }

    public DocumentTracker<T> createDocumentTracker(String fileName) {
        String unlocalized = this.fLocator == null ? fileName : this.fLocator.getUnlocalizedFileName(fileName);
        DocumentationDocument doc = DocumentationDocument.createDocumentationDocument(this.fDocRoot, this.fDocSetItem, unlocalized);
        return new DocumentTracker(doc);
    }

    public void createIndexDocument(DocumentTracker<T> tracker, IndexerObserver<T> observer) throws Exception {
        Document domDoc = this.toDomDocument(tracker);
        if (domDoc == null) {
            return;
        }
        this.parseDocument(tracker, domDoc);
        observer.parsedDocument(tracker);
        DocumentationDocument doc = tracker.getDocumentationDocument();
        String exclusionReason = SingleDocumentHandler.getDocumentExclusionReason(doc);
        if (exclusionReason == null) {
            List<IndexDocument<T>> indexDocs = this.createIndexDocuments(doc);
            if (indexDocs != null && !indexDocs.isEmpty()) {
                tracker.setIndexDocuments(indexDocs);
                observer.createdIndexDocument(tracker);
            } else {
                tracker.setFailureMessage("Could not populate index document");
            }
        } else {
            tracker.setFailureMessage(exclusionReason);
        }
    }

    private Document toDomDocument(DocumentTracker<T> tracker) throws IOException {
        try {
            File helpDir = this.fDocSetItem.getHelpLocation().buildHelpPath(this.fDocRoot, new FileHelpPathBuilder(), new String[0]);
            return this.fDomDocumentBuilder.toDomDocument(tracker.getDocumentationDocument(), helpDir);
        }
        catch (FileNotFoundException fnfe) {
            tracker.setFailureMessage("File not found");
            return null;
        }
        catch (IOException ioe) {
            tracker.setFailureMessage("IOException: " + ioe.getMessage());
            return null;
        }
    }

    private void parseDocument(DocumentTracker<T> tracker, Document domDoc) throws Exception {
        this.fDocumentParser.parseDocument(tracker, domDoc, DocumentParser.ParserType.values());
    }

    private static String getDocumentExclusionReason(DocumentationDocument doc) {
        String title = doc.getTitle();
        if (title == null || title.equals(doc.getRelativePath())) {
            return "No title found";
        }
        if (doc.getType() == null) {
            return "Could not determine page type";
        }
        return null;
    }

    private List<IndexDocument<T>> createIndexDocuments(DocumentationDocument doc) {
        return this.fIndexDocBuilder.createIndexDocuments(doc);
    }
}

