/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlTagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class LinkFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private final List<String> fLinks = new LinkedList<String>();

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"a"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        return LinkFragmentHandler.isInPageContent(xmlTag) || LinkFragmentHandler.isFunctionAlphaListLink(xmlTag);
    }

    private static boolean isInPageContent(XmlTagInfo xmlTag) {
        return DocCenterHtmlTagUtils.isInContentContainer(xmlTag) && !DocCenterHtmlTagUtils.isInBreadCrumb(xmlTag);
    }

    private static boolean isFunctionAlphaListLink(XmlTagInfo xmlTag) {
        String href = xmlTag.getAttribute("href");
        return href != null && href.equals("functionlist-alpha.html");
    }

    @Override
    public boolean continueHandling() {
        return true;
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void startElement(XmlTagInfo location) {
        String href = location.getAttribute("href");
        if (href != null) {
            if (href.contains("#")) {
                href = href.substring(0, href.indexOf(35));
            }
            if (href.trim().length() > 0 && href.endsWith(".html") && !href.startsWith("http:")) {
                this.fLinks.add(href);
            }
        }
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        Collection<String> existing = doc.getOutgoingLinks();
        if (existing == null || existing.isEmpty()) {
            List<String> resolvedLinks = this.resolveLinks(doc);
            doc.addOutgoingLinks(resolvedLinks);
        }
    }

    private List<String> resolveLinks(DocumentationDocument doc) {
        ArrayList<String> resolvedLinks = new ArrayList<String>(this.fLinks.size());
        for (String link : this.fLinks) {
            String relPath;
            DocLink resolvedLink = doc.resolveRelativeLink(link, "dummy text");
            if (resolvedLink == null || resolvedLink.getLocation() != DocLink.Location.IN_PRODUCT || (relPath = resolvedLink.getPath()) == null || relPath.trim().length() <= 0) continue;
            resolvedLinks.add(relPath);
        }
        return resolvedLinks;
    }
}

