/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DefaultDomDocumentBuilder;
import com.mathworks.helpsearch.index.DocCenterIndexDocumentBuilder;
import com.mathworks.helpsearch.index.DocumentParser;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DomDocumentBuilder;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.SingleDocumentHandler;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlParserFactory;
import com.mathworks.helpsearch.index.report.SingleDocumentReport;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.io.File;
import java.util.List;

public class SingleDocumentReportBuilder {
    private final File docRoot;
    private final DocumentationSet docSet;
    private final LocalizedFileLocator locator;
    private final DomDocumentBuilder domDocBuilder;

    public SingleDocumentReportBuilder(String docRoot, DocumentationSet docSet, LocalizedFileLocator locator, HtmlToDomAdapter adapter) {
        this(new File(docRoot), docSet, locator, adapter);
    }

    public SingleDocumentReportBuilder(File docRoot, DocumentationSet docSet, LocalizedFileLocator locator, HtmlToDomAdapter adapter) {
        this.docRoot = docRoot;
        this.docSet = docSet;
        this.locator = locator;
        this.domDocBuilder = new DefaultDomDocumentBuilder(locator, adapter);
    }

    public SingleDocumentReport buildReport(DocProduct product, String relPath) throws Exception {
        DocCenterIndexDocumentBuilder indexDocumentBuilder = new DocCenterIndexDocumentBuilder(null, null);
        DocumentParser docParser = this.createDocumentationParser(product);
        SingleDocumentHandler<DocumentationSearchField> handler = new SingleDocumentHandler<DocumentationSearchField>(this.docRoot, product, this.locator, this.domDocBuilder, docParser, indexDocumentBuilder);
        DocumentTracker<DocumentationSearchField> docTracker = handler.createDocumentTracker(relPath);
        SingleDocumentReport report = new SingleDocumentReport();
        SingleDocumentObserver observer = new SingleDocumentObserver(report);
        handler.createIndexDocument(docTracker, observer);
        report.addMicrodataParts(docTracker.getTopLevelMicrodataItems());
        report.addDocumentationDocumentParts(docTracker.getDocumentationDocument());
        List indexDocs = docTracker.getIndexDocuments();
        report.addIndexDocumentParts(indexDocs);
        report.addOutgoingLinksParts(docTracker.getDocumentationDocument().getOutgoingLinks());
        report.addSummaryParts();
        return report;
    }

    private DocumentParser createDocumentationParser(DocProduct product) {
        return new DocumentParser(ContentFormat.DOC_CENTER_DOC, new DocCenterHtmlParserFactory(product));
    }

    private static class SingleDocumentObserver
    implements IndexerObserver<DocumentationSearchField> {
        private final SingleDocumentReport report;

        private SingleDocumentObserver(SingleDocumentReport report) {
            this.report = report;
        }

        @Override
        public void indexingStarted() {
        }

        @Override
        public void startDocument(DocumentTracker<DocumentationSearchField> tracker) {
            this.report.addCompletedState(SingleDocumentReport.DocumentState.FOUND);
        }

        @Override
        public void parsedDocument(DocumentTracker<DocumentationSearchField> tracker) {
            this.report.addCompletedState(SingleDocumentReport.DocumentState.PARSED);
        }

        @Override
        public void createdIndexDocument(DocumentTracker<DocumentationSearchField> tracker) {
            this.report.addCompletedState(SingleDocumentReport.DocumentState.INDEXED);
        }

        @Override
        public void endDocument(DocumentTracker<DocumentationSearchField> tracker) {
        }

        @Override
        public void indexingFinished() {
        }
    }
}

