/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.suggestion;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DisplayableResult;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.TextHighlighter;

public class PageSuggestion
implements DisplayableResult {
    private final DocSetItem fDocSetItem;
    private final String fTitle;
    private final String fSummary;
    private final String fPath;
    private final TextHighlighter fHighlighter;

    public PageSuggestion(DocSetItem prod, String title, String summary, String loc) {
        this(prod, title, summary, loc, null);
    }

    public PageSuggestion(DocSetItem prod, String title, String summary, String loc, TextHighlighter highlighter) {
        this.fDocSetItem = prod;
        this.fTitle = title;
        this.fSummary = summary;
        this.fPath = loc;
        this.fHighlighter = highlighter;
    }

    @Override
    public DocSetItem getDocSetItem() {
        return this.fDocSetItem;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getSummary() {
        return this.fSummary;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    public String getPageId() {
        return CategoryUtils.createIdFromFilePath(this.fDocSetItem, this.getPath());
    }

    @Override
    public SearchHighlight highlightText(String text) {
        return this.fHighlighter == null ? new SearchHighlight(text) : this.fHighlighter.addHighlightsToString(text);
    }

    public String toString() {
        return this.getTitle();
    }

    private String concat() {
        return this.fTitle + "|" + this.fSummary + "|" + this.fPath;
    }

    public boolean equals(Object other) {
        if (other instanceof PageSuggestion) {
            PageSuggestion otherSugg = (PageSuggestion)other;
            return this.concat().equals(otherSugg.concat());
        }
        return false;
    }

    public int hashCode() {
        return this.concat().hashCode();
    }
}

