/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.export.PrintExportPanel;
import com.mathworks.page.export.PrintExportSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PreviewTabColor
extends MJPanel
implements ActionListener,
PropertyChangeListener {
    private PrintExportSettings fPrintSettings;
    private MJRadioButton fRadBW;
    private MJRadioButton fRadGrayScale;
    private MJRadioButton fRadColor;
    private MJRadioButton fRadRGB;
    private MJRadioButton fRadCMYK;
    private MJRadioButton fRadBtnBkTransparent;
    private MJRadioButton fRadBtnBkScreen;
    private MJRadioButton fRadBtnBkManual;
    private MJComboBox fTextManualBkCol;
    private static final String BLACK = "black";
    private static final String WHITE = "white";
    private static final String sBlack = PrintExportPanel.sResHandle.getString("black");
    private static final String sWhite = PrintExportPanel.sResHandle.getString("white");

    public PreviewTabColor(PrintExportSettings printExportSettings) {
        this.fPrintSettings = printExportSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PreviewTabColor.this.createUI();
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.createUI();
        }
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.colorscale")));
        this.add((Component)mJPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 6, 3, 6), 0, 0));
        this.fRadBW = new MJRadioButton(PrintExportPanel.sResHandle.getString("colorscale.bw"));
        this.fRadBW.setName("RadBtn_BWScale");
        this.fRadGrayScale = new MJRadioButton(PrintExportPanel.sResHandle.getString("colorscale.gray"));
        this.fRadGrayScale.setName("RadBtn_GrayScale");
        this.fRadColor = new MJRadioButton(PrintExportPanel.sResHandle.getString("colorscale.color"));
        this.fRadColor.setName("RadBtn_ColorScale");
        this.fRadRGB = new MJRadioButton(PrintExportPanel.sResHandle.getString("colorscale.colorRGB"));
        this.fRadRGB.setName("RadBtn_ColorScaleRGB");
        this.fRadCMYK = new MJRadioButton(PrintExportPanel.sResHandle.getString("colorscale.colorCMYK"));
        this.fRadCMYK.setName("RadBtn_ColorScaleCMYK");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBW);
        buttonGroup.add((AbstractButton)this.fRadGrayScale);
        buttonGroup.add((AbstractButton)this.fRadColor);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadRGB);
        buttonGroup.add((AbstractButton)this.fRadCMYK);
        this.fRadBW.addActionListener((ActionListener)this);
        this.fRadGrayScale.addActionListener((ActionListener)this);
        this.fRadColor.addActionListener((ActionListener)this);
        this.fRadRGB.addActionListener((ActionListener)this);
        this.fRadCMYK.addActionListener((ActionListener)this);
        mJPanel.add((Component)this.fRadBW, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadGrayScale, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadColor, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadRGB, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 18, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadCMYK, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 18, 6, 3), 0, 0));
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.figBGGroup")));
        mJPanel2.setLayout((LayoutManager)new GridBagLayout());
        this.add((Component)mJPanel2, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 6), 0, 0));
        this.fRadBtnBkTransparent = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.fBkTransparent"));
        this.fRadBtnBkTransparent.setName("RadBtn_BkTransparent");
        this.fRadBtnBkScreen = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.fBkScreen"));
        this.fRadBtnBkScreen.setName("RadBtn_BkScreen");
        this.fRadBtnBkManual = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.fBkManual"));
        this.fRadBtnBkManual.setName("RadBtn_BkManual");
        this.fTextManualBkCol = new MJComboBox();
        this.fTextManualBkCol.setName("Text_ManualBkColor");
        this.fTextManualBkCol.setEditorColumnCount(6);
        this.fTextManualBkCol.setEditable(true);
        this.fTextManualBkCol.addItem((Object)sWhite);
        this.fTextManualBkCol.addItem((Object)sBlack);
        this.fTextManualBkCol.addItem((Object)"[.9 .9 .9]");
        this.fTextManualBkCol.addItem((Object)"[.8 .8 .8]");
        this.fTextManualBkCol.addItem((Object)"[.5 .5 .5]");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this.fRadBtnBkTransparent);
        buttonGroup2.add((AbstractButton)this.fRadBtnBkScreen);
        buttonGroup2.add((AbstractButton)this.fRadBtnBkManual);
        mJPanel2.add((Component)this.fRadBtnBkScreen, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fRadBtnBkManual, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 0), 0, 0));
        mJPanel2.add((Component)this.fTextManualBkCol, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.fRadBtnBkTransparent.addActionListener((ActionListener)this);
        this.fRadBtnBkScreen.addActionListener((ActionListener)this);
        this.fRadBtnBkManual.addActionListener((ActionListener)this);
        this.fTextManualBkCol.addActionListener((ActionListener)this);
        this.fTextManualBkCol.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PreviewTabColor.this.fRadBtnBkManual.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabColor.this.onBackgroundChanged();
            }
        });
        this.fRadBtnBkTransparent.setEnabled(false);
        MJPanel mJPanel3 = new MJPanel();
        this.add((Component)mJPanel3, new GridBagConstraints(0, n++, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fRadBW) || object.equals(this.fRadGrayScale) || object.equals(this.fRadColor) || object.equals(this.fRadRGB) || object.equals(this.fRadCMYK)) {
            this.onColorScaleChanged();
        } else if (object.equals(this.fRadBtnBkTransparent) || object.equals(this.fRadBtnBkScreen) || object.equals(this.fRadBtnBkManual)) {
            this.onBackgroundChanged();
        } else if (object.equals(this.fTextManualBkCol)) {
            this.fRadBtnBkManual.setSelected(true);
            this.onBackgroundChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("GrayScale") || string.equals("DriverColor") || string.equals("CMYK")) {
            this.setColorScale();
        } else if (string.equals("BkColor")) {
            this.setBackground(object.toString());
        }
    }

    private void onBackgroundChanged() {
        String string = "";
        String string2 = "off";
        if (!this.fRadBtnBkScreen.isSelected()) {
            if (this.fRadBtnBkTransparent.isSelected()) {
                string = "none";
            } else {
                string = (String)this.fTextManualBkCol.getSelectedItem();
                if ((string = string.trim()).equals("") || string.compareToIgnoreCase(sWhite) == 0) {
                    string2 = "on";
                }
            }
        }
        if (string.equals(sWhite)) {
            string = WHITE;
        } else if (string.equals(sBlack)) {
            string = BLACK;
        }
        boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
        this.fPrintSettings.setBackgroundColor(this, string);
        this.fPrintSettings.setFireMATLABCallback(bl);
        this.fPrintSettings.setInvertHardCopy(this, string2);
    }

    private void setBackground(String string) {
        if ("".equals(string)) {
            this.fRadBtnBkScreen.setSelected(true);
        } else {
            this.fRadBtnBkManual.setSelected(true);
            if (string.equals(WHITE)) {
                string = sWhite;
            } else if (string.equals(BLACK)) {
                string = sBlack;
            }
            this.fTextManualBkCol.setSelectedItem((Object)string);
        }
    }

    private void onColorScaleChanged() {
        if (this.fRadBW.isSelected()) {
            this.fPrintSettings.setDriverColor(this, new Double(0.0));
            this.fRadRGB.setEnabled(false);
            this.fRadCMYK.setEnabled(false);
        } else if (this.fRadGrayScale.isSelected()) {
            boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
            this.fPrintSettings.setDriverColor(this, new Double(1.0));
            this.fPrintSettings.setFireMATLABCallback(bl);
            this.fPrintSettings.setGrayScale(this, new Double(1.0));
            this.fRadRGB.setEnabled(false);
            this.fRadCMYK.setEnabled(false);
        } else if (this.fRadColor.isSelected()) {
            this.fRadRGB.setEnabled(true);
            this.fRadCMYK.setEnabled(true);
            boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
            this.fPrintSettings.setDriverColor(this, new Double(1.0));
            if (this.fRadRGB.isSelected()) {
                this.fPrintSettings.setCMYK(this, new Double(0.0));
            } else if (this.fRadCMYK.isSelected()) {
                this.fPrintSettings.setCMYK(this, new Double(1.0));
            } else {
                this.fRadRGB.setSelected(true);
            }
            this.fPrintSettings.setFireMATLABCallback(bl);
            this.fPrintSettings.setGrayScale(this, new Double(0.0));
        } else if (this.fRadRGB.isSelected()) {
            this.fPrintSettings.setCMYK(this, new Double(0.0));
        } else if (this.fRadCMYK.isSelected()) {
            this.fPrintSettings.setCMYK(this, new Double(1.0));
        }
    }

    private void setColorScale() {
        this.fRadBW.removeActionListener((ActionListener)this);
        this.fRadGrayScale.removeActionListener((ActionListener)this);
        this.fRadColor.removeActionListener((ActionListener)this);
        this.fRadRGB.removeActionListener((ActionListener)this);
        this.fRadCMYK.removeActionListener((ActionListener)this);
        double d = this.fPrintSettings.getDriverColor();
        double d2 = this.fPrintSettings.getGrayScale();
        double d3 = this.fPrintSettings.getCMYK();
        if (d == 0.0) {
            this.fRadBW.setSelected(true);
            this.fRadRGB.setEnabled(false);
            this.fRadCMYK.setEnabled(false);
        } else if (d2 == 1.0) {
            this.fRadGrayScale.setSelected(true);
            this.fRadRGB.setEnabled(false);
            this.fRadCMYK.setEnabled(false);
        } else if (d3 == 0.0) {
            this.fRadColor.setSelected(true);
            this.fRadRGB.setEnabled(true);
            this.fRadRGB.setSelected(true);
            this.fRadCMYK.setEnabled(true);
        } else {
            this.fRadColor.setSelected(true);
            this.fRadRGB.setEnabled(true);
            this.fRadCMYK.setEnabled(true);
            this.fRadCMYK.setSelected(true);
        }
        this.fRadBW.addActionListener((ActionListener)this);
        this.fRadGrayScale.addActionListener((ActionListener)this);
        this.fRadColor.addActionListener((ActionListener)this);
        this.fRadRGB.addActionListener((ActionListener)this);
        this.fRadCMYK.addActionListener((ActionListener)this);
    }
}

