/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.hg.peer.UnitPos;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.Callback;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class PrintExportSettings {
    public static final String[] MATLAB_PAPER_TYPES = new String[]{"USLetter", "USLegal", "A0", "A1", "A2", "A3", "A4", "A5", "B0", "B1", "B2", "B3", "B4", "B5", "arch-A", "arch-B", "arch-C", "arch-D", "arch-E", "A", "B", "C", "D", "E", "Tabloid"};
    public static final double[] MATLAB_PAPER_WIDTH_ARRAY = new double[]{8.5, 8.5, 33.1354, 23.4036, 16.548, 11.6944, 8.267716, 5.8472, 40.5426, 28.6832, 20.2516, 14.3416, 10.1258, 7.1708, 9.0, 12.0, 18.0, 24.0, 36.0, 8.5, 11.0, 17.0, 22.0, 34.0, 11.0};
    public static final double[] MATLAB_PAPER_HEIGHT_ARRAY = new double[]{11.0, 14.0, 46.8466, 33.1354, 23.4036, 16.5278, 11.692913, 8.2639, 57.3664, 40.5032, 28.6832, 20.2516, 14.3416, 10.1258, 12.0, 18.0, 24.0, 36.0, 48.0, 11.0, 17.0, 22.0, 34.0, 44.0, 17.0};
    public static final String[] RENDERER_CODE_ARRAY = new String[]{"auto", "painters", "zbuffer", "opengl"};
    public static final String[] MATLAB_PAPER_UNITS = new String[]{"inches", "centimeters", "points"};
    public static final String[] MATLAB_PAPER_ORIENTATION_TYPES = new String[]{"portrait", "landscape", "rotated"};
    public static final String[] MATLAB_FONTANGLES = new String[]{"normal", "italic", "oblique"};
    public static final String[] MATLAB_FONTWEIGHTS = new String[]{"normal", "light", "demi", "bold"};
    public static final String[] MATLAB_LINESTYLES = new String[]{"solid", "dashed", "dotted", "dash-dot", "cycle through styles"};
    public static final String ORIENT_PORTRAIT = "portrait";
    public static final String ORIENT_LANDSCAPE = "landscape";
    public static final String ORIENT_ROTATED = "rotated";
    public static final String POSITIONMODE_AUTO = "auto";
    public static final String POSITIONMODE_MANUAL = "manual";
    public static final String MATLAB_PAPERTYPE_CUSTOM = "<custom>";
    private double fResolution;
    private double fFig;
    private double fAxPreview;
    private Map fHashProps = new Hashtable(42, 5.0f);
    private List fPropChangeListeners = new Vector(4, 2);
    private static final int NUM_PROPS = 42;
    public static final String PROP_STYLESHEET = "StyleSheet";
    public static final String PROP_PAPER_NAME = "PaperType";
    public static final String PROP_PAPER_SIZE = "PaperSize";
    public static final String PROP_PAPER_UNITS = "PaperUnits";
    public static final String PROP_PAPER_POSITION = "PaperPosition";
    public static final String PROP_PAPER_POSITIONMODE = "PaperPositionMode";
    public static final String PROP_PAPER_ORIENTATION = "PaperOrientation";
    public static final String PROP_FIG_SIZE = "FigSize";
    public static final String PROP_FONT_NAME = "FontName";
    public static final String PROP_FONT_SIZE = "FontSize";
    public static final String PROP_FONT_SIZETYPE = "FontSizeType";
    public static final String PROP_FONT_ANGLE = "FontAngle";
    public static final String PROP_FONT_WEIGHT = "FontWeight";
    public static final String PROP_FONT_COLOR = "FontColor";
    public static final String PROP_LINE_WIDTH = "LineWidth";
    public static final String PROP_LINE_WIDTHTYPE = "LineWidthType";
    public static final String PROP_LINE_MINWIDTH = "LineMinWidth";
    public static final String PROP_LINE_STYLE = "LineStyle";
    public static final String PROP_LINE_COLOR = "LineColor";
    public static final String PROP_BKCOLOR = "BkColor";
    public static final String PROP_INVERTHARDCOPY = "InvertHardCopy";
    public static final String PROP_PRINTUI = "PrintUI";
    public static final String PROP_PRINTACTIVEX = "PrintActiveX";
    public static final String PROP_AXES_FREEZETICKS = "AxesFreezeTicks";
    public static final String PROP_AXES_FREEZELIMS = "AxesFreezeLimits";
    public static final String PROP_DRIVERCOLOR = "DriverColor";
    public static final String PROP_GRAYSCALE = "GrayScale";
    public static final String PROP_CMYK = "CMYK";
    public static final String PROP_RENDERER = "Renderer";
    public static final String PROP_RESOLUTION = "DPI";
    public static final String PROP_RESOLUTIONMODE = "ResolutionMode";
    public static final String PROP_FILENAME = "FileName";
    public static final String PROP_DESTINATION = "Destination";
    public static final String PROP_PRINTDRIVER = "PrintDriver";
    public static final String PROP_DEFPRINTER = "defPrinter";
    public static final String PROP_PRINTER_COLOR = "PrinterColor";
    public static final String PROP_NUM_COPIES = "copies";
    public static final String PROP_HEADER_TEXT = "HeaderText";
    public static final String PROP_HEADER_FONTNAME = "HeaderFontName";
    public static final String PROP_HEADER_FONTSIZE = "HeaderFontSize";
    public static final String PROP_HEADER_FONTWEIGHT = "HeaderFontWeight";
    public static final String PROP_HEADER_FONTANGLE = "HeaderFontAngle";
    public static final String PROP_HEADER_DATEFORMAT = "HeaderDateFormat";
    private Callback fCallback = new Callback();
    private boolean fDoSendMcallback = true;
    private static boolean sUseNewPrintPreview = true;
    private static String sFigPos = "";

    public Callback getCallback() {
        return this.fCallback;
    }

    public static void UseNewPreview(boolean bl) {
        sUseNewPrintPreview = bl;
    }

    public static boolean IsNewPreviewUsed() {
        return sUseNewPrintPreview;
    }

    public static String getFigPos() {
        return sFigPos;
    }

    public static void setFigPos(String string) {
        sFigPos = string;
    }

    public static String convertMatlabPaperType(String string) {
        String string2 = string;
        for (int i = 0; i < MATLAB_PAPER_TYPES.length; ++i) {
            if (MATLAB_PAPER_TYPES[i].compareToIgnoreCase(string) != 0) continue;
            string2 = MATLAB_PAPER_TYPES[i];
            break;
        }
        return string2;
    }

    public PrintExportSettings(double d) {
        this.fResolution = d;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropChangeListeners.remove(propertyChangeListener);
    }

    protected void firePropertyChangeEvent(Object object, String string, Object object2, Object object3) {
        if (object3 != null && object3.equals(object2)) {
            return;
        }
        if (object3 == null && object2 == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object2, object3);
        PropertyChangeListener propertyChangeListener = null;
        int n = this.fPropChangeListeners.size();
        for (int i = 0; i < n; ++i) {
            propertyChangeListener = (PropertyChangeListener)this.fPropChangeListeners.get(i);
            if (propertyChangeListener == object) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void initialize(double d, double d2, final Object[] objectArray, final Object[] objectArray2) {
        if (objectArray == null) {
            return;
        }
        this.fFig = d;
        this.fAxPreview = d2;
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PrintExportSettings.this.initializeChildrenOnAWTThread(objectArray, objectArray2);
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.initializeChildrenOnAWTThread(objectArray, objectArray2);
        }
    }

    private void initializeChildrenOnAWTThread(Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray2[i] instanceof Boolean) {
                objectArray2[i] = new Double((Boolean)objectArray2[i] != false ? 1.0 : 0.0);
            } else if (objectArray2[i] instanceof Character) {
                objectArray2[i] = objectArray2[i].toString();
            } else if (objectArray2[i] == null) {
                objectArray2[i] = "";
            }
            this.fHashProps.put(objectArray[i], objectArray2[i]);
        }
        String string = (String)this.fHashProps.get(PROP_STYLESHEET);
        for (int i = 0; i < objectArray.length; ++i) {
            this.firePropertyChangeEvent(this, (String)objectArray[i], null, objectArray2[i]);
        }
        this.firePropertyChangeEvent(this, PROP_STYLESHEET, null, string);
    }

    public Object[] getKeys() {
        return this.fHashProps.keySet().toArray();
    }

    public Object[] getValues() {
        return this.fHashProps.values().toArray();
    }

    public double getFigureHandle() {
        return this.fFig;
    }

    public double getPreviewAxesHandle() {
        return this.fAxPreview;
    }

    public void GenerateMCode() throws Exception {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        Object[] objectArray = this.getKeys();
        Object[] objectArray2 = this.getValues();
        bufferedWriter.write("function setupprint(fig)");
        bufferedWriter.newLine();
        bufferedWriter.write("%SETUPPRINT(FIG)");
        bufferedWriter.newLine();
        bufferedWriter.write("%  FIG:  The figure handle to setup for printing");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("%  Autogenerated by MATLAB");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        for (int i = 0; i < objectArray.length; ++i) {
            bufferedWriter.write("pt.");
            bufferedWriter.write(objectArray[i].toString());
            bufferedWriter.write(" = ");
            if (objectArray2[i] instanceof String) {
                bufferedWriter.write(39);
                bufferedWriter.write(objectArray2[i].toString());
                bufferedWriter.write(39);
            } else if (objectArray2[i] instanceof Double) {
                bufferedWriter.write(objectArray2[i].toString());
            } else if (objectArray2[i] instanceof double[]) {
                double[] dArray = (double[])objectArray2[i];
                bufferedWriter.write(91);
                for (int j = 0; j < dArray.length; ++j) {
                    if (j > 0) {
                        bufferedWriter.write(44);
                    }
                    bufferedWriter.write(Double.toString(dArray[j]));
                }
                bufferedWriter.write(93);
            }
            bufferedWriter.write(59);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("setprinttemplate(fig, pt);");
        bufferedWriter.newLine();
        bufferedWriter.close();
        MLEditorServices.getEditorApplication().newEditor(stringWriter.getBuffer().toString());
    }

    public void SaveStyleSheet(String string) throws Exception {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        string2 = string2.substring(0, n);
        this.setStylesheet(null, string2);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        Object[] objectArray = this.getKeys();
        Object[] objectArray2 = this.getValues();
        for (int i = 0; i < objectArray.length; ++i) {
            bufferedWriter.write(objectArray[i].toString());
            bufferedWriter.write(32);
            if (objectArray2[i] instanceof String) {
                bufferedWriter.write(39);
                bufferedWriter.write(objectArray2[i].toString());
                bufferedWriter.write(39);
            } else if (objectArray2[i] instanceof Double) {
                bufferedWriter.write(objectArray2[i].toString());
            } else if (objectArray2[i] instanceof double[]) {
                double[] dArray = (double[])objectArray2[i];
                bufferedWriter.write(91);
                for (n = 0; n < dArray.length; ++n) {
                    if (n > 0) {
                        bufferedWriter.write(44);
                    }
                    bufferedWriter.write(Double.toString(dArray[n]));
                }
                bufferedWriter.write(93);
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        if (string2.equals("default")) {
            this.fCallback.postCallback((Object)new Object[]{"PropertyChange", this});
        }
    }

    public void LoadStyleSheet(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            this.fHashProps.clear();
            this.fCallback.postCallback((Object)new Object[]{"PropertyChange", this});
        } else {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<String> vector = new Vector<String>();
            Vector<Object> vector2 = new Vector<Object>();
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                int n = string2.indexOf(32);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                vector.add(string3);
                if (string4.charAt(0) == '\'') {
                    vector2.add(string4.substring(1, string4.length() - 1));
                    continue;
                }
                if (string4.charAt(0) == '[') {
                    string4 = string4.substring(1);
                    Vector<String> vector3 = new Vector<String>();
                    while ((n = string4.indexOf(44)) != -1) {
                        vector3.add(string4.substring(0, n));
                        string4 = string4.substring(n + 1);
                    }
                    vector3.add(string4.substring(0, string4.length() - 1));
                    double[] dArray = new double[vector3.size()];
                    for (n = 0; n < vector3.size(); ++n) {
                        dArray[n] = Double.parseDouble((String)vector3.get(n));
                    }
                    vector2.add(dArray);
                    continue;
                }
                try {
                    vector2.add(new Double(string4));
                }
                catch (Exception exception) {
                    vector2.add(string4);
                }
            }
            bufferedReader.close();
            this.initializeChildrenOnAWTThread(vector.toArray(), vector2.toArray());
            this.fCallback.postCallback((Object)new Object[]{"PropertyChange", this});
        }
    }

    private void setPropertyNoMCallback(Object object, String string, Object object2) {
        boolean bl = this.setFireMATLABCallback(false);
        this.setProperty(object, string, object2);
        this.setFireMATLABCallback(bl);
    }

    private void setProperty(Object object, String string, Object object2) {
        boolean bl = this.fDoSendMcallback;
        this.fDoSendMcallback = false;
        this.firePropertyChangeEvent(object, string, this.fHashProps.get(string), object2);
        this.fHashProps.put(string, object2);
        if (bl) {
            this.fCallback.postCallback((Object)new Object[]{"PropertyChange", this});
            this.fDoSendMcallback = true;
        }
    }

    private Object getProperty(String string) {
        return this.fHashProps.get(string);
    }

    public boolean setFireMATLABCallback(boolean bl) {
        boolean bl2 = this.fDoSendMcallback;
        this.fDoSendMcallback = bl;
        return bl2;
    }

    public double[] convertUnits(double d, double d2, int n, int n2) {
        double[] dArray = new double[2];
        HGRectangle hGRectangle = new HGRectangle(0.0, 0.0, d, d2);
        double[] dArray2 = (double[])this.getProperty(PROP_PAPER_SIZE);
        Dimension dimension = new Dimension((int)(dArray2[0] * this.fResolution), (int)(dArray2[1] * this.fResolution));
        HGRectangle hGRectangle2 = UnitPos.convertPosition((HGRectangle)hGRectangle, (int)n, (int)n2, (Dimension)dimension);
        dArray[0] = hGRectangle2.getWidth();
        dArray[1] = hGRectangle2.getHeight();
        return dArray;
    }

    public double[] convertUnits(double d, double d2, double d3, double d4, int n, int n2) {
        double[] dArray = new double[4];
        HGRectangle hGRectangle = new HGRectangle(d, d2, d3, d4);
        double[] dArray2 = (double[])this.getProperty(PROP_PAPER_SIZE);
        Dimension dimension = new Dimension((int)(dArray2[0] * this.fResolution), (int)(dArray2[1] * this.fResolution));
        HGRectangle hGRectangle2 = UnitPos.convertPosition((HGRectangle)hGRectangle, (int)n, (int)n2, (Dimension)dimension);
        dArray[0] = hGRectangle2.getX();
        dArray[1] = hGRectangle2.getY();
        dArray[2] = hGRectangle2.getWidth();
        dArray[3] = hGRectangle2.getHeight();
        return dArray;
    }

    public void setStylesheet(Object object, String string) {
        this.setProperty(object, PROP_STYLESHEET, string);
    }

    public String getStylesheet() {
        return (String)this.getProperty(PROP_STYLESHEET);
    }

    public String getPaperType() {
        return (String)this.getProperty(PROP_PAPER_NAME);
    }

    public int getPaperTypeEnum() {
        String string = (String)this.getProperty(PROP_PAPER_NAME);
        for (int i = 0; i < MATLAB_PAPER_TYPES.length; ++i) {
            if (string.compareToIgnoreCase(MATLAB_PAPER_TYPES[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public void setPaperType(Object object, String string) {
        int n;
        if (string.equals(MATLAB_PAPERTYPE_CUSTOM)) {
            this.setProperty(object, PROP_PAPER_NAME, string);
            return;
        }
        this.setPropertyNoMCallback(object, PROP_PAPER_NAME, string);
        String[] stringArray = MATLAB_PAPER_TYPES;
        for (n = 0; n < stringArray.length && !string.equals(stringArray[n]); ++n) {
        }
        double[] dArray = new double[]{MATLAB_PAPER_WIDTH_ARRAY[n], MATLAB_PAPER_HEIGHT_ARRAY[n]};
        String string2 = this.getPaperOrientation();
        if (string2.equals(ORIENT_LANDSCAPE) || string2.equals(ORIENT_ROTATED)) {
            double d = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d;
        }
        dArray = this.convertUnits(dArray[0], dArray[1], 0, UnitPos.unitsToInt((String)this.getUnits()));
        this.setPaperSize2(this, dArray);
    }

    public double[] getPaperSize() {
        double[] dArray = (double[])this.getProperty(PROP_PAPER_SIZE);
        return (double[])dArray.clone();
    }

    public double[] getPaperSizeInInches() {
        double[] dArray = (double[])this.getProperty(PROP_PAPER_SIZE);
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        dArray = this.convertUnits(dArray[0], dArray[1], UnitPos.unitsToInt((String)string), 0);
        return dArray;
    }

    public void setPaperSize(Object object, double[] dArray) {
        boolean bl = this.setFireMATLABCallback(false);
        this.setPaperSize2(object, dArray);
        this.setFireMATLABCallback(bl);
        this.setPaperType(this, MATLAB_PAPERTYPE_CUSTOM);
    }

    public void setPaperSizeInInches(Object object, double[] dArray) {
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        double[] dArray2 = this.convertUnits(dArray[0], dArray[1], 0, UnitPos.unitsToInt((String)string));
        this.setPaperSize(object, dArray2);
    }

    private void setPaperSize2(Object object, double[] dArray) {
        String string = this.getPaperPositionMode();
        if (string.equals(POSITIONMODE_AUTO)) {
            this.setPropertyNoMCallback(object, PROP_PAPER_SIZE, dArray);
            this.setFigPositionAuto();
        } else {
            this.setProperty(object, PROP_PAPER_SIZE, dArray);
        }
    }

    public String getPaperOrientation() {
        return (String)this.getProperty(PROP_PAPER_ORIENTATION);
    }

    public void setPaperOrientation(Object object, String string) {
        Object object2 = this.getProperty(PROP_PAPER_ORIENTATION);
        this.setPropertyNoMCallback(object, PROP_PAPER_ORIENTATION, string);
        double[] dArray = this.getPaperSize();
        if (string.equals(ORIENT_PORTRAIT) ^ object2.equals(ORIENT_PORTRAIT)) {
            double d = dArray[0];
            double d2 = dArray[1];
            dArray = new double[]{d2, d};
        }
        this.setPaperSize2(this, dArray);
    }

    public double[] getPaperPosition() {
        double[] dArray = (double[])this.getProperty(PROP_PAPER_POSITION);
        dArray = (double[])dArray.clone();
        return dArray;
    }

    public double[] getPaperPositionInInches() {
        double[] dArray = (double[])this.getProperty(PROP_PAPER_POSITION);
        dArray = (double[])dArray.clone();
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        dArray = this.convertUnits(dArray[0], dArray[1], dArray[2], dArray[3], UnitPos.unitsToInt((String)string), 0);
        return dArray;
    }

    public void setPaperPosition(Object object, double[] dArray) {
        this.setProperty(object, PROP_PAPER_POSITION, dArray);
    }

    public void setPaperPositionInInches(Object object, double[] dArray) {
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        double[] dArray2 = this.convertUnits(dArray[0], dArray[1], dArray[2], dArray[3], 0, UnitPos.unitsToInt((String)string));
        this.setPaperPosition(object, dArray2);
    }

    public String getUnits() {
        return (String)this.getProperty(PROP_PAPER_UNITS);
    }

    public void setUnits(Object object, String string) {
        double[] dArray = this.getPaperSize();
        double[] dArray2 = this.getFigSize();
        double[] dArray3 = this.getPaperPosition();
        int n = UnitPos.unitsToInt((String)this.getUnits());
        int n2 = UnitPos.unitsToInt((String)string);
        this.setPropertyNoMCallback(object, PROP_PAPER_UNITS, string);
        dArray = this.convertUnits(dArray[0], dArray[1], n, n2);
        dArray2 = this.convertUnits(dArray2[0], dArray2[1], n, n2);
        dArray3 = this.convertUnits(dArray3[0], dArray3[1], dArray3[2], dArray3[3], n, n2);
        boolean bl = this.setFireMATLABCallback(false);
        this.setPaperSize2(this, dArray);
        this.setFigSize(this, dArray2);
        this.setFireMATLABCallback(bl);
        this.setPaperPosition(this, dArray3);
    }

    public String getPaperPositionMode() {
        return (String)this.getProperty(PROP_PAPER_POSITIONMODE);
    }

    public void setPaperPositionMode(Object object, String string) {
        if (string.equals(POSITIONMODE_AUTO)) {
            this.setPropertyNoMCallback(object, PROP_PAPER_POSITIONMODE, string);
            this.setFigPositionAuto();
        } else {
            this.setProperty(object, PROP_PAPER_POSITIONMODE, string);
        }
    }

    private void setFigPositionAuto() {
        double[] dArray = this.getFigSize();
        double[] dArray2 = this.getPaperSize();
        double d = (dArray2[0] - dArray[0]) / 2.0;
        double d2 = (dArray2[1] - dArray[1]) / 2.0;
        double[] dArray3 = new double[]{d, d2, dArray[0], dArray[1]};
        this.setPaperPosition(this, dArray3);
    }

    public double[] getFigSize() {
        double[] dArray = (double[])this.getProperty(PROP_FIG_SIZE);
        if (dArray != null) {
            return (double[])dArray.clone();
        }
        return null;
    }

    public double[] getFigSizeInInches() {
        double[] dArray = (double[])this.getProperty(PROP_FIG_SIZE);
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        dArray = this.convertUnits(dArray[0], dArray[1], UnitPos.unitsToInt((String)string), 0);
        return dArray;
    }

    public void setFigSize(Object object, double d, double d2) {
        double[] dArray = new double[]{d, d2};
        this.setFigSize(object, dArray);
    }

    public void setFigSize(Object object, double[] dArray) {
        if (this.isPositionModeAuto()) {
            this.setPropertyNoMCallback(object, PROP_FIG_SIZE, dArray);
            this.setFigPositionAuto();
        } else {
            this.setProperty(object, PROP_FIG_SIZE, dArray);
        }
    }

    boolean isPositionModeAuto() {
        String string = this.getPaperPositionMode();
        boolean bl = string.equals(POSITIONMODE_AUTO);
        return bl;
    }

    public void setFigSizeInInches(Object object, double[] dArray) {
        String string = (String)this.getProperty(PROP_PAPER_UNITS);
        double[] dArray2 = this.convertUnits(dArray[0], dArray[1], 0, UnitPos.unitsToInt((String)string));
        this.setFigSize(object, dArray2);
    }

    public void setFontName(Object object, String string) {
        this.setProperty(object, PROP_FONT_NAME, string);
    }

    public String getFontName() {
        return (String)this.getProperty(PROP_FONT_NAME);
    }

    public void setFontSize(Object object, Double d) {
        this.setProperty(object, PROP_FONT_SIZE, d);
    }

    public Double getFontSize() {
        return (Double)this.getProperty(PROP_FONT_SIZE);
    }

    public void setFontSizeType(Object object, String string) {
        this.setProperty(object, PROP_FONT_SIZETYPE, string);
    }

    public String getFontSizeType() {
        return (String)this.getProperty(PROP_FONT_SIZETYPE);
    }

    public void setFontAngle(Object object, String string) {
        this.setProperty(object, PROP_FONT_ANGLE, string);
    }

    public String getFontAngle() {
        return (String)this.getProperty(PROP_FONT_ANGLE);
    }

    public void setFontWeight(Object object, String string) {
        this.setProperty(object, PROP_FONT_WEIGHT, string);
    }

    public String getFontWeight() {
        return (String)this.getProperty(PROP_FONT_WEIGHT);
    }

    public void setFontColor(Object object, String string) {
        this.setProperty(object, PROP_FONT_COLOR, string);
    }

    public String getFontColor() {
        return (String)this.getProperty(PROP_FONT_COLOR);
    }

    public void setLineWidth(Object object, Double d) {
        this.setProperty(object, PROP_LINE_WIDTH, d);
    }

    public Double getLineWidth() {
        return (Double)this.getProperty(PROP_LINE_WIDTH);
    }

    public void setLineWidthType(Object object, String string) {
        this.setProperty(object, PROP_LINE_WIDTHTYPE, string);
    }

    public String getLineWidthType() {
        return (String)this.getProperty(PROP_LINE_WIDTHTYPE);
    }

    public void setLineMinWidth(Object object, Double d) {
        this.setProperty(object, PROP_LINE_MINWIDTH, d);
    }

    public Double getLineMinWidth() {
        return (Double)this.getProperty(PROP_LINE_MINWIDTH);
    }

    public void setLineStyle(Object object, String string) {
        this.setProperty(object, PROP_LINE_STYLE, string);
    }

    public String getLineStyle() {
        return (String)this.getProperty(PROP_LINE_STYLE);
    }

    public void setLineColor(Object object, String string) {
        this.setProperty(object, PROP_LINE_COLOR, string);
    }

    public String getLineColor() {
        return (String)this.getProperty(PROP_LINE_COLOR);
    }

    public String getBackgroundColor() {
        String string = (String)this.getProperty(PROP_BKCOLOR);
        if (string == null || string.length() == 0) {
            string = "white";
        }
        return string;
    }

    public void setBackgroundColor(Object object, String string) {
        this.setProperty(object, PROP_BKCOLOR, string);
    }

    public String getInvertHardCopy() {
        return (String)this.getProperty(PROP_INVERTHARDCOPY);
    }

    public void setInvertHardCopy(Object object, String string) {
        this.setProperty(object, PROP_INVERTHARDCOPY, string);
    }

    public Double getPrintUI() {
        return (Double)this.getProperty(PROP_PRINTUI);
    }

    public void setPrintUI(Object object, Double d) {
        this.setProperty(object, PROP_PRINTUI, d);
    }

    public Double getPrintActiveX() {
        return (Double)this.getProperty(PROP_PRINTACTIVEX);
    }

    public void setPrintActiveX(Object object, Double d) {
        this.setProperty(object, PROP_PRINTACTIVEX, d);
    }

    public Double getAxesTicksLims() {
        return (Double)this.getProperty(PROP_AXES_FREEZETICKS);
    }

    public void setAxesTicksLims(Object object, Double d) {
        this.setProperty(object, PROP_AXES_FREEZETICKS, d);
        this.fHashProps.put(PROP_AXES_FREEZETICKS, d);
        this.fHashProps.put(PROP_AXES_FREEZELIMS, d);
    }

    public Double getDriverColor() {
        return (Double)this.getProperty(PROP_DRIVERCOLOR);
    }

    public void setDriverColor(Object object, Double d) {
        this.setProperty(object, PROP_DRIVERCOLOR, d);
    }

    public Double getGrayScale() {
        Double d = (Double)this.getProperty(PROP_GRAYSCALE);
        if (d == null) {
            return new Double(0.0);
        }
        return d;
    }

    public void setGrayScale(Object object, Double d) {
        this.setProperty(object, PROP_GRAYSCALE, d);
    }

    public Double getCMYK() {
        return (Double)this.getProperty(PROP_CMYK);
    }

    public void setCMYK(Object object, Double d) {
        this.setProperty(object, PROP_CMYK, d);
    }

    public String getRenderer() {
        return (String)this.getProperty(PROP_RENDERER);
    }

    public void setRenderer(Object object, String string) {
        this.setProperty(object, PROP_RENDERER, string);
    }

    public String getResolution() {
        return (String)this.getProperty(PROP_RESOLUTION);
    }

    public void setResolution(Object object, Double d) {
        this.setProperty(object, PROP_RESOLUTION, d);
    }

    public String getResoulutionMode() {
        return (String)this.getProperty(PROP_RESOLUTIONMODE);
    }

    public void setResoulutionMode(Object object, String string) {
        this.setProperty(object, PROP_RESOLUTIONMODE, string);
    }

    public String getFilename() {
        return (String)this.getProperty(PROP_FILENAME);
    }

    public void setFilename(Object object, String string) {
        this.setProperty(object, PROP_FILENAME, string);
    }

    public String getDestination() {
        return (String)this.getProperty(PROP_DESTINATION);
    }

    public void setDestination(Object object, String string) {
        this.setProperty(object, PROP_DESTINATION, string);
    }

    public String getPrintDriver() {
        return (String)this.getProperty(PROP_PRINTDRIVER);
    }

    public void setPrintDriver(Object object, String string) {
        this.setProperty(object, PROP_PRINTDRIVER, string);
    }

    public String getDefPrinter() {
        return (String)this.getProperty(PROP_DEFPRINTER);
    }

    public void setDefPrinter(Object object, String string) {
        this.setProperty(object, PROP_DEFPRINTER, string);
    }

    public Double getPrinterColor() {
        return (Double)this.getProperty(PROP_PRINTER_COLOR);
    }

    public void setPrinterColor(Object object, Double d) {
        this.setProperty(object, PROP_PRINTER_COLOR, d);
    }

    public Double getNumCopies() {
        return (Double)this.getProperty(PROP_NUM_COPIES);
    }

    public void setNumCopies(Object object, Double d) {
        this.setProperty(object, PROP_NUM_COPIES, d);
    }

    public void setHeaderFont(String string, double d, String string2, String string3) {
        this.fHashProps.put(PROP_HEADER_FONTNAME, string);
        this.fHashProps.put(PROP_HEADER_FONTSIZE, new Double(d));
        this.fHashProps.put(PROP_HEADER_FONTWEIGHT, string2);
        this.fHashProps.put(PROP_HEADER_FONTANGLE, string3);
    }

    public String getHeaderText() {
        String string = (String)this.getProperty(PROP_HEADER_TEXT);
        return string == null ? "" : string;
    }

    public void setHeaderText(Object object, String string) {
        this.setProperty(object, PROP_HEADER_TEXT, string);
    }

    public String getHeaderDateFormat() {
        String string = (String)this.getProperty(PROP_HEADER_DATEFORMAT);
        return string == null ? "" : string;
    }

    public void setHeaderDateFormat(Object object, String string) {
        this.setProperty(object, PROP_HEADER_DATEFORMAT, string);
    }

    public static Double convertToDoubleOrZero(String string) {
        Double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = new Double(0.0);
        }
        return d;
    }
}

