/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.BeanManager;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.DataSourceCombo;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import com.mathworks.util.CategoricalVariable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class DataSourceControl
extends PropertyControl {
    protected static String STR_NO_VALUE = null;
    protected static final String STR_AUTO = PropertyEditorResources.getBundle().getString("value.auto");
    protected static final String STR_MANUAL = PropertyEditorResources.getBundle().getString("value.manual");
    protected static final int NUM_NO_VALUE = -1;
    protected static final int NUM_MANUAL = 0;
    protected static final int NUM_AUTO = 1;
    protected DataSourceCombo fCombo;
    protected boolean fIsAuto;
    protected int fModeValue = -1;
    protected String fModePropertyName = null;
    protected PropertyDescriptor fModeProperty;

    public DataSourceControl(String string, CellEditorListener cellEditorListener, boolean bl, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper(bl);
        this.fCombo.setName(string2 + "." + string);
    }

    private void constructorHelper(boolean bl) {
        this.fIsAuto = bl;
        this.fCombo = new DataSourceCombo(bl);
        this.setCustomEditor((JComponent)((Object)this.fCombo));
        this.fCombo.setToolTipText(PropertyEditorResources.getBundle().getString("tooltip.datasource"));
        this.fCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1) {
                    DataSourceControl.this.fModeValue = string == null || string.equals("") || string.equals(STR_AUTO) ? 1 : 0;
                }
            }
        });
    }

    public void setModePropertyName(String string) {
        this.fModePropertyName = string;
    }

    public String getModePropertyname() {
        return this.fModePropertyName;
    }

    @Override
    public String getName() {
        if (this.fCombo != null) {
            return this.fCombo.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public String getToolTipText() {
        return this.fCombo.getToolTipText();
    }

    public void setToolTipText(String string) {
        this.fCombo.setToolTipText(string);
    }

    @Override
    public void addEditStoppedSupport() {
        this.fCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DataSourceControl.this.fCombo.getSelectedItem();
                DataSourceControl.this.fModeValue = string == null || string.equals("") || string.equals(STR_AUTO) ? 1 : 0;
                DataSourceControl.this.propertyEditStopped();
            }
        });
    }

    @Override
    public void applyChanges(Object[] objectArray) {
        this.enablePropertyChangeListeners(false);
        super.applyChanges(objectArray);
        this.setValue(this.getDisplayedValue());
        this.enablePropertyChangeListeners(true);
        if (this.fIsAuto) {
            this.fModeProperty = BeanManager.getProperty(objectArray[0], this.fModePropertyName);
        }
        if (this.fIsAuto && this.fModeValue != -1 && this.fModeProperty != null) {
            final Object[] objectArray2 = objectArray;
            try {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DataSourceControl.this.enablePropertyChangeListeners(false);
                        for (Object object : objectArray2) {
                            if (PropertyEditor.isHGUsingMATLABClasses()) {
                                Object object2;
                                String string;
                                String string2 = string = DataSourceControl.this.fModeValue == 1 ? STR_AUTO : STR_MANUAL;
                                if (DataSourceControl.this.fModeProperty.getPropertyType() == MLArrayRef.class || DataSourceControl.this.fModeProperty.getPropertyType() == Object.class) {
                                    object2 = MLPropertyTypeConverter.getProperty(object, DataSourceControl.this.fModeProperty);
                                    MLPropertyTypeConverter.setProperty(object, object2, (Object)string, DataSourceControl.this.fModeProperty);
                                    continue;
                                }
                                if (DataSourceControl.this.fModeProperty.getPropertyType() == CategoricalVariable.class) {
                                    object2 = (CategoricalVariable)BeanManager.getPropertyValue(object, DataSourceControl.this.fModeProperty);
                                    Object object3 = object2.findValueByLabel(string);
                                    BeanManager.setPropertyValue(object, DataSourceControl.this.fModeProperty, object3);
                                    continue;
                                }
                                BeanManager.setPropertyValue(object, DataSourceControl.this.fModeProperty, string);
                                continue;
                            }
                            BeanManager.setPropertyValue(object, DataSourceControl.this.fModeProperty, DataSourceControl.this.fModeValue);
                        }
                        DataSourceControl.this.enablePropertyChangeListeners(true);
                    }
                });
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof RuntimeException) {
                    ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fModeProperty.getName() + "\")", (Exception)throwable);
                }
                ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fModeProperty.getName() + "\")", exception);
            }
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        this.fCombo.willFireActionEvents = false;
        if (object == PropertyControl.MIXED_VALUES) {
            this.fCombo.setSelectedItem(PropertyControl.MIXED_VALUES);
        } else {
            String string;
            String string2 = string = object instanceof String ? (String)object : this.valueToString(object);
            if (this.fIsAuto && (string == null || string.length() == 0)) {
                this.fCombo.setSelectedItem(STR_AUTO);
                this.fModeValue = 1;
            } else if (this.fIsAuto && string.equals(STR_AUTO)) {
                this.fCombo.setSelectedItem(STR_AUTO);
                this.fModeValue = 1;
            } else {
                this.fCombo.setSelectedItem(string);
                this.fModeValue = 0;
            }
        }
        this.fCombo.willFireActionEvents = true;
    }

    @Override
    public Object getDisplayedValue() {
        Object object = this.fCombo.getSelectedItem();
        String string = (String)object;
        if (string == null || string.equals(STR_AUTO)) {
            return "";
        }
        if (this.fIsAuto && this.fModeValue == 1) {
            return "";
        }
        return string;
    }
}

