/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.io;

import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.io.Log;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class FileDeleter {
    private static FileDeleter sInstance = null;
    private final ScheduledThreadPoolExecutor fExecutor = new ScheduledThreadPoolExecutor(0, NamedThreadFactory.createDaemonThreadFactory("FileDeleter", Log.LOG));
    private final BlockingDeque<File> fFiles = new LinkedBlockingDeque<File>();
    private long fDelayBetweenAttempts = 10000L;

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean bl = FileDeleter.recursiveDelete(file);
        if (!bl) {
            FileDeleter.getInstance().deleteFileLater(file);
        }
        return bl;
    }

    private static synchronized FileDeleter getInstance() {
        if (sInstance == null) {
            sInstance = new FileDeleter();
        }
        return sInstance;
    }

    private FileDeleter() {
        this.fExecutor.setKeepAliveTime(this.getDelayBetweenAttempts() * 10L, TimeUnit.MILLISECONDS);
        this.fExecutor.allowCoreThreadTimeOut(true);
    }

    private synchronized long getDelayBetweenAttempts() {
        return this.fDelayBetweenAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setThreadTimeout(long l) {
        FileDeleter fileDeleter = FileDeleter.getInstance();
        synchronized (fileDeleter) {
            FileDeleter.getInstance().fDelayBetweenAttempts = l;
        }
    }

    private void deleteFileLater(File file) {
        assert (file != null) : "file must not be null";
        this.fFiles.add(file);
        DeleteFiles deleteFiles = new DeleteFiles();
        this.fExecutor.schedule(deleteFiles, this.getDelayBetweenAttempts(), TimeUnit.MILLISECONDS);
    }

    public static boolean isThreadActive() {
        return FileDeleter.getInstance().fExecutor.getActiveCount() > 0;
    }

    public static File[] getCurrentDeletionList() {
        return FileDeleter.getInstance().fFiles.toArray(new File[FileDeleter.getInstance().fFiles.size()]);
    }

    private static boolean recursiveDelete(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (FileDeleter.recursiveDelete(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }

    private final class DeleteFiles
    implements Runnable {
        DeleteFiles() {
        }

        @Override
        public void run() {
            Object object;
            Iterator iterator = FileDeleter.this.fFiles.iterator();
            while (iterator.hasNext()) {
                object = (File)iterator.next();
                try {
                    if (((File)object).exists() && !FileDeleter.recursiveDelete((File)object)) continue;
                    iterator.remove();
                }
                catch (SecurityException securityException) {
                    iterator.remove();
                }
            }
            if (!FileDeleter.this.fFiles.isEmpty()) {
                object = new DeleteFiles();
                FileDeleter.this.fExecutor.schedule((Runnable)object, FileDeleter.this.getDelayBetweenAttempts(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

